/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ReportHighScoresPanel;
import net.sf.freecol.common.resources.ResourceManager;

public final class VictoryPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(VictoryPanel.class.getName());
    private static final int OK = 0;
    private static final int CONTINUE = 1;
    private final Canvas parent;
    private Box buttonsBox = Box.createHorizontalBox();
    private JButton ok = new JButton(Messages.message("victory.yes", new String[0]));
    private JButton continueButton = new JButton(Messages.message("victory.continue", new String[0]));

    public VictoryPanel(Canvas parent) {
        this.parent = parent;
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 3, 0, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        this.setCancelComponent(this.ok);
        JLabel victoryLabel = VictoryPanel.getDefaultHeader(Messages.message("victory.text", new String[0]));
        Image tempImage = ResourceManager.getImage("VictoryImage");
        JLabel imageLabel = tempImage != null ? new JLabel(new ImageIcon(tempImage)) : new JLabel("");
        int row = 1;
        int column = 1;
        this.add((Component)victoryLabel, higConst.rc(row, column));
        this.add((Component)imageLabel, higConst.rc(row += 2, column));
        this.add((Component)this.buttonsBox, higConst.rc(row += 2, column));
        this.ok.setActionCommand(String.valueOf(0));
        this.ok.addActionListener(this);
        this.continueButton.setActionCommand(String.valueOf(1));
        this.continueButton.addActionListener(this);
        VictoryPanel.enterPressesWhenFocused(this.ok);
        VictoryPanel.enterPressesWhenFocused(this.continueButton);
        this.buttonsBox.removeAll();
        if (parent.getClient().isSingleplayer()) {
            this.buttonsBox.add(this.continueButton);
            this.buttonsBox.add(Box.createGlue());
        }
        this.buttonsBox.add(this.ok);
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    if (this.parent.getClient().retire()) {
                        this.parent.showInformationMessage("highscores.new");
                        this.parent.showReportPanel(ReportHighScoresPanel.class.getName());
                    }
                    this.parent.quit();
                    break;
                }
                case 1: {
                    if (this.parent.getClient().retire()) {
                        this.parent.showInformationMessage("highscores.new");
                        this.parent.showReportPanel(ReportHighScoresPanel.class.getName());
                    }
                    this.parent.getClient().continuePlaying();
                    this.parent.remove(this);
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

