/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;

public final class WarehouseDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(WarehouseDialog.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private final Canvas parent;
    private final JButton ok = new JButton(Messages.message("warehouseDialog.saveSettings", new String[0]));
    private final JButton cancel = new JButton(Messages.message("warehouseDialog.cancel", new String[0]));
    private final JPanel warehouseDialog;
    private final JPanel buttonPanel;
    private static final int[] widths = new int[]{0, 3, 0};
    private static final int[] heights = new int[]{-5, 3, -1, 3, -3};
    private static final int labelColumn = 1;
    private static final int spinnerColumn = 3;

    public WarehouseDialog(Canvas parent) {
        this.parent = parent;
        this.warehouseDialog = new JPanel(new GridLayout(0, 4, 3, 3));
        this.warehouseDialog.setOpaque(false);
        this.ok.setActionCommand(String.valueOf(0));
        this.cancel.setActionCommand(String.valueOf(1));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.ok.setMnemonic('y');
        this.cancel.setMnemonic('n');
        FreeColPanel.enterPressesWhenFocused(this.cancel);
        FreeColPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(this.cancel);
        int[] widths = new int[]{0};
        int[] heights = new int[]{0, 3, 0, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.ok);
        this.buttonPanel.add(this.cancel);
        this.add((Component)WarehouseDialog.getDefaultHeader(Messages.message("warehouseDialog.name", new String[0])), higConst.rc(1, 1));
        this.add((Component)this.warehouseDialog, higConst.rc(3, 1));
        this.add((Component)this.buttonPanel, higConst.rc(5, 1));
    }

    public void initialize(Colony colony) {
        this.warehouseDialog.removeAll();
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            this.warehouseDialog.add(new WarehouseGoodsPanel(colony, goodsType));
        }
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.setResponse(new Boolean(true));
                    for (Component c : this.warehouseDialog.getComponents()) {
                        if (!(c instanceof WarehouseGoodsPanel)) continue;
                        ((WarehouseGoodsPanel)c).saveSettings();
                    }
                    break;
                }
                case 1: {
                    this.parent.remove(this);
                    this.setResponse(new Boolean(false));
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    public class WarehouseGoodsPanel
    extends JPanel {
        private final Colony colony;
        private final GoodsType goodsType;
        private final JCheckBox export;
        private final JSpinner lowLevel;
        private final JSpinner highLevel;
        private final JSpinner exportLevel;

        public WarehouseGoodsPanel(Colony colony, GoodsType goodsType) {
            this.colony = colony;
            this.goodsType = goodsType;
            int goodsIndex = goodsType.getIndex();
            this.setLayout(new HIGLayout(widths, heights));
            this.setOpaque(false);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(goodsType.getName()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
            Goods goods = new Goods(colony.getGame(), colony, goodsType, colony.getGoodsContainer().getGoodsCount(goodsType));
            GoodsLabel goodsLabel = new GoodsLabel(goods, WarehouseDialog.this.parent);
            goodsLabel.setHorizontalAlignment(10);
            this.add((Component)goodsLabel, FreeColPanel.higConst.rcwh(1, 1, 1, 3));
            ExportData exportData = colony.getExportData(goodsType);
            this.export = new JCheckBox(Messages.message("warehouseDialog.export", new String[0]), exportData.isExported());
            this.export.setToolTipText(Messages.message("warehouseDialog.export.shortDescription", new String[0]));
            if (!colony.hasAbility("model.ability.export")) {
                this.export.setEnabled(false);
            }
            this.add((Component)this.export, FreeColPanel.higConst.rc(5, 1));
            SpinnerNumberModel lowLevelModel = new SpinnerNumberModel(exportData.getLowLevel(), 0, 100, 1);
            this.lowLevel = new JSpinner(lowLevelModel);
            this.lowLevel.setToolTipText(Messages.message("warehouseDialog.lowLevel.shortDescription", new String[0]));
            this.add((Component)this.lowLevel, FreeColPanel.higConst.rc(1, 3));
            SpinnerNumberModel highLevelModel = new SpinnerNumberModel(exportData.getHighLevel(), 0, 100, 1);
            this.highLevel = new JSpinner(highLevelModel);
            this.highLevel.setToolTipText(Messages.message("warehouseDialog.highLevel.shortDescription", new String[0]));
            this.add((Component)this.highLevel, FreeColPanel.higConst.rc(3, 3));
            SpinnerNumberModel exportLevelModel = new SpinnerNumberModel(exportData.getExportLevel(), 0, colony.getWarehouseCapacity(), 1);
            this.exportLevel = new JSpinner(exportLevelModel);
            this.exportLevel.setToolTipText(Messages.message("warehouseDialog.exportLevel.shortDescription", new String[0]));
            this.add((Component)this.exportLevel, FreeColPanel.higConst.rc(5, 3));
            this.setSize(this.getPreferredSize());
        }

        public void saveSettings() {
            int lowLevelValue = ((SpinnerNumberModel)this.lowLevel.getModel()).getNumber().intValue();
            int highLevelValue = ((SpinnerNumberModel)this.highLevel.getModel()).getNumber().intValue();
            int exportLevelValue = ((SpinnerNumberModel)this.exportLevel.getModel()).getNumber().intValue();
            ExportData exportData = this.colony.getExportData(this.goodsType);
            boolean changed = this.export.isSelected() != exportData.isExported() || lowLevelValue != exportData.getLowLevel() || highLevelValue != exportData.getHighLevel() || exportLevelValue != exportData.getExportLevel();
            exportData.setExported(this.export.isSelected());
            exportData.setLowLevel(lowLevelValue);
            exportData.setHighLevel(highLevelValue);
            exportData.setExportLevel(exportLevelValue);
            if (changed) {
                WarehouseDialog.this.parent.getClient().getInGameController().setGoodsLevels(this.colony, this.goodsType);
            }
        }
    }
}

