/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.sound;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.freecol.client.gui.sound.Playlist;
import net.sf.freecol.common.FreeColException;

public class SoundLibrary {
    private Map<String, Playlist> playlists = new HashMap<String, Playlist>();
    private static final FileFilter soundFileFilter = new FileFilter(){

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            String s = file.getName();
            return s.endsWith(".au") || s.endsWith(".wav") || s.endsWith(".aif") || s.endsWith(".aiff") || s.endsWith(".ogg") || s.endsWith(".mp3");
        }
    };

    public SoundLibrary(File dir) throws FreeColException {
        if (!dir.isDirectory()) {
            throw new FreeColException("The file \"" + dir.getName() + "\" is not a directory.");
        }
        for (File file : dir.listFiles()) {
            if (file.getName().endsWith(".svn")) continue;
            if (file.isDirectory()) {
                Object[] files = file.listFiles(soundFileFilter);
                Arrays.sort(files);
                this.playlists.put(file.getName(), new Playlist((File[])files));
                continue;
            }
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            this.playlists.put(fileName, new Playlist(file));
        }
    }

    public Playlist get(String string) {
        return this.playlists.get(string);
    }

    public Playlist get(SoundEffect effect) {
        return this.playlists.get(effect.toString().toLowerCase());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SoundEffect {
        ERROR,
        ATTACK,
        ILLEGAL_MOVE,
        LOAD_CARGO,
        SELL_CARGO,
        ATTACK_ARTILLERY,
        SUNK,
        ATTACK_DRAGOON,
        ATTACK_NAVAL,
        CAPTURED_BY_ARTILLERY,
        BUILDING_COMPLETE,
        MISSION_ESTABLISHED;

    }
}

