/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.sound;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import net.sf.freecol.client.gui.sound.Playlist;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.PercentageOption;

public class SoundPlayer {
    private static final Logger logger = Logger.getLogger(SoundPlayer.class.getName());
    public static final int STANDARD_DELAY = 2000;
    private static final int MAXIMUM_FADE_MS = 7000;
    private static final int FADE_UPDATE_MS = 5;
    private ThreadGroup soundPlayerThreads = new ThreadGroup("soundPlayerThreads");
    private boolean soundPaused = false;
    private boolean soundStopped = true;
    private boolean multipleSounds;
    private SoundPlayerThread currentSoundPlayerThread;
    private boolean defaultPlayContinues;
    private final int defaultRepeatMode;
    private final int defaultPickMode;
    private Mixer mixer;
    private PercentageOption volume;

    public SoundPlayer(AudioMixerOption mixerOption, PercentageOption volume, boolean multipleSounds, boolean defaultPlayContinues) {
        this(mixerOption, volume, multipleSounds, defaultPlayContinues, 1, 0);
    }

    public SoundPlayer(AudioMixerOption mixerOption, PercentageOption volume, boolean multipleSounds, boolean defaultPlayContinues, int defaultRepeatMode, int defaultPickMode) {
        if (mixerOption == null) {
            throw new NullPointerException();
        }
        if (volume == null) {
            throw new NullPointerException();
        }
        this.volume = volume;
        this.multipleSounds = multipleSounds;
        this.defaultPlayContinues = defaultPlayContinues;
        this.defaultRepeatMode = defaultRepeatMode;
        this.defaultPickMode = defaultPickMode;
        mixerOption.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SoundPlayer.this.mixer = AudioSystem.getMixer(((AudioMixerOption.MixerWrapper)e.getNewValue()).getMixerInfo());
            }
        });
        this.mixer = AudioSystem.getMixer(mixerOption.getValue().getMixerInfo());
    }

    public void play(Playlist playlist) {
        this.play(playlist, this.defaultPlayContinues, this.defaultRepeatMode, this.defaultPickMode, 0);
    }

    public void play(Playlist playlist, int delay) {
        this.play(playlist, this.defaultPlayContinues, this.defaultRepeatMode, this.defaultPickMode, delay);
    }

    public void playOnce(Playlist playlist) {
        this.play(playlist, false, this.defaultRepeatMode, this.defaultPickMode, 0);
    }

    public void playOnce(Playlist playlist, int delay) {
        this.play(playlist, false, this.defaultRepeatMode, this.defaultPickMode, delay);
    }

    public void play(Playlist playlist, boolean playContinues, int repeatMode, int pickMode, int delay) {
        if (playlist != null) {
            this.currentSoundPlayerThread = new SoundPlayerThread(playlist, playContinues, repeatMode, pickMode, delay);
            this.currentSoundPlayerThread.start();
        } else {
            this.currentSoundPlayerThread = null;
        }
    }

    public void stop() {
        this.soundStopped = true;
        this.soundPaused = false;
    }

    public boolean isStopped() {
        return this.soundStopped;
    }

    public void pause() {
        this.soundPaused = true;
    }

    public boolean isPaused() {
        return this.soundPaused;
    }

    class SoundPlayerThread
    extends Thread {
        private Playlist playlist;
        private boolean playContinues;
        private int repeatMode;
        private int pickMode;
        private boolean repeatSound;
        private int delay;

        public SoundPlayerThread(Playlist playlist, boolean playContinues, int repeatMode, int pickMode, int delay) {
            super(SoundPlayer.this.soundPlayerThreads, "FreeColClient:SoundPlayer");
            this.playlist = playlist;
            this.playContinues = playContinues;
            this.repeatMode = repeatMode;
            this.pickMode = pickMode;
            this.delay = delay;
        }

        private boolean shouldStopThread() {
            return !SoundPlayer.this.multipleSounds && SoundPlayer.this.currentSoundPlayerThread != this;
        }

        public void run() {
            this.playlist.setRepeatMode(this.repeatMode);
            this.playlist.setPickMode(this.pickMode);
            SoundPlayer.this.soundPaused = false;
            SoundPlayer.this.soundStopped = false;
            if (this.delay != 0) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            do {
                this.playSound(this.playlist.next());
                try {
                    Thread.sleep(222L);
                }
                catch (Exception e) {
                    break;
                }
            } while (this.playContinues && this.playlist.hasNext() && !SoundPlayer.this.soundStopped && !this.shouldStopThread());
        }

        public void playSound(File file) {
            try {
                AudioInputStream in = AudioSystem.getAudioInputStream(file);
                AudioInputStream din = null;
                if (in != null) {
                    AudioFormat baseFormat = in.getFormat();
                    AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), baseFormat.isBigEndian());
                    din = AudioSystem.getAudioInputStream(decodedFormat, in);
                    this.rawplay(decodedFormat, din);
                    in.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not play audio.", e);
            }
        }

        private void updateVolume(FloatControl c, int volume) {
            float gain = 20.0f * (float)Math.log10((double)volume / 100.0);
            c.setValue(gain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rawplay(AudioFormat targetFormat, AudioInputStream din) throws IOException, LineUnavailableException {
            byte[] data = new byte[8192];
            SourceDataLine line = this.getLine(targetFormat);
            if (line != null) {
                line.start();
                final FloatControl c = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                PropertyChangeListener pcl = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        int v = (Integer)e.getNewValue();
                        SoundPlayerThread.this.updateVolume(c, v);
                    }
                };
                SoundPlayer.this.volume.addPropertyChangeListener(pcl);
                this.updateVolume(c, SoundPlayer.this.volume.getValue());
                int read = 0;
                int written = 0;
                try {
                    while (read != -1 && !SoundPlayer.this.soundStopped && !this.shouldStopThread()) {
                        try {
                            while (SoundPlayer.this.soundPaused) {
                                Thread.sleep(10L);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if ((read = din.read(data, 0, data.length)) == -1) continue;
                        written = line.write(data, 0, read);
                    }
                }
                finally {
                    SoundPlayer.this.volume.removePropertyChangeListener(pcl);
                }
                if (!SoundPlayer.this.soundStopped) {
                    long ms = System.currentTimeMillis() + 5L;
                    long fadeStop = System.currentTimeMillis() + 7000L;
                    while (read != -1 && !SoundPlayer.this.soundStopped && System.currentTimeMillis() < fadeStop) {
                        read = din.read(data, 0, data.length);
                        if (read != -1) {
                            written = line.write(data, 0, read);
                        }
                        if (System.currentTimeMillis() <= ms) continue;
                        float currentGain = c.getValue();
                        float newGain = currentGain - 1.0f;
                        if (newGain < c.getMinimum()) {
                            newGain = c.getMinimum();
                        }
                        c.setValue(newGain);
                        ms = System.currentTimeMillis() + 5L;
                    }
                }
                line.drain();
                line.stop();
                line.close();
                din.close();
            }
        }

        private SourceDataLine getLine(AudioFormat audioFormat) throws LineUnavailableException {
            SourceDataLine sdl = null;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            sdl = (SourceDataLine)SoundPlayer.this.mixer.getLine(info);
            sdl.open(audioFormat);
            return sdl;
        }
    }
}

