/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.gui.action.ImprovementActionType;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.DifficultyLevel;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;
import net.sf.freecol.common.option.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Specification {
    protected static Specification specification;
    private static final Logger logger;
    private final Map<String, FreeColGameObjectType> allTypes;
    private final Map<String, AbstractOption> allOptions;
    private final Map<String, OptionGroup> allOptionGroups;
    private final Map<GoodsType, UnitType> experts;
    private final Map<String, List<Ability>> allAbilities;
    private final Map<String, List<Modifier>> allModifiers;
    private final List<BuildingType> buildingTypeList;
    private final List<GoodsType> goodsTypeList;
    private final List<GoodsType> farmedGoodsTypeList;
    private final List<GoodsType> foodGoodsTypeList;
    private final List<GoodsType> newWorldGoodsTypeList;
    private final List<ResourceType> resourceTypeList;
    private final List<TileType> tileTypeList;
    private final List<TileImprovementType> tileImprovementTypeList;
    private final List<ImprovementActionType> improvementActionTypeList;
    private final List<UnitType> unitTypeList;
    private final List<UnitType> unitTypesTrainedInEurope;
    private final List<UnitType> unitTypesPurchasedInEurope;
    private final List<FoundingFather> foundingFathers;
    private final List<Nation> nations;
    private final List<Nation> europeanNations;
    private final List<Nation> REFNations;
    private final List<Nation> classicNations;
    private final List<Nation> indianNations;
    private final List<NationType> nationTypes;
    private final List<EuropeanNationType> europeanNationTypes;
    private final List<EuropeanNationType> REFNationTypes;
    private final List<EuropeanNationType> classicNationTypes;
    private final List<IndianNationType> indianNationTypes;
    private final List<EquipmentType> equipmentTypes;
    private final List<DifficultyLevel> difficultyLevels;
    private int storableTypes = 0;

    protected Specification(InputStream in) {
        logger.info("Initializing Specification");
        this.allTypes = new HashMap<String, FreeColGameObjectType>();
        this.allOptions = new HashMap<String, AbstractOption>();
        this.allOptionGroups = new HashMap<String, OptionGroup>();
        this.experts = new HashMap<GoodsType, UnitType>();
        this.allAbilities = new HashMap<String, List<Ability>>();
        this.allModifiers = new HashMap<String, List<Modifier>>();
        this.buildingTypeList = new ArrayList<BuildingType>();
        this.goodsTypeList = new ArrayList<GoodsType>();
        this.foodGoodsTypeList = new ArrayList<GoodsType>();
        this.farmedGoodsTypeList = new ArrayList<GoodsType>();
        this.newWorldGoodsTypeList = new ArrayList<GoodsType>();
        this.resourceTypeList = new ArrayList<ResourceType>();
        this.tileTypeList = new ArrayList<TileType>();
        this.tileImprovementTypeList = new ArrayList<TileImprovementType>();
        this.improvementActionTypeList = new ArrayList<ImprovementActionType>();
        this.unitTypeList = new ArrayList<UnitType>();
        this.unitTypesPurchasedInEurope = new ArrayList<UnitType>();
        this.unitTypesTrainedInEurope = new ArrayList<UnitType>();
        this.foundingFathers = new ArrayList<FoundingFather>();
        this.nations = new ArrayList<Nation>();
        this.europeanNations = new ArrayList<Nation>();
        this.REFNations = new ArrayList<Nation>();
        this.classicNations = new ArrayList<Nation>();
        this.indianNations = new ArrayList<Nation>();
        this.nationTypes = new ArrayList<NationType>();
        this.europeanNationTypes = new ArrayList<EuropeanNationType>();
        this.REFNationTypes = new ArrayList<EuropeanNationType>();
        this.classicNationTypes = new ArrayList<EuropeanNationType>();
        this.indianNationTypes = new ArrayList<IndianNationType>();
        this.equipmentTypes = new ArrayList<EquipmentType>();
        this.difficultyLevels = new ArrayList<DifficultyLevel>();
        try {
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in);
            xsr.nextTag();
            while (xsr.nextTag() != 2) {
                int nationIndex;
                String childName = xsr.getLocalName();
                logger.finest("Found child named " + childName);
                if ("goods-types".equals(childName)) {
                    int goodsIndex = 0;
                    while (xsr.nextTag() != 2) {
                        GoodsType goodsType = new GoodsType(goodsIndex++);
                        goodsType.readFromXML(xsr, this);
                        this.goodsTypeList.add(goodsType);
                        this.allTypes.put(goodsType.getId(), goodsType);
                        if (goodsType.isFarmed()) {
                            this.farmedGoodsTypeList.add(goodsType);
                        }
                        if (goodsType.isFoodType()) {
                            this.foodGoodsTypeList.add(goodsType);
                        }
                        if (goodsType.isNewWorldGoodsType()) {
                            this.newWorldGoodsTypeList.add(goodsType);
                        }
                        if (!goodsType.isStorable()) continue;
                        ++this.storableTypes;
                    }
                    continue;
                }
                if ("building-types".equals(childName)) {
                    int buildingIndex = 0;
                    while (xsr.nextTag() != 2) {
                        BuildingType buildingType = new BuildingType(buildingIndex++);
                        buildingType.readFromXML(xsr, this);
                        this.allTypes.put(buildingType.getId(), buildingType);
                        this.buildingTypeList.add(buildingType);
                    }
                    continue;
                }
                if ("resource-types".equals(childName)) {
                    int resIndex = 0;
                    while (xsr.nextTag() != 2) {
                        ResourceType resourceType = new ResourceType(resIndex++);
                        resourceType.readFromXML(xsr, this);
                        this.allTypes.put(resourceType.getId(), resourceType);
                        this.resourceTypeList.add(resourceType);
                    }
                    continue;
                }
                if ("tile-types".equals(childName)) {
                    int tileIndex = 0;
                    while (xsr.nextTag() != 2) {
                        TileType tileType = new TileType(tileIndex++);
                        tileType.readFromXML(xsr, this);
                        this.allTypes.put(tileType.getId(), tileType);
                        this.tileTypeList.add(tileType);
                    }
                    continue;
                }
                if ("tileimprovement-types".equals(childName)) {
                    int impIndex = 0;
                    while (xsr.nextTag() != 2) {
                        TileImprovementType tileImprovementType = new TileImprovementType(impIndex++);
                        tileImprovementType.readFromXML(xsr, this);
                        this.allTypes.put(tileImprovementType.getId(), tileImprovementType);
                        this.tileImprovementTypeList.add(tileImprovementType);
                    }
                    continue;
                }
                if ("improvementaction-types".equals(childName)) {
                    while (xsr.nextTag() != 2) {
                        ImprovementActionType impActionType = new ImprovementActionType();
                        impActionType.readFromXML(xsr, this);
                        this.allTypes.put(impActionType.getId(), impActionType);
                        this.improvementActionTypeList.add(impActionType);
                    }
                    continue;
                }
                if ("unit-types".equals(childName)) {
                    int unitIndex = 0;
                    while (xsr.nextTag() != 2) {
                        UnitType unitType = new UnitType(unitIndex++);
                        unitType.readFromXML(xsr, this);
                        this.allTypes.put(unitType.getId(), unitType);
                        this.unitTypeList.add(unitType);
                        if (unitType.getExpertProduction() != null) {
                            this.experts.put(unitType.getExpertProduction(), unitType);
                        }
                        if (!unitType.hasPrice()) continue;
                        if (unitType.getSkill() > 0) {
                            this.unitTypesTrainedInEurope.add(unitType);
                            continue;
                        }
                        if (unitType.hasSkill()) continue;
                        this.unitTypesPurchasedInEurope.add(unitType);
                    }
                    continue;
                }
                if ("founding-fathers".equals(childName)) {
                    int fatherIndex = 0;
                    while (xsr.nextTag() != 2) {
                        FoundingFather foundingFather = new FoundingFather(fatherIndex++);
                        foundingFather.readFromXML(xsr, this);
                        this.allTypes.put(foundingFather.getId(), foundingFather);
                        this.foundingFathers.add(foundingFather);
                    }
                    continue;
                }
                if ("nation-types".equals(childName)) {
                    nationIndex = 0;
                    while (xsr.nextTag() != 2) {
                        NationType nationType;
                        if ("european-nation-type".equals(xsr.getLocalName())) {
                            nationType = new EuropeanNationType(nationIndex++);
                            nationType.readFromXML(xsr, this);
                            if (nationType.isREF()) {
                                this.REFNationTypes.add((EuropeanNationType)nationType);
                            } else {
                                this.europeanNationTypes.add((EuropeanNationType)nationType);
                            }
                        } else {
                            nationType = new IndianNationType(nationIndex++);
                            nationType.readFromXML(xsr, this);
                            this.indianNationTypes.add((IndianNationType)nationType);
                        }
                        this.allTypes.put(nationType.getId(), nationType);
                        this.nationTypes.add(nationType);
                    }
                    continue;
                }
                if ("nations".equals(childName)) {
                    nationIndex = 0;
                    while (xsr.nextTag() != 2) {
                        Nation nation = new Nation(nationIndex++);
                        nation.readFromXML(xsr, this);
                        this.allTypes.put(nation.getId(), nation);
                        this.nations.add(nation);
                        if (nation.getType().isEuropean()) {
                            if (nation.getType().isREF()) {
                                this.REFNations.add(nation);
                            } else {
                                this.europeanNations.add(nation);
                            }
                            if (!nation.isClassic()) continue;
                            this.classicNations.add(nation);
                            this.classicNationTypes.add((EuropeanNationType)nation.getType());
                            continue;
                        }
                        this.indianNations.add(nation);
                    }
                    continue;
                }
                if ("equipment-types".equals(childName)) {
                    int equipmentIndex = 0;
                    while (xsr.nextTag() != 2) {
                        EquipmentType equipmentType = new EquipmentType(equipmentIndex++);
                        equipmentType.readFromXML(xsr, this);
                        this.allTypes.put(equipmentType.getId(), equipmentType);
                        this.equipmentTypes.add(equipmentType);
                    }
                    continue;
                }
                if ("difficultyLevels".equals(childName)) {
                    int levelIndex = 0;
                    while (xsr.nextTag() != 2) {
                        DifficultyLevel level = new DifficultyLevel(levelIndex++);
                        level.readFromXML(xsr, this);
                        this.allTypes.put(level.getId(), level);
                        this.difficultyLevels.add(level);
                    }
                    continue;
                }
                if ("options".equals(childName)) {
                    while (xsr.nextTag() != 2) {
                        AbstractOption option = null;
                        String optionType = xsr.getLocalName();
                        if (OptionGroup.getXMLElementTagName().equals(optionType)) {
                            option = new OptionGroup(xsr);
                        } else if (IntegerOption.getXMLElementTagName().equals(optionType) || "integer-option".equals(optionType)) {
                            option = new IntegerOption(xsr);
                        } else if (BooleanOption.getXMLElementTagName().equals(optionType) || "boolean-option".equals(optionType)) {
                            option = new BooleanOption(xsr);
                        } else if (StringOption.getXMLElementTagName().equals(optionType) || "string-option".equals(optionType)) {
                            option = new StringOption(xsr);
                        } else if (RangeOption.getXMLElementTagName().equals(optionType) || "range-option".equals(optionType)) {
                            option = new RangeOption(xsr);
                        } else if (SelectOption.getXMLElementTagName().equals(optionType) || "select-option".equals(optionType)) {
                            option = new SelectOption(xsr);
                        } else if (LanguageOption.getXMLElementTagName().equals(optionType) || "language-option".equals(optionType)) {
                            option = new LanguageOption(xsr);
                        } else if (FileOption.getXMLElementTagName().equals(optionType) || "file-option".equals(optionType)) {
                            option = new FileOption(xsr);
                        } else {
                            logger.finest("Parsing of " + optionType + " is not implemented yet");
                            xsr.nextTag();
                        }
                        if (option == null) continue;
                        if (option instanceof OptionGroup) {
                            this.addOptionGroup((OptionGroup)option);
                            continue;
                        }
                        this.addAbstractOption(option);
                    }
                    continue;
                }
                throw new RuntimeException("unexpected: " + childName);
            }
            Goods.initialize(this.getGoodsTypeList(), this.numberOfGoodsTypes());
            logger.info("Specification initialization complete");
        }
        catch (XMLStreamException e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.warning(sw.toString());
            throw new RuntimeException("Error parsing specification");
        }
    }

    public void addAbility(Ability ability) {
        String id = ability.getId();
        this.addAbility(id);
        this.allAbilities.get(id).add(ability);
    }

    public void addAbility(String id) {
        if (!this.allAbilities.containsKey(id)) {
            this.allAbilities.put(id, new ArrayList());
        }
    }

    public List<Ability> getAbilities(String id) {
        return this.allAbilities.get(id);
    }

    public void addModifier(Modifier modifier) {
        String id = modifier.getId();
        if (!this.allModifiers.containsKey(id)) {
            this.allModifiers.put(id, new ArrayList());
        }
        this.allModifiers.get(id).add(modifier);
    }

    public List<Modifier> getModifiers(String id) {
        return this.allModifiers.get(id);
    }

    public FreeColGameObjectType getType(String Id) throws IllegalArgumentException {
        if (Id == null) {
            throw new IllegalArgumentException("Trying to retrieve FreeColGameObjectType with ID 'null'.");
        }
        if (!this.allTypes.containsKey(Id)) {
            throw new IllegalArgumentException("Trying to retrieve FreeColGameObjectType with ID '" + Id + "' returned 'null'.");
        }
        return this.allTypes.get(Id);
    }

    public boolean hasOption(String Id) {
        return Id != null && this.allOptions.containsKey(Id);
    }

    public AbstractOption getOption(String Id) throws IllegalArgumentException {
        if (Id == null) {
            throw new IllegalArgumentException("Trying to retrieve AbstractOption with ID 'null'.");
        }
        if (!this.allOptions.containsKey(Id)) {
            throw new IllegalArgumentException("Trying to retrieve AbstractOption with ID '" + Id + "' returned 'null'.");
        }
        return this.allOptions.get(Id);
    }

    public OptionGroup getOptionGroup(String Id) throws IllegalArgumentException {
        if (Id == null) {
            throw new IllegalArgumentException("Trying to retrieve OptionGroup with ID 'null'.");
        }
        if (!this.allOptionGroups.containsKey(Id)) {
            throw new IllegalArgumentException("Trying to retrieve OptionGroup with ID '" + Id + "' returned 'null'.");
        }
        return this.allOptionGroups.get(Id);
    }

    public void addOptionGroup(OptionGroup optionGroup) {
        this.allOptionGroups.put(optionGroup.getId(), optionGroup);
        Iterator<Option> iter = optionGroup.iterator();
        while (iter.hasNext()) {
            Option option = iter.next();
            this.addAbstractOption((AbstractOption)option);
        }
    }

    public void addAbstractOption(AbstractOption abstractOption) {
        this.allOptions.put(abstractOption.getId(), abstractOption);
    }

    public IntegerOption getIntegerOption(String Id) {
        return (IntegerOption)this.getOption(Id);
    }

    public RangeOption getRangeOption(String Id) {
        return (RangeOption)this.getOption(Id);
    }

    public BooleanOption getBooleanOption(String Id) {
        return (BooleanOption)this.getOption(Id);
    }

    public StringOption getStringOption(String Id) {
        return (StringOption)this.getOption(Id);
    }

    public List<BuildingType> getBuildingTypeList() {
        return this.buildingTypeList;
    }

    public int numberOfBuildingTypes() {
        return this.buildingTypeList.size();
    }

    public BuildingType getBuildingType(int buildingTypeIndex) {
        return this.buildingTypeList.get(buildingTypeIndex);
    }

    public BuildingType getBuildingType(String id) {
        return (BuildingType)this.getType(id);
    }

    public List<GoodsType> getGoodsTypeList() {
        return this.goodsTypeList;
    }

    public int numberOfGoodsTypes() {
        return this.goodsTypeList.size();
    }

    public int numberOfStoredGoodsTypes() {
        return this.storableTypes;
    }

    public List<GoodsType> getFarmedGoodsTypeList() {
        return this.farmedGoodsTypeList;
    }

    public List<GoodsType> getNewWorldGoodsTypeList() {
        return this.newWorldGoodsTypeList;
    }

    public int numberOfFarmedGoodsTypes() {
        return this.farmedGoodsTypeList.size();
    }

    public GoodsType getGoodsType(String id) {
        return (GoodsType)this.getType(id);
    }

    public List<GoodsType> getGoodsFood() {
        return this.foodGoodsTypeList;
    }

    public List<ResourceType> getResourceTypeList() {
        return this.resourceTypeList;
    }

    public int numberOfResourceTypes() {
        return this.resourceTypeList.size();
    }

    public ResourceType getResourceType(String id) {
        return (ResourceType)this.getType(id);
    }

    public List<TileType> getTileTypeList() {
        return this.tileTypeList;
    }

    public int numberOfTileTypes() {
        return this.tileTypeList.size();
    }

    public TileType getTileType(String id) {
        return (TileType)this.getType(id);
    }

    public List<TileImprovementType> getTileImprovementTypeList() {
        return this.tileImprovementTypeList;
    }

    public TileImprovementType getTileImprovementType(String id) {
        return (TileImprovementType)this.getType(id);
    }

    public List<ImprovementActionType> getImprovementActionTypeList() {
        return this.improvementActionTypeList;
    }

    public ImprovementActionType getImprovementActionType(String id) {
        return (ImprovementActionType)this.getType(id);
    }

    public List<UnitType> getUnitTypeList() {
        return this.unitTypeList;
    }

    public int numberOfUnitTypes() {
        return this.unitTypeList.size();
    }

    public UnitType getUnitType(String id) {
        return (UnitType)this.getType(id);
    }

    public UnitType getExpertForProducing(GoodsType goodsType) {
        return this.experts.get(goodsType);
    }

    public List<UnitType> getUnitTypesWithAbility(String ... abilities) {
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        block0: for (UnitType unitType : this.getUnitTypeList()) {
            for (String ability : abilities) {
                if (!unitType.hasAbility(ability)) continue;
                unitTypes.add(unitType);
                continue block0;
            }
        }
        return unitTypes;
    }

    public List<UnitType> getUnitTypesTrainedInEurope() {
        return this.unitTypesTrainedInEurope;
    }

    public List<UnitType> getUnitTypesPurchasedInEurope() {
        return this.unitTypesPurchasedInEurope;
    }

    public List<FoundingFather> getFoundingFathers() {
        return this.foundingFathers;
    }

    public int numberOfFoundingFathers() {
        return this.foundingFathers.size();
    }

    public FoundingFather getFoundingFather(String id) {
        return (FoundingFather)this.getType(id);
    }

    public List<NationType> getNationTypes() {
        return this.nationTypes;
    }

    public List<EuropeanNationType> getEuropeanNationTypes() {
        return this.europeanNationTypes;
    }

    public List<EuropeanNationType> getREFNationTypes() {
        return this.REFNationTypes;
    }

    public List<IndianNationType> getIndianNationTypes() {
        return this.indianNationTypes;
    }

    public List<EuropeanNationType> getClassicNationTypes() {
        return this.classicNationTypes;
    }

    public int numberOfNationTypes() {
        return this.nationTypes.size();
    }

    public NationType getNationType(String id) {
        return (NationType)this.getType(id);
    }

    public List<Nation> getNations() {
        return this.nations;
    }

    public Nation getNation(String id) {
        return (Nation)this.getType(id);
    }

    public List<Nation> getClassicNations() {
        return this.classicNations;
    }

    public List<Nation> getEuropeanNations() {
        return this.europeanNations;
    }

    public List<Nation> getIndianNations() {
        return this.indianNations;
    }

    public List<Nation> getREFNations() {
        return this.REFNations;
    }

    public List<EquipmentType> getEquipmentTypeList() {
        return this.equipmentTypes;
    }

    public EquipmentType getEquipmentType(String id) {
        return (EquipmentType)this.getType(id);
    }

    public List<DifficultyLevel> getDifficultyLevels() {
        return this.difficultyLevels;
    }

    public DifficultyLevel getDifficultyLevel(String id) {
        return (DifficultyLevel)this.getType(id);
    }

    public DifficultyLevel getDifficultyLevel(int level) {
        return this.difficultyLevels.get(level);
    }

    public void applyDifficultyLevel(int difficultyLevel) {
        for (String key : this.difficultyLevels.get(difficultyLevel).getOptions().keySet()) {
            this.allOptions.put(key, this.difficultyLevels.get(difficultyLevel).getOptions().get(key));
        }
    }

    public static void createSpecification(InputStream is) {
        specification = new Specification(is);
    }

    public static Specification getSpecification() {
        if (specification == null) {
            try {
                specification = new Specification(new FileInputStream("data/freecol/specification.xml"));
                logger.info("getSpecification()");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return specification;
    }

    public <T extends FreeColGameObjectType> T getType(XMLStreamReader in, String attributeName, Class<T> returnClass, T defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return (T)((FreeColGameObjectType)returnClass.cast(this.getType(attributeString)));
        }
        return defaultValue;
    }

    static {
        logger = Logger.getLogger(Specification.class.getName());
    }
}

