/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import net.sf.freecol.common.resources.ResourceFactory;
import net.sf.freecol.common.resources.ResourceMapping;

public class FreeColDataFile {
    private static final Logger logger = Logger.getLogger(FreeColDataFile.class.getName());
    private static final String RESOURCES_PROPERTIES_FILE = "resources.properties";
    private final File file;
    private final JarFile jarFile;
    private final List<InputStream> openStreams;
    private final String jarDirectory;
    private final InputStream supportOldSavegames;

    public FreeColDataFile(File file) throws IOException {
        if (!file.exists()) {
            for (String ending : this.getFileEndings()) {
                File tempFile = new File(file.getAbsolutePath() + ending);
                if (!tempFile.exists()) continue;
                file = tempFile;
                break;
            }
        }
        this.file = file;
        this.openStreams = new LinkedList<InputStream>();
        if (file.isDirectory()) {
            this.jarFile = null;
            this.jarDirectory = null;
            this.supportOldSavegames = null;
        } else {
            FileInputStream fis = new FileInputStream(file);
            this.openStreams.add(fis);
            BufferedInputStream in = new BufferedInputStream(fis);
            this.openStreams.add(in);
            ((InputStream)in).mark(10);
            byte[] buf = new byte[5];
            ((InputStream)in).read(buf, 0, 5);
            ((InputStream)in).reset();
            if (new String(buf).startsWith("PK")) {
                this.jarFile = new JarFile(file);
                this.jarDirectory = file.getName().split("\\.")[0];
                this.supportOldSavegames = null;
            } else {
                if (!new String(buf).equals("<?xml")) {
                    in = new BufferedInputStream(new GZIPInputStream(in));
                }
                this.supportOldSavegames = in;
                this.jarFile = null;
                this.jarDirectory = null;
            }
        }
    }

    public InputStream getInputStream(String filename) throws IOException {
        if (this.supportOldSavegames != null) {
            return this.supportOldSavegames;
        }
        if (this.file.isDirectory()) {
            FileInputStream fis = new FileInputStream(new File(this.file, filename));
            this.openStreams.add(fis);
            BufferedInputStream bis = new BufferedInputStream(fis);
            this.openStreams.add(bis);
            return bis;
        }
        InputStream fis = this.jarFile.getInputStream(this.jarFile.getJarEntry(this.jarDirectory + "/" + filename));
        this.openStreams.add(fis);
        BufferedInputStream bis = new BufferedInputStream(fis);
        this.openStreams.add(bis);
        return bis;
    }

    public ResourceMapping getResourceMapping() {
        try {
            Properties properties = new Properties();
            properties.load(this.getInputStream(RESOURCES_PROPERTIES_FILE));
            ResourceMapping rc = new ResourceMapping();
            if (this.supportOldSavegames != null) {
                return rc;
            }
            Enumeration<?> pn = properties.propertyNames();
            while (pn.hasMoreElements()) {
                String key = (String)pn.nextElement();
                URL resourceLocator = this.file.isDirectory() ? new URL("file", null, new File(this.file, properties.getProperty(key)).getAbsolutePath()) : new URL("jar:file:" + this.file.getAbsoluteFile() + "!/" + this.jarDirectory + "/" + properties.getProperty(key));
                rc.add(key, ResourceFactory.createResource(resourceLocator));
            }
            return rc;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception while reading ResourceMapping from: " + this.file, e);
            return null;
        }
    }

    public void close() {
        if (this.jarFile != null) {
            try {
                this.jarFile.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.openStreams != null) {
            for (InputStream is : this.openStreams) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.supportOldSavegames != null) {
            try {
                this.supportOldSavegames.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String[] getFileEndings() {
        return new String[]{".zip"};
    }
}

