/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.logging.TextFormatter;
import net.sf.freecol.common.networking.Message;

public final class DefaultHandler
extends Handler {
    private static final String fileName = new String("FreeCol.log");
    private FileWriter fileWriter;
    private final boolean consoleLogging;

    public DefaultHandler(boolean consoleLogging, File directory) throws FreeColException {
        this.consoleLogging = consoleLogging;
        File file = new File(directory, fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FreeColException("Log file \"" + fileName + "\" could not be created.");
            }
            if (file.isFile()) {
                file.delete();
            }
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new FreeColException("Log file \"" + fileName + "\" could not be created.");
        }
        if (!file.canWrite()) {
            throw new FreeColException("Can not write in log file \"" + fileName + "\".");
        }
        try {
            this.fileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            throw new FreeColException("Can not write in log file \"" + fileName + "\".");
        }
        this.setFormatter(new TextFormatter());
        try {
            String str = "FreeCol game version: " + FreeCol.getRevision() + "\n" + "FreeCol protocol version: " + Message.getFreeColProtocolVersion() + "\n\n" + "Java vendor: " + System.getProperty("java.vendor") + "\n" + "Java version: " + System.getProperty("java.version") + "\n" + "Java WM name: " + System.getProperty("java.vm.name") + "\n" + "Java WM vendor: " + System.getProperty("java.vm.vendor") + "\n" + "Java WM version: " + System.getProperty("java.vm.version") + "\n\n" + "OS name: " + System.getProperty("os.name") + "\n" + "OS architecture: " + System.getProperty("os.arch") + "\n" + "OS version: " + System.getProperty("os.version") + "\n\n";
            this.fileWriter.write(str, 0, str.length());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        String str = this.getFormatter().format(record);
        if (this.consoleLogging && record.getLevel().intValue() >= Level.WARNING.intValue()) {
            System.err.println(str);
        }
        try {
            this.fileWriter.write(str, 0, str.length());
        }
        catch (IOException e) {
            System.err.println("Failed to write log record!");
            e.printStackTrace(System.err);
        }
        this.flush();
    }
}

