/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public class AbstractUnit
extends FreeColObject {
    private Unit.Role role = Unit.Role.DEFAULT;
    private int number = 1;

    public AbstractUnit() {
    }

    public AbstractUnit(String id, Unit.Role someRole, int someNumber) {
        this.setId(id);
        this.role = someRole;
        this.number = someNumber;
    }

    public AbstractUnit(UnitType unitType, Unit.Role someRole, int someNumber) {
        this(unitType.getId(), someRole, someNumber);
    }

    public AbstractUnit(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLImpl(in);
    }

    public final UnitType getUnitType() {
        return FreeCol.getSpecification().getUnitType(this.getId());
    }

    public final Unit.Role getRole() {
        return this.role;
    }

    public final void setRole(Unit.Role newRole) {
        this.role = newRole;
    }

    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int newNumber) {
        this.number = newNumber;
    }

    public EquipmentType[] getEquipment() {
        ArrayList<EquipmentType> equipment = new ArrayList<EquipmentType>();
        switch (this.role) {
            case PIONEER: {
                EquipmentType tools = FreeCol.getSpecification().getEquipmentType("model.equipment.tools");
                for (int count = 0; count < tools.getMaximumCount(); ++count) {
                    equipment.add(tools);
                }
                break;
            }
            case MISSIONARY: {
                equipment.add(FreeCol.getSpecification().getEquipmentType("model.equipment.missionary"));
                break;
            }
            case SOLDIER: {
                equipment.add(FreeCol.getSpecification().getEquipmentType("model.equipment.muskets"));
                break;
            }
            case SCOUT: {
                equipment.add(FreeCol.getSpecification().getEquipmentType("model.equipment.horses"));
                break;
            }
            case DRAGOON: {
                equipment.add(FreeCol.getSpecification().getEquipmentType("model.equipment.muskets"));
                equipment.add(FreeCol.getSpecification().getEquipmentType("model.equipment.horses"));
                break;
            }
        }
        return equipment.toArray(new EquipmentType[equipment.size()]);
    }

    public String toString() {
        return Integer.toString(this.number) + " " + this.getId() + " (" + this.role.toString() + ")";
    }

    public final void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "id"));
        this.role = Enum.valueOf(Unit.Role.class, this.getAttribute(in, "role", "default").toUpperCase());
        this.number = this.getAttribute(in, "number", 1);
        in.nextTag();
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(AbstractUnit.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("role", this.role.toString().toLowerCase());
        out.writeAttribute("number", String.valueOf(this.number));
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "abstractUnit";
    }
}

