/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueue
extends FreeColObject
implements ListModel {
    private static final Logger logger = Logger.getLogger(BuildQueue.class.getName());
    private final List<BuildableType> model = new ArrayList<BuildableType>();
    private final List<ListDataListener> dataListeners = new ArrayList<ListDataListener>();
    private Type type = Type.MIXED;
    private int units = 0;
    private int buildings = 0;
    private Colony colony;

    public BuildQueue() {
    }

    public BuildQueue(Object[] values) {
        for (Object value : values) {
            BuildableType item = (BuildableType)value;
            this.model.add(item);
            if (item instanceof UnitType) {
                ++this.units;
                continue;
            }
            if (!(item instanceof BuildingType)) continue;
            ++this.buildings;
        }
    }

    public BuildQueue(Iterable<BuildableType> buildableTypes) {
        for (BuildableType buildableType : buildableTypes) {
            this.model.add(buildableType);
            if (buildableType instanceof UnitType) {
                ++this.units;
                continue;
            }
            if (!(buildableType instanceof BuildingType)) continue;
            ++this.buildings;
        }
    }

    public BuildQueue(XMLStreamReader in) throws XMLStreamException {
        this.readFromXML(in);
    }

    public BuildQueue(Element e) {
        this.readFromXMLElement(e);
    }

    public BuildQueue(Type type) {
        this.type = type;
    }

    public final Colony getColony() {
        return this.colony;
    }

    public final void setColony(Colony newColony) {
        this.colony = newColony;
    }

    public Type getType() {
        return this.type;
    }

    public boolean acceptsUnits() {
        return this.type != Type.BUILDINGS;
    }

    public boolean acceptsBuildings() {
        return this.type != Type.UNITS;
    }

    public boolean hasUnits() {
        return this.units > 0;
    }

    public boolean hasBuildings() {
        return this.buildings > 0;
    }

    public boolean ignoresPreferredIndex() {
        return this.type != Type.MIXED;
    }

    public boolean isReadOnly() {
        return this.type == Type.UNITS;
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public Iterator<BuildableType> iterator() {
        return this.model.iterator();
    }

    @Override
    public int getSize() {
        return this.model.size();
    }

    public int size() {
        return this.model.size();
    }

    public Object getElementAt(int index) {
        return this.model.get(index);
    }

    public BuildableType get(int index) {
        return this.model.get(index);
    }

    public boolean add(BuildableType item) {
        return this.add(this.model.size(), item);
    }

    public boolean addUnchecked(BuildableType item) {
        return this.model.add(item);
    }

    public void addUnchecked(int index, BuildableType item) {
        this.model.add(index, item);
    }

    public boolean add(int preferredIndex, BuildableType item) {
        if (this.type == Type.UNITS && item instanceof UnitType) {
            return true;
        }
        if (item instanceof UnitType && this.acceptsUnits() || item instanceof BuildingType && this.acceptsBuildings()) {
            int minimumIndex;
            int index = preferredIndex;
            if (item instanceof BuildingType) {
                int minimumIndex2 = this.findMinimumIndex((BuildingType)item);
                if (minimumIndex2 > index) {
                    index = minimumIndex2;
                }
            } else if (item instanceof UnitType && (minimumIndex = this.findMinimumIndex((UnitType)item)) > index) {
                index = minimumIndex;
            }
            this.model.add(index, item);
            if (item instanceof UnitType) {
                ++this.units;
            } else {
                ++this.buildings;
            }
            this.fireContentsChanged(0, this.getSize());
            return true;
        }
        return false;
    }

    public void addAll(int preferredIndex, BuildQueue buildQueue) {
        for (int index = 0; index < buildQueue.size(); ++index) {
            BuildableType item = buildQueue.get(index);
            this.add(preferredIndex + index, item);
        }
    }

    public void clear() {
        this.model.clear();
        this.units = 0;
        this.buildings = 0;
        this.fireContentsChanged(0, this.getSize());
    }

    public boolean contains(BuildableType item) {
        return this.model.contains(item);
    }

    public BuildableType firstItem() {
        return this.model.get(0);
    }

    public Object lastItem() {
        return this.model.get(this.model.size() - 1);
    }

    public boolean remove(BuildableType item) {
        boolean removed = this.model.remove(item);
        if (removed) {
            this.fireContentsChanged(0, this.getSize());
            if (item instanceof UnitType) {
                --this.units;
            } else {
                --this.buildings;
            }
        }
        return removed;
    }

    public void remove(int index) {
        BuildableType item = this.model.get(index);
        this.model.remove(index);
        if (item instanceof UnitType) {
            --this.units;
        } else {
            --this.buildings;
        }
        this.fireContentsChanged(0, this.getSize());
    }

    private boolean hasBuildingType(BuildingType buildingType) {
        if (this.model.contains(buildingType)) {
            return true;
        }
        if (buildingType.getUpgradesTo() != null) {
            return this.hasBuildingType(buildingType.getUpgradesTo());
        }
        return false;
    }

    public int findMinimumIndex(BuildingType buildingType) {
        BuildingType upgradeFrom = buildingType.getUpgradesFrom();
        if (upgradeFrom == null) {
            return 0;
        }
        if (this.colony != null) {
            Building building = this.colony.getBuilding(buildingType);
            if (building != null && upgradeFrom.equals(building.getType())) {
                return 0;
            }
            return -1;
        }
        int index = this.model.indexOf(upgradeFrom);
        if (index < 0) {
            return index;
        }
        return index + 1;
    }

    public int findMinimumIndex(UnitType unitType) {
        if (unitType.getAbilitiesRequired().isEmpty()) {
            return 0;
        }
        int index = -1;
        block0: for (Map.Entry<String, Boolean> entry : unitType.getAbilitiesRequired().entrySet()) {
            if (this.colony != null && this.colony.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) {
                if (index >= 0) continue;
                index = 0;
                continue;
            }
            if (!this.definedOnlyByBuildingType(entry.getKey())) continue;
            for (int newIndex = 0; newIndex < this.model.size(); ++newIndex) {
                BuildableType buildableType = this.model.get(newIndex);
                if (buildableType.hasAbility(entry.getKey()) != entry.getValue().booleanValue() || index >= newIndex) continue;
                index = newIndex;
                continue block0;
            }
            return -1;
        }
        if (index < 0) {
            return index;
        }
        return index + 1;
    }

    public int findMinimumIndex(BuildableType buildableType) {
        if (buildableType instanceof BuildingType) {
            return this.findMinimumIndex((BuildingType)buildableType);
        }
        if (buildableType instanceof UnitType) {
            return this.findMinimumIndex((UnitType)buildableType);
        }
        return -1;
    }

    public boolean definedOnlyByBuildingType(String id) {
        List<Ability> definedAbilities = Specification.getSpecification().getAbilities(id);
        if (definedAbilities != null) {
            for (Ability ability : definedAbilities) {
                if (ability.getSource() == null || ability.getSource() instanceof BuildingType) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean dependenciesSatisfiedBy(BuildQueue ... queues) {
        HashSet<BuildableType> items = new HashSet<BuildableType>(this.model);
        for (BuildQueue buildQueue : queues) {
            items.addAll(buildQueue.model);
        }
        FeatureContainer featureContainer = new FeatureContainer();
        for (BuildableType item : items) {
            featureContainer.add(item.getFeatureContainer());
        }
        for (BuildableType item : this.model) {
            if (item instanceof BuildingType) {
                BuildingType upgradesFrom = ((BuildingType)item).getUpgradesFrom();
                if (upgradesFrom == null || items.contains(upgradesFrom)) continue;
                return false;
            }
            if (!(item instanceof UnitType)) continue;
            for (Map.Entry<String, Boolean> entry : ((UnitType)item).getAbilitiesRequired().entrySet()) {
                if (!this.definedOnlyByBuildingType(entry.getKey()) || featureContainer.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.dataListeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.dataListeners.remove(l);
    }

    public void fireContentsChanged(int firstIndex, int lastIndex) {
        ListDataEvent event = new ListDataEvent(this, 0, firstIndex, lastIndex);
        for (ListDataListener listener : this.dataListeners) {
            listener.contentsChanged(event);
        }
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(BuildQueue.getXMLElementTagName());
        out.writeAttribute("type", this.type.toString());
        out.writeAttribute("xLength", String.valueOf(this.model.size()));
        for (int index = 0; index < this.model.size(); ++index) {
            out.writeAttribute("x" + index, this.model.get(index).getId());
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.type = Enum.valueOf(Type.class, in.getAttributeValue(null, "type"));
        int size = Integer.parseInt(in.getAttributeValue(null, "size"));
        for (int index = 0; index < size; ++index) {
            this.addUnchecked((BuildableType)Specification.getSpecification().getType(in.getAttributeValue(null, "element" + index)));
        }
    }

    public static String getXMLElementTagName() {
        return "buildQueue";
    }

    public String toString() {
        String text = "";
        for (BuildableType item : this.model) {
            text = text + item.getName() + " ";
        }
        return text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MIXED,
        UNITS,
        BUILDINGS;

    }
}

