/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildableType
extends FreeColGameObjectType {
    public static final int UNDEFINED = Integer.MIN_VALUE;
    public static final BuildableType NOTHING = new BuildableType("model.buildableType.nothing");
    private int populationRequired = 1;
    private List<AbstractGoods> goodsRequired = new ArrayList<AbstractGoods>();
    private final HashMap<String, Boolean> requiredAbilities = new HashMap();

    public BuildableType() {
    }

    private BuildableType(String id) {
        this.setId(id);
    }

    public String getGoodsRequiredAsString() {
        if (this.goodsRequired == null || this.goodsRequired.isEmpty()) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractGoods goods : this.goodsRequired) {
            result.add(Messages.message("model.goods.goodsAmount", "%amount%", String.valueOf(goods.getAmount()), "%goods%", goods.getType().getName()));
        }
        return Utils.join(", ", result);
    }

    public final List<AbstractGoods> getGoodsRequired() {
        return this.goodsRequired;
    }

    public final int getAmountRequiredOf(GoodsType type) {
        for (AbstractGoods goods : this.goodsRequired) {
            if (goods.getType() != type) continue;
            return goods.getAmount();
        }
        return 0;
    }

    public final void setGoodsRequired(List<AbstractGoods> newGoodsRequired) {
        this.goodsRequired = newGoodsRequired;
    }

    public int getPopulationRequired() {
        return this.populationRequired;
    }

    public void setPopulationRequired(int newPopulationRequired) {
        this.populationRequired = newPopulationRequired;
    }

    public Map<String, Boolean> getAbilitiesRequired() {
        return this.requiredAbilities;
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
    }

    @Override
    protected void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        super.readFromXML(in, specification);
    }

    @Override
    protected FreeColObject readChild(XMLStreamReader in, Specification specification) throws XMLStreamException {
        String childName = in.getLocalName();
        if ("required-ability".equals(childName)) {
            String abilityId = in.getAttributeValue(null, "id");
            boolean value = this.getAttribute(in, "value", true);
            this.getAbilitiesRequired().put(abilityId, value);
            specification.addAbility(abilityId);
            in.nextTag();
            return new Ability(abilityId, value);
        }
        if ("required-goods".equals(childName)) {
            GoodsType type = specification.getGoodsType(in.getAttributeValue(null, "id"));
            int amount = this.getAttribute(in, "value", 0);
            AbstractGoods requiredGoods = new AbstractGoods(type, amount);
            if (amount > 0) {
                type.setBuildingMaterial(true);
                if (this.getGoodsRequired() == null) {
                    this.setGoodsRequired(new ArrayList<AbstractGoods>());
                }
                this.getGoodsRequired().add(requiredGoods);
            }
            in.nextTag();
            return requiredGoods;
        }
        return super.readChild(in, specification);
    }
}

