/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Building
extends FreeColGameObject
implements WorkLocation,
Ownable,
Named {
    private Colony colony;
    private List<Unit> units = Collections.emptyList();
    private BuildingType buildingType;
    private static Comparator<Building> buildingComparator = new Comparator<Building>(){

        @Override
        public int compare(Building b1, Building b2) {
            return b1.getType().getSequence() - b2.getType().getSequence();
        }
    };

    public Building(Game game, Colony colony, BuildingType type) {
        super(game);
        this.colony = colony;
        this.buildingType = type;
    }

    public Building(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Building(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Building(Game game, String id) {
        super(game, id);
    }

    @Override
    public Player getOwner() {
        return this.colony.getOwner();
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tile getTile() {
        return this.colony.getTile();
    }

    @Override
    public String getName() {
        return this.buildingType.getName();
    }

    public int getLevel() {
        return this.buildingType.getLevel();
    }

    @Override
    public String getLocationName() {
        return Messages.message("inLocation", "%location%", this.getName());
    }

    public String getNextName() {
        BuildingType next = this.buildingType.getUpgradesTo();
        return next == null ? null : next.getName();
    }

    public boolean canBuildNext() {
        return this.getColony().canBuild(this.buildingType.getUpgradesTo());
    }

    @Override
    public Colony getColony() {
        return this.colony;
    }

    public BuildingType getType() {
        return this.buildingType;
    }

    public boolean canBeDamaged() {
        return this.buildingType.getGoodsRequired() != null;
    }

    public void damage() {
        if (this.canBeDamaged()) {
            this.setType(this.buildingType.getUpgradesFrom());
        }
    }

    public void upgrade() {
        if (!this.canBuildNext()) {
            throw new IllegalStateException("Cannot upgrade this building.");
        }
        this.setType(this.buildingType.getUpgradesTo());
    }

    private void setType(BuildingType newBuildingType) {
        this.colony.getFeatureContainer().remove(this.buildingType.getFeatureContainer());
        if (newBuildingType != null) {
            this.buildingType = newBuildingType;
            this.colony.getFeatureContainer().add(this.buildingType.getFeatureContainer());
            for (Unit unit : this.units) {
                if (this.canAdd(unit.getType())) continue;
                unit.putOutsideColony();
            }
        }
        while (this.units.size() > this.getMaxUnits()) {
            this.getLastUnit().putOutsideColony();
        }
    }

    public int getMaxUnits() {
        return this.buildingType.getWorkPlaces();
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable.getLocation() == this) {
            return true;
        }
        if (this.getUnitCount() >= this.getMaxUnits()) {
            return false;
        }
        if (!(locatable instanceof Unit)) {
            return false;
        }
        return this.canAdd(((Unit)locatable).getType());
    }

    public boolean canAdd(UnitType unitType) {
        return this.buildingType.canAdd(unitType);
    }

    @Override
    public void add(Locatable locatable) {
        if (!this.canAdd(locatable)) {
            throw new IllegalStateException("Cannot add " + locatable + " to " + this.getName());
        }
        if (!this.units.contains(locatable)) {
            if (((Object)this.units).equals(Collections.emptyList())) {
                this.units = new ArrayList<Unit>();
            }
            Unit unit = (Unit)locatable;
            unit.removeAllEquipment(false);
            Unit student = unit.getStudent();
            if (this.buildingType.hasAbility("model.ability.teach")) {
                if (student == null && (student = this.findStudent(unit)) != null) {
                    unit.setStudent(student);
                    student.setTeacher(unit);
                }
            } else if (student != null) {
                student.setTeacher(null);
                unit.setStudent(null);
            }
            this.units.add(unit);
            GoodsType output = this.getGoodsOutputType();
            if (output != null) {
                this.colony.firePropertyChange(Colony.ColonyChangeEvent.PRODUCTION_CHANGE.toString(), new AbstractGoods(output, 0), new AbstractGoods(output, 1));
            }
        }
    }

    public UnitType getExpertUnitType() {
        return FreeCol.getSpecification().getExpertForProducing(this.getGoodsOutputType());
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (this.units.remove(locatable)) {
                ((Unit)locatable).setMovesLeft(0);
                GoodsType output = this.getGoodsOutputType();
                if (output != null) {
                    this.colony.firePropertyChange(Colony.ColonyChangeEvent.PRODUCTION_CHANGE.toString(), new AbstractGoods(output, 1), new AbstractGoods(output, 0));
                }
            }
        } else {
            throw new IllegalStateException("Can only add units to building.");
        }
    }

    @Override
    public boolean contains(Locatable locatable) {
        return this.units.contains(locatable);
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    @Override
    public List<Unit> getUnitList() {
        return new ArrayList<Unit>(this.units);
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public void newTurn() {
        if (this.buildingType.hasAbility("model.ability.teach")) {
            this.trainStudents();
        }
        if (this.buildingType.hasAbility("model.ability.repairUnits")) {
            this.repairUnits();
        }
        if (this.getGoodsOutputType() != null) {
            this.produceGoods();
        }
    }

    private void repairUnits() {
        for (Unit unit : this.getTile().getUnitList()) {
            if (!unit.isUnderRepair() || !this.buildingType.hasAbility("model.ability.repairUnits", unit.getType())) continue;
            unit.setHitpoints(unit.getHitpoints() + 1);
            if (unit.isUnderRepair()) continue;
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.DEFAULT, this, "model.unit.unitRepaired", "%unit%", unit.getName(), "%repairLocation%", this.getLocationName());
        }
    }

    private void produceGoods() {
        int goodsInput = this.getGoodsInput();
        int goodsOutput = this.getProduction();
        GoodsType goodsInputType = this.getGoodsInputType();
        GoodsType goodsOutputType = this.getGoodsOutputType();
        if (goodsInput == 0 && !this.canAutoProduce() && this.getMaximumGoodsInput() > 0) {
            this.addModelMessage((FreeColGameObject)this.getColony(), ModelMessage.MessageType.MISSING_GOODS, goodsInputType, "model.building.notEnoughInput", "%inputGoods%", goodsInputType.getName(), "%building%", this.getName(), "%colony%", this.colony.getName());
        }
        if (goodsOutput <= 0) {
            return;
        }
        if (goodsOutputType.isBuildingMaterial() && !goodsOutputType.isStorable() && !this.getColony().canBuild()) {
            return;
        }
        if (goodsInputType != null) {
            this.colony.removeGoods(goodsInputType, goodsInput);
        }
        this.colony.addGoods(goodsOutputType, goodsOutput);
        if (goodsOutputType.isPlayerAccumulated()) {
            this.getOwner().increment(goodsOutputType, goodsOutput);
        }
        if (this.getUnitCount() > 0) {
            int experience = goodsOutput / this.getUnitCount();
            for (Unit unit : this.getUnitList()) {
                unit.modifyExperience(experience);
            }
        }
    }

    public Unit findStudent(Unit teacher) {
        Unit student = null;
        int skill = Integer.MIN_VALUE;
        for (Unit potentialStudent : this.getColony().getUnitList()) {
            if (!potentialStudent.canBeStudent(teacher) || potentialStudent.getTeacher() != null || potentialStudent.getSkillLevel() <= skill) continue;
            student = potentialStudent;
            skill = student.getSkillLevel();
        }
        return student;
    }

    private boolean assignStudent(Unit teacher) {
        Unit student = this.findStudent(teacher);
        if (student == null) {
            this.addModelMessage((FreeColGameObject)this.getColony(), ModelMessage.MessageType.WARNING, teacher, "model.building.noStudent", "%teacher%", teacher.getName(), "%colony%", this.colony.getName());
            return false;
        }
        teacher.setStudent(student);
        student.setTeacher(teacher);
        return true;
    }

    private void trainStudents() {
        Iterator<Unit> teachers = this.getUnitIterator();
        while (teachers.hasNext()) {
            Unit teacher = teachers.next();
            if (teacher.getStudent() == null && !this.assignStudent(teacher)) continue;
            int training = teacher.getTurnsOfTraining() + 1;
            if (training < teacher.getNeededTurnsOfTraining()) {
                teacher.setTurnsOfTraining(training);
                continue;
            }
            teacher.setTurnsOfTraining(0);
            teacher.getStudent().train();
            if (teacher.getStudent() != null) continue;
            this.assignStudent(teacher);
        }
    }

    public GoodsType getGoodsOutputType() {
        return this.getType().getProducedGoodsType();
    }

    public GoodsType getGoodsInputType() {
        return this.getType().getConsumedGoodsType();
    }

    public int getMaximumGoodsInput() {
        if (this.getGoodsInputType() == null) {
            return 0;
        }
        if (this.canAutoProduce()) {
            return this.getMaximumAutoProduction();
        }
        return this.getProductivity(new Unit[0]);
    }

    private int getStoredInput() {
        return this.colony.getGoodsCount(this.getGoodsInputType());
    }

    public int getGoodsInput() {
        if (this.getGoodsInputType() == null) {
            return 0;
        }
        if (this.canAutoProduce()) {
            return this.getGoodsInputAuto(this.colony.getProductionOf(this.getGoodsInputType()));
        }
        return this.calculateGoodsInput(this.getMaximumGoodsInput(), 0);
    }

    public int getGoodsInputNextTurn() {
        if (this.getGoodsInputType() == null) {
            return 0;
        }
        if (this.canAutoProduce()) {
            return this.getGoodsInputAuto(this.colony.getProductionNextTurn(this.getGoodsInputType()));
        }
        return this.calculateGoodsInput(this.getMaximumGoodsInput(), this.colony.getProductionNextTurn(this.getGoodsInputType()));
    }

    private int getGoodsInputAuto(int available) {
        if (this.getGoodsInputType() == null) {
            return 0;
        }
        int outputGoods = this.colony.getGoodsCount(this.getGoodsOutputType());
        if (outputGoods < this.getGoodsOutputType().getBreedingNumber() || outputGoods >= this.colony.getWarehouseCapacity()) {
            return 0;
        }
        int surplus = available;
        if (this.getGoodsInputType().isFoodType()) {
            if ((surplus -= this.colony.getFoodConsumptionByType(this.getGoodsInputType())) <= 0) {
                return 0;
            }
            surplus = (int)Math.ceil((double)surplus / 2.0);
        }
        return surplus;
    }

    private int calculateGoodsInput(int maximumGoodsInput, int addToWarehouse) {
        int availableInput = this.getStoredInput() + addToWarehouse;
        if (availableInput < maximumGoodsInput) {
            return availableInput;
        }
        return maximumGoodsInput;
    }

    private int getProductionAdding(int availableGoodsInput, Unit ... additionalUnits) {
        if (this.getGoodsOutputType() == null) {
            return 0;
        }
        int maximumGoodsInput = this.getProductivity(additionalUnits);
        if (this.getGoodsInputType() != null) {
            if (availableGoodsInput < maximumGoodsInput) {
                maximumGoodsInput = availableGoodsInput;
            }
            if (this.buildingType.hasAbility("model.ability.expertsUseConnections") && this.getGameOptions().getBoolean("model.option.expertsHaveConnections")) {
                int minimumGoodsInput = 0;
                for (Unit unit : this.units) {
                    if (unit.getType() != this.getExpertUnitType()) continue;
                    minimumGoodsInput += 4;
                }
                for (Unit unit : additionalUnits) {
                    if (!this.canAdd(unit) || unit.getType() != this.getExpertUnitType()) continue;
                    minimumGoodsInput += 4;
                }
                if (maximumGoodsInput < minimumGoodsInput) {
                    maximumGoodsInput = minimumGoodsInput;
                }
            }
        }
        return this.applyModifiers(maximumGoodsInput);
    }

    public int getProduction() {
        if (this.canAutoProduce()) {
            return this.getAutoProduction(this.getGoodsInput());
        }
        if (this.getGoodsInputType() == null) {
            return this.getProductionAdding(0, new Unit[0]);
        }
        return this.getProductionAdding(this.getStoredInput(), new Unit[0]);
    }

    public int getProductionNextTurn() {
        if (this.canAutoProduce()) {
            return this.getAutoProduction(this.getGoodsInputNextTurn());
        }
        if (this.getGoodsInputType() == null) {
            return this.getProductionAdding(0, new Unit[0]);
        }
        return this.getProductionAdding(this.getStoredInput() + this.colony.getProductionNextTurn(this.getGoodsInputType()), new Unit[0]);
    }

    public boolean canAutoProduce() {
        return this.buildingType.hasAbility("model.ability.autoProduction");
    }

    private int getAutoProduction(int availableInput) {
        int availSpace;
        if (this.getGoodsOutputType() == null || this.colony.getGoodsCount(this.getGoodsOutputType()) >= this.colony.getWarehouseCapacity()) {
            return 0;
        }
        int goodsOutput = this.getMaximumAutoProduction();
        if (this.getGoodsInputType() != null && availableInput < goodsOutput) {
            goodsOutput = availableInput;
        }
        if (goodsOutput > (availSpace = this.colony.getWarehouseCapacity() - this.colony.getGoodsCount(this.getGoodsOutputType()))) {
            goodsOutput = availSpace;
        }
        return this.applyModifiers(goodsOutput);
    }

    public int getAdditionalProductionNextTurn(Unit addUnit) {
        return this.getProductionAdding(this.getStoredInput() + this.colony.getProductionNextTurn(this.getGoodsInputType()), addUnit) - this.getProductionNextTurn();
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == this.getGoodsOutputType()) {
            return this.getProduction();
        }
        return 0;
    }

    private int getProductivity(Unit ... additionalUnits) {
        if (this.getGoodsOutputType() == null) {
            return 0;
        }
        int productivity = 0;
        for (Unit unit : this.units) {
            productivity += this.getUnitProductivity(unit);
        }
        for (Unit unit : additionalUnits) {
            if (!this.canAdd(unit)) continue;
            productivity += this.getUnitProductivity(unit);
        }
        return productivity;
    }

    public int getUnitProductivity(Unit prodUnit) {
        if (this.getGoodsOutputType() == null || prodUnit == null) {
            return 0;
        }
        int base = this.buildingType.getBasicProduction();
        int productivity = prodUnit.getProductionOf(this.getGoodsOutputType(), base);
        if (productivity > 0 && (productivity += this.colony.getProductionBonus()) < 1) {
            productivity = 1;
        }
        return productivity;
    }

    public Set<Modifier> getProductivityModifiers(Unit prodUnit) {
        if (this.getGoodsOutputType() == null) {
            return Collections.emptySet();
        }
        String outputId = this.getGoodsOutputType().getId();
        LinkedHashSet<Modifier> result = new LinkedHashSet<Modifier>();
        if (this.buildingType.getProductionModifier() != null) {
            result.add(this.buildingType.getProductionModifier());
        }
        result.addAll(prodUnit.getModifierSet(outputId));
        return result;
    }

    public int getMaximumProduction() {
        if (this.canAutoProduce()) {
            return this.getMaximumAutoProduction();
        }
        return this.applyModifiers(this.getProductivity(new Unit[0]));
    }

    private int getMaximumAutoProduction() {
        int available = this.colony.getGoodsCount(this.getGoodsOutputType());
        if (available < this.getGoodsOutputType().getBreedingNumber()) {
            return 0;
        }
        return Math.max(1, available / 10);
    }

    public int getAdditionalProduction(Unit addUnit) {
        return this.getProductionAdding(this.getStoredInput(), addUnit) - this.getProduction();
    }

    public int applyModifiers(int productivity) {
        GoodsType goodsOutputType = this.getGoodsOutputType();
        if (goodsOutputType == null) {
            return 0;
        }
        return Math.round(this.colony.getFeatureContainer().applyModifier(productivity, goodsOutputType.getId(), this.buildingType, this.getGame().getTurn()));
    }

    public static Comparator<Building> getBuildingComparator() {
        return buildingComparator;
    }

    @Override
    public void dispose() {
        for (Unit unit : new ArrayList<Unit>(this.units)) {
            unit.dispose();
        }
        super.dispose();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Building.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("colony", this.colony.getId());
        out.writeAttribute("buildingType", this.buildingType.getId());
        Iterator<Unit> unitIterator = this.getUnitIterator();
        while (unitIterator.hasNext()) {
            unitIterator.next().toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.colony = this.getFreeColGameObject(in, "colony", Colony.class);
        this.buildingType = FreeCol.getSpecification().getBuildingType(in.getAttributeValue(null, "buildingType"));
        this.units.clear();
        while (in.nextTag() != 2) {
            Unit unit = this.updateFreeColGameObject(in, Unit.class);
            if (this.units.contains(unit)) continue;
            if (((Object)this.units).equals(Collections.emptyList())) {
                this.units = new ArrayList<Unit>();
            }
            this.units.add(unit);
        }
    }

    public static String getXMLElementTagName() {
        return "building";
    }

    @Override
    public String toString() {
        return this.getType().getId();
    }
}

