/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.awt.Image;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

public final class BuildingType
extends BuildableType {
    private int level;
    private int workPlaces;
    private int basicProduction;
    private int minSkill;
    private int maxSkill;
    private GoodsType consumes;
    private GoodsType produces;
    private Modifier productionModifier = null;
    private BuildingType upgradesFrom;
    private BuildingType upgradesTo;
    private int sequence;

    public BuildingType(int index) {
        this.setIndex(index);
        this.setPopulationRequired(1);
    }

    public BuildingType getUpgradesFrom() {
        return this.upgradesFrom;
    }

    public BuildingType getUpgradesTo() {
        return this.upgradesTo;
    }

    public Image getImage() {
        return ResourceManager.getImage(this.getId() + ".image");
    }

    public BuildingType getFirstLevel() {
        BuildingType buildingType = this;
        while (buildingType.getUpgradesFrom() != null) {
            buildingType = buildingType.getUpgradesFrom();
        }
        return buildingType;
    }

    public int getWorkPlaces() {
        return this.workPlaces;
    }

    public int getBasicProduction() {
        return this.basicProduction;
    }

    public GoodsType getConsumedGoodsType() {
        return this.consumes;
    }

    public GoodsType getProducedGoodsType() {
        return this.produces;
    }

    public int getLevel() {
        return this.level;
    }

    public int getSequence() {
        return this.sequence;
    }

    public FreeColGameObjectType getType() {
        return this;
    }

    public Modifier getProductionModifier() {
        return this.productionModifier;
    }

    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        if (this.hasAttribute(in, "upgradesFrom")) {
            this.upgradesFrom = specification.getBuildingType(in.getAttributeValue(null, "upgradesFrom"));
            this.upgradesFrom.upgradesTo = this;
            this.level = this.upgradesFrom.level + 1;
        } else {
            this.level = 1;
        }
        this.setPopulationRequired(this.getAttribute(in, "required-population", 1));
        this.workPlaces = this.getAttribute(in, "workplaces", 0);
        this.basicProduction = this.getAttribute(in, "basicProduction", 0);
        this.consumes = specification.getType(in, "consumes", GoodsType.class, null);
        this.produces = specification.getType(in, "produces", GoodsType.class, null);
        if (this.produces != null && this.basicProduction > 0) {
            this.productionModifier = new Modifier(this.produces.getId(), this, this.basicProduction, Modifier.Type.ADDITIVE);
        }
        this.minSkill = this.getAttribute(in, "minSkill", Integer.MIN_VALUE);
        this.maxSkill = this.getAttribute(in, "maxSkill", Integer.MAX_VALUE);
        this.sequence = this.getAttribute(in, "sequence", 0);
    }

    public static String getXMLElementTagName() {
        return "building-type";
    }

    public boolean canAdd(UnitType unitType) {
        return unitType.hasSkill() && unitType.getSkill() >= this.minSkill && unitType.getSkill() <= this.maxSkill;
    }
}

