/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BonusOrPenalty;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Colony
extends Settlement
implements Nameable,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(Colony.class.getName());
    public static final int BELLS_PER_REBEL = 200;
    public static final int FOOD_PER_COLONIST = 200;
    public static final Ability HAS_PORT = new Ability("model.ability.hasPort");
    public static final BonusOrPenalty SOL_MODIFIER_SOURCE = new BonusOrPenalty("modifiers.solModifier");
    private String name;
    private final List<ColonyTile> colonyTiles = new ArrayList<ColonyTile>();
    private final java.util.Map<String, Building> buildingMap = new HashMap<String, Building>();
    private final java.util.Map<String, ExportData> exportData = new HashMap<String, ExportData>();
    private int sonsOfLiberty;
    private int oldSonsOfLiberty;
    private int tories;
    private int oldTories;
    private int productionBonus;
    private boolean landLocked = true;
    private int unitCount = -1;
    private int lastVisited = -1;
    private List<BuildableType> buildQueue = new ArrayList<BuildableType>();

    public Colony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, tile);
        this.goodsContainer = new GoodsContainer(game, this);
        this.goodsContainer.addPropertyChangeListener("CARGO_CHANGE", this);
        this.name = name;
        this.sonsOfLiberty = 0;
        this.oldSonsOfLiberty = 0;
        Map map = game.getMap();
        tile.setOwner(owner);
        if (!tile.hasRoad()) {
            TileImprovement road = new TileImprovement(game, tile, FreeCol.getSpecification().getTileImprovementType("model.improvement.Road"));
            road.setTurnsToComplete(0);
            road.setVirtual(true);
            tile.add(road);
        }
        for (Map.Direction direction : Map.Direction.values()) {
            Tile t = map.getNeighbourOrNull(direction, tile);
            if (t == null) continue;
            if (t.getOwner() == null) {
                t.setOwner(owner);
            }
            this.colonyTiles.add(new ColonyTile(game, this, t));
            if (!t.getType().isWater()) continue;
            this.landLocked = false;
        }
        if (!this.landLocked) {
            this.featureContainer.addAbility(HAS_PORT);
        }
        this.colonyTiles.add(new ColonyTile(game, this, tile));
        List<BuildingType> buildingTypes = FreeCol.getSpecification().getBuildingTypeList();
        for (BuildingType buildingType : buildingTypes) {
            if (buildingType.getUpgradesFrom() == null && buildingType.getGoodsRequired().isEmpty()) {
                this.addBuilding(new Building(this.getGame(), this, buildingType));
                continue;
            }
            if (!this.isFree(buildingType)) continue;
            this.addBuilding(new Building(this.getGame(), this, buildingType));
        }
        this.setCurrentlyBuilding(BuildableType.NOTHING);
    }

    public Colony(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Colony(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Colony(Game game, String id) {
        super(game, id);
    }

    private boolean isFree(BuildingType buildingType) {
        float value = this.owner.getFeatureContainer().applyModifier(100.0f, "model.modifier.buildingPriceBonus", buildingType, this.getGame().getTurn());
        return value == 0.0f && this.canBuild(buildingType);
    }

    public void addBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        this.buildingMap.put(buildingType.getId(), building);
        this.featureContainer.add(building.getType().getFeatureContainer());
    }

    public boolean canReducePopulation() {
        return (float)this.getUnitCount() > FeatureContainer.applyModifierSet(0.0f, this.getGame().getTurn(), this.getModifierSet("model.modifier.minimumColonySize"));
    }

    public void updatePopulation(int difference) {
        int population = this.getUnitCount();
        if (population > 0) {
            for (BuildingType buildingType : FreeCol.getSpecification().getBuildingTypeList()) {
                Building b;
                if (!this.isFree(buildingType) || (b = this.createFreeBuilding(buildingType)) == null) continue;
                this.addBuilding(b);
            }
            this.getTile().updatePlayerExploredTiles();
            this.updateSoL();
            this.updateProductionBonus();
        }
        this.firePropertyChange(ColonyChangeEvent.POPULATION_CHANGE.toString(), population - difference, population);
    }

    public ExportData getExportData(GoodsType goodsType) {
        ExportData result = this.exportData.get(goodsType.getId());
        if (result == null) {
            result = new ExportData(goodsType);
            this.setExportData(result);
        }
        return result;
    }

    public final void setExportData(ExportData newExportData) {
        this.exportData.put(newExportData.getId(), newExportData);
    }

    public boolean isLandLocked() {
        return this.landLocked;
    }

    public boolean isUndead() {
        Iterator<Unit> unitIterator = this.getUnitIterator();
        return unitIterator.hasNext() && unitIterator.next().isUndead();
    }

    @Override
    public void setOwner(Player owner) {
        super.setOwner(owner);
        this.tile.setOwner(owner);
        for (Unit unit : this.getUnitList()) {
            unit.setOwner(owner);
            if (!(unit.getLocation() instanceof ColonyTile)) continue;
            ((ColonyTile)unit.getLocation()).getWorkTile().setOwner(owner);
        }
        for (Unit target : this.tile.getUnitList()) {
            target.setOwner(this.getOwner());
        }
        for (ExportData exportDatum : this.exportData.values()) {
            exportDatum.setExported(false);
        }
        this.updatePopulation(0);
    }

    public void setUnitCount(int unitCount) {
        this.unitCount = unitCount;
    }

    public Building getBuildingForProducing(GoodsType goodsType) {
        for (Building building : this.buildingMap.values()) {
            if (building.getGoodsOutputType() != goodsType) continue;
            return building;
        }
        return null;
    }

    public Building getBuildingForConsuming(GoodsType goodsType) {
        for (Building building : this.buildingMap.values()) {
            if (building.getGoodsInputType() != goodsType) continue;
            return building;
        }
        return null;
    }

    public List<WorkLocation> getWorkLocations() {
        ArrayList<WorkLocation> result = new ArrayList<WorkLocation>(this.colonyTiles);
        result.addAll(this.buildingMap.values());
        return result;
    }

    public List<Building> getBuildings() {
        return new ArrayList<Building>(this.buildingMap.values());
    }

    public List<ColonyTile> getColonyTiles() {
        return this.colonyTiles;
    }

    public Building getBuilding(BuildingType type) {
        return this.buildingMap.get(type.getFirstLevel().getId());
    }

    public Building getBuildingWithAbility(String ability) {
        for (Building building : this.buildingMap.values()) {
            if (!building.getType().hasAbility(ability)) continue;
            return building;
        }
        return null;
    }

    public ColonyTile getColonyTile(int x, int y) {
        Tile t = this.getTile(x, y);
        for (ColonyTile c : this.colonyTiles) {
            if (c.getWorkTile() != t) continue;
            return c;
        }
        return null;
    }

    public ColonyTile getColonyTile(Tile t) {
        for (ColonyTile c : this.colonyTiles) {
            if (c.getWorkTile() != t) continue;
            return c;
        }
        return null;
    }

    @Override
    public void add(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (((Unit)locatable).isColonist()) {
                WorkLocation w = this.getVacantWorkLocationFor((Unit)locatable);
                if (w == null) {
                    logger.warning("Could not find a 'WorkLocation' for " + locatable + " in " + this);
                    ((Unit)locatable).putOutsideColony();
                } else {
                    int oldPopulation = this.getUnitCount();
                    ((Unit)locatable).work(w);
                    this.firePropertyChange(ColonyChangeEvent.POPULATION_CHANGE.toString(), oldPopulation, oldPopulation + 1);
                    this.updatePopulation(1);
                }
            } else {
                ((Unit)locatable).putOutsideColony();
            }
        } else if (locatable instanceof Goods) {
            this.addGoods((Goods)locatable);
        } else {
            logger.warning("Tried to add an unrecognized 'Locatable' to a 'Colony'.");
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            for (WorkLocation w : this.getWorkLocations()) {
                if (!w.contains(locatable)) continue;
                int oldPopulation = this.getUnitCount();
                w.remove(locatable);
                this.firePropertyChange(ColonyChangeEvent.POPULATION_CHANGE.toString(), oldPopulation, oldPopulation - 1);
                this.updatePopulation(-1);
                return;
            }
        } else if (locatable instanceof Goods) {
            this.removeGoods((Goods)locatable);
        } else {
            logger.warning("Tried to remove an unrecognized 'Locatable' from a 'Colony'.");
        }
    }

    @Override
    public int getUnitCount() {
        int count = 0;
        if (this.unitCount != -1) {
            return this.unitCount;
        }
        for (WorkLocation w : this.getWorkLocations()) {
            count += w.getUnitCount();
        }
        return count;
    }

    @Override
    public List<Unit> getUnitList() {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (WorkLocation wl : this.getWorkLocations()) {
            for (Unit unit : wl.getUnitList()) {
                units.add(unit);
            }
        }
        return units;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public boolean contains(Locatable locatable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (locatable instanceof Unit && ((Unit)locatable).getOwner() == this.getOwner()) {
            return true;
        }
        return locatable instanceof Goods;
    }

    public boolean canTrain(Unit unit) {
        return this.canTrain(unit.getType());
    }

    public boolean canTrain(UnitType unitType) {
        if (!this.hasAbility("model.ability.teach")) {
            return false;
        }
        for (Building building : this.buildingMap.values()) {
            if (!building.getType().hasAbility("model.ability.teach") || !building.canAdd(unitType)) continue;
            return true;
        }
        return false;
    }

    public List<Unit> getTeachers() {
        ArrayList<Unit> teachers = new ArrayList<Unit>();
        for (Building building : this.buildingMap.values()) {
            if (!building.getType().hasAbility("model.ability.teach")) continue;
            teachers.addAll(building.getUnitList());
        }
        return teachers;
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        List<Unit> unitList = this.getUnitList();
        if (this.unitCount != -1 && unitList.isEmpty()) {
            return null;
        }
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : unitList) {
            float tmpPower = this.getGame().getCombatModel().getDefencePower(attacker, nextUnit);
            if (!(tmpPower > defencePower) && defender != null) continue;
            defender = nextUnit;
            defencePower = tmpPower;
        }
        if (defender == null) {
            throw new IllegalStateException("Colony " + this.name + " contains no units!");
        }
        return defender;
    }

    public List<UnitType> getBuildableUnits() {
        ArrayList<UnitType> buildableUnits = new ArrayList<UnitType>();
        List<UnitType> unitTypes = FreeCol.getSpecification().getUnitTypeList();
        for (UnitType unitType : unitTypes) {
            if (unitType.getGoodsRequired().isEmpty() || !this.canBuild(unitType)) continue;
            buildableUnits.add(unitType);
        }
        return buildableUnits;
    }

    public BuildableType getCurrentlyBuilding() {
        return this.buildQueue.get(0);
    }

    public void setCurrentlyBuilding(BuildableType buildable) {
        if (buildable instanceof BuildingType && this.buildQueue.contains(buildable)) {
            this.buildQueue.remove(buildable);
        }
        this.buildQueue.add(0, buildable);
    }

    public void stopBuilding() {
        if (this.getCurrentlyBuilding() != BuildableType.NOTHING) {
            this.setCurrentlyBuilding(BuildableType.NOTHING);
        }
    }

    public List<BuildableType> getBuildQueue() {
        return this.buildQueue;
    }

    public void setBuildQueue(List<BuildableType> newBuildQueue) {
        this.buildQueue = newBuildQueue;
    }

    public void addBells(int amount) {
        if (FreeCol.isInDebugMode()) {
            GoodsType bells = FreeCol.getSpecification().getGoodsType("model.goods.bells");
            this.getOwner().increment(bells, amount);
            if (this.getMembers() <= this.getUnitCount() + 1 && amount > 0) {
                this.addGoods(bells, amount);
            }
            this.updateSoL();
        }
    }

    public int getBellUpkeep() {
        return Math.max(0, this.getUnitCount() - 2);
    }

    public int getSoL() {
        return this.sonsOfLiberty;
    }

    public void updateSoL() {
        int units = this.getUnitCount();
        if (units <= 0) {
            return;
        }
        GoodsType bells = FreeCol.getSpecification().getGoodsType("model.goods.bells");
        int membership = this.getGoodsCount(bells) * 100 / (200 * units);
        if (membership < 0) {
            membership = 0;
        } else if (membership > 100) {
            membership = 100;
        }
        this.oldSonsOfLiberty = this.sonsOfLiberty;
        this.oldTories = this.tories;
        this.sonsOfLiberty = membership;
        this.tories = units - this.getMembers();
    }

    public int getMembers() {
        float result = (float)(this.sonsOfLiberty * this.getUnitCount()) / 100.0f;
        return Math.round(result);
    }

    public int getTory() {
        return 100 - this.getSoL();
    }

    public int getProductionBonus() {
        return this.productionBonus;
    }

    public Modifier getProductionModifier(GoodsType goodsType) {
        return new Modifier(goodsType.getId(), SOL_MODIFIER_SOURCE, this.productionBonus, Modifier.Type.ADDITIVE);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getLocationName() {
        return this.name;
    }

    public int getFoodProduction() {
        int result = 0;
        for (GoodsType foodType : FreeCol.getSpecification().getGoodsFood()) {
            result += this.getProductionOf(foodType);
        }
        return result;
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        int amount = 0;
        for (WorkLocation workLocation : this.getWorkLocations()) {
            amount += workLocation.getProductionOf(goodsType);
        }
        return amount;
    }

    public WorkLocation getVacantWorkLocationFor(Unit unit) {
        for (GoodsType foodType : FreeCol.getSpecification().getGoodsFood()) {
            ColonyTile colonyTile = this.getVacantColonyTileFor(unit, foodType);
            if (colonyTile == null) continue;
            return colonyTile;
        }
        for (Building building : this.buildingMap.values()) {
            if (!building.canAdd(unit)) continue;
            return building;
        }
        return null;
    }

    public ColonyTile getVacantColonyTileFor(Unit unit, GoodsType goodsType) {
        ColonyTile bestPick = null;
        int highestProduction = 0;
        for (ColonyTile colonyTile : this.colonyTiles) {
            int potential;
            Tile workTile;
            if (!colonyTile.canAdd(unit) || this.owner.getLandPrice(workTile = colonyTile.getWorkTile()) != 0 || (potential = colonyTile.getProductionOf(unit, goodsType)) <= highestProduction) continue;
            highestProduction = potential;
            bestPick = colonyTile;
        }
        return bestPick;
    }

    public int getVacantColonyTileProductionFor(Unit unit, GoodsType goodsType) {
        ColonyTile bestPick = this.getVacantColonyTileFor(unit, goodsType);
        return bestPick == null ? 0 : bestPick.getProductionOf(unit, goodsType);
    }

    public int getProductionNextTurn(GoodsType goodsType) {
        int count = 0;
        Building building = this.getBuildingForProducing(goodsType);
        count = building == null ? this.getProductionOf(goodsType) : building.getProductionNextTurn();
        return count;
    }

    public int getProductionNetOf(GoodsType goodsType) {
        GoodsType bellsType = FreeCol.getSpecification().getGoodsType("model.goods.bells");
        int count = this.getProductionNextTurn(goodsType);
        int used = 0;
        Building bldg = this.getBuildingForConsuming(goodsType);
        if (bldg != null) {
            used = bldg.getGoodsInputNextTurn();
        }
        if (goodsType == bellsType) {
            used = this.getBellUpkeep();
        }
        if (goodsType.isStorable()) {
            BuildableType currentBuildable;
            if (goodsType.isFoodType()) {
                used += this.getFoodConsumption();
            }
            if ((currentBuildable = this.getCurrentlyBuilding()) != null && currentBuildable != BuildableType.NOTHING && !currentBuildable.getGoodsRequired().isEmpty()) {
                boolean willBeFinished = true;
                int possiblyUsed = 0;
                for (AbstractGoods goodsRequired : currentBuildable.getGoodsRequired()) {
                    GoodsType requiredType = goodsRequired.getType();
                    int requiredAmount = goodsRequired.getAmount();
                    int presentAmount = this.getGoodsCount(requiredType);
                    if (requiredType.equals(goodsType)) {
                        if (presentAmount + (count - used) < requiredAmount) {
                            willBeFinished = false;
                            break;
                        }
                        if (presentAmount >= requiredAmount) continue;
                        possiblyUsed = requiredAmount - presentAmount;
                        continue;
                    }
                    if (this.getGoodsCount(requiredType) + this.getProductionNextTurn(requiredType) >= goodsRequired.getAmount()) continue;
                    willBeFinished = false;
                    break;
                }
                if (willBeFinished && possiblyUsed > 0) {
                    used += possiblyUsed;
                }
            }
        }
        return count - used;
    }

    public boolean canBreed(GoodsType goodsType) {
        int breedingNumber = goodsType.getBreedingNumber();
        return breedingNumber != Integer.MAX_VALUE && breedingNumber <= this.getGoodsCount(goodsType);
    }

    public boolean canBuild() {
        return this.canBuild(this.getCurrentlyBuilding());
    }

    public boolean canBuild(BuildableType buildableType) {
        BuildingType newBuildingType;
        Building colonyBuilding;
        if (buildableType == null || buildableType == BuildableType.NOTHING) {
            return false;
        }
        if (buildableType.getGoodsRequired().isEmpty()) {
            return false;
        }
        if (buildableType.getPopulationRequired() > this.getUnitCount()) {
            return false;
        }
        if (!(buildableType instanceof BuildingType) && !this.featureContainer.hasAbility("model.ability.build", buildableType, this.getGame().getTurn())) {
            return false;
        }
        java.util.Map<String, Boolean> requiredAbilities = buildableType.getAbilitiesRequired();
        for (Map.Entry<String, Boolean> entry : requiredAbilities.entrySet()) {
            if (this.hasAbility(entry.getKey()) == entry.getValue().booleanValue()) continue;
            return false;
        }
        return !(buildableType instanceof BuildingType) || !((colonyBuilding = this.getBuilding(newBuildingType = (BuildingType)buildableType)) == null ? newBuildingType.getUpgradesFrom() != null : colonyBuilding.getType().getUpgradesTo() != newBuildingType);
    }

    public Building createBuilding(BuildingType buildingType) {
        return this.getGame().getModelController().createBuilding(this.getId() + "buildBuilding", this, buildingType);
    }

    public Building createFreeBuilding(BuildingType buildingType) {
        return this.getGame().getModelController().createBuilding(this.getId() + "buildFreeBuilding", this, buildingType);
    }

    void checkBuildableComplete() {
        if (this.lastVisited == this.getGame().getTurn().getNumber()) {
            return;
        }
        this.lastVisited = this.getGame().getTurn().getNumber();
        if (!this.canBuild()) {
            return;
        }
        BuildableType buildable = this.getCurrentlyBuilding();
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        for (AbstractGoods goodsRequired : buildable.getGoodsRequired()) {
            int required;
            GoodsType requiredGoodsType = goodsRequired.getType();
            int available = this.getGoodsCount(requiredGoodsType);
            if (available >= (required = goodsRequired.getAmount())) continue;
            if (!requiredGoodsType.isStorable()) {
                return;
            }
            messages.add(new ModelMessage((FreeColGameObject)this, ModelMessage.MessageType.MISSING_GOODS, requiredGoodsType, "model.colony.buildableNeedsGoods", "%colony%", this.getName(), "%buildable%", buildable.getName(), "%amount%", String.valueOf(required - available), "%goodsType%", requiredGoodsType.getName()));
        }
        if (!messages.isEmpty()) {
            for (ModelMessage message : messages) {
                this.owner.addModelMessage(message);
            }
            return;
        }
        for (AbstractGoods goodsRequired : buildable.getGoodsRequired()) {
            if (this.getGameOptions().getBoolean("model.option.saveProductionOverflow") || goodsRequired.getType().isStorable()) {
                this.removeGoods(goodsRequired);
                continue;
            }
            this.removeGoods(goodsRequired.getType());
        }
        if (buildable instanceof UnitType) {
            Unit unit = this.getGame().getModelController().createUnit(this.getId() + "buildUnit", this.getTile(), this.getOwner(), (UnitType)buildable);
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.UNIT_ADDED, unit, "model.colony.unitReady", "%colony%", this.getName(), "%unit%", unit.getName());
        } else if (buildable instanceof BuildingType) {
            BuildingType upgradesFrom = ((BuildingType)buildable).getUpgradesFrom();
            if (upgradesFrom == null) {
                this.addBuilding(this.createBuilding((BuildingType)buildable));
            } else {
                this.getBuilding(upgradesFrom).upgrade();
            }
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.BUILDING_COMPLETED, this, "model.colony.buildingReady", "%colony%", this.getName(), "%building%", buildable.getName());
            this.buildQueue.remove(0);
            if (this.buildQueue.isEmpty()) {
                this.buildQueue.add(BuildableType.NOTHING);
            }
            if (this.buildQueue.size() == 1 && this.buildQueue.get(0) == BuildableType.NOTHING) {
                this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.WARNING, this, "model.colony.cannotBuild", "%colony%", this.getName());
            }
        }
    }

    public int getPriceForBuilding() {
        int price = 0;
        for (AbstractGoods goodsRequired : this.getCurrentlyBuilding().getGoodsRequired()) {
            GoodsType requiredGoodsType = goodsRequired.getType();
            int remaining = goodsRequired.getAmount() - this.getGoodsCount(requiredGoodsType);
            if (remaining <= 0) continue;
            if (requiredGoodsType.isStorable()) {
                price += this.getOwner().getMarket().getBidPrice(requiredGoodsType, remaining) * 110 / 100;
                continue;
            }
            price += requiredGoodsType.getPrice() * remaining;
        }
        return price;
    }

    public void payForBuilding() {
        if (this.getPriceForBuilding() > this.getOwner().getGold()) {
            throw new IllegalStateException("Not enough gold.");
        }
        for (AbstractGoods goodsRequired : this.getCurrentlyBuilding().getGoodsRequired()) {
            GoodsType requiredGoodsType = goodsRequired.getType();
            int remaining = goodsRequired.getAmount() - this.getGoodsCount(requiredGoodsType);
            if (remaining <= 0) continue;
            if (requiredGoodsType.isStorable()) {
                this.getOwner().getMarket().buy(requiredGoodsType, remaining, this.getOwner());
            } else {
                this.getOwner().modifyGold(-remaining * requiredGoodsType.getPrice());
            }
            this.addGoods(requiredGoodsType, remaining);
        }
    }

    public Collection<String> getWarnings(GoodsType goodsType, int amount, int production) {
        BuildableType currentlyBuilding;
        LinkedList<String> result = new LinkedList<String>();
        if (goodsType.isFoodType() && goodsType.isStorable()) {
            if (amount + production < 0) {
                result.add(Messages.message("model.colony.famineFeared", "%colony%", this.getName(), "%number%", "0"));
            }
        } else {
            int waste = amount + production - this.getWarehouseCapacity();
            if (waste > 0 && !this.getExportData(goodsType).isExported() && !goodsType.limitIgnored()) {
                result.add(Messages.message("model.building.warehouseSoonFull", "%goods%", goodsType.getName(), "%colony%", this.getName(), "%amount%", String.valueOf(waste)));
            }
        }
        if ((currentlyBuilding = this.getCurrentlyBuilding()) != BuildingType.NOTHING) {
            for (AbstractGoods goods : currentlyBuilding.getGoodsRequired()) {
                if (!goods.getType().equals(goodsType) || amount >= goods.getAmount()) continue;
                result.add(Messages.message("model.colony.buildableNeedsGoods", "%colony%", this.getName(), "%buildable%", currentlyBuilding.getName(), "%amount%", String.valueOf(goods.getAmount() - amount), "%goodsType%", goodsType.getName()));
            }
        }
        this.addInsufficientProductionMessage(result, this.getBuildingForProducing(goodsType));
        Building buildingForConsuming = this.getBuildingForConsuming(goodsType);
        if (buildingForConsuming != null && !buildingForConsuming.getGoodsOutputType().isStorable()) {
            this.addInsufficientProductionMessage(result, buildingForConsuming);
        }
        return result;
    }

    private void addInsufficientProductionMessage(List<String> warnings, Building building) {
        int delta;
        if (building != null && (delta = building.getMaximumProduction() - building.getProductionNextTurn()) > 0) {
            warnings.add(this.createInsufficientProductionMessage(building.getGoodsOutputType(), delta, building.getGoodsInputType(), building.getMaximumGoodsInput() - building.getGoodsInputNextTurn()));
        }
    }

    private String createInsufficientProductionMessage(GoodsType outputType, int missingOutput, GoodsType inputType, int missingInput) {
        return Messages.message("model.colony.insufficientProduction", "%outputAmount%", String.valueOf(missingOutput), "%outputType%", outputType.getName(), "%colony%", this.getName(), "%inputAmount%", String.valueOf(missingInput), "%inputType%", inputType.getName());
    }

    public Unit getRandomUnit() {
        return this.getFirstUnit();
    }

    private Unit getFirstUnit() {
        for (WorkLocation wl : this.getWorkLocations()) {
            Iterator<Unit> unitIterator = wl.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit o = unitIterator.next();
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    private void saveWarehouseState() {
        logger.finest("Saving state of warehouse in " + this.getName());
        this.getGoodsContainer().saveState();
    }

    private void addColonyTileProduction() {
        for (ColonyTile colonyTile : this.colonyTiles) {
            logger.finest("Calling newTurn for colony tile " + colonyTile.toString());
            colonyTile.newTurn();
        }
    }

    void updateFood() {
        int required = this.getFoodConsumption();
        int available = this.getFoodCount();
        int production = this.getFoodProduction();
        if (required > available) {
            this.getRandomUnit().dispose();
            this.removeFood(available);
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.UNIT_LOST, "model.colony.colonistStarved", "%colony%", this.getName());
        } else {
            int turnsToLive;
            this.removeFood(required);
            if (required > production && (turnsToLive = (available - required) / (required - production)) <= 3) {
                this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.WARNING, "model.colony.famineFeared", "%colony%", this.getName(), "%number%", String.valueOf(turnsToLive));
            }
        }
    }

    private void checkForNewColonist() {
        List<UnitType> unitTypes;
        if (this.getFoodCount() >= 200 && !(unitTypes = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.bornInColony")).isEmpty()) {
            int random = this.getGame().getModelController().getRandom(this.getId() + "bornInColony", unitTypes.size());
            Unit u = this.getGame().getModelController().createUnit(this.getId() + "newTurn200food", this.getTile(), this.getOwner(), unitTypes.get(random));
            this.removeFood(200);
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.UNIT_ADDED, u, "model.colony.newColonist", "%colony%", this.getName());
            logger.info("New colonist created in " + this.getName() + " with ID=" + u.getId());
        }
    }

    private void exportGoods() {
        if (this.hasAbility("model.ability.export")) {
            List<Goods> exportGoods = this.getCompactGoods();
            for (Goods goods : exportGoods) {
                int amount;
                GoodsType type = goods.getType();
                ExportData data = this.getExportData(type);
                if (!data.isExported() || !this.owner.canTrade(goods, 1) || (amount = goods.getAmount() - data.getExportLevel()) <= 0) continue;
                this.removeGoods(type, amount);
                this.getOwner().getMarket().sell(type, amount, this.owner, 1);
            }
        }
    }

    private void createWarehouseCapacityWarning() {
        List<Goods> storedGoods = this.getGoodsContainer().getFullGoods();
        for (Goods goods : storedGoods) {
            int waste;
            GoodsType goodsType = goods.getType();
            if (!goodsType.isStorable() || goodsType.limitIgnored() || this.getExportData(goodsType).isExported() && this.owner.canTrade(goods, 1) || goods.getAmount() >= this.getWarehouseCapacity() || (waste = goods.getAmount() + this.getProductionNetOf(goodsType) - this.getWarehouseCapacity()) <= 0) continue;
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.WAREHOUSE_CAPACITY, goodsType, "model.building.warehouseSoonFull", "%goods%", goods.getName(), "%colony%", this.getName(), "%amount%", String.valueOf(waste));
        }
    }

    private void createSoLMessages() {
        ModelMessage govMgtMessage;
        if (this.sonsOfLiberty / 10 != this.oldSonsOfLiberty / 10) {
            if (this.sonsOfLiberty > this.oldSonsOfLiberty) {
                this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.SONS_OF_LIBERTY, FreeCol.getSpecification().getGoodsType("model.goods.bells"), "model.colony.SoLIncrease", "%oldSoL%", String.valueOf(this.oldSonsOfLiberty), "%newSoL%", String.valueOf(this.sonsOfLiberty), "%colony%", this.getName());
            } else {
                this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.SONS_OF_LIBERTY, FreeCol.getSpecification().getGoodsType("model.goods.bells"), "model.colony.SoLDecrease", "%oldSoL%", String.valueOf(this.oldSonsOfLiberty), "%newSoL%", String.valueOf(this.sonsOfLiberty), "%colony%", this.getName());
            }
        }
        if ((govMgtMessage = this.checkForGovMgtChangeMessage()) != null) {
            this.addModelMessage(govMgtMessage);
        }
    }

    public ModelMessage checkForGovMgtChangeMessage() {
        int veryBadGovernment = Specification.getSpecification().getIntegerOption("model.option.veryBadGovernmentLimit").getValue();
        int badGovernment = Specification.getSpecification().getIntegerOption("model.option.badGovernmentLimit").getValue();
        String msgId = null;
        ModelMessage.MessageType msgType = ModelMessage.MessageType.GOVERNMENT_EFFICIENCY;
        if (this.sonsOfLiberty == 100) {
            if (this.oldSonsOfLiberty < 100) {
                msgId = "model.colony.SoL100";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            }
        } else if (this.sonsOfLiberty >= 50) {
            if (this.oldSonsOfLiberty == 100) {
                msgId = "model.colony.lostSoL100";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            }
            if (this.oldSonsOfLiberty < 50) {
                msgId = "model.colony.SoL50";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            }
        } else {
            if (this.oldSonsOfLiberty >= 50) {
                msgId = "model.colony.lostSoL50";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
            }
            if (this.tories > veryBadGovernment) {
                if (this.oldTories <= veryBadGovernment) {
                    msgId = "model.colony.veryBadGovernment";
                }
            } else if (this.tories > badGovernment) {
                if (this.oldTories <= badGovernment) {
                    msgId = "model.colony.badGovernment";
                } else if (this.oldTories > veryBadGovernment) {
                    msgId = "model.colony.governmentImproved1";
                }
            } else if (this.oldTories > badGovernment) {
                msgId = "model.colony.governmentImproved2";
            }
        }
        if (msgId == null) {
            return null;
        }
        ModelMessage msg = new ModelMessage((FreeColGameObject)this, msgType, FreeCol.getSpecification().getGoodsType("model.goods.bells"), msgId, "%colony%", this.getName());
        return msg;
    }

    private void updateProductionBonus() {
        int veryBadGovernment = Specification.getSpecification().getIntegerOption("model.option.veryBadGovernmentLimit").getValue();
        int badGovernment = Specification.getSpecification().getIntegerOption("model.option.badGovernmentLimit").getValue();
        int newBonus = 0;
        if (this.sonsOfLiberty == 100) {
            newBonus = 2;
        } else if (this.sonsOfLiberty >= 50) {
            newBonus = 1;
        } else if (this.tories > veryBadGovernment) {
            newBonus = -2;
        } else if (this.tories > badGovernment) {
            newBonus = -1;
        }
        if (this.getOwner().isAI()) {
            newBonus = Math.max(0, newBonus);
        }
        int oldBonus = this.productionBonus;
        this.productionBonus = newBonus;
        this.firePropertyChange(ColonyChangeEvent.BONUS_CHANGE.toString(), oldBonus, newBonus);
    }

    @Override
    public void newTurn() {
        if (this.unitCount != -1) {
            return;
        }
        if (this.getTile() == null) {
            logger.warning("Colony " + this.getName() + " lacks a tile!");
            return;
        }
        this.saveWarehouseState();
        this.addColonyTileProduction();
        this.updateFood();
        if (this.getUnitCount() == 0) {
            this.dispose();
            return;
        }
        ArrayList<GoodsType> goodsForBuilding = new ArrayList<GoodsType>();
        if (this.canBuild()) {
            for (AbstractGoods goodsRequired : this.getCurrentlyBuilding().getGoodsRequired()) {
                goodsForBuilding.add(goodsRequired.getType());
            }
        } else {
            BuildableType currentlyBuilding = this.getCurrentlyBuilding();
            if (currentlyBuilding == null || currentlyBuilding == BuildableType.NOTHING) {
                for (GoodsType goodsType : Specification.getSpecification().getGoodsTypeList()) {
                    if (!goodsType.isBuildingMaterial() || goodsType.isStorable() || this.getProductionOf(goodsType) <= 0) continue;
                    this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.WARNING, this, "model.colony.cannotBuild", "%colony%", this.getName());
                }
            } else if (currentlyBuilding.getPopulationRequired() > this.getUnitCount()) {
                this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.WARNING, this, "model.colony.buildNeedPop", "%colony%", this.getName(), "%building%", currentlyBuilding.getName());
            }
        }
        ArrayList<Building> buildings1 = new ArrayList<Building>();
        ArrayList<Building> buildings2 = new ArrayList<Building>();
        for (Building building : this.getBuildings()) {
            if (building.getType().hasAbility("model.ability.autoProduction")) {
                logger.finest("Calling newTurn for building " + building.getName());
                building.newTurn();
                continue;
            }
            if (goodsForBuilding.contains(building.getGoodsOutputType())) {
                buildings1.add(building);
                continue;
            }
            int index = -1;
            GoodsType outputType = building.getGoodsOutputType();
            if (outputType != null) {
                for (int i = 0; i < buildings2.size(); ++i) {
                    if (!outputType.equals(((Building)buildings2.get(i)).getGoodsInputType())) continue;
                    index = i;
                }
            }
            if (index == -1) {
                buildings2.add(building);
                continue;
            }
            buildings2.add(index, building);
        }
        for (Building building : buildings1) {
            logger.finest("Calling newTurn for building " + building.getName());
            building.newTurn();
        }
        this.checkBuildableComplete();
        for (Building building : buildings2) {
            logger.finest("Calling newTurn for building " + building.getName());
            building.newTurn();
        }
        this.checkForNewColonist();
        this.exportGoods();
        this.goodsContainer.cleanAndReport();
        this.createWarehouseCapacityWarning();
        int bellsToRemove = this.getBellUpkeep();
        if (bellsToRemove > 0) {
            this.removeGoods(Goods.BELLS, bellsToRemove);
            this.owner.increment(Goods.BELLS, -bellsToRemove);
        }
        this.updateSoL();
        this.createSoLMessages();
        this.updateProductionBonus();
    }

    public int getWarehouseCapacity() {
        return (int)this.featureContainer.applyModifier(0.0f, "model.modifier.warehouseStorage", null, this.getGame().getTurn());
    }

    public Building getWarehouse() {
        for (Building building : this.buildingMap.values()) {
            if (building.getType().getModifierSet("model.modifier.warehouseStorage").isEmpty()) continue;
            return building;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("CARGO_CHANGE".equals(event.getPropertyName())) {
            this.firePropertyChange(ColonyChangeEvent.WAREHOUSE_CHANGE.toString(), event.getOldValue(), event.getNewValue());
        }
    }

    @Override
    public void dispose() {
        for (WorkLocation workLocation : this.getWorkLocations()) {
            ((FreeColGameObject)((Object)workLocation)).dispose();
        }
        TileItemContainer container = this.getTile().getTileItemContainer();
        TileImprovement road = container.getRoad();
        if (road != null && road.isVirtual()) {
            container.removeTileItem(road);
        }
        super.dispose();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Colony.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("name", this.name);
        out.writeAttribute("owner", this.owner.getId());
        out.writeAttribute("tile", this.tile.getId());
        if (this.getGame().isClientTrusted() || showAll || player == this.getOwner()) {
            out.writeAttribute("sonsOfLiberty", Integer.toString(this.sonsOfLiberty));
            out.writeAttribute("oldSonsOfLiberty", Integer.toString(this.oldSonsOfLiberty));
            out.writeAttribute("tories", Integer.toString(this.tories));
            out.writeAttribute("oldTories", Integer.toString(this.oldTories));
            out.writeAttribute("productionBonus", Integer.toString(this.productionBonus));
            if (!BuildableType.NOTHING.equals(this.getCurrentlyBuilding())) {
                out.writeAttribute("currentlyBuilding", this.getCurrentlyBuilding().getId());
            }
            out.writeAttribute("landLocked", Boolean.toString(this.landLocked));
            for (ExportData data : this.exportData.values()) {
                data.toXML(out);
            }
            for (Modifier modifier : this.featureContainer.getModifierSet("model.goods.bells", null, this.getGame().getTurn())) {
                if (!Modifier.COLONY_GOODS_PARTY.equals(modifier.getSource())) continue;
                modifier.toXML(out);
            }
            for (WorkLocation workLocation : this.getWorkLocations()) {
                ((FreeColGameObject)((Object)workLocation)).toXML(out, player, showAll, toSavedGame);
            }
        } else {
            out.writeAttribute("unitCount", Integer.toString(this.getUnitCount()));
            if (this.getStockade() != null) {
                this.getStockade().toXML(out, player, showAll, toSavedGame);
            }
        }
        this.goodsContainer.toXML(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.name = in.getAttributeValue(null, "name");
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        this.tile = this.getFreeColGameObject(in, "tile", Tile.class);
        this.owner.addSettlement(this);
        this.sonsOfLiberty = this.getAttribute(in, "sonsOfLiberty", 0);
        this.oldSonsOfLiberty = this.getAttribute(in, "oldSonsOfLiberty", 0);
        this.tories = this.getAttribute(in, "tories", 0);
        this.oldTories = this.getAttribute(in, "oldTories", 0);
        this.productionBonus = this.getAttribute(in, "productionBonus", 0);
        this.setCurrentlyBuilding(FreeCol.getSpecification().getType(in, "currentlyBuilding", BuildableType.class, BuildableType.NOTHING));
        this.landLocked = this.getAttribute(in, "landLocked", true);
        if (!this.landLocked) {
            this.featureContainer.addAbility(HAS_PORT);
        }
        this.unitCount = this.getAttribute(in, "unitCount", -1);
        this.featureContainer.addModifier(Settlement.DEFENCE_MODIFIER);
        block0: while (in.nextTag() != 2) {
            if (in.getLocalName().equals(ColonyTile.getXMLElementTagName())) {
                ColonyTile ct = (ColonyTile)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (ct == null) {
                    this.colonyTiles.add(new ColonyTile(this.getGame(), in));
                    continue;
                }
                ct.readFromXML(in);
                continue;
            }
            if (in.getLocalName().equals(Building.getXMLElementTagName())) {
                Building b = (Building)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (b == null) {
                    this.addBuilding(new Building(this.getGame(), in));
                    continue;
                }
                b.readFromXML(in);
                continue;
            }
            if (in.getLocalName().equals(GoodsContainer.getXMLElementTagName())) {
                GoodsContainer gc = (GoodsContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (gc == null) {
                    if (this.goodsContainer != null) {
                        this.goodsContainer.removePropertyChangeListener(this);
                    }
                    this.goodsContainer = new GoodsContainer(this.getGame(), (Location)this, in);
                    this.goodsContainer.addPropertyChangeListener("CARGO_CHANGE", this);
                    continue;
                }
                this.goodsContainer.readFromXML(in);
                continue;
            }
            if (in.getLocalName().equals(ExportData.getXMLElementTagName())) {
                ExportData data = new ExportData();
                data.readFromXML(in);
                this.exportData.put(data.getId(), data);
                continue;
            }
            if (Modifier.getXMLElementTagName().equals(in.getLocalName())) {
                Modifier modifier = new Modifier(in);
                if (!Modifier.COLONY_GOODS_PARTY.equals(modifier.getSource())) continue;
                Set<Modifier> bellsBonus = this.featureContainer.getModifierSet("model.goods.bells");
                for (Modifier existingModifier : bellsBonus) {
                    if (!Modifier.COLONY_GOODS_PARTY.equals(existingModifier.getSource()) || modifier.getType() != existingModifier.getType()) continue;
                    continue block0;
                }
                this.featureContainer.addModifier(modifier);
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " loading colony " + this.name);
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "colony";
    }

    @Override
    public Colony getColony() {
        return this;
    }

    public boolean hasStockade() {
        return this.getStockade() != null;
    }

    public Building getStockade() {
        for (Building building : this.buildingMap.values()) {
            if (building.getType().getModifierSet("model.modifier.defence").isEmpty()) continue;
            return building;
        }
        return null;
    }

    public final Set<Modifier> getModifierSet(String id) {
        Set<Modifier> result = this.featureContainer.getModifierSet(id, null, this.getGame().getTurn());
        result.addAll(this.owner.getFeatureContainer().getModifierSet(id, null, this.getGame().getTurn()));
        return result;
    }

    public boolean hasAbility(String id) {
        HashSet<Ability> colonyAbilities = new HashSet<Ability>(this.featureContainer.getAbilitySet(id, null, this.getGame().getTurn()));
        Set<Ability> playerAbilities = this.owner.getFeatureContainer().getAbilitySet(id, null, this.getGame().getTurn());
        colonyAbilities.addAll(playerAbilities);
        return FeatureContainer.hasAbility(colonyAbilities);
    }

    @Override
    public FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    public boolean canBombardEnemyShip() {
        if (this.isLandLocked()) {
            return false;
        }
        return this.hasAbility("model.ability.bombardShips");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColonyChangeEvent {
        POPULATION_CHANGE,
        PRODUCTION_CHANGE,
        BONUS_CHANGE,
        WAREHOUSE_CHANGE;

    }
}

