/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonyTile
extends FreeColGameObject
implements WorkLocation,
Ownable {
    private static final Logger logger = Logger.getLogger(ColonyTile.class.getName());
    private Colony colony;
    private Tile workTile;
    private Unit unit;
    private boolean colonyCenterTile;

    public ColonyTile(Game game, Colony colony, Tile workTile) {
        super(game);
        this.colony = colony;
        this.workTile = workTile;
        this.colonyCenterTile = colony.getTile() == workTile;
    }

    public ColonyTile(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public ColonyTile(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public ColonyTile(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getLocationName() {
        String name = this.getColony().getName();
        if (this.isColonyCenterTile()) {
            return name;
        }
        return Messages.message("nearLocation", "%location%", name);
    }

    public String getLabel() {
        return this.workTile.getLabel();
    }

    @Override
    public Player getOwner() {
        return this.colony.getOwner();
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    public boolean isColonyCenterTile() {
        return this.colonyCenterTile;
    }

    public Tile getWorkTile() {
        return this.workTile;
    }

    @Override
    public Tile getTile() {
        return this.colony.getTile();
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public Colony getColony() {
        return this.colony;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public int getUnitCount() {
        return this.getUnit() != null ? 1 : 0;
    }

    public void relocateWorkers() {
        if (this.getUnit() != null) {
            for (WorkLocation wl : this.getColony().getWorkLocations()) {
                if (wl == this || !wl.canAdd(this.getUnit())) continue;
                this.getUnit().work(wl);
                break;
            }
        }
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        if (this.workTile.getSettlement() != null) {
            return false;
        }
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            Settlement settlement = this.getWorkTile().getOwningSettlement();
            if (settlement != null) {
                if (settlement instanceof Colony && settlement != this.getColony()) {
                    return false;
                }
                if (settlement instanceof IndianSettlement && unit.getOwner().getLandPrice(this.getWorkTile()) > 0) {
                    return false;
                }
            }
            if (!this.workTile.isLand() && !this.getColony().hasAbility("model.ability.produceInWater")) {
                return false;
            }
            if (!unit.getType().hasSkill()) {
                return false;
            }
            return this.getUnit() == null || unit == this.getUnit();
        }
        return false;
    }

    @Override
    public void add(Locatable locatable) {
        if (this.isColonyCenterTile() || this.unit != null) {
            throw new IllegalStateException("Other unit present while adding a unit to ColonyTile:" + this.getId());
        }
        if (!this.canAdd(locatable)) {
            if (this.getWorkTile().getOwningSettlement() != null && this.getWorkTile().getOwningSettlement() != this.getColony()) {
                throw new IllegalArgumentException("Cannot add locatable to this location: somebody else owns this land!");
            }
            throw new IllegalArgumentException("Cannot add locatable to this location: there is a unit here already!");
        }
        Unit u = (Unit)locatable;
        this.getWorkTile().takeOwnership(u.getOwner(), this.getColony());
        u.removeAllEquipment(false);
        this.setUnit(u);
        if (this.unit != null) {
            this.getWorkTile().setOwningSettlement(this.getColony());
        } else {
            this.getWorkTile().setOwningSettlement(null);
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (this.getUnit() == null) {
            return;
        }
        if (!this.getUnit().equals(locatable)) {
            return;
        }
        this.getUnit().setMovesLeft(0);
        this.getWorkTile().setOwningSettlement(null);
        this.setUnit(null);
    }

    @Override
    public List<Unit> getUnitList() {
        if (this.getUnit() == null) {
            return new ArrayList<Unit>();
        }
        return Collections.singletonList(this.getUnit());
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public boolean contains(Locatable locatable) {
        return locatable == this.unit;
    }

    public Unit getFirstUnit() {
        return this.getUnit();
    }

    public Unit getLastUnit() {
        return this.getUnit();
    }

    public Unit getOccupyingUnit() {
        return this.workTile.getOccupyingUnit();
    }

    public boolean isOccupied() {
        return this.workTile.isOccupied();
    }

    @Override
    public void newTurn() {
        if (this.isColonyCenterTile()) {
            this.produceGoodsCenterTile();
        } else if (this.getUnit() != null && !this.isOccupied()) {
            this.produceGoods();
            this.workTile.expendResource(this.getUnit().getWorkType(), this.getUnit().getType(), this.colony);
        }
    }

    private void produceGoods() {
        int amount = this.getProductionOf(this.getUnit().getWorkType());
        if (amount > 0) {
            this.colony.addGoods(this.getUnit().getWorkType(), amount);
            this.unit.modifyExperience(amount);
        }
    }

    private void produceGoodsCenterTile() {
        GoodsType goodsFood = this.workTile.primaryGoods();
        this.colony.addGoods(goodsFood, this.getProductionOf(goodsFood));
        GoodsType type2 = this.workTile.secondaryGoods();
        if (type2 != null) {
            this.colony.addGoods(type2, this.getProductionOf(type2));
        }
        if (this.unit != null) {
            this.getWorkTile().setOwningSettlement(this.getColony());
        } else {
            this.getWorkTile().setOwningSettlement(null);
        }
    }

    public GoodsType getWorkType(Unit unit) {
        GoodsType workType = unit.getWorkType();
        int amount = this.getProductionOf(unit, workType);
        if (amount == 0) {
            List<GoodsType> farmedGoodsTypes = FreeCol.getSpecification().getFarmedGoodsTypeList();
            for (GoodsType farmedGoods : farmedGoodsTypes) {
                int newAmount = this.getProductionOf(unit, farmedGoods);
                if (newAmount <= amount) continue;
                amount = newAmount;
                workType = farmedGoods;
            }
        }
        return workType;
    }

    @Override
    public int getProductionOf(GoodsType goodsType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("GoodsType must not be 'null'.");
        }
        if (this.getUnit() == null) {
            if (this.isColonyCenterTile() && (goodsType.isFoodType() || goodsType.equals(this.workTile.secondaryGoods()))) {
                return this.workTile.potential(goodsType, null);
            }
            return 0;
        }
        if (goodsType.equals(this.getUnit().getWorkType())) {
            return this.getProductionOf(this.getUnit(), goodsType);
        }
        return 0;
    }

    public Set<Modifier> getProductionModifiers(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("GoodsType must not be 'null'.");
        }
        HashSet<Modifier> result = new HashSet<Modifier>();
        if (this.getUnit() == null) {
            if (this.isColonyCenterTile() && (goodsType.isFoodType() || goodsType.equals(this.workTile.secondaryGoods()))) {
                result.addAll(this.workTile.getProductionBonus(goodsType, null));
                result.addAll(this.getColony().getFeatureContainer().getModifierSet(goodsType.getId()));
            }
        } else if (goodsType.equals(this.getUnit().getWorkType())) {
            result.addAll(this.workTile.getProductionBonus(goodsType, unitType));
            result.addAll(this.getUnit().getModifierSet(goodsType.getId()));
        }
        return result;
    }

    public int getProductionOf(Unit unit, GoodsType goodsType) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        if (this.workTile.isLand() || this.colony.hasAbility("model.ability.produceInWater")) {
            int production = unit.getProductionOf(goodsType, this.workTile.potential(goodsType, unit.getType()));
            if (production > 0) {
                production = Math.max(1, production + this.colony.getProductionBonus());
            }
            return production;
        }
        return 0;
    }

    @Override
    public void dispose() {
        if (this.unit != null) {
            this.getWorkTile().setOwningSettlement(null);
            this.unit.dispose();
        }
        super.dispose();
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(ColonyTile.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("colony", this.colony.getId());
        out.writeAttribute("workTile", this.workTile.getId());
        this.writeFreeColGameObject(this.unit, out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.colony = this.getFreeColGameObject(in, "colony", Colony.class);
        this.workTile = this.getFreeColGameObject(in, "workTile", Tile.class);
        this.colonyCenterTile = this.colony.getTile() == this.workTile;
        this.unit = null;
        while (in.nextTag() != 2) {
            if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
            this.unit = this.updateFreeColGameObject(in, Unit.class);
        }
    }

    @Override
    public String toString() {
        return this.getWorkTile().getPosition().toString() + " in '" + this.getColony().getName() + "'" + super.toString();
    }

    public static String getXMLElementTagName() {
        return "colonyTile";
    }
}

