/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeItem;

public class ColonyTradeItem
extends TradeItem {
    private Colony colony;

    public ColonyTradeItem(Game game, Player source, Player destination, Colony colony) {
        super(game, "tradeItem.colony", source, destination);
        this.colony = colony;
    }

    public ColonyTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXMLImpl(in);
    }

    public final Colony getColony() {
        return this.colony;
    }

    public final void setColony(Colony newColony) {
        this.colony = newColony;
    }

    public boolean isValid() {
        return this.colony.getOwner() == this.getSource() && this.getDestination().isEuropean();
    }

    public boolean isUnique() {
        return false;
    }

    public void makeTrade() {
        this.colony.setOwner(this.getDestination());
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readFromXMLImpl(in);
        String colonyID = in.getAttributeValue(null, "colony");
        this.colony = (Colony)this.getGame().getFreeColGameObject(colonyID);
        in.nextTag();
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(ColonyTradeItem.getXMLElementTagName());
        super.toXMLImpl(out);
        out.writeAttribute("colony", this.colony.getId());
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "colonyTradeItem";
    }
}

