/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Set;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CombatModel {
    public CombatOdds calculateCombatOdds(Unit var1, Unit var2);

    public CombatResult generateAttackResult(Unit var1, Unit var2);

    public CombatResult generateAttackResult(Colony var1, Unit var2);

    public float getOffencePower(Colony var1, Unit var2);

    public float getOffencePower(Unit var1, Unit var2);

    public float getDefencePower(Colony var1, Unit var2);

    public float getDefencePower(Unit var1, Unit var2);

    public Set<Modifier> getOffensiveModifiers(Colony var1, Unit var2);

    public Set<Modifier> getOffensiveModifiers(Unit var1, Unit var2);

    public Set<Modifier> getDefensiveModifiers(Unit var1, Unit var2);

    public Set<Modifier> getDefensiveModifiers(Colony var1, Unit var2);

    public void attack(Unit var1, Unit var2, CombatResult var3, int var4, Location var5);

    public void bombard(Colony var1, Unit var2, CombatResult var3, Location var4);

    public static class CombatOdds {
        public static final float UNKNOWN_ODDS = -1.0f;
        public float win;

        public CombatOdds(float win) {
            this.win = win;
        }
    }

    public static class CombatResult {
        public CombatResultType type;
        public int damage;

        public CombatResult(CombatResultType type, int damage) {
            this.type = type;
            this.damage = damage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CombatResultType {
        GREAT_LOSS,
        LOSS,
        EVADES,
        WIN,
        GREAT_WIN,
        DONE_SETTLEMENT;

    }
}

