/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.CostDecider;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class DefaultCostDecider
implements CostDecider {
    private int movesLeft;
    private boolean newTurn;

    public int getCost(Unit unit, Tile oldTile, Tile newTile, int ml, int turns) {
        this.movesLeft = ml;
        this.newTurn = false;
        if (!newTile.isExplored()) {
            return -1;
        }
        if (newTile.isLand() && unit.isNaval() && (newTile.getSettlement() == null || newTile.getSettlement().getOwner() != unit.getOwner() && !unit.canTradeWith(newTile.getSettlement()))) {
            return -1;
        }
        if (!newTile.isLand() && !unit.isNaval()) {
            return -1;
        }
        Unit.MoveType moveType = unit.getMoveType(oldTile, newTile, ml);
        int mc = unit.getMoveCost(oldTile, newTile, ml);
        Unit defender = newTile.getFirstUnit();
        if (newTile.getSettlement() != null && newTile.getSettlement().getOwner() != unit.getOwner()) {
            switch (moveType) {
                case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: 
                case ENTER_INDIAN_VILLAGE_WITH_FREE_COLONIST: 
                case ENTER_INDIAN_VILLAGE_WITH_MISSIONARY: 
                case ENTER_INDIAN_VILLAGE_WITH_SCOUT: 
                case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                    if (unit.getDestination() != null && unit.getDestination().getTile() == newTile) break;
                    return -1;
                }
                case ATTACK: {
                    if (unit.getDestination() != null && unit.getDestination().getTile() == newTile) break;
                    this.movesLeft = 0;
                    return ml + unit.getInitialMovesLeft() * 5;
                }
                case ILLEGAL_MOVE: {
                    if (unit.getDestination() != null && unit.getDestination().getTile() == newTile) break;
                    return -1;
                }
                case DISEMBARK: 
                case EMBARK: 
                case EXPLORE_LOST_CITY_RUMOUR: 
                case MOVE: 
                case MOVE_HIGH_SEAS: {
                    assert (false);
                    break;
                }
            }
        } else if (defender != null && defender.getOwner() != unit.getOwner()) {
            if (!unit.isOffensiveUnit()) {
                return -1;
            }
            if (moveType != Unit.MoveType.ATTACK || unit.getDestination() == null || unit.getDestination().getTile() != newTile) {
                mc += Math.max(0, 20 - turns * 4);
            }
        } else if (newTile.isLand() && newTile.getFirstUnit() != null && newTile.getFirstUnit().isNaval() && newTile.getFirstUnit().getOwner() != unit.getOwner()) {
            mc += Math.max(0, 20 - turns * 4);
        }
        if (mc <= ml) {
            this.movesLeft -= mc;
            return mc;
        }
        mc = this.getCost(unit, oldTile, newTile, unit.getInitialMovesLeft(), turns + 1);
        this.newTurn = true;
        return ml + mc;
    }

    public int getMovesLeft() {
        return this.movesLeft;
    }

    public boolean isNewTurn() {
        return this.newTurn;
    }
}

