/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifficultyLevel
extends FreeColGameObjectType {
    private final Map<String, AbstractOption> levelOptions = new HashMap<String, AbstractOption>();

    public DifficultyLevel(int index) {
        this.setIndex(index);
    }

    public AbstractOption getOption(String Id) throws IllegalArgumentException {
        if (Id == null) {
            throw new IllegalArgumentException("Trying to retrieve AbstractOption with ID 'null'.");
        }
        if (!this.levelOptions.containsKey(Id)) {
            throw new IllegalArgumentException("Trying to retrieve AbstractOption with ID '" + Id + "' returned 'null'.");
        }
        return this.levelOptions.get(Id);
    }

    public Map<String, AbstractOption> getOptions() {
        return this.levelOptions;
    }

    @Override
    public void readFromXML(XMLStreamReader in, Specification specification) throws XMLStreamException {
        String id = in.getAttributeValue(null, "id");
        if (id == null) {
            throw new XMLStreamException("invalid <" + DifficultyLevel.getXMLElementTagName() + "> tag : no id attribute found.");
        }
        this.setId(in.getAttributeValue(null, "id"));
        while (in.nextTag() != 2) {
            AbstractOption option;
            String optionType = in.getLocalName();
            if (IntegerOption.getXMLElementTagName().equals(optionType) || "integer-option".equals(optionType)) {
                option = new IntegerOption(in);
                this.levelOptions.put(option.getId(), option);
                continue;
            }
            if (BooleanOption.getXMLElementTagName().equals(optionType) || "boolean-option".equals(optionType)) {
                option = new BooleanOption(in);
                this.levelOptions.put(option.getId(), option);
                continue;
            }
            if (StringOption.getXMLElementTagName().equals(optionType) || "string-option".equals(optionType)) {
                option = new StringOption(in);
                this.levelOptions.put(option.getId(), option);
                continue;
            }
            logger.finest("Parsing of " + optionType + " is not implemented yet");
            in.nextTag();
        }
    }
}

