/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentType
extends BuildableType {
    public static final EquipmentType[] NO_EQUIPMENT = new EquipmentType[0];
    private int maximumCount = 1;
    private int combatLossPriority;
    private Unit.Role role;
    private boolean militaryEquipment;
    private HashMap<String, Boolean> requiredLocationAbilities = new HashMap();
    private List<String> compatibleEquipment = new ArrayList<String>();

    public EquipmentType() {
    }

    public EquipmentType(int index) {
        this.setIndex(index);
    }

    public final int getMaximumCount() {
        return this.maximumCount;
    }

    public final void setMaximumCount(int newMaximumCount) {
        this.maximumCount = newMaximumCount;
    }

    public final Unit.Role getRole() {
        return this.role;
    }

    public final void setRole(Unit.Role newRole) {
        this.role = newRole;
    }

    public final int getCombatLossPriority() {
        return this.combatLossPriority;
    }

    public boolean canBeCaptured() {
        return this.combatLossPriority > 0;
    }

    public final void setCombatLossPriority(int newCombatLossPriority) {
        this.combatLossPriority = newCombatLossPriority;
    }

    public Map<String, Boolean> getUnitAbilitiesRequired() {
        return this.getAbilitiesRequired();
    }

    public Map<String, Boolean> getLocationAbilitiesRequired() {
        return this.requiredLocationAbilities;
    }

    public boolean isCompatibleWith(EquipmentType otherType) {
        if (this.getId().equals(otherType.getId())) {
            return true;
        }
        return this.compatibleEquipment.contains(otherType.getId()) && otherType.compatibleEquipment.contains(this.getId());
    }

    public final boolean isMilitaryEquipment() {
        return this.militaryEquipment;
    }

    public final void setMilitaryEquipment(boolean newMilitaryEquipment) {
        this.militaryEquipment = newMilitaryEquipment;
    }

    @Override
    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.maximumCount = this.getAttribute(in, "maximum-count", 1);
        this.combatLossPriority = this.getAttribute(in, "combat-loss-priority", 0);
        String roleString = this.getAttribute(in, "role", "default");
        this.role = Enum.valueOf(Unit.Role.class, roleString.toUpperCase());
    }

    @Override
    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            Modifier modifier;
            String nodeName = in.getLocalName();
            if ("required-location-ability".equals(nodeName)) {
                String abilityId = in.getAttributeValue(null, "id");
                boolean value = this.getAttribute(in, "value", true);
                this.getLocationAbilitiesRequired().put(abilityId, value);
                specification.addAbility(abilityId);
                in.nextTag();
                continue;
            }
            if ("compatible-equipment".equals(nodeName)) {
                String equipmentId = in.getAttributeValue(null, "id");
                this.compatibleEquipment.add(equipmentId);
                in.nextTag();
                continue;
            }
            FreeColObject object = super.readChild(in, specification);
            if (!(object instanceof Modifier) || !(modifier = (Modifier)object).getId().equals("model.modifier.offence") && !modifier.getId().equals("model.modifier.defence")) continue;
            this.militaryEquipment = true;
        }
        if (this.militaryEquipment) {
            for (AbstractGoods goods : this.getGoodsRequired()) {
                goods.getType().setMilitaryGoods(true);
            }
        }
    }
}

