/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Europe
extends FreeColGameObject
implements Location,
Ownable,
Named {
    private static final Logger logger = Logger.getLogger(Europe.class.getName());
    private static final int RECRUIT_PRICE_INITIAL = 200;
    private static final int LOWER_CAP_INITIAL = 80;
    public static final String UNITS_TAG_NAME = "units";
    private UnitType[] recruitables = new UnitType[]{null, null, null};
    private Map<UnitType, Integer> unitPrices = new HashMap<UnitType, Integer>();
    private int recruitPrice;
    private int recruitLowerCap;
    private List<Unit> units = Collections.emptyList();
    private Player owner;

    public Europe(Game game, Player owner) {
        super(game);
        this.owner = owner;
        this.recruitPrice = 200;
        this.recruitLowerCap = 80;
    }

    public Europe(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Europe(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Europe(Game game, String id) {
        super(game, id);
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        for (AbstractGoods requiredGoods : equipmentType.getGoodsRequired()) {
            GoodsType goodsType = requiredGoods.getType();
            if (this.getOwner().canTrade(goodsType) && this.getOwner().getGold() >= this.getOwner().getMarket().getBidPrice(goodsType, requiredGoods.getAmount())) continue;
            return false;
        }
        return true;
    }

    public void generateInitialRecruits() {
        for (int index = 0; index < this.recruitables.length; ++index) {
            String optionId = "model.option.recruitable.slot" + index;
            if (Specification.getSpecification().hasOption(optionId)) {
                String unitTypeId = Specification.getSpecification().getStringOption(optionId).getValue();
                this.setRecruitable(index, Specification.getSpecification().getUnitType(unitTypeId));
                continue;
            }
            this.setRecruitable(index, this.owner.generateRecruitable("recruitable" + index));
        }
    }

    public boolean recruitablesDiffer() {
        return !this.recruitables[0].equals(this.recruitables[1]) || !this.recruitables[0].equals(this.recruitables[2]);
    }

    public UnitType getRecruitable(int slot) {
        if (slot >= 0 && slot < 3) {
            return this.recruitables[slot];
        }
        throw new IllegalArgumentException("Wrong recruitement slot: " + slot);
    }

    public void setRecruitable(int slot, UnitType type) {
        if (slot >= 0 && slot < 3) {
            this.recruitables[slot] = type;
        } else {
            logger.warning("setRecruitable: invalid slot(" + slot + ") given.");
        }
    }

    public void recruit(int slot, Unit unit, UnitType newRecruitable) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        if (this.getRecruitPrice() > unit.getOwner().getGold()) {
            throw new IllegalStateException("Not enough gold to recruit " + unit.getName() + ".");
        }
        unit.getOwner().modifyGold(-this.getRecruitPrice());
        this.incrementRecruitPrice();
        unit.setLocation(this);
        unit.getOwner().updateCrossesRequired();
        unit.getOwner().reduceCrosses();
        this.setRecruitable(slot, newRecruitable);
    }

    public void emigrate(int slot, Unit unit, UnitType newRecruitable) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        if (!unit.getOwner().checkEmigrate()) {
            throw new IllegalStateException("Not enough crosses to emigrate unit: " + unit.getOwner().getCrosses() + "/" + unit.getOwner().getCrossesRequired());
        }
        unit.setLocation(this);
        unit.getOwner().updateCrossesRequired();
        unit.getOwner().reduceCrosses();
        if (!unit.getOwner().hasAbility("model.ability.selectRecruit")) {
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.UNIT_ADDED, unit, "model.europe.emigrate", "%europe%", this.getName(), "%unit%", unit.getName());
        }
        this.setRecruitable(slot, newRecruitable);
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    public void add(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalArgumentException("Only units can be added to Europe.");
        }
        if (!this.units.contains(locatable)) {
            if (((Object)this.units).equals(Collections.emptyList())) {
                this.units = new ArrayList<Unit>();
            }
            this.units.add((Unit)locatable);
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            this.units.remove(locatable);
        } else {
            logger.warning("Tried to remove an unrecognized 'Locatable' from a europe.");
        }
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.units.contains(locatable);
        }
        return false;
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return true;
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.units;
    }

    public void disposeUnitList() {
        while (!this.units.isEmpty()) {
            Unit unit = this.units.remove(0);
            unit.dispose();
        }
        this.units = null;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    public int getUnitPrice(UnitType unitType) {
        Integer price = this.unitPrices.get(unitType);
        if (price != null) {
            return price;
        }
        return unitType.getPrice();
    }

    public void train(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        int price = this.getUnitPrice(unit.getType());
        if (price <= 0) {
            throw new IllegalArgumentException("Unit price must be a positive integer.");
        }
        if (this.getUnitPrice(unit.getType()) > unit.getOwner().getGold()) {
            throw new IllegalStateException("Not enough gold to train " + unit.getName() + ".");
        }
        unit.getOwner().modifyGold(-price);
        this.increasePrice(unit, price);
        unit.setLocation(this);
    }

    private void increasePrice(Unit unit, int price) {
        int increase;
        Specification spec = Specification.getSpecification();
        String baseOption = "model.option.priceIncreasePerType";
        String name = unit.getType().getId().substring(unit.getType().getId().lastIndexOf(46));
        String option = spec.getBooleanOption(baseOption).getValue() ? "model.option.priceIncrease" + name : "model.option.priceIncrease";
        int n = increase = spec.hasOption(option) ? spec.getIntegerOption(option).getValue() : 0;
        if (increase != 0) {
            this.unitPrices.put(unit.getType(), new Integer(price + increase));
        }
    }

    public int getRecruitPrice() {
        int required = this.owner.getCrossesRequired();
        int crosses = this.owner.getCrosses();
        int difference = Math.max(required - crosses, 0);
        return Math.max(this.recruitPrice * difference / required, this.recruitLowerCap);
    }

    private void incrementRecruitPrice() {
        this.recruitPrice += Specification.getSpecification().getIntegerOption("model.option.recruitPriceIncrease").getValue();
        this.recruitLowerCap += Specification.getSpecification().getIntegerOption("model.option.lowerCapIncrease").getValue();
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    public void newTurn() {
        for (Unit unit : this.getUnitList()) {
            if (!unit.isNaval() || !unit.isUnderRepair()) continue;
            unit.setHitpoints(unit.getHitpoints() + 1);
            if (unit.isUnderRepair()) continue;
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.DEFAULT, unit, "model.unit.shipRepaired", "%unit%", unit.getName(), "%repairLocation%", this.getLocationName());
        }
    }

    @Override
    public String getLocationName() {
        return this.toString();
    }

    @Override
    public String getName() {
        return this.getOwner().getEuropeName();
    }

    @Override
    public String toString() {
        return "Europe";
    }

    private void unitsToXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (!this.units.isEmpty()) {
            out.writeStartElement(UNITS_TAG_NAME);
            for (Unit unit : this.units) {
                unit.toXML(out, player, showAll, toSavedGame);
            }
            out.writeEndElement();
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Europe.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        for (int index = 0; index < this.recruitables.length; ++index) {
            if (this.recruitables[index] == null) continue;
            out.writeAttribute("recruit" + index, this.recruitables[index].getId());
        }
        out.writeAttribute("recruitPrice", Integer.toString(this.recruitPrice));
        out.writeAttribute("recruitLowerCap", Integer.toString(this.recruitLowerCap));
        out.writeAttribute("owner", this.owner.getId());
        for (Map.Entry<UnitType, Integer> entry : this.unitPrices.entrySet()) {
            out.writeStartElement("unitPrice");
            out.writeAttribute("unitType", entry.getKey().getId());
            out.writeAttribute("price", entry.getValue().toString());
            out.writeEndElement();
        }
        this.unitsToXML(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        Specification spec = FreeCol.getSpecification();
        for (int index = 0; index < this.recruitables.length; ++index) {
            String unitTypeId = in.getAttributeValue(null, "recruit" + index);
            if (unitTypeId == null) continue;
            this.recruitables[index] = spec.getUnitType(unitTypeId);
        }
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        this.recruitPrice = this.getAttribute(in, "recruitPrice", 200);
        this.recruitLowerCap = this.getAttribute(in, "recruitLowerCap", 80);
        this.unitPrices.clear();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(UNITS_TAG_NAME)) {
                this.units = new ArrayList<Unit>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    this.units.add(this.updateFreeColGameObject(in, Unit.class));
                }
                continue;
            }
            if (!in.getLocalName().equals("unitPrice")) continue;
            String unitTypeId = in.getAttributeValue(null, "unitType");
            Integer price = new Integer(in.getAttributeValue(null, "price"));
            this.unitPrices.put(spec.getUnitType(unitTypeId), price);
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "europe";
    }
}

