/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Feature
extends FreeColObject {
    private FreeColGameObjectType source;
    private Turn firstTurn;
    private Turn lastTurn;
    private List<Scope> scopes;

    public final boolean hasTimeLimit() {
        return this.firstTurn != null || this.lastTurn != null;
    }

    public final boolean hasScope() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public String getName() {
        return Messages.message(this.getId() + ".name", new String[0]);
    }

    public final List<Scope> getScopes() {
        return this.scopes;
    }

    public final void setScopes(List<Scope> newScopes) {
        this.scopes = newScopes;
    }

    public final Turn getFirstTurn() {
        return this.firstTurn;
    }

    public final void setFirstTurn(Turn newFirstTurn) {
        this.firstTurn = newFirstTurn;
    }

    public final Turn getLastTurn() {
        return this.lastTurn;
    }

    public final void setLastTurn(Turn newLastTurn) {
        this.lastTurn = newLastTurn;
    }

    public final FreeColGameObjectType getSource() {
        return this.source;
    }

    public final void setSource(FreeColGameObjectType newSource) {
        this.source = newSource;
    }

    public boolean appliesTo(FreeColGameObjectType objectType) {
        if (!this.hasScope()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(objectType)) continue;
            return true;
        }
        return false;
    }

    public boolean appliesTo(FreeColGameObjectType objectType, Turn turn) {
        if (turn != null && (this.firstTurn != null && turn.getNumber() < this.firstTurn.getNumber() || this.lastTurn != null && turn.getNumber() > this.lastTurn.getNumber())) {
            return false;
        }
        return this.appliesTo(objectType);
    }

    public boolean isOutOfDate(Turn turn) {
        return turn != null && this.lastTurn != null && turn.getNumber() > this.lastTurn.getNumber();
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        if (this.getSource() != null) {
            out.writeAttribute("source", this.getSource().getId());
        }
        if (this.getFirstTurn() != null) {
            out.writeAttribute("firstTurn", String.valueOf(this.getFirstTurn().getNumber()));
        }
        if (this.getLastTurn() != null) {
            out.writeAttribute("lastTurn", String.valueOf(this.getLastTurn().getNumber()));
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        if (this.getScopes() != null) {
            for (Scope scope : this.getScopes()) {
                scope.toXMLImpl(out);
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        String lastTurn;
        String sourceId = in.getAttributeValue(null, "source");
        if (sourceId == null) {
            this.setSource(null);
        } else {
            this.setSource(Specification.getSpecification().getType(sourceId));
        }
        String firstTurn = in.getAttributeValue(null, "firstTurn");
        if (firstTurn != null) {
            this.setFirstTurn(new Turn(Integer.parseInt(firstTurn)));
        }
        if ((lastTurn = in.getAttributeValue(null, "lastTurn")) != null) {
            this.setLastTurn(new Turn(Integer.parseInt(lastTurn)));
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String childName = in.getLocalName();
            if (Scope.getXMLElementTagName().equals(childName)) {
                Scope scope = new Scope(in);
                if (this.getScopes() == null) {
                    this.setScopes(new ArrayList<Scope>());
                }
                this.getScopes().add(scope);
                continue;
            }
            logger.finest("Parsing of " + childName + " is not implemented yet");
            while (in.nextTag() != 2 || !in.getLocalName().equals(childName)) {
                in.nextTag();
            }
        }
    }
}

