/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureContainer {
    private Map<String, Set<Ability>> abilities = new HashMap<String, Set<Ability>>();
    private Map<String, Set<Modifier>> modifiers = new HashMap<String, Set<Modifier>>();

    public Set<Ability> getAbilities() {
        HashSet<Ability> result = new HashSet<Ability>();
        for (Set<Ability> abilitySet : this.abilities.values()) {
            result.addAll(abilitySet);
        }
        return result;
    }

    public Set<Modifier> getModifiers() {
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (Set<Modifier> modifierSet : this.modifiers.values()) {
            result.addAll(modifierSet);
        }
        return result;
    }

    public Set<Ability> getAbilitySet(String id) {
        return this.getAbilitySet(id, null, null);
    }

    public Set<Ability> getAbilitySet(String id, FreeColGameObjectType objectType) {
        return this.getAbilitySet(id, objectType, null);
    }

    public Set<Ability> getAbilitySet(String id, FreeColGameObjectType objectType, Turn turn) {
        if (Specification.getSpecification().getAbilities(id) == null) {
            throw new IllegalArgumentException("Unknown ability key: " + id);
        }
        Set<Ability> abilitySet = this.abilities.get(id);
        if (abilitySet == null) {
            return new HashSet<Ability>();
        }
        HashSet<Ability> result = new HashSet<Ability>();
        for (Ability ability : abilitySet) {
            if (!ability.appliesTo(objectType, turn)) continue;
            result.add(ability);
        }
        return result;
    }

    public boolean hasAbility(String id) {
        return this.hasAbility(id, null, null);
    }

    public boolean hasAbility(String id, FreeColGameObjectType objectType) {
        return this.hasAbility(id, objectType, null);
    }

    public boolean hasAbility(String id, FreeColGameObjectType objectType, Turn turn) {
        if (Specification.getSpecification().getAbilities(id) == null) {
            throw new IllegalArgumentException("Unknown ability key: " + id);
        }
        Set<Ability> abilitySet = this.abilities.get(id);
        if (abilitySet == null) {
            return false;
        }
        boolean foundApplicableAbility = false;
        for (Ability ability : abilitySet) {
            if (!ability.appliesTo(objectType, turn)) continue;
            if (ability.getValue()) {
                foundApplicableAbility = true;
                continue;
            }
            return false;
        }
        return foundApplicableAbility;
    }

    public static boolean hasAbility(Set<Ability> abilitySet) {
        if (abilitySet.isEmpty()) {
            return false;
        }
        for (Ability ability : abilitySet) {
            if (ability.getValue()) continue;
            return false;
        }
        return true;
    }

    public Set<Modifier> getModifierSet(String id) {
        return this.getModifierSet(id, null, null);
    }

    public Set<Modifier> getModifierSet(String id, FreeColGameObjectType objectType) {
        return this.getModifierSet(id, objectType, null);
    }

    public Set<Modifier> getModifierSet(String id, FreeColGameObjectType objectType, Turn turn) {
        if (Specification.getSpecification().getModifiers(id) == null && Specification.getSpecification().getType(id) == null) {
            throw new IllegalArgumentException("Unknown modifier key: " + id);
        }
        Set<Modifier> modifierSet = this.modifiers.get(id);
        if (modifierSet == null) {
            return new HashSet<Modifier>();
        }
        if (objectType == null) {
            return modifierSet;
        }
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (Modifier modifier : modifierSet) {
            if (!modifier.appliesTo(objectType, turn)) continue;
            result.add(modifier);
        }
        return result;
    }

    public float applyModifier(float number, String id) {
        return this.applyModifier(number, id, null, null);
    }

    public float applyModifier(float number, String id, FreeColGameObjectType objectType) {
        return this.applyModifier(number, id, objectType, null);
    }

    public float applyModifier(float number, String id, FreeColGameObjectType objectType, Turn turn) {
        return FeatureContainer.applyModifierSet(number, turn, this.getModifierSet(id, objectType, turn));
    }

    public static float applyModifierSet(float number, Turn turn, Set<Modifier> modifierSet) {
        if (modifierSet == null) {
            return number;
        }
        float additive = 0.0f;
        float percentage = 0.0f;
        float multiplicative = 1.0f;
        for (Modifier modifier : modifierSet) {
            float value = modifier.getValue();
            if (value == Float.MIN_VALUE) {
                return Float.MIN_VALUE;
            }
            if (modifier.hasIncrement() && turn != null) {
                int diff = turn.getNumber() - modifier.getFirstTurn().getNumber();
                switch (modifier.getIncrementType()) {
                    case ADDITIVE: {
                        value += modifier.getIncrement() * (float)diff;
                        break;
                    }
                    case MULTIPLICATIVE: {
                        value *= modifier.getIncrement() * (float)diff;
                        break;
                    }
                    case PERCENTAGE: {
                        value += value * modifier.getIncrement() * (float)diff / 100.0f;
                    }
                }
            }
            switch (modifier.getType()) {
                case ADDITIVE: {
                    additive += value;
                    break;
                }
                case MULTIPLICATIVE: {
                    multiplicative *= value;
                    break;
                }
                case PERCENTAGE: {
                    percentage += value;
                }
            }
        }
        float result = number;
        result += additive;
        result *= multiplicative;
        result += result * percentage / 100.0f;
        return result;
    }

    public boolean addAbility(Ability ability) {
        if (ability == null) {
            return false;
        }
        Set<Ability> abilitySet = this.abilities.get(ability.getId());
        if (abilitySet == null) {
            abilitySet = new HashSet<Ability>();
            this.abilities.put(ability.getId(), abilitySet);
        }
        return abilitySet.add(ability);
    }

    public boolean addModifier(Modifier modifier) {
        if (modifier == null) {
            return false;
        }
        Set<Modifier> modifierSet = this.modifiers.get(modifier.getId());
        if (modifierSet == null) {
            modifierSet = new HashSet<Modifier>();
            this.modifiers.put(modifier.getId(), modifierSet);
        }
        return modifierSet.add(modifier);
    }

    public Ability removeAbility(Ability oldAbility) {
        if (oldAbility == null) {
            return null;
        }
        Set<Ability> abilitySet = this.abilities.get(oldAbility.getId());
        if (abilitySet == null) {
            return null;
        }
        if (abilitySet.remove(oldAbility)) {
            return oldAbility;
        }
        return null;
    }

    public Modifier removeModifier(Modifier oldModifier) {
        if (oldModifier == null) {
            return null;
        }
        Set<Modifier> modifierSet = this.modifiers.get(oldModifier.getId());
        if (modifierSet == null) {
            return null;
        }
        if (modifierSet.remove(oldModifier)) {
            return oldModifier;
        }
        return null;
    }

    public void add(FeatureContainer featureContainer) {
        for (Map.Entry<String, Set<Ability>> entry : featureContainer.abilities.entrySet()) {
            Set<Ability> abilitySet = this.abilities.get(entry.getKey());
            if (abilitySet == null) {
                this.abilities.put(entry.getKey(), new HashSet(entry.getValue()));
                continue;
            }
            abilitySet.addAll((Collection<Ability>)entry.getValue());
        }
        for (Map.Entry<String, Set<Feature>> entry : featureContainer.modifiers.entrySet()) {
            Set<Modifier> modifierSet = this.modifiers.get(entry.getKey());
            if (modifierSet == null) {
                this.modifiers.put(entry.getKey(), new HashSet(entry.getValue()));
                continue;
            }
            modifierSet.addAll((Collection<Modifier>)entry.getValue());
        }
    }

    public void remove(FeatureContainer featureContainer) {
        for (Map.Entry<String, Set<Ability>> entry : featureContainer.abilities.entrySet()) {
            Set<Ability> abilitySet = this.abilities.get(entry.getKey());
            if (abilitySet == null) continue;
            abilitySet.removeAll((Collection)entry.getValue());
        }
        for (Map.Entry<String, Set<Feature>> entry : featureContainer.modifiers.entrySet()) {
            Set<Modifier> modifierSet = this.modifiers.get(entry.getKey());
            if (modifierSet == null) continue;
            modifierSet.removeAll((Collection)entry.getValue());
        }
    }
}

