/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoundingFather
extends FreeColGameObjectType {
    private int[] weight = new int[4];
    private FoundingFatherType type;
    private Map<UnitType, UnitType> upgrades;
    private Map<String, String> events = new HashMap<String, String>();
    private Set<String> availableTo = new HashSet<String>();
    private List<AbstractUnit> units;

    public FoundingFather(int newIndex) {
        this.setIndex(newIndex);
    }

    public String getText() {
        return Messages.message(this.getId() + ".text", new String[0]);
    }

    public String getBirthAndDeath() {
        return Messages.message(this.getId() + ".birthAndDeath", new String[0]);
    }

    public FoundingFatherType getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return FoundingFather.getTypeAsString(this.type);
    }

    public static String getTypeAsString(FoundingFatherType type) {
        return Messages.message("model.foundingFather." + type.toString().toLowerCase(), new String[0]);
    }

    public int getWeight(int age) {
        switch (age) {
            case 1: {
                return this.weight[1];
            }
            case 2: {
                return this.weight[2];
            }
        }
        return this.weight[3];
    }

    public final List<AbstractUnit> getUnits() {
        return this.units;
    }

    public final void setUnits(List<AbstractUnit> newUnits) {
        this.units = newUnits;
    }

    public boolean isAvailableTo(Player player) {
        return this.availableTo.isEmpty() || this.availableTo.contains(player.getNationID()) || this.availableTo.contains(player.getNationType().getId());
    }

    public final Map<UnitType, UnitType> getUpgrades() {
        return this.upgrades;
    }

    public final void setUpgrades(Map<UnitType, UnitType> newUpgrades) {
        this.upgrades = newUpgrades;
    }

    public Map<String, String> getEvents() {
        return this.events;
    }

    public void setEvents(Map<String, String> newEvents) {
        this.events = newEvents;
    }

    @Override
    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        String typeString = in.getAttributeValue(null, "type").toUpperCase();
        this.type = Enum.valueOf(FoundingFatherType.class, typeString);
        this.weight[1] = Integer.parseInt(in.getAttributeValue(null, "weight1"));
        this.weight[2] = Integer.parseInt(in.getAttributeValue(null, "weight2"));
        this.weight[3] = Integer.parseInt(in.getAttributeValue(null, "weight3"));
    }

    @Override
    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String childName = in.getLocalName();
            if ("event".equals(childName)) {
                String eventId = in.getAttributeValue(null, "id");
                String value = in.getAttributeValue(null, "value");
                this.events.put(eventId, value);
                in.nextTag();
                continue;
            }
            if ("nation".equals(childName) || "nation-type".equals(childName)) {
                this.availableTo.add(in.getAttributeValue(null, "id"));
                in.nextTag();
                continue;
            }
            if ("unit".equals(childName)) {
                AbstractUnit unit = new AbstractUnit(in);
                if (this.units == null) {
                    this.units = new ArrayList<AbstractUnit>();
                }
                this.units.add(unit);
                continue;
            }
            if ("upgrade".equals(childName)) {
                UnitType fromType = specification.getUnitType(in.getAttributeValue(null, "from-id"));
                UnitType toType = specification.getUnitType(in.getAttributeValue(null, "to-id"));
                if (fromType != null && toType != null) {
                    if (this.upgrades == null) {
                        this.upgrades = new HashMap<UnitType, UnitType>();
                    }
                    this.upgrades.put(fromType, toType);
                }
                in.nextTag();
                continue;
            }
            super.readChild(in, specification);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FoundingFatherType {
        TRADE,
        EXPLORATION,
        MILITARY,
        POLITICAL,
        RELIGIOUS;

    }
}

