/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeColGameObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(FreeColGameObject.class.getName());
    private Game game;
    private boolean disposed = false;
    private boolean uninitialized;

    protected FreeColGameObject() {
        logger.info("FreeColGameObject without ID created.");
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game) {
        this.game = game;
        if (game != null) {
            this.setId(this.getRealXMLElementTagName() + ":" + game.getNextID());
        } else if (this instanceof Game) {
            this.setId("0");
        } else {
            logger.warning("Created 'FreeColGameObject' with 'game == null': " + this);
        }
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game, XMLStreamReader in) throws XMLStreamException {
        this.game = game;
        if (game == null && !(this instanceof Game)) {
            logger.warning("Created 'FreeColGameObject' with 'game == null': " + this);
        }
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game, Element e) {
        this.game = game;
        if (game == null && !(this instanceof Game)) {
            logger.warning("Created 'FreeColGameObject' with 'game == null': " + this);
        }
        this.uninitialized = false;
    }

    public FreeColGameObject(Game game, String id) {
        this.game = game;
        if (game == null && !(this instanceof Game)) {
            logger.warning("Created 'FreeColGameObject' with 'game == null': " + this);
        }
        this.setId(id);
        this.uninitialized = true;
    }

    public Game getGame() {
        return this.game;
    }

    public GameOptions getGameOptions() {
        return this.game.getGameOptions();
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public void dispose() {
        this.disposed = true;
        this.getGame().removeFreeColGameObject(this.getId());
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    public void updateID() {
    }

    public void toSavedXML(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, null, true, true);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out, null, false, false);
    }

    protected abstract void toXMLImpl(XMLStreamWriter var1, Player var2, boolean var3, boolean var4) throws XMLStreamException;

    @Override
    public final void toXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (toSavedGame && !showAll) {
            throw new IllegalArgumentException("'showAll' should be true when saving a game.");
        }
        this.toXMLImpl(out, player, showAll, toSavedGame);
    }

    @Override
    public final void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.uninitialized = false;
        super.readFromXML(in);
    }

    public static String getXMLElementTagName() {
        return "unknown";
    }

    public Integer getIntegerID() {
        String stringPart = this.getRealXMLElementTagName() + ":";
        return new Integer(this.getId().substring(stringPart.length()));
    }

    private String getRealXMLElementTagName() {
        String tagName = "";
        try {
            Method m = this.getClass().getMethod("getXMLElementTagName", null);
            tagName = (String)m.invoke((Object)null, (Object[])null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tagName;
    }

    @Override
    public final void setId(String newID) {
        if (this.game != null && !(this instanceof Game)) {
            if (!newID.equals(this.getId())) {
                if (this.getId() != null) {
                    this.game.removeFreeColGameObject(this.getId());
                }
                super.setId(newID);
                this.game.setFreeColGameObject(newID, this);
            }
        } else {
            super.setId(newID);
        }
    }

    public void setFakeID(String newID) {
        super.setId(newID);
    }

    protected void addModelMessage(FreeColGameObject source, ModelMessage.MessageType type, String messageID, String ... data) {
        this.addModelMessage(source, type, (FreeColObject)null, messageID, data);
    }

    protected void addModelMessage(FreeColGameObject source, ModelMessage.MessageType type, FreeColObject display, String messageID, String ... data) {
        ModelMessage message = new ModelMessage(source, type, display, messageID, data);
        this.addModelMessage(message);
    }

    protected void addModelMessage(ModelMessage message) {
        if (message.getSource() == null) {
            logger.warning("ModelMessage with ID " + message.getId() + " has null source.");
        } else if (message.getOwner() == null) {
            logger.warning("ModelMessage with ID " + message.getId() + " has null owner.");
        }
        message.getOwner().addModelMessage(message);
    }

    public boolean hasID(String id) {
        return this.getId().equals(id);
    }

    public boolean equals(FreeColGameObject o) {
        if (o != null) {
            return Utils.equals(this.getGame(), o.getGame()) && this.getId().equals(o.getId());
        }
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof FreeColGameObject ? this.equals((FreeColGameObject)o) : false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getId() + " (super's hash code: " + Integer.toHexString(super.hashCode()) + ")";
    }

    public <T extends FreeColGameObject> T getFreeColGameObject(XMLStreamReader in, String attributeName, Class<T> returnClass) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString == null) {
            return null;
        }
        FreeColGameObject returnValue = (FreeColGameObject)returnClass.cast(this.getGame().getFreeColGameObject(attributeString));
        try {
            if (returnValue == null) {
                Constructor<T> c = returnClass.getConstructor(Game.class, String.class);
                returnValue = (FreeColGameObject)returnClass.cast(c.newInstance(this.getGame(), attributeString));
            }
            return (T)returnValue;
        }
        catch (Exception e) {
            logger.warning("Failed to create FreeColGameObject with ID " + attributeString);
            return null;
        }
    }

    public <T extends FreeColGameObject> T getFreeColGameObject(XMLStreamReader in, String attributeName, Class<T> returnClass, T defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return (T)((FreeColGameObject)returnClass.cast(this.getGame().getFreeColGameObject(attributeString)));
        }
        return defaultValue;
    }

    public <T extends FreeColGameObject> T updateFreeColGameObject(XMLStreamReader in, Class<T> returnClass) {
        String attributeString = in.getAttributeValue(null, "ID");
        if (attributeString == null) {
            return null;
        }
        FreeColGameObject returnValue = (FreeColGameObject)returnClass.cast(this.getGame().getFreeColGameObject(attributeString));
        try {
            if (returnValue == null) {
                Constructor<T> c = returnClass.getConstructor(Game.class, XMLStreamReader.class);
                returnValue = (FreeColGameObject)returnClass.cast(c.newInstance(this.getGame(), in));
            } else {
                returnValue.readFromXML(in);
            }
            return (T)returnValue;
        }
        catch (Exception e) {
            logger.warning("Failed to update FreeColGameObject with ID " + attributeString);
            e.printStackTrace();
            return null;
        }
    }
}

