/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeColGameObjectType
extends FreeColObject {
    private int index;
    protected FeatureContainer featureContainer = new FeatureContainer();

    public final FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    public final void setFeatureContainer(FeatureContainer newFeatureContainer) {
        this.featureContainer = newFeatureContainer;
    }

    protected final void setIndex(int index) {
        this.index = index;
    }

    public final int getIndex() {
        return this.index;
    }

    public final String getNameKey() {
        return this.getId() + ".name";
    }

    public final String getName() {
        return Messages.message(this.getNameKey(), new String[0]);
    }

    public final String getDescription() {
        return Messages.message(this.getId() + ".description", new String[0]);
    }

    public boolean hasAbility(String id) {
        return this.featureContainer.hasAbility(id);
    }

    public boolean hasAbility(String id, FreeColGameObjectType type) {
        return this.featureContainer.hasAbility(id, type);
    }

    public void addAbility(Ability ability) {
        this.featureContainer.addAbility(ability);
    }

    public void addModifier(Modifier modifier) {
        this.featureContainer.addModifier(modifier);
    }

    public Set<Modifier> getModifierSet(String id) {
        return this.featureContainer.getModifierSet(id);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        throw new UnsupportedOperationException("Call 'readFromXML' instead.");
    }

    public void readFromXML(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "id"));
        this.readAttributes(in, specification);
        this.readChildren(in, specification);
    }

    protected void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
    }

    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            this.readChild(in, specification);
        }
    }

    protected FreeColObject readChild(XMLStreamReader in, Specification specification) throws XMLStreamException {
        String childName = in.getLocalName();
        if (Ability.getXMLElementTagName().equals(childName)) {
            Ability ability = new Ability(in);
            if (ability.getSource() == null) {
                ability.setSource(this);
            }
            this.addAbility(ability);
            specification.addAbility(ability);
            return ability;
        }
        if (Modifier.getXMLElementTagName().equals(childName)) {
            Modifier modifier = new Modifier(in);
            if (modifier.getSource() == null) {
                modifier.setSource(this);
            }
            this.addModifier(modifier);
            specification.addModifier(modifier);
            return modifier;
        }
        logger.warning("Parsing of " + childName + " is not implemented yet");
        while (in.nextTag() != 2 || !in.getLocalName().equals(childName)) {
            in.nextTag();
        }
        return null;
    }

    public String toString() {
        return this.getId();
    }
}

