/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Player;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeColObject {
    protected static Logger logger = Logger.getLogger(FreeColObject.class.getName());
    protected static final String ID_ATTRIBUTE = "ID";
    protected static final String ID_ATTRIBUTE_TAG = "id";
    protected static final String ARRAY_SIZE = "xLength";
    private String id;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public String getId() {
        return this.id;
    }

    protected void setId(String newId) {
        this.id = newId;
    }

    public Element toXMLElement(Player player, Document document) {
        return this.toXMLElement(player, document, true, false);
    }

    public Element toXMLElement(Player player, Document document, boolean showAll, boolean toSavedGame) {
        try {
            StringWriter sw = new StringWriter();
            XMLOutputFactory xif = XMLOutputFactory.newInstance();
            XMLStreamWriter xsw = xif.createXMLStreamWriter(sw);
            this.toXML(xsw, player, showAll, toSavedGame);
            xsw.close();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document tempDocument = null;
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                tempDocument = builder.parse(new InputSource(new StringReader(sw.toString())));
                return (Element)document.importNode(tempDocument.getDocumentElement(), true);
            }
            catch (ParserConfigurationException pce) {
                StringWriter swe = new StringWriter();
                pce.printStackTrace(new PrintWriter(swe));
                logger.warning(swe.toString());
                throw new IllegalStateException("ParserConfigurationException");
            }
            catch (SAXException se) {
                StringWriter swe = new StringWriter();
                se.printStackTrace(new PrintWriter(swe));
                logger.warning(swe.toString());
                throw new IllegalStateException("SAXException");
            }
            catch (IOException ie) {
                StringWriter swe = new StringWriter();
                ie.printStackTrace(new PrintWriter(swe));
                logger.warning(swe.toString());
                throw new IllegalStateException("IOException");
            }
        }
        catch (XMLStreamException e) {
            logger.warning(e.toString());
            throw new IllegalStateException("XMLStreamException");
        }
    }

    public Element toXMLElement(Document document) {
        return this.toXMLElement(null, document, true, false);
    }

    public void toXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        this.toXMLImpl(out);
    }

    public void toXML(XMLStreamWriter out, Player player) throws XMLStreamException {
        this.toXML(out, player, false, false);
    }

    public void toXML(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, null, true, false);
    }

    public void readFromXMLElement(Element element) {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        try {
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer xmlTransformer = factory.newTransformer();
                StringWriter stringWriter = new StringWriter();
                xmlTransformer.transform(new DOMSource(element), new StreamResult(stringWriter));
                String xml = stringWriter.toString();
                XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(xml));
                xsr.nextTag();
                this.readFromXML(xsr);
            }
            catch (TransformerException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                logger.warning(sw.toString());
                throw new IllegalStateException("TransformerException");
            }
        }
        catch (XMLStreamException e) {
            logger.warning(e.toString());
            throw new IllegalStateException("XMLStreamException");
        }
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLImpl(in);
    }

    protected int[] readFromArrayElement(String tagName, XMLStreamReader in, int[] arrayType) throws XMLStreamException {
        if (!in.getLocalName().equals(tagName)) {
            in.nextTag();
        }
        int[] array = new int[Integer.parseInt(in.getAttributeValue(null, ARRAY_SIZE))];
        for (int x = 0; x < array.length; ++x) {
            array[x] = Integer.parseInt(in.getAttributeValue(null, "x" + Integer.toString(x)));
        }
        in.nextTag();
        return array;
    }

    protected <T> T[] readFromArrayElement(String tagName, XMLStreamReader in, Class<T> type) throws XMLStreamException {
        if (!in.getLocalName().equals(tagName)) {
            in.nextTag();
        }
        int size = Integer.parseInt(in.getAttributeValue(null, ARRAY_SIZE));
        Object[] array = (Object[])Array.newInstance(type, size);
        for (int x = 0; x < array.length; ++x) {
            try {
                Object object;
                String value = in.getAttributeValue(null, "x" + Integer.toString(x));
                if (value != null) {
                    Constructor<T> c = type.getConstructor(type);
                    object = c.newInstance(value);
                } else {
                    object = null;
                }
                array[x] = object;
                continue;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        in.nextTag();
        return array;
    }

    protected <T> void toArrayElement(String tagName, T[] array, XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(tagName);
        out.writeAttribute(ARRAY_SIZE, Integer.toString(array.length));
        for (int x = 0; x < array.length; ++x) {
            out.writeAttribute("x" + Integer.toString(x), array[x].toString());
        }
        out.writeEndElement();
    }

    protected void toArrayElement(String tagName, int[] array, XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(tagName);
        out.writeAttribute(ARRAY_SIZE, Integer.toString(array.length));
        for (int x = 0; x < array.length; ++x) {
            out.writeAttribute("x" + Integer.toString(x), Integer.toString(array[x]));
        }
        out.writeEndElement();
    }

    protected <T> void toListElement(String tagName, List<T> array, XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(tagName);
        out.writeAttribute(ARRAY_SIZE, Integer.toString(array.size()));
        for (int x = 0; x < array.size(); ++x) {
            out.writeAttribute("x" + Integer.toString(x), array.get(x).toString());
        }
        out.writeEndElement();
    }

    protected <T> List<T> readFromListElement(String tagName, XMLStreamReader in, Class<T> type) throws XMLStreamException {
        if (!in.getLocalName().equals(tagName)) {
            in.nextTag();
        }
        int length = Integer.parseInt(in.getAttributeValue(null, ARRAY_SIZE));
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int x = 0; x < length; ++x) {
            try {
                Object object;
                String value = in.getAttributeValue(null, "x" + Integer.toString(x));
                if (value != null) {
                    Constructor<T> c = type.getConstructor(type);
                    object = c.newInstance(value);
                } else {
                    object = null;
                }
                list.add(object);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        in.nextTag();
        return list;
    }

    protected String[] readFromArrayElement(String tagName, XMLStreamReader in, String[] arrayType) throws XMLStreamException {
        if (!in.getLocalName().equals(tagName)) {
            in.nextTag();
        }
        String[] array = new String[Integer.parseInt(in.getAttributeValue(null, ARRAY_SIZE))];
        for (int x = 0; x < array.length; ++x) {
            array[x] = in.getAttributeValue(null, "x" + Integer.toString(x));
        }
        in.nextTag();
        return array;
    }

    public boolean hasAttribute(XMLStreamReader in, String attributeName) {
        String attributeString = in.getAttributeValue(null, attributeName);
        return attributeString != null;
    }

    public int getAttribute(XMLStreamReader in, String attributeName, int defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return Integer.parseInt(attributeString);
        }
        return defaultValue;
    }

    public float getAttribute(XMLStreamReader in, String attributeName, float defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return Float.parseFloat(attributeString);
        }
        return defaultValue;
    }

    public boolean getAttribute(XMLStreamReader in, String attributeName, boolean defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return Boolean.parseBoolean(attributeString);
        }
        return defaultValue;
    }

    public String getAttribute(XMLStreamReader in, String attributeName, String defaultValue) {
        String attributeString = in.getAttributeValue(null, attributeName);
        if (attributeString != null) {
            return attributeString;
        }
        return defaultValue;
    }

    public void writeAttribute(XMLStreamWriter out, String attributeName, FreeColObject object) throws XMLStreamException {
        if (object != null) {
            out.writeAttribute(attributeName, object.getId());
        }
    }

    public void writeFreeColGameObject(FreeColGameObject object, XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (object != null) {
            object.toXMLImpl(out, player, showAll, toSavedGame);
        }
    }

    public static String getXMLElementTagName() {
        return null;
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, ID_ATTRIBUTE_TAG));
        if (this.getId() == null) {
            this.setId(in.getAttributeValue(null, ID_ATTRIBUTE));
        }
        this.readAttributes(in);
        this.readChildren(in);
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
    }

    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        while (in.nextTag() != 2) {
        }
    }

    protected abstract void toXMLImpl(XMLStreamWriter var1) throws XMLStreamException;

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
    }

    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

