/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelController;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Game.class.getName());
    protected int playerIndex = 0;
    private Player unknownEnemy;
    private List<Player> players = new ArrayList<Player>();
    private Map map;
    private GameOptions gameOptions;
    private Player currentPlayer = null;
    private Player viewOwner;
    private int maxPlayers = 4;
    private HashMap<String, FreeColGameObject> freeColGameObjects = new HashMap(10000);
    private int nextId = 1;
    private boolean canGiveID;
    private Turn turn = new Turn(1);
    private final ModelController modelController;
    private FreeColGameObjectListener freeColGameObjectListener;
    private static final LostCityRumour lostCityRumour = new LostCityRumour();
    private CombatModel combatModel;
    private List<Nation> vacantNations = new ArrayList<Nation>();

    public Game(ModelController modelController) {
        super(null);
        this.modelController = modelController;
        this.combatModel = new SimpleCombatModel(modelController.getPseudoRandom());
        this.viewOwner = null;
        this.gameOptions = new GameOptions();
        this.currentPlayer = null;
        this.canGiveID = true;
    }

    public Game(FreeColGameObjectListener freeColGameObjectListener, ModelController modelController, XMLStreamReader in, FreeColGameObject[] fcgos) throws XMLStreamException {
        super(null, in);
        this.setFreeColGameObjectListener(freeColGameObjectListener);
        this.modelController = modelController;
        if (modelController != null) {
            this.combatModel = new SimpleCombatModel(modelController.getPseudoRandom());
        }
        this.viewOwner = null;
        this.canGiveID = true;
        for (FreeColGameObject object : fcgos) {
            object.setGame(this);
            object.updateID();
            if (!(object instanceof Player)) continue;
            this.players.add((Player)object);
        }
        this.readFromXML(in);
    }

    public Game(ModelController modelController, XMLStreamReader in, String viewOwnerUsername) throws XMLStreamException {
        super(null, in);
        this.modelController = modelController;
        this.combatModel = new SimpleCombatModel(modelController.getPseudoRandom());
        this.canGiveID = false;
        this.readFromXML(in);
        this.viewOwner = this.getPlayerByName(viewOwnerUsername);
    }

    public ModelController getModelController() {
        return this.modelController;
    }

    public Player getUnknownEnemy() {
        return this.unknownEnemy;
    }

    public void setUnknownEnemy(Player player) {
        this.unknownEnemy = player;
    }

    public final List<Nation> getVacantNations() {
        return this.vacantNations;
    }

    public final void setVacantNations(List<Nation> newNations) {
        this.vacantNations = newNations;
    }

    public boolean isClientTrusted() {
        return false;
    }

    public Player getViewOwner() {
        return this.viewOwner;
    }

    public Colony getColony(String name) {
        Iterator<Player> pit = this.getPlayerIterator();
        while (pit.hasNext()) {
            Colony result;
            Player p = pit.next();
            if (!p.isEuropean() || (result = p.getColony(name)) == null) continue;
            return result;
        }
        return null;
    }

    public Turn getTurn() {
        return this.turn;
    }

    void setTurn(Turn newTurn) {
        this.turn = newTurn;
    }

    public final CombatModel getCombatModel() {
        return this.combatModel;
    }

    public final void setCombatModel(CombatModel newCombatModel) {
        this.combatModel = newCombatModel;
    }

    public LostCityRumour getLostCityRumour() {
        return lostCityRumour;
    }

    public String getNextID() {
        if (this.canGiveID) {
            String id = Integer.toString(this.nextId);
            ++this.nextId;
            return id;
        }
        throw new Error("The client's \"Game\" was requested to give out an id.");
    }

    public void addPlayer(Player player) {
        if (player.isAI() || this.canAddNewPlayer()) {
            this.players.add(player);
            this.vacantNations.remove(FreeCol.getSpecification().getNation(player.getNationID()));
            player.addPropertyChangeListener("nationID", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    Nation oldNation = FreeCol.getSpecification().getNation((String)e.getOldValue());
                    Nation newNation = FreeCol.getSpecification().getNation((String)e.getNewValue());
                    Game.this.vacantNations.remove(newNation);
                    Game.this.vacantNations.add(oldNation);
                }
            });
            if (this.currentPlayer == null) {
                this.currentPlayer = player;
            }
        } else {
            logger.warning("Tried to add a new player, but the game was already full.");
        }
    }

    public void removePlayer(Player player) {
        boolean updateCurrentPlayer = this.currentPlayer == player;
        this.players.remove(this.players.indexOf(player));
        this.vacantNations.add(FreeCol.getSpecification().getNation(player.getNationID()));
        player.dispose();
        if (updateCurrentPlayer) {
            this.currentPlayer = this.getFirstPlayer();
        }
    }

    public void setFreeColGameObject(String id, FreeColGameObject freeColGameObject) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("Parameter 'id' must not be 'null' or empty string.");
        }
        if (freeColGameObject == null) {
            throw new IllegalArgumentException("Parameter 'freeColGameObject' must not be 'null'.");
        }
        FreeColGameObject old = this.freeColGameObjects.put(id, freeColGameObject);
        if (old != null) {
            throw new IllegalArgumentException("Replacing FreeColGameObject: " + old.getClass() + " with " + freeColGameObject.getClass());
        }
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.setFreeColGameObject(id, freeColGameObject);
        }
    }

    public void setFreeColGameObjectListener(FreeColGameObjectListener freeColGameObjectListener) {
        this.freeColGameObjectListener = freeColGameObjectListener;
    }

    public FreeColGameObjectListener getFreeColGameObjectListener() {
        return this.freeColGameObjectListener;
    }

    public FreeColGameObject getFreeColGameObject(String id) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("Parameter 'id' must not be null or empty string.");
        }
        return this.freeColGameObjects.get(id);
    }

    public FreeColGameObject getFreeColGameObjectSafely(String id) {
        if (id != null && id.length() > 0) {
            return this.freeColGameObjects.get(id);
        }
        return null;
    }

    public FreeColGameObject removeFreeColGameObject(String id) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("Parameter 'id' must not be null or empty string.");
        }
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.removeFreeColGameObject(id);
        }
        return this.freeColGameObjects.remove(id);
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public Nation getVacantNation() {
        if (this.vacantNations.isEmpty()) {
            return null;
        }
        return this.vacantNations.get(0);
    }

    public Player getPlayer(String nationID) {
        Iterator<Player> playerIterator = this.getPlayerIterator();
        while (playerIterator.hasNext()) {
            Player player = playerIterator.next();
            if (!player.getNationID().equals(nationID)) continue;
            return player;
        }
        return null;
    }

    public void setCurrentPlayer(Player newCp) {
        if (newCp != null) {
            if (this.currentPlayer != null) {
                this.currentPlayer.endTurn();
            }
        } else {
            logger.info("Current player set to 'null'.");
        }
        this.currentPlayer = newCp;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public Player getNextPlayer() {
        return this.getPlayerAfter(this.currentPlayer);
    }

    public Player getPlayerAfter(Player beforePlayer) {
        if (this.players.size() == 0) {
            return null;
        }
        int index = this.players.indexOf(beforePlayer) + 1;
        if (index >= this.players.size()) {
            index = 0;
        }
        Player player;
        while ((player = this.players.get(index)).isDead()) {
            if (++index < this.players.size()) continue;
            index = 0;
        }
        return player;
    }

    public boolean isNextPlayerInNewTurn() {
        return this.players.indexOf(this.currentPlayer) > this.players.indexOf(this.getNextPlayer()) || this.currentPlayer == this.getNextPlayer();
    }

    public Player getFirstPlayer() {
        if (this.players.isEmpty()) {
            return null;
        }
        return this.players.get(0);
    }

    public Iterator<FreeColGameObject> getFreeColGameObjectIterator() {
        return this.freeColGameObjects.values().iterator();
    }

    public Player getPlayerByName(String name) {
        Iterator<Player> playerIterator = this.getPlayerIterator();
        while (playerIterator.hasNext()) {
            Player player = playerIterator.next();
            if (!player.getName().equals(name)) continue;
            return player;
        }
        return null;
    }

    public boolean playerNameInUse(String username) {
        for (Player player : this.players) {
            if (!player.getName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public Iterator<Player> getPlayerIterator() {
        return this.players.iterator();
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public int getNumberOfPlayers() {
        return this.players.size();
    }

    public List<Player> getEuropeanPlayers() {
        ArrayList<Player> europeans = new ArrayList<Player>();
        for (Player player : this.players) {
            if (!player.isEuropean()) continue;
            europeans.add(player);
        }
        return europeans;
    }

    public int getMaximumPlayers() {
        return this.maxPlayers;
    }

    public void setMaximumPlayers(int newMax) {
        this.maxPlayers = newMax;
    }

    public boolean canAddNewPlayer() {
        int realPlayers = 0;
        for (Player player : this.players) {
            if (player.isAI()) continue;
            ++realPlayers;
        }
        return realPlayers < this.getMaximumPlayers();
    }

    public boolean isAllPlayersReadyToLaunch() {
        for (Player player : this.players) {
            if (player.isReady()) continue;
            return false;
        }
        return true;
    }

    public boolean checkIntegrity() {
        ArrayList<String> brokenObjects = new ArrayList<String>();
        boolean ok = true;
        for (FreeColGameObject fgo : ((HashMap)this.freeColGameObjects.clone()).values()) {
            if (!fgo.isUninitialized()) continue;
            brokenObjects.add(fgo.getId());
            logger.warning("Uinitialized object: " + fgo.getId() + " (" + fgo.getClass() + ")");
            ok = false;
        }
        if (ok) {
            logger.info("Game integrity ok.");
        } else {
            logger.warning("Game integrity test failed.");
            this.fixIntegrity(brokenObjects);
        }
        return ok;
    }

    private boolean fixIntegrity(List<String> list) {
        for (Player player : this.getPlayers()) {
            for (Unit unit : player.getUnits()) {
                if (unit.getOwner() != null) continue;
                logger.warning("Fixing " + unit.getId() + ": owner missing");
                unit.setOwner(player);
            }
        }
        return false;
    }

    public void newTurn() {
        this.turn.increase();
        logger.info("Turn is now " + this.turn.toString());
        for (Player player : this.players) {
            logger.info("Calling newTurn for player " + player.getName());
            player.newTurn();
        }
    }

    @Override
    public GameOptions getGameOptions() {
        return this.gameOptions;
    }

    public static int getInciteAmount(Player payingPlayer, Player targetPlayer, Player attackingPlayer) {
        int amount = 0;
        Tension payingTension = attackingPlayer.getTension(payingPlayer);
        Tension targetTension = attackingPlayer.getTension(targetPlayer);
        amount = targetTension != null && payingTension.getValue() > targetTension.getValue() ? 10000 : 5000;
        return Math.max(amount += 20 * (payingTension.getValue() - targetTension.getValue()), 650);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        Player p;
        out.writeStartElement(Game.getXMLElementTagName());
        if (toSavedGame && !showAll) {
            throw new IllegalArgumentException("showAll must be set to true when toSavedGame is true.");
        }
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("turn", Integer.toString(this.getTurn().getNumber()));
        this.writeAttribute(out, "currentPlayer", this.currentPlayer);
        if (toSavedGame) {
            out.writeAttribute("nextID", Integer.toString(this.nextId));
        }
        this.gameOptions.toXML(out);
        Iterator<Player> playerIterator = this.getPlayerIterator();
        while (playerIterator.hasNext()) {
            p = playerIterator.next();
            p.toXML(out, player, showAll, toSavedGame);
        }
        this.writeFreeColGameObject(this.getUnknownEnemy(), out, player, showAll, toSavedGame);
        this.writeFreeColGameObject(this.map, out, player, showAll, toSavedGame);
        playerIterator = this.getPlayerIterator();
        while (playerIterator.hasNext()) {
            p = playerIterator.next();
            if (!this.isClientTrusted() && !showAll && !p.equals(player)) continue;
            for (ModelMessage message : p.getModelMessages()) {
                message.toXML(out);
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        String currentPlayerStr;
        this.setId(in.getAttributeValue(null, "ID"));
        this.getTurn().setNumber(Integer.parseInt(in.getAttributeValue(null, "turn")));
        String nextIDStr = in.getAttributeValue(null, "nextID");
        if (nextIDStr != null) {
            this.nextId = Integer.parseInt(nextIDStr);
        }
        if ((currentPlayerStr = in.getAttributeValue(null, "currentPlayer")) != null) {
            this.currentPlayer = (Player)this.getFreeColGameObject(currentPlayerStr);
            if (this.currentPlayer == null) {
                this.currentPlayer = new Player(this, currentPlayerStr);
                this.players.add(this.currentPlayer);
            }
        } else {
            this.currentPlayer = null;
        }
        this.gameOptions = null;
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(GameOptions.getXMLElementTagName()) || in.getLocalName().equals("game-options")) {
                if (this.gameOptions != null) {
                    this.gameOptions.readFromXML(in);
                    continue;
                }
                this.gameOptions = new GameOptions(in);
                continue;
            }
            if (in.getLocalName().equals(Player.getXMLElementTagName())) {
                Player player = (Player)this.getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (player != null) {
                    player.readFromXML(in);
                    continue;
                }
                player = new Player(this, in);
                if (player.getName().equals("unknown enemy")) {
                    this.setUnknownEnemy(player);
                    continue;
                }
                this.players.add(player);
                continue;
            }
            if (in.getLocalName().equals(Map.getXMLElementTagName())) {
                String mapId = in.getAttributeValue(null, "ID");
                this.map = (Map)this.getFreeColGameObject(mapId);
                if (this.map != null) {
                    this.map.readFromXML(in);
                    continue;
                }
                this.map = new Map(this, mapId);
                this.map.readFromXML(in);
                continue;
            }
            if (in.getLocalName().equals(ModelMessage.getXMLElementTagName())) {
                ModelMessage message = new ModelMessage();
                message.readFromXML(in, this);
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " loading game");
            in.nextTag();
        }
        if (!in.getLocalName().equals(Game.getXMLElementTagName())) {
            logger.warning("Error parsing xml: expecting closing tag </" + Game.getXMLElementTagName() + "> " + "found instead: " + in.getLocalName());
        }
        if (this.gameOptions == null) {
            this.gameOptions = new GameOptions();
        }
    }

    public static String getXMLElementTagName() {
        return "game";
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    public int getNextPlayerIndex() {
        return this.playerIndex++;
    }

    public HashMap<String, Long> getGameStatistics() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Iterator<FreeColGameObject> iter = this.getFreeColGameObjectIterator();
        map.put("disposed", new Long(0L));
        while (iter.hasNext()) {
            Long l;
            Long l2;
            Long count;
            FreeColGameObject obj = iter.next();
            String className = obj.getClass().getSimpleName();
            if (map.containsKey(className)) {
                l2 = count = map.get(className);
                l = count = Long.valueOf(count + 1L);
                map.put(className, count);
            } else {
                count = new Long(1L);
                map.put(className, count);
            }
            if (!obj.isDisposed()) continue;
            l2 = count = map.get("disposed");
            l = count = Long.valueOf(count + 1L);
            map.put("disposed", count);
        }
        return map;
    }

    public HashMap<String, Long> getMemoryStatistics() {
        System.gc();
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(Messages.message("menuBar.debug.memoryManager.free", new String[0]), new Long(free));
        map.put(Messages.message("menuBar.debug.memoryManager.total", new String[0]), new Long(total));
        map.put(Messages.message("menuBar.debug.memoryManager.max", new String[0]), new Long(max));
        return map;
    }
}

