/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeItem;

public class GoldTradeItem
extends TradeItem {
    private int gold;

    public GoldTradeItem(Game game, Player source, Player destination, int gold) {
        super(game, "tradeItem.gold", source, destination);
        this.gold = gold;
    }

    public GoldTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXMLImpl(in);
    }

    public final int getGold() {
        return this.gold;
    }

    public final void setGold(int newGold) {
        this.gold = newGold;
    }

    public boolean isValid() {
        return this.gold >= 0 && this.getSource().getGold() >= this.gold;
    }

    public boolean isUnique() {
        return true;
    }

    public void makeTrade() {
        this.getSource().modifyGold(-this.gold);
        this.getDestination().modifyGold(this.gold);
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readFromXMLImpl(in);
        this.gold = Integer.parseInt(in.getAttributeValue(null, "gold"));
        in.nextTag();
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(GoldTradeItem.getXMLElementTagName());
        super.toXMLImpl(out);
        out.writeAttribute("gold", Integer.toString(this.gold));
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "goldTradeItem";
    }
}

