/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Goods
extends AbstractGoods
implements Locatable,
Ownable,
Named {
    private static Logger logger = Logger.getLogger(Goods.class.getName());
    public static GoodsType FOOD;
    public static GoodsType LUMBER;
    public static GoodsType ORE;
    public static GoodsType SILVER;
    public static GoodsType HORSES;
    public static GoodsType RUM;
    public static GoodsType CIGARS;
    public static GoodsType CLOTH;
    public static GoodsType COATS;
    public static GoodsType TRADEGOODS;
    public static GoodsType TOOLS;
    public static GoodsType MUSKETS;
    public static GoodsType FISH;
    public static GoodsType BELLS;
    public static GoodsType CROSSES;
    public static GoodsType HAMMERS;
    public static GoodsType SUGAR;
    public static GoodsType TOBACCO;
    public static GoodsType FURS;
    public static GoodsType COTTON;
    private Game game;
    private Location location;

    public Goods(Game game, Location location, GoodsType type, int amount) {
        if (game == null) {
            throw new IllegalArgumentException("Parameter 'game' must not be 'null'.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be 'null'.");
        }
        if (location != null && location.getGoodsContainer() == null) {
            throw new IllegalArgumentException("This location cannot store goods");
        }
        this.game = game;
        this.location = location;
        this.setType(type);
        this.setAmount(amount);
    }

    public Goods(Game game, XMLStreamReader in) throws XMLStreamException {
        this.game = game;
        this.readFromXML(in);
    }

    public Goods(Game game, Element e) {
        this.game = game;
        this.readFromXMLElement(e);
    }

    public static void initialize(List<GoodsType> goodsList, int numberOfTypes) {
        for (GoodsType g : goodsList) {
            try {
                String fieldName = g.getId().substring(g.getId().lastIndexOf(46) + 1).toUpperCase();
                Goods.class.getDeclaredField(fieldName).set(null, g);
            }
            catch (Exception e) {
                logger.warning("Error assigning a GoodsType to Goods." + g.getId().toUpperCase() + "\n" + e.toString());
            }
        }
    }

    @Override
    public Player getOwner() {
        return this.location instanceof Ownable ? ((Ownable)((Object)this.location)).getOwner() : null;
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return Messages.message("model.goods.goodsAmount", "%goods%", this.getName(), "%amount%", String.valueOf(this.getAmount()));
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    public String getName(boolean sellable) {
        return this.getType().getName(sellable);
    }

    @Override
    public Tile getTile() {
        return this.location != null ? this.location.getTile() : null;
    }

    @Override
    public void setLocation(Location location) {
        if (location != null && location.getGoodsContainer() == null) {
            throw new IllegalArgumentException("Goods have to be located in a GoodsContainers.");
        }
        try {
            if (this.location != null) {
                this.location.remove(this);
            }
            if (location != null) {
                location.add(this);
            }
            this.location = location;
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Could not move the goods of type: " + this.getType().getName() + " with amount: " + this.getAmount() + " from " + this.location + " to " + location, e);
        }
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public int getSpaceTaken() {
        return 1;
    }

    public void adjustAmount() {
        int maxAmount = this.location.getGoodsContainer().getGoodsCount(this.getType());
        if (this.getAmount() > maxAmount) {
            this.setAmount(maxAmount);
        }
    }

    public void loadOnto(Unit carrier) {
        if (this.getLocation() == null) {
            throw new IllegalStateException("The goods need to be taken from a place, but 'location == null'.");
        }
        if (this.getLocation().getTile() != carrier.getTile()) {
            throw new IllegalStateException("It is not allowed to load cargo onto a ship on another tile.");
        }
        if (this.getLocation().getTile() == null) {
            Unit source = (Unit)this.getLocation();
            if (!carrier.isInEurope() || !source.isInEurope()) {
                throw new IllegalStateException("Loading cargo onto a ship that is not in port in Europe.");
            }
        }
        this.setLocation(carrier);
    }

    public void unload() {
        if (!(this.getLocation() instanceof Unit)) {
            throw new IllegalStateException("Goods not on a unit");
        }
        Unit carrier = (Unit)this.getLocation();
        Location location = carrier.getLocation();
        if (location instanceof Europe || location.getTile().getSettlement() == null || !(location.getTile().getSettlement() instanceof Colony)) {
            throw new IllegalStateException("Goods may only be unloaded while the carrier is in a colony");
        }
        this.setLocation(location.getTile().getSettlement());
    }

    public Game getGame() {
        return this.game;
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(Goods.getXMLElementTagName());
        out.writeAttribute("type", this.getType().getId());
        out.writeAttribute("amount", Integer.toString(this.getAmount()));
        if (this.location != null) {
            out.writeAttribute("location", this.location.getId());
        } else {
            logger.warning("Creating an XML-element for a 'Goods' without a 'Location'.");
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setType(FreeCol.getSpecification().getGoodsType(in.getAttributeValue(null, "type")));
        this.setAmount(Integer.parseInt(in.getAttributeValue(null, "amount")));
        String locationStr = in.getAttributeValue(null, "location");
        if (locationStr != null) {
            this.location = (Location)((Object)this.getGame().getFreeColGameObject(locationStr));
        }
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "goods";
    }
}

