/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoodsContainer
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Location.class.getName());
    public static final int CARGO_SIZE = 100;
    public static final String STORED_GOODS_TAG = "storedGoods";
    public static final String OLD_STORED_GOODS_TAG = "oldStoredGoods";
    public static final String CARGO_CHANGE = "CARGO_CHANGE";
    private Map<GoodsType, Integer> storedGoods = new HashMap<GoodsType, Integer>();
    private Map<GoodsType, Integer> oldStoredGoods = new HashMap<GoodsType, Integer>();
    private final Location parent;

    public GoodsContainer(Game game, Location parent) {
        super(game);
        if (parent == null) {
            throw new IllegalArgumentException("Location of GoodsContainer must not be null!");
        }
        this.parent = parent;
    }

    public GoodsContainer(Game game, Location parent, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        if (parent == null) {
            throw new IllegalArgumentException("Location of GoodsContainer must not be null!");
        }
        this.parent = parent;
        this.readFromXML(in);
    }

    public GoodsContainer(Game game, Location parent, Element e) {
        super(game, e);
        if (parent == null) {
            throw new IllegalArgumentException("Location of GoodsContainer must not be null!");
        }
        this.parent = parent;
        this.readFromXMLElement(e);
    }

    public void addGoods(AbstractGoods g) {
        this.addGoods(g.getType(), g.getAmount());
    }

    public void addGoods(GoodsType type, int amount) {
        int oldAmount = this.getGoodsCount(type);
        int newAmount = oldAmount + amount;
        if (newAmount < 0) {
            throw new IllegalStateException("Operation would leave " + newAmount + " goods of type " + type.getName() + " in Location " + this.parent);
        }
        if (newAmount == 0) {
            this.storedGoods.remove(type);
        } else {
            this.storedGoods.put(type, newAmount);
        }
        this.firePropertyChange(CARGO_CHANGE, new AbstractGoods(type, oldAmount), new AbstractGoods(type, newAmount));
    }

    public Goods removeGoods(AbstractGoods g) {
        return this.removeGoods(g.getType(), g.getAmount());
    }

    public Goods removeGoods(GoodsType type) {
        return this.removeGoods(type, Integer.MAX_VALUE);
    }

    public Goods removeGoods(GoodsType type, int amount) {
        Goods removedGoods;
        int oldAmount = this.getGoodsCount(type);
        int newAmount = oldAmount - amount;
        if (newAmount > 0) {
            removedGoods = new Goods(this.getGame(), this.parent, type, amount);
            this.storedGoods.put(type, newAmount);
        } else {
            removedGoods = new Goods(this.getGame(), this.parent, type, oldAmount);
            this.storedGoods.remove(type);
        }
        this.firePropertyChange(CARGO_CHANGE, new AbstractGoods(type, oldAmount), new AbstractGoods(type, newAmount));
        return removedGoods;
    }

    public void removeAbove(int newAmount) {
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            if (!goodsType.isStorable() || goodsType.limitIgnored() || this.storedGoods.get(goodsType) <= newAmount) continue;
            this.setAmount(goodsType, newAmount);
        }
    }

    private void setAmount(GoodsType goodsType, int newAmount) {
        int oldAmount = this.getGoodsCount(goodsType);
        if (newAmount == 0) {
            this.storedGoods.remove(goodsType);
        } else {
            this.storedGoods.put(goodsType, newAmount);
        }
        this.firePropertyChange(CARGO_CHANGE, new AbstractGoods(goodsType, oldAmount), new AbstractGoods(goodsType, newAmount));
    }

    public void removeAll() {
        this.storedGoods.clear();
    }

    public boolean hasReachedCapacity(int amount) {
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            if (!goodsType.isStorable() || goodsType.limitIgnored() || this.storedGoods.get(goodsType) <= amount) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Goods g) {
        throw new UnsupportedOperationException();
    }

    public int getGoodsCount(GoodsType type) {
        if (this.storedGoods.containsKey(type)) {
            return this.storedGoods.get(type);
        }
        return 0;
    }

    public int getOldGoodsCount(GoodsType type) {
        if (this.oldStoredGoods.containsKey(type)) {
            return this.oldStoredGoods.get(type);
        }
        return 0;
    }

    public Goods getGoods(GoodsType goodsType) {
        return new Goods(this.getGame(), this.parent, goodsType, this.getGoodsCount(goodsType));
    }

    public int getGoodsCount() {
        int count = 0;
        for (Integer amount : this.storedGoods.values()) {
            if (amount % 100 == 0) {
                count += amount / 100;
                continue;
            }
            count += amount / 100 + 1;
        }
        return count;
    }

    public Iterator<Goods> getGoodsIterator() {
        return this.getGoods().iterator();
    }

    public List<Goods> getGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            for (int amount = this.storedGoods.get(goodsType).intValue(); amount > 0; amount -= 100) {
                totalGoods.add(new Goods(this.getGame(), this.parent, goodsType, amount >= 100 ? 100 : amount));
            }
        }
        return totalGoods;
    }

    public List<Goods> getCompactGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
            if (entry.getValue() <= 0) continue;
            totalGoods.add(new Goods(this.getGame(), this.parent, entry.getKey(), entry.getValue()));
        }
        return totalGoods;
    }

    public List<Goods> getFullGoods() {
        ArrayList<Goods> totalGoods = new ArrayList<Goods>();
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            totalGoods.add(new Goods(this.getGame(), this.parent, goodsType, this.storedGoods.get(goodsType)));
        }
        return totalGoods;
    }

    public void saveState() {
        this.oldStoredGoods.clear();
        for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
            this.oldStoredGoods.put(entry.getKey(), new Integer(entry.getValue()));
        }
    }

    public void cleanAndReport() {
        if (!(this.parent instanceof Colony)) {
            return;
        }
        Colony colony = (Colony)this.parent;
        int limit = colony.getWarehouseCapacity();
        int adjustment = limit / 100;
        for (GoodsType goodsType : this.storedGoods.keySet()) {
            if (goodsType.limitIgnored() || !goodsType.isStorable()) continue;
            ExportData exportData = colony.getExportData(goodsType);
            int low = exportData.getLowLevel() * adjustment;
            int high = exportData.getHighLevel() * adjustment;
            int amount = this.storedGoods.get(goodsType);
            int oldAmount = this.getOldGoodsCount(goodsType);
            if (amount > limit) {
                int waste = amount - limit;
                this.setAmount(goodsType, limit);
                this.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.WAREHOUSE_CAPACITY, goodsType, "model.building.warehouseWaste", "%goods%", goodsType.getName(), "%waste%", String.valueOf(waste), "%colony%", colony.getName());
                continue;
            }
            if (amount == limit && oldAmount < limit) {
                this.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.WAREHOUSE_CAPACITY, goodsType, "model.building.warehouseOverfull", "%goods%", goodsType.getName(), "%colony%", colony.getName());
                continue;
            }
            if (amount > high && oldAmount <= high) {
                this.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.WAREHOUSE_CAPACITY, goodsType, "model.building.warehouseFull", "%goods%", goodsType.getName(), "%level%", String.valueOf(high), "%colony%", colony.getName());
                continue;
            }
            if (amount >= low || oldAmount < low) continue;
            this.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.WAREHOUSE_CAPACITY, goodsType, "model.building.warehouseEmpty", "%goods%", goodsType.getName(), "%level%", String.valueOf(low), "%colony%", colony.getName());
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(GoodsContainer.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        if (!this.storedGoods.isEmpty()) {
            out.writeStartElement(STORED_GOODS_TAG);
            for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
                out.writeStartElement(Goods.getXMLElementTagName());
                out.writeAttribute("type", entry.getKey().getId());
                out.writeAttribute("amount", entry.getValue().toString());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        if (!this.oldStoredGoods.isEmpty()) {
            out.writeStartElement(OLD_STORED_GOODS_TAG);
            for (Map.Entry<GoodsType, Integer> entry : this.oldStoredGoods.entrySet()) {
                out.writeStartElement(Goods.getXMLElementTagName());
                out.writeAttribute("type", entry.getKey().getId());
                out.writeAttribute("amount", entry.getValue().toString());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        while (in.nextTag() != 2) {
            Integer amount;
            GoodsType goodsType;
            if (in.getLocalName().equals(STORED_GOODS_TAG)) {
                while (in.nextTag() != 2) {
                    if (in.getLocalName().equals(Goods.getXMLElementTagName())) {
                        goodsType = Specification.getSpecification().getGoodsType(in.getAttributeValue(null, "type"));
                        amount = new Integer(in.getAttributeValue(null, "amount"));
                        this.storedGoods.put(goodsType, amount);
                    }
                    in.nextTag();
                }
                continue;
            }
            if (!in.getLocalName().equals(OLD_STORED_GOODS_TAG)) continue;
            while (in.nextTag() != 2) {
                if (in.getLocalName().equals(Goods.getXMLElementTagName())) {
                    goodsType = Specification.getSpecification().getGoodsType(in.getAttributeValue(null, "type"));
                    amount = new Integer(in.getAttributeValue(null, "amount"));
                    this.oldStoredGoods.put(goodsType, amount);
                }
                in.nextTag();
            }
        }
    }

    public static String getXMLElementTagName() {
        return "goodsContainer";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("GoodsContainer with: ");
        for (Map.Entry<GoodsType, Integer> entry : this.storedGoods.entrySet()) {
            sb.append(entry.getKey().getName() + "=" + entry.getValue() + ", ");
        }
        return sb.toString();
    }
}

