/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.FreeColGameObjectType;

public final class GoodsType
extends FreeColGameObjectType {
    public static final int NO_BREEDING = Integer.MAX_VALUE;
    public static final int NO_PRICE = Integer.MAX_VALUE;
    private boolean isFarmed;
    private boolean isFood;
    private boolean ignoreLimit;
    private boolean newWorldGoods;
    private boolean buildingMaterial;
    private boolean militaryGoods;
    private boolean tradeGoods;
    private boolean storable;
    private boolean playerAccumulated;
    private GoodsType madeFrom;
    private GoodsType makes;
    private GoodsType storedAs;
    private int initialAmount;
    private int initialPrice;
    private int priceDiff;
    private int breedingNumber = Integer.MAX_VALUE;
    private int price = Integer.MAX_VALUE;

    public GoodsType(int index) {
        this.setIndex(index);
    }

    public String getName(boolean sellable) {
        if (sellable) {
            return this.getName();
        }
        return this.getName() + " (" + Messages.message("model.goods.boycotted", new String[0]) + ")";
    }

    public boolean isRawMaterial() {
        return this.makes != null;
    }

    public boolean isRefined() {
        return this.madeFrom != null;
    }

    public GoodsType getRawMaterial() {
        return this.madeFrom;
    }

    public GoodsType getProducedMaterial() {
        return this.makes;
    }

    public boolean isFarmed() {
        return this.isFarmed;
    }

    public boolean limitIgnored() {
        return this.ignoreLimit;
    }

    public boolean isNewWorldGoodsType() {
        return this.newWorldGoods;
    }

    public boolean isNewWorldLuxuryType() {
        return this.madeFrom != null && this.madeFrom.isNewWorldGoodsType();
    }

    public boolean isStorable() {
        return this.storable;
    }

    public boolean isStoredAs() {
        return this.storedAs != null;
    }

    public GoodsType getStoredAs() {
        if (this.storedAs == null) {
            return this;
        }
        return this.storedAs;
    }

    public int getInitialAmount() {
        return this.initialAmount;
    }

    public int getInitialSellPrice() {
        return this.initialPrice;
    }

    public int getInitialBuyPrice() {
        return this.initialPrice + this.priceDiff;
    }

    public int getPriceDifference() {
        return this.priceDiff;
    }

    public boolean isFoodType() {
        return this.isFood;
    }

    public GoodsType outputType() {
        return this.makes;
    }

    public GoodsType inputType() {
        return this.madeFrom;
    }

    public boolean isBuildingMaterial() {
        return this.buildingMaterial;
    }

    public void setBuildingMaterial(boolean newBuildingMaterial) {
        this.buildingMaterial = newBuildingMaterial;
    }

    public boolean isRawBuildingMaterial() {
        if (this.madeFrom != null) {
            return false;
        }
        GoodsType refinedType = this.makes;
        while (refinedType != null) {
            if (refinedType.isBuildingMaterial()) {
                return true;
            }
            refinedType = refinedType.makes;
        }
        return false;
    }

    public boolean isMilitaryGoods() {
        return this.militaryGoods;
    }

    public void setMilitaryGoods(boolean newMilitaryGoods) {
        this.militaryGoods = newMilitaryGoods;
    }

    public boolean isTradeGoods() {
        return this.tradeGoods;
    }

    public void setTradeGoods(boolean newTradeGoods) {
        this.tradeGoods = newTradeGoods;
    }

    public boolean isPlayerAccumulated() {
        return this.playerAccumulated;
    }

    public void setPlayerAccumulated(boolean newPlayerAccumulated) {
        this.playerAccumulated = newPlayerAccumulated;
    }

    public int getBreedingNumber() {
        return this.breedingNumber;
    }

    public void setBreedingNumber(int newBreedingNumber) {
        this.breedingNumber = newBreedingNumber;
    }

    public boolean isBreedable() {
        return this.breedingNumber != Integer.MAX_VALUE;
    }

    public int getPrice() {
        return this.price;
    }

    public void setPrice(int newPrice) {
        this.price = newPrice;
    }

    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.isFarmed = this.getAttribute(in, "is-farmed", false);
        this.isFood = this.getAttribute(in, "is-food", false);
        this.ignoreLimit = this.getAttribute(in, "ignore-limit", false);
        this.newWorldGoods = this.getAttribute(in, "new-world-goods", false);
        this.breedingNumber = this.getAttribute(in, "breeding-number", Integer.MAX_VALUE);
        this.price = this.getAttribute(in, "price", Integer.MAX_VALUE);
        this.playerAccumulated = this.getAttribute(in, "player-accumulated", false);
        this.madeFrom = specification.getType(in, "made-from", GoodsType.class, null);
        if (this.madeFrom != null) {
            this.madeFrom.makes = this;
        }
        this.storable = this.getAttribute(in, "storable", true);
        this.storedAs = specification.getType(in, "stored-as", GoodsType.class, null);
    }

    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            if ("market".equals(in.getLocalName())) {
                this.initialAmount = Integer.parseInt(in.getAttributeValue(null, "initial-amount"));
                this.initialPrice = this.getAttribute(in, "initial-price", 1);
                this.priceDiff = this.getAttribute(in, "price-difference", 1);
                in.nextTag();
                continue;
            }
            super.readChild(in, specification);
        }
    }
}

