/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.FreeColObject;

public class HistoryEvent
extends FreeColObject {
    private int turn;
    private Type type;
    private String[] strings = new String[0];

    public HistoryEvent() {
        this.setId("");
    }

    public HistoryEvent(int turn, Type type, String ... strings) {
        this.setId("");
        this.turn = turn;
        this.type = type;
        this.strings = strings;
    }

    public final int getTurn() {
        return this.turn;
    }

    public final void setTurn(int newInt) {
        this.turn = newInt;
    }

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type newType) {
        this.type = newType;
    }

    public final String[] getStrings() {
        return this.strings;
    }

    public final void setStrings(String[] newStrings) {
        this.strings = newStrings;
    }

    public String toString() {
        return Messages.message("model.history." + this.type.toString(), this.strings);
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(HistoryEvent.getXMLElementTagName());
        out.writeAttribute("id", this.getId());
        out.writeAttribute("turn", Integer.toString(this.turn));
        out.writeAttribute("type", this.type.toString());
        this.toArrayElement("strings", this.strings, out);
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "id"));
        this.turn = Integer.parseInt(in.getAttributeValue(null, "turn"));
        this.type = Enum.valueOf(Type.class, in.getAttributeValue(null, "type"));
        this.strings = this.readFromArrayElement("strings", in, new String[0]);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "historyEvent";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DISCOVER_NEW_WORLD,
        DISCOVER_REGION,
        MEET_NATION,
        CITY_OF_GOLD,
        FOUND_COLONY,
        ABANDON_COLONY,
        CONQUER_COLONY,
        COLONY_DESTROYED,
        COLONY_CONQUERED,
        DESTROY_SETTLEMENT,
        DESTROY_NATION,
        FOUNDING_FATHER,
        DECLARE_INDEPENDENCE,
        INDEPENDENCE;

    }
}

