/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndianNationType
extends NationType {
    private SettlementNumber numberOfSettlements;
    private AggressionLevel aggression;
    private Settlement.SettlementType typeOfSettlement;
    private List<RandomChoice<UnitType>> skills = new ArrayList<RandomChoice<UnitType>>();
    private List<String> regions = new ArrayList<String>();

    public IndianNationType(int index) {
        super(index);
    }

    @Override
    public boolean isEuropean() {
        return false;
    }

    @Override
    public boolean isREF() {
        return false;
    }

    public final SettlementNumber getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public final void setNumberOfSettlements(SettlementNumber newNumberOfSettlements) {
        this.numberOfSettlements = newNumberOfSettlements;
    }

    public final AggressionLevel getAggression() {
        return this.aggression;
    }

    public final void setAggression(AggressionLevel newAggression) {
        this.aggression = newAggression;
    }

    public final Settlement.SettlementType getTypeOfSettlement() {
        return this.typeOfSettlement;
    }

    public final String getSettlementTypeAsString() {
        switch (this.typeOfSettlement) {
            case INCA_CITY: 
            case AZTEC_CITY: {
                return Messages.message("settlementType.city", new String[0]);
            }
            case INDIAN_VILLAGE: {
                return Messages.message("settlementType.village", new String[0]);
            }
        }
        return Messages.message("settlementType.camp", new String[0]);
    }

    public final void setTypeOfSettlement(Settlement.SettlementType newTypeOfSettlement) {
        this.typeOfSettlement = newTypeOfSettlement;
    }

    public List<String> getRegionNames() {
        return this.regions;
    }

    public List<RandomChoice<UnitType>> getSkills() {
        return this.skills;
    }

    @Override
    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        String valueString = in.getAttributeValue(null, "number-of-settlements").toUpperCase();
        this.numberOfSettlements = Enum.valueOf(SettlementNumber.class, valueString);
        valueString = in.getAttributeValue(null, "aggression").toUpperCase();
        this.aggression = Enum.valueOf(AggressionLevel.class, valueString);
        valueString = in.getAttributeValue(null, "type-of-settlement").toUpperCase();
        this.typeOfSettlement = Enum.valueOf(Settlement.SettlementType.class, valueString);
    }

    @Override
    public void readChildren(XMLStreamReader in, Specification specification) throws XMLStreamException {
        while (in.nextTag() != 2) {
            String childName = in.getLocalName();
            if ("skill".equals(childName)) {
                UnitType unitType = specification.getUnitType(in.getAttributeValue(null, "id"));
                int probability = this.getAttribute(in, "probability", 0);
                this.skills.add(new RandomChoice<UnitType>(unitType, probability));
                in.nextTag();
                continue;
            }
            if (Region.getXMLElementTagName().equals(childName)) {
                this.regions.add(in.getAttributeValue(null, "id"));
                in.nextTag();
                continue;
            }
            super.readChild(in, specification);
        }
        Collections.sort(this.skills, new Comparator<RandomChoice<UnitType>>(){

            @Override
            public int compare(RandomChoice<UnitType> choice1, RandomChoice<UnitType> choice2) {
                return choice2.getProbability() - choice1.getProbability();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AggressionLevel {
        LOW,
        AVERAGE,
        HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettlementNumber {
        LOW,
        AVERAGE,
        HIGH;

    }
}

