/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndianSettlement
extends Settlement {
    private static final Logger logger = Logger.getLogger(IndianSettlement.class.getName());
    public static final int MISSIONARY_TENSION = -3;
    public static final int MAX_CONVERT_DISTANCE = 10;
    public static final int TURNS_PER_TRIBUTE = 5;
    public static final int ALARM_RADIUS = 2;
    public static final int ALARM_TILE_IN_USE = 2;
    public static final int ALARM_NEW_MISSIONARY = -100;
    public static final int MAX_HORSES_PER_TURN = 2;
    public static final String UNITS_TAG_NAME = "units";
    public static final String OWNED_UNITS_TAG_NAME = "ownedUnits";
    public static final String IS_VISITED_TAG_NAME = "isVisited";
    public static final String ALARM_TAG_NAME = "alarm";
    public static final String MISSIONARY_TAG_NAME = "missionary";
    public static final String WANTED_GOODS_TAG_NAME = "wantedGoods";
    public static final int KEEP_RAW_MATERIAL = 50;
    private UnitType learnableSkill = null;
    private GoodsType[] wantedGoods = new GoodsType[]{null, null, null};
    private Set<Player> visitedBy = new HashSet<Player>();
    private boolean isCapital = false;
    private List<Unit> units = Collections.emptyList();
    private ArrayList<Unit> ownedUnits = new ArrayList();
    private Unit missionary = null;
    private int convertProgress = 0;
    int lastTribute = 0;
    private Map<Player, Tension> alarm = new HashMap<Player, Tension>();
    private final Comparator<GoodsType> wantedGoodsComparator = new Comparator<GoodsType>(){

        @Override
        public int compare(GoodsType goodsType1, GoodsType goodsType2) {
            return IndianSettlement.this.getPrice(goodsType2, 100) - IndianSettlement.this.getPrice(goodsType1, 100);
        }
    };
    private final Comparator<Goods> exportGoodsComparator = new Comparator<Goods>(){

        @Override
        public int compare(Goods goods1, Goods goods2) {
            if (goods2.getAmount() == goods1.getAmount()) {
                return IndianSettlement.this.getPrice(goods2) - IndianSettlement.this.getPrice(goods1);
            }
            return goods2.getAmount() - goods1.getAmount();
        }
    };

    public IndianSettlement(Game game, Player player, Tile tile, boolean isCapital, UnitType learnableSkill, Set<Player> isVisited, Unit missionary) {
        super(game, player, tile);
        if (tile == null) {
            throw new IllegalArgumentException("Parameter 'tile' must not be 'null'.");
        }
        tile.setOwner(player);
        tile.setSettlement(this);
        this.goodsContainer = new GoodsContainer(game, this);
        this.learnableSkill = learnableSkill;
        this.isCapital = isCapital;
        this.visitedBy = isVisited;
        this.missionary = missionary;
        this.convertProgress = 0;
        this.updateWantedGoods();
    }

    public IndianSettlement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public IndianSettlement(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public IndianSettlement(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getLocationName() {
        if (this.isCapital()) {
            return Messages.message("indianCapital", "%nation%", this.getOwner().getNationAsString());
        }
        return Messages.message("indianSettlement", "%nation%", this.getOwner().getNationAsString());
    }

    public Map<Player, Tension> getAlarm() {
        return this.alarm;
    }

    public int getTribute(Player player) {
        this.modifyAlarm(player, 200);
        int gold = 0;
        if (this.getGame().getTurn().getNumber() > this.lastTribute + 5) {
            switch (this.getOwner().getTension(player).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    gold = Math.min(this.getOwner().getGold() / 10, 100);
                    break;
                }
                case DISPLEASED: {
                    gold = Math.min(this.getOwner().getGold() / 20, 100);
                    break;
                }
            }
        }
        this.getOwner().modifyGold(-gold);
        this.lastTribute = this.getGame().getTurn().getNumber();
        return gold;
    }

    public void modifyAlarm(Player player, int addToAlarm) {
        Tension tension = this.alarm.get(player);
        if (tension != null) {
            tension.modify(addToAlarm);
        }
        if (this.owner != null) {
            if (this.isCapital()) {
                this.owner.modifyTension(player, addToAlarm, this);
            } else {
                this.owner.modifyTension(player, addToAlarm / 2, this);
            }
        }
    }

    public void propagatedAlarm(Player player, int addToAlarm) {
        Tension tension = this.alarm.get(player);
        if (tension != null && this.hasBeenVisited(player)) {
            tension.modify(addToAlarm);
        }
    }

    public void setAlarm(Player player, Tension newAlarm) {
        if (player != this.owner) {
            this.alarm.put(player, newAlarm);
        }
    }

    public Tension getAlarm(Player player) {
        return this.alarm.get(player);
    }

    public String getAlarmLevelMessage(Player player) {
        if (this.alarm.get(player) == null) {
            this.alarm.put(player, new Tension(0));
        }
        return "indianSettlement.alarm." + this.alarm.get(player).getLevel().toString().toLowerCase();
    }

    public boolean hasBeenVisited() {
        Iterator<Player> playerIterator = this.visitedBy.iterator();
        while (playerIterator.hasNext()) {
            if (!playerIterator.next().isEuropean()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBeenVisited(Player player) {
        return this.visitedBy.contains(player);
    }

    public void setVisited(Player player) {
        this.visitedBy.add(player);
        if (this.alarm.get(player) == null) {
            this.alarm.put(player, new Tension(0));
        }
    }

    public void addOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        if (!this.ownedUnits.contains(unit)) {
            this.ownedUnits.add(unit);
        }
    }

    public Iterator<Unit> getOwnedUnitsIterator() {
        return this.ownedUnits.iterator();
    }

    public boolean removeOwnedUnit(Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Parameter 'unit' must not be 'null'.");
        }
        return this.ownedUnits.remove(unit);
    }

    public UnitType getLearnableSkill() {
        return this.learnableSkill;
    }

    public Unit getMissionary() {
        return this.missionary;
    }

    public void setMissionary(Unit missionary) {
        if (missionary != null) {
            if (missionary.getRole() != Unit.Role.MISSIONARY) {
                throw new IllegalArgumentException("Specified unit is not a missionary.");
            }
            missionary.setLocation(null);
            Tension currentAlarm = this.alarm.get(missionary.getOwner());
            if (currentAlarm == null) {
                this.alarm.put(missionary.getOwner(), new Tension(0));
            } else {
                currentAlarm.modify(-100);
            }
        }
        if (missionary != this.missionary) {
            this.convertProgress = 0;
        }
        if (this.missionary != null) {
            this.missionary.dispose();
        }
        this.missionary = missionary;
        this.getTile().updatePlayerExploredTiles();
    }

    public String getResponseToMissionaryAttempt(Tension.Level tension, String success) {
        String response = null;
        if (success.equals("true")) {
            switch (tension) {
                case HAPPY: {
                    response = "indianSettlement.mission.Happy";
                    break;
                }
                case CONTENT: {
                    response = "indianSettlement.mission.Content";
                    break;
                }
                case DISPLEASED: {
                    response = "indianSettlement.mission.Displeased";
                    break;
                }
                default: {
                    logger.warning("Unknown response for tension " + (Object)((Object)tension));
                    break;
                }
            }
        } else {
            switch (tension) {
                case ANGRY: {
                    response = "indianSettlement.mission.Angry";
                    break;
                }
                case HATEFUL: {
                    response = "indianSettlement.mission.Hateful";
                    break;
                }
                default: {
                    logger.warning("Requesting reaction when no mission was established");
                }
            }
        }
        return response;
    }

    public GoodsType[] getWantedGoods() {
        return this.wantedGoods;
    }

    public void setWantedGoods(int index, GoodsType type) {
        if (0 <= index && index <= 2) {
            this.wantedGoods[index] = type;
        }
    }

    public void setLearnableSkill(UnitType skill) {
        this.learnableSkill = skill;
    }

    public Settlement.SettlementType getTypeOfSettlement() {
        return ((IndianNationType)this.owner.getNationType()).getTypeOfSettlement();
    }

    @Override
    public int getRadius() {
        if (this.getTypeOfSettlement() == Settlement.SettlementType.INCA_CITY || this.getTypeOfSettlement() == Settlement.SettlementType.AZTEC_CITY) {
            return 2;
        }
        return 1;
    }

    public boolean isCapital() {
        return this.isCapital;
    }

    public void setCapital(boolean isCapital) {
        this.isCapital = isCapital;
    }

    @Override
    public void add(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (!this.units.contains(locatable)) {
                Unit indian = (Unit)locatable;
                if (((Object)this.units).equals(Collections.emptyList())) {
                    this.units = new ArrayList<Unit>();
                }
                this.units.add(indian);
                if (indian.getIndianSettlement() == null) {
                    indian.setIndianSettlement(this);
                }
            }
        } else if (locatable instanceof Goods) {
            this.addGoods((Goods)locatable);
        } else {
            logger.warning("Tried to add an unrecognized 'Locatable' to a IndianSettlement.");
        }
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (!this.units.remove(locatable)) {
                logger.warning("Failed to remove unit " + ((Unit)locatable).getId() + " from IndianSettlement");
            }
        } else if (locatable instanceof Goods) {
            this.removeGoods((Goods)locatable);
        } else {
            logger.warning("Tried to remove an unrecognized 'Locatable' from a IndianSettlement.");
        }
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.units;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        Unit defender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : this.units) {
            float tmpPower = attacker.getGame().getCombatModel().getDefencePower(attacker, nextUnit);
            if (!(tmpPower > defencePower)) continue;
            defender = nextUnit;
            defencePower = tmpPower;
        }
        return defender;
    }

    public int getPrice(Goods goods) {
        return this.getPrice(goods.getType(), goods.getAmount());
    }

    public int getPrice(GoodsType type, int amount) {
        int returnPrice = 0;
        GoodsType armsType = FreeCol.getSpecification().getGoodsType("model.goods.muskets");
        GoodsType horsesType = FreeCol.getSpecification().getGoodsType("model.goods.horses");
        EquipmentType armsEqType = FreeCol.getSpecification().getEquipmentType("model.equipment.indian.muskets");
        EquipmentType horsesEqType = FreeCol.getSpecification().getEquipmentType("model.equipment.indian.horses");
        int musketsToArmIndian = armsEqType.getAmountRequiredOf(armsType);
        int horsesToMountIndian = horsesEqType.getAmountRequiredOf(horsesType);
        int musketsCurrAvail = this.getGoodsCount(armsType);
        int horsesCurrAvail = this.getGoodsCount(horsesType);
        if (amount > 100) {
            throw new IllegalArgumentException();
        }
        if (type == armsType) {
            int need = 0;
            int supply = musketsCurrAvail;
            for (int i = 0; i < this.ownedUnits.size(); ++i) {
                need += musketsToArmIndian;
                if (!this.ownedUnits.get(i).isArmed()) continue;
                supply += musketsToArmIndian;
            }
            int sets = (musketsCurrAvail + amount) / musketsToArmIndian - musketsCurrAvail / musketsToArmIndian;
            int startPrice = 19 + this.getPriceAddition() - supply / musketsToArmIndian;
            for (int i = 0; i < sets; ++i) {
                if (startPrice - i < 8 && (need > supply || musketsCurrAvail < musketsToArmIndian)) {
                    startPrice = 8 + i;
                }
                returnPrice += musketsToArmIndian * (startPrice - i);
            }
        } else if (type == horsesType) {
            int need = 0;
            int supply = horsesCurrAvail;
            for (int i = 0; i < this.ownedUnits.size(); ++i) {
                need += horsesToMountIndian;
                if (!this.ownedUnits.get(i).isMounted()) continue;
                supply += horsesToMountIndian;
            }
            int sets = (horsesCurrAvail + amount) / horsesToMountIndian - horsesCurrAvail / horsesToMountIndian;
            int startPrice = 24 + this.getPriceAddition() - supply / horsesToMountIndian;
            for (int i = 0; i < sets; ++i) {
                if (startPrice - i * 4 < 4 && (need > supply || horsesCurrAvail < horsesToMountIndian * 2)) {
                    startPrice = 4 + i * 4;
                }
                returnPrice += horsesToMountIndian * (startPrice - i * 4);
            }
        } else if (type.isFarmed()) {
            returnPrice = 0;
        } else {
            int valueGoods;
            int currentGoods = this.getGoodsCount(type);
            GoodsType rawType = type.getRawMaterial();
            if (rawType != null) {
                int rawProduction = this.getMaximumProduction(rawType);
                if (currentGoods < 100) {
                    currentGoods = rawProduction < 5 ? (currentGoods += rawProduction * 10) : (rawProduction < 10 ? (currentGoods += 50 + Math.max((rawProduction - 5) * 5, 0)) : (rawProduction < 20 ? (currentGoods += 75 + Math.max((rawProduction - 10) * 2, 0)) : (currentGoods += 100)));
                }
            }
            if (type.isTradeGoods()) {
                currentGoods += 20;
            }
            if ((valueGoods = Math.min(currentGoods + amount, 200) - currentGoods) < 0) {
                valueGoods = 0;
            }
            returnPrice = (int)((20.0 + (double)this.getPriceAddition() - 0.05 * (double)(currentGoods + valueGoods)) * (double)(currentGoods + valueGoods) - (20.0 + (double)this.getPriceAddition() - 0.05 * (double)currentGoods) * (double)currentGoods);
        }
        if (type == this.wantedGoods[0]) {
            returnPrice = returnPrice * 12 / 10;
        } else if (type == this.wantedGoods[1]) {
            returnPrice = returnPrice * 11 / 10;
        } else if (type == this.wantedGoods[2]) {
            returnPrice = returnPrice * 105 / 100;
        }
        return returnPrice;
    }

    public int getMaximumProduction(GoodsType goodsType) {
        int amount = 0;
        Map.CircleIterator it = this.getGame().getMap().getCircleIterator(this.getTile().getPosition(), true, this.getRadius());
        while (it.hasNext()) {
            Tile workTile = this.getGame().getMap().getTile((Map.Position)it.next());
            if (workTile.getOwningSettlement() != null && workTile.getOwningSettlement() != this) continue;
            amount += workTile.potential(goodsType, null);
        }
        return amount;
    }

    public void updateWantedGoods() {
        ArrayList<GoodsType> goodsTypes = new ArrayList<GoodsType>(FreeCol.getSpecification().getGoodsTypeList());
        Collections.sort(goodsTypes, this.wantedGoodsComparator);
        int wantedIndex = 0;
        for (GoodsType goodsType : goodsTypes) {
            if (goodsType.isMilitaryGoods() || !goodsType.isStorable()) continue;
            if (wantedIndex >= this.wantedGoods.length) break;
            this.wantedGoods[wantedIndex] = goodsType;
            ++wantedIndex;
        }
    }

    private int getPriceAddition() {
        return this.getBonusMultiplier() - 1;
    }

    public int getBonusMultiplier() {
        int multiplier = 0;
        switch (this.getTypeOfSettlement()) {
            case INDIAN_CAMP: {
                multiplier = 1;
                break;
            }
            case INDIAN_VILLAGE: {
                multiplier = 2;
                break;
            }
            case AZTEC_CITY: 
            case INCA_CITY: {
                multiplier = 3;
                break;
            }
        }
        if (this.isCapital()) {
            ++multiplier;
        }
        return multiplier;
    }

    public int getGeneratedUnitCount() {
        int n;
        switch (this.getTypeOfSettlement()) {
            case INDIAN_CAMP: {
                n = 0;
                break;
            }
            case INDIAN_VILLAGE: {
                n = 1;
                break;
            }
            case AZTEC_CITY: 
            case INCA_CITY: {
                n = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("getTypeOfSettlement() out of range (" + (Object)((Object)this.getTypeOfSettlement()) + ") in IndianSettlement.getGeneratedUnitCount()");
            }
        }
        return 2 * n + 4;
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.units.contains(locatable);
        }
        return false;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return true;
    }

    @Override
    public int getProductionOf(GoodsType type) {
        int potential = 0;
        Map.CircleIterator it = this.getGame().getMap().getCircleIterator(this.getTile().getPosition(), true, this.getRadius());
        while (it.hasNext()) {
            Tile workTile = this.getGame().getMap().getTile((Map.Position)it.next());
            if (workTile.getOwningSettlement() != null && workTile.getOwningSettlement() != this || workTile.isOccupied()) continue;
            potential += workTile.potential(type, null);
        }
        if (type.isFoodType()) {
            potential = Math.min(potential, this.ownedUnits.size() * 3);
        }
        return potential;
    }

    @Override
    public void newTurn() {
        if (this.isUninitialized()) {
            logger.warning("Uninitialized when calling newTurn");
            return;
        }
        List<GoodsType> goodsList = FreeCol.getSpecification().getGoodsTypeList();
        int workers = this.ownedUnits.size();
        for (GoodsType g : goodsList) {
            this.addGoods(g, this.getProductionOf(g));
        }
        if (this.getGoodsCount(Goods.TOOLS) > 0) {
            GoodsType typeWithSmallestAmount = null;
            for (GoodsType g : goodsList) {
                if (g.isFoodType() || g.isBuildingMaterial() || g.isRawBuildingMaterial() || !g.isRawMaterial() || this.getGoodsCount(g) <= 50 || typeWithSmallestAmount != null && this.getGoodsCount(g.getProducedMaterial()) >= this.getGoodsCount(typeWithSmallestAmount)) continue;
                typeWithSmallestAmount = g.getProducedMaterial();
            }
            if (typeWithSmallestAmount != null) {
                int production = Math.min(this.getGoodsCount(typeWithSmallestAmount.getRawMaterial()), Math.min(10, this.getGoodsCount(Goods.TOOLS)));
                this.removeGoods(Goods.TOOLS, production);
                this.removeGoods(typeWithSmallestAmount.getRawMaterial(), production);
                this.addGoods(typeWithSmallestAmount, production * 5);
            }
        }
        this.consumeGoods(Goods.FOOD, this.getFoodConsumption());
        this.consumeGoods(Goods.RUM, 2 * workers);
        this.consumeGoods(Goods.TRADEGOODS, 2 * workers);
        this.consumeGoods(Goods.ORE, workers);
        this.consumeGoods(Goods.SILVER, workers);
        this.consumeGoods(Goods.CIGARS, workers);
        this.consumeGoods(Goods.COATS, workers);
        this.consumeGoods(Goods.CLOTH, workers);
        this.goodsContainer.removeAbove(500);
        this.checkForNewIndian();
        if (this.getUnitCount() > 0) {
            this.increaseAlarm();
        }
        this.breedHorses();
        this.updateWantedGoods();
    }

    public boolean checkForNewMissionaryConvert() {
        if (this.missionary != null && this.getGame().getViewOwner() == null) {
            int increment = 8;
            if (this.missionary.hasAbility("model.ability.expertMissionary")) {
                increment = 13;
            }
            this.convertProgress += (increment += 2 * this.alarm.get(this.missionary.getOwner()).getValue() / 100);
            if (this.convertProgress >= 100 && this.getUnitCount() > 2) {
                this.convertProgress = 0;
                return true;
            }
        }
        return false;
    }

    private void checkForNewIndian() {
        if (this.getFoodCount() + 4 * this.getGoodsCount(Goods.RUM) > 250) {
            List<UnitType> unitTypes;
            if (this.ownedUnits.size() <= this.getGeneratedUnitCount() && (unitTypes = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.bornInIndianSettlement")).size() > 0) {
                int random = this.getGame().getModelController().getRandom(this.getId() + "bornInIndianSettlement", unitTypes.size());
                Unit u = this.getGame().getModelController().createUnit(this.getId() + "newTurn200food", this.getTile(), this.getOwner(), unitTypes.get(random));
                this.addOwnedUnit(u);
                u.setIndianSettlement(this);
                logger.info("New indian native created in " + this.getTile() + " with ID=" + u.getId());
            }
            this.consumeGoods(Goods.FOOD, 200);
            this.consumeGoods(Goods.RUM, 50);
        }
    }

    private void increaseAlarm() {
        HashMap<Player, Integer> extraAlarm = new HashMap<Player, Integer>();
        for (Player enemy : this.getGame().getEuropeanPlayers()) {
            extraAlarm.put(enemy, new Integer(0));
        }
        int alarmRadius = this.getRadius() + 2;
        Map.CircleIterator ci = this.getGame().getMap().getCircleIterator(this.getTile().getPosition(), true, alarmRadius);
        while (ci.hasNext()) {
            Player enemy;
            Tile tile = this.getGame().getMap().getTile((Map.Position)ci.next());
            Colony colony = tile.getColony();
            if (colony == null) {
                if (tile.getFirstUnit() != null && (enemy = tile.getFirstUnit().getOwner()).isEuropean()) {
                    int alarm = (Integer)extraAlarm.get(enemy);
                    for (Unit unit : tile.getUnitList()) {
                        if (!unit.isOffensiveUnit() || unit.isNaval()) continue;
                        alarm += unit.getType().getOffence();
                    }
                    extraAlarm.put(enemy, alarm);
                }
                if (tile.getOwningSettlement() == null || (enemy = tile.getOwningSettlement().getOwner()) == null || !enemy.isEuropean()) continue;
                extraAlarm.put(enemy, (Integer)extraAlarm.get(enemy) + 2);
                continue;
            }
            enemy = colony.getOwner();
            extraAlarm.put(enemy, (Integer)extraAlarm.get(enemy) + 2 + colony.getUnitCount());
        }
        if (this.missionary != null) {
            Player enemy = this.missionary.getOwner();
            int missionaryAlarm = -3;
            if (this.missionary.hasAbility("model.ability.expertMissionary")) {
                missionaryAlarm *= 2;
            }
            extraAlarm.put(enemy, (Integer)extraAlarm.get(enemy) + missionaryAlarm);
        }
        for (Map.Entry entry : extraAlarm.entrySet()) {
            Integer newAlarm = (Integer)entry.getValue();
            if (this.alarm == null) continue;
            Player player = (Player)entry.getKey();
            int modifiedAlarm = (int)player.getFeatureContainer().applyModifier(newAlarm.intValue(), "model.modifier.nativeAlarmModifier", null, this.getGame().getTurn());
            Tension oldAlarm = this.alarm.get(player);
            if (oldAlarm != null) {
                modifiedAlarm -= 4 + oldAlarm.getValue() / 100;
            }
            this.modifyAlarm(player, modifiedAlarm);
        }
    }

    private void consumeGoods(GoodsType type, int amount) {
        if (this.getGoodsCount(type) > 0) {
            amount = Math.min(amount, this.getGoodsCount(type));
            this.getOwner().modifyGold(amount);
            this.removeGoods(type, amount);
        }
    }

    public void equipBraves() {
        GoodsType armsType = FreeCol.getSpecification().getGoodsType("model.goods.muskets");
        GoodsType horsesType = FreeCol.getSpecification().getGoodsType("model.goods.horses");
        EquipmentType armsEqType = FreeCol.getSpecification().getEquipmentType("model.equipment.indian.muskets");
        EquipmentType horsesEqType = FreeCol.getSpecification().getEquipmentType("model.equipment.indian.horses");
        int musketsToArmIndian = armsEqType.getAmountRequiredOf(armsType);
        int horsesToMountIndian = horsesEqType.getAmountRequiredOf(horsesType);
        int armsAvail = this.getGoodsCount(armsType);
        int horsesAvail = this.getGoodsCount(horsesType);
        for (Unit brave : this.getUnitList()) {
            logger.finest("Muskets available=" + this.getGoodsCount(armsType));
            if (armsAvail < musketsToArmIndian) break;
            if (brave.isArmed()) continue;
            logger.info("Equiping brave with muskets");
            brave.equipWith(armsEqType);
            if (!brave.isArmed()) {
                logger.warning("Brave has NOT been armed");
            }
            armsAvail = this.getGoodsCount(armsType);
        }
        for (Unit brave : this.getUnitList()) {
            if (horsesAvail < horsesToMountIndian) break;
            if (brave.isMounted()) continue;
            logger.info("Equiping brave with horses");
            brave.equipWith(horsesEqType);
            horsesAvail = this.getGoodsCount(horsesType);
        }
    }

    @Override
    public void dispose() {
        while (this.ownedUnits.size() > 0) {
            this.ownedUnits.remove(0).setIndianSettlement(null);
        }
        for (Unit unit : this.units) {
            unit.dispose();
        }
        super.dispose();
    }

    public void createGoodsContainer() {
        this.goodsContainer = new GoodsContainer(this.getGame(), this);
    }

    private void breedHorses() {
        GoodsType horsesType = FreeCol.getSpecification().getGoodsType("model.goods.horses");
        GoodsType reqGoodsType = horsesType.getRawMaterial();
        if (this.getGoodsCount(horsesType) < horsesType.getBreedingNumber()) {
            return;
        }
        int foodProdAvail = this.getProductionOf(reqGoodsType) - this.getFoodConsumptionByType(reqGoodsType);
        if (foodProdAvail <= 0) {
            return;
        }
        int horsesThisTurn = Math.min(2, foodProdAvail);
        this.addGoods(horsesType, horsesThisTurn);
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(IndianSettlement.getXMLElementTagName());
        if (toSavedGame && !showAll) {
            logger.warning("toSavedGame is true, but showAll is false");
        }
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("tile", this.tile.getId());
        out.writeAttribute("owner", this.owner.getId());
        out.writeAttribute("lastTribute", Integer.toString(this.lastTribute));
        out.writeAttribute("isCapital", Boolean.toString(this.isCapital));
        if (this.getGame().isClientTrusted() || showAll || player == this.getOwner()) {
            out.writeAttribute("convertProgress", Integer.toString(this.convertProgress));
            this.writeAttribute(out, "learnableSkill", this.learnableSkill);
            for (int i = 0; i < this.wantedGoods.length; ++i) {
                String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
                out.writeAttribute(tag, this.wantedGoods[i].getId());
            }
        }
        if (this.getGame().isClientTrusted() || showAll || player == this.getOwner()) {
            Iterator<Player> playerIterator = this.visitedBy.iterator();
            while (playerIterator.hasNext()) {
                out.writeStartElement(IS_VISITED_TAG_NAME);
                out.writeAttribute("player", playerIterator.next().getId());
                out.writeEndElement();
            }
        } else if (this.hasBeenVisited(player)) {
            out.writeStartElement(IS_VISITED_TAG_NAME);
            out.writeAttribute("player", player.getId());
            out.writeEndElement();
        }
        for (Map.Entry<Player, Tension> entry : this.alarm.entrySet()) {
            out.writeStartElement(ALARM_TAG_NAME);
            out.writeAttribute("player", entry.getKey().getId());
            out.writeAttribute("value", String.valueOf(entry.getValue().getValue()));
            out.writeEndElement();
        }
        if (this.missionary != null) {
            out.writeStartElement(MISSIONARY_TAG_NAME);
            this.missionary.toXML(out, player, showAll, toSavedGame);
            out.writeEndElement();
        }
        if (this.getGame().isClientTrusted() || showAll || player == this.getOwner()) {
            if (!this.units.isEmpty()) {
                out.writeStartElement(UNITS_TAG_NAME);
                for (Unit unit : this.units) {
                    unit.toXML(out, player, showAll, toSavedGame);
                }
                out.writeEndElement();
            }
            this.goodsContainer.toXML(out, player, showAll, toSavedGame);
            for (Unit unit : this.ownedUnits) {
                out.writeStartElement(OWNED_UNITS_TAG_NAME);
                out.writeAttribute("ID", unit.getId());
                out.writeEndElement();
            }
        } else {
            GoodsContainer emptyGoodsContainer = new GoodsContainer(this.getGame(), this);
            emptyGoodsContainer.setFakeID(this.goodsContainer.getId());
            emptyGoodsContainer.toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.tile = (Tile)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "tile"));
        if (this.tile == null) {
            this.tile = new Tile(this.getGame(), in.getAttributeValue(null, "tile"));
        }
        this.owner = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "owner"));
        if (this.owner == null) {
            this.owner = new Player(this.getGame(), in.getAttributeValue(null, "owner"));
        }
        this.isCapital = this.getAttribute(in, "isCapital", false);
        this.owner.addSettlement(this);
        this.featureContainer.addModifier(Settlement.DEFENCE_MODIFIER);
        this.ownedUnits.clear();
        String ownedUnitsStr = in.getAttributeValue(null, OWNED_UNITS_TAG_NAME);
        if (ownedUnitsStr != null) {
            StringTokenizer st = new StringTokenizer(ownedUnitsStr, ", ", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                Unit u = (Unit)this.getGame().getFreeColGameObject(token);
                if (u == null && ((u = new Unit(this.getGame(), token)).getOwner() == null || u.getOwner() == this.owner)) {
                    this.owner.setUnit(u);
                }
                if (u.getOwner() != null && u.getOwner() != this.owner) {
                    logger.warning("Error in savegame: unit " + u.getId() + " does not belong to settlement " + this.getId());
                    continue;
                }
                this.ownedUnits.add(u);
            }
        }
        if (this.getAttribute(in, "hasBeenVisited", false)) {
            this.visitedBy = new HashSet<Player>(this.getGame().getEuropeanPlayers());
        }
        for (int i = 0; i < this.wantedGoods.length; ++i) {
            String tag = WANTED_GOODS_TAG_NAME + Integer.toString(i);
            String wantedGoodsId = this.getAttribute(in, tag, null);
            if (wantedGoodsId == null) continue;
            this.wantedGoods[i] = FreeCol.getSpecification().getGoodsType(wantedGoodsId);
        }
        this.convertProgress = this.getAttribute(in, "convertProgress", 0);
        this.lastTribute = this.getAttribute(in, "lastTribute", 0);
        this.learnableSkill = FreeCol.getSpecification().getType(in, "learnableSkill", UnitType.class, null);
        this.visitedBy.clear();
        this.alarm = new HashMap<Player, Tension>();
        while (in.nextTag() != 2) {
            if (IS_VISITED_TAG_NAME.equals(in.getLocalName())) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                this.visitedBy.add(player);
                in.nextTag();
                continue;
            }
            if (ALARM_TAG_NAME.equals(in.getLocalName())) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                this.alarm.put(player, new Tension(this.getAttribute(in, "value", 0)));
                in.nextTag();
                continue;
            }
            if (WANTED_GOODS_TAG_NAME.equals(in.getLocalName())) {
                String[] wantedGoodsID = this.readFromArrayElement(WANTED_GOODS_TAG_NAME, in, new String[0]);
                for (int i = 0; i < wantedGoodsID.length && i != 3; ++i) {
                    this.wantedGoods[i] = FreeCol.getSpecification().getGoodsType(wantedGoodsID[i]);
                }
                continue;
            }
            if (MISSIONARY_TAG_NAME.equals(in.getLocalName())) {
                in.nextTag();
                this.missionary = this.updateFreeColGameObject(in, Unit.class);
                in.nextTag();
                continue;
            }
            if (UNITS_TAG_NAME.equals(in.getLocalName())) {
                this.units = new ArrayList<Unit>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    Unit unit = this.updateFreeColGameObject(in, Unit.class);
                    if (unit.getLocation() != this) {
                        logger.warning("fixing unit location");
                        unit.setLocation(this);
                    }
                    this.units.add(unit);
                }
                continue;
            }
            if (OWNED_UNITS_TAG_NAME.equals(in.getLocalName())) {
                Unit unit = this.getFreeColGameObject(in, "ID", Unit.class);
                if (unit.getOwner() != null && unit.getOwner() != this.owner) {
                    logger.warning("Error in savegame: unit " + unit.getId() + " does not belong to settlement " + this.getId());
                } else {
                    this.ownedUnits.add(unit);
                    this.owner.setUnit(unit);
                }
                in.nextTag();
                continue;
            }
            if (!in.getLocalName().equals(GoodsContainer.getXMLElementTagName())) continue;
            this.goodsContainer = (GoodsContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
            if (this.goodsContainer != null) {
                this.goodsContainer.readFromXML(in);
                continue;
            }
            this.goodsContainer = new GoodsContainer(this.getGame(), (Location)this, in);
        }
    }

    public static String getXMLElementTagName() {
        return "indianSettlement";
    }

    @Override
    public Colony getColony() {
        return null;
    }

    public List<Goods> getSellGoods() {
        List<Goods> settlementGoods = this.getCompactGoods();
        for (Goods goods : settlementGoods) {
            if (goods.getAmount() <= 100) continue;
            goods.setAmount(100);
        }
        Collections.sort(settlementGoods, this.exportGoodsComparator);
        ArrayList<Goods> result = new ArrayList<Goods>();
        int count = 0;
        for (Goods goods : settlementGoods) {
            if (!goods.getType().isNewWorldGoodsType() || goods.getAmount() <= 0) continue;
            result.add(goods);
            if (++count <= 2) continue;
            return result;
        }
        return result;
    }

    public int getPriceToSell(Goods goods) {
        return this.getPriceToSell(goods.getType(), goods.getAmount());
    }

    public int getPriceToSell(GoodsType type, int amount) {
        if (amount > 100) {
            throw new IllegalArgumentException();
        }
        int price = 10 - this.getProductionOf(type);
        if (price < 1) {
            price = 1;
        }
        return amount * price;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.getLocationName());
        s.append(" at (").append(this.tile.getX()).append(",").append(this.tile.getY()).append(")");
        return s.toString();
    }
}

