/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.PseudoRandom;
import net.sf.freecol.common.model.CostDecider;
import net.sf.freecol.common.model.DefaultCostDecider;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Map.class.getName());
    public static final int NUMBER_OF_DIRECTIONS = Direction.values().length;
    public static final int COST_INFINITY = Integer.MIN_VALUE;
    private Tile[][] tiles;
    private final DefaultCostDecider defaultCostDecider = new DefaultCostDecider();
    private final java.util.Map<String, Region> regions = new HashMap<String, Region>();

    public Map(Game game, Tile[][] tiles) {
        super(game);
        this.tiles = tiles;
    }

    public Map(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Map(Game game, String id) {
        super(game, id);
    }

    public Collection<Region> getRegions() {
        return this.regions.values();
    }

    public Region getRegion(String id) {
        return this.regions.get(id);
    }

    public Region getRegionByName(String id) {
        for (Region region : this.regions.values()) {
            if (!id.equals(region.getName())) continue;
            return region;
        }
        return null;
    }

    public void setRegion(Region region) {
        this.regions.put(region.getNameKey(), region);
    }

    public PathNode findPath(Tile start, Tile end, PathType type) {
        return this.findPath(null, start, end, type);
    }

    public PathNode findPath(Unit unit, Tile start, Tile end) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        return this.findPath(unit, start, end, null, null);
    }

    public PathNode findPath(Unit unit, Tile start, Tile end, Unit carrier) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit must not be 'null'.");
        }
        return this.findPath(unit, start, end, null, carrier);
    }

    private PathNode findPath(Unit unit, Tile start, Tile end, PathType type) {
        return this.findPath(unit, start, end, type, null);
    }

    private PathNode findPath(Unit unit, Tile start, Tile end, PathType type, Unit carrier) {
        PathNode firstNode;
        if (start == null) {
            throw new IllegalArgumentException("Argument 'start' must not be 'null'.");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 'end' must not be 'null'.");
        }
        if (start.equals(end)) {
            throw new IllegalArgumentException("start == end");
        }
        if (carrier != null && unit == null) {
            throw new IllegalArgumentException("Argument 'unit' must not be 'null'.");
        }
        Unit theUnit = unit;
        if (carrier != null) {
            unit = carrier;
        }
        if (unit != null) {
            firstNode = new PathNode(start, 0, this.getDistance(start.getPosition(), end.getPosition()), Direction.N, unit.getMovesLeft(), 0);
            firstNode.setOnCarrier(carrier != null);
        } else {
            firstNode = new PathNode(start, 0, this.getDistance(start.getPosition(), end.getPosition()), Direction.N, -1, -1);
        }
        HashMap<String, PathNode> openList = new HashMap<String, PathNode>();
        PriorityQueue<PathNode> openListQueue = new PriorityQueue<PathNode>(1024, new Comparator<PathNode>(){

            @Override
            public int compare(PathNode o, PathNode p) {
                int i = o.getF() - p.getF();
                if (i != 0) {
                    return i;
                }
                i = o.getTile().getX() - p.getTile().getX();
                if (i != 0) {
                    return i;
                }
                return o.getTile().getY() - p.getTile().getY();
            }
        });
        HashMap<String, PathNode> closedList = new HashMap<String, PathNode>();
        openList.put(firstNode.getTile().getId(), firstNode);
        openListQueue.offer(firstNode);
        while (!openList.isEmpty()) {
            PathNode currentNode = openListQueue.peek();
            if (currentNode.getTile() == end) {
                while (currentNode.previous != null) {
                    currentNode.previous.next = currentNode;
                    currentNode = currentNode.previous;
                }
                return currentNode.next;
            }
            for (Direction direction : Direction.values()) {
                Tile newTile = this.getNeighbourOrNull(direction, currentNode.getTile());
                if (newTile == null || currentNode.previous != null && currentNode.previous.getTile() == newTile) continue;
                int cost = currentNode.getCost();
                int movesLeft = currentNode.getMovesLeft();
                int turns = currentNode.getTurns();
                boolean onCarrier = currentNode.isOnCarrier();
                if (carrier != null && onCarrier && newTile.isLand() && (newTile.getSettlement() == null || newTile.getSettlement().getOwner() == unit.getOwner())) {
                    onCarrier = false;
                    unit = theUnit;
                    movesLeft = unit.getInitialMovesLeft();
                } else {
                    unit = currentNode.isOnCarrier() ? carrier : theUnit;
                }
                if (unit != null) {
                    int extraCost = this.defaultCostDecider.getCost(unit, currentNode.getTile(), newTile, movesLeft, turns);
                    if (extraCost == -1 && !newTile.equals(end)) continue;
                    if (extraCost == -1) {
                        if (newTile.equals(end)) {
                            cost += unit.getInitialMovesLeft();
                            movesLeft = 0;
                        }
                    } else {
                        if (carrier != null) {
                            extraCost = unit.equals(carrier) ? (extraCost *= theUnit.getInitialMovesLeft()) : (extraCost *= carrier.getInitialMovesLeft());
                        }
                        cost += extraCost;
                        movesLeft = this.defaultCostDecider.getMovesLeft();
                        if (this.defaultCostDecider.isNewTurn()) {
                            ++turns;
                        }
                    }
                } else {
                    if ((type == PathType.ONLY_SEA && newTile.isLand() || type == PathType.ONLY_LAND && !newTile.isLand()) && !newTile.equals(end)) continue;
                    cost += newTile.getMoveCost(currentNode.getTile());
                }
                int f = cost + this.getDistance(newTile.getPosition(), end.getPosition());
                PathNode successor = (PathNode)openList.get(newTile.getId());
                if (successor != null) {
                    if (successor.getF() <= f) continue;
                    openList.remove(successor.getTile().getId());
                    openListQueue.remove(successor);
                } else {
                    successor = (PathNode)closedList.get(newTile.getId());
                    if (successor != null) {
                        if (successor.getF() <= f) continue;
                        closedList.remove(newTile.getId());
                    }
                }
                successor = new PathNode(newTile, cost, f, direction, movesLeft, turns);
                successor.previous = currentNode;
                successor.setOnCarrier(onCarrier);
                openList.put(successor.getTile().getId(), successor);
                openListQueue.offer(successor);
            }
            closedList.put(currentNode.getTile().getId(), currentNode);
            openList.remove(currentNode.getTile().getId());
            openListQueue.remove(currentNode);
        }
        return null;
    }

    public PathNode search(Unit unit, GoalDecider gd, int maxTurns) {
        return this.search(unit, unit.getTile(), gd, this.defaultCostDecider, maxTurns);
    }

    public PathNode search(Unit unit, Tile startTile, GoalDecider gd, int maxTurns) {
        return this.search(unit, startTile, gd, this.defaultCostDecider, maxTurns);
    }

    public PathNode search(Unit unit, GoalDecider gd, int maxTurns, Unit carrier) {
        return this.search(unit, unit.getTile(), gd, this.defaultCostDecider, maxTurns, carrier);
    }

    public PathNode search(Tile startTile, GoalDecider gd, CostDecider costDecider, int maxTurns) {
        return this.search(null, startTile, gd, costDecider, maxTurns);
    }

    public PathNode search(Unit unit, Tile startTile, GoalDecider gd, CostDecider costDecider, int maxTurns) {
        return this.search(unit, startTile, gd, costDecider, maxTurns, null);
    }

    public PathNode search(Unit unit, Tile startTile, GoalDecider gd, CostDecider costDecider, int maxTurns, Unit carrier) {
        PathNode bestTarget;
        if (startTile == null) {
            throw new IllegalArgumentException("startTile must not be 'null'.");
        }
        Unit theUnit = unit;
        if (carrier != null) {
            unit = carrier;
        }
        int ml = unit != null ? unit.getMovesLeft() : -1;
        PathNode firstNode = new PathNode(startTile, 0, 0, Direction.N, ml, 0);
        firstNode.setOnCarrier(carrier != null);
        HashMap<String, PathNode> openList = new HashMap<String, PathNode>();
        PriorityQueue<PathNode> openListQueue = new PriorityQueue<PathNode>(1024, new Comparator<PathNode>(){

            @Override
            public int compare(PathNode o, PathNode p) {
                int i = o.getCost() - p.getCost();
                if (i != 0) {
                    return i;
                }
                i = o.getTile().getX() - p.getTile().getX();
                if (i != 0) {
                    return i;
                }
                return o.getTile().getY() - p.getTile().getY();
            }
        });
        HashMap<String, PathNode> closedList = new HashMap<String, PathNode>();
        openList.put(startTile.getId(), firstNode);
        openListQueue.offer(firstNode);
        while (!openList.isEmpty()) {
            PathNode currentNode = openListQueue.poll();
            openList.remove(currentNode.getTile().getId());
            closedList.put(currentNode.getTile().getId(), currentNode);
            if (currentNode.getTurns() > maxTurns) break;
            if (gd.check(unit, currentNode) && !gd.hasSubGoals()) {
                PathNode bestTarget2 = gd.getGoal();
                if (bestTarget2 != null) {
                    while (bestTarget2.previous != null) {
                        bestTarget2.previous.next = bestTarget2;
                        bestTarget2 = bestTarget2.previous;
                    }
                    return bestTarget2.next;
                }
                logger.warning("The returned goal is null.");
                return null;
            }
            for (Direction direction : Direction.values()) {
                PathNode successor;
                Tile newTile = this.getNeighbourOrNull(direction, currentNode.getTile());
                if (newTile == null || currentNode.previous != null && currentNode.previous.getTile() == newTile) continue;
                int cost = currentNode.getCost();
                int movesLeft = currentNode.getMovesLeft();
                int turns = currentNode.getTurns();
                boolean onCarrier = currentNode.isOnCarrier();
                if (carrier != null && onCarrier && newTile.isLand() && (newTile.getSettlement() == null || newTile.getSettlement().getOwner() == unit.getOwner())) {
                    onCarrier = false;
                    unit = theUnit;
                    movesLeft = unit.getInitialMovesLeft();
                } else {
                    unit = currentNode.isOnCarrier() ? carrier : theUnit;
                }
                int extraCost = costDecider.getCost(unit, currentNode.getTile(), newTile, movesLeft, turns);
                if (extraCost == -1) continue;
                cost = carrier != null && unit.equals(theUnit) ? (int)((double)cost + (double)extraCost * (1.0 + (double)carrier.getInitialMovesLeft() / (double)theUnit.getInitialMovesLeft())) : (cost += extraCost);
                movesLeft = costDecider.getMovesLeft();
                if (costDecider.isNewTurn()) {
                    ++turns;
                }
                if ((successor = (PathNode)closedList.get(newTile.getId())) != null) {
                    if (successor.getCost() <= cost) continue;
                    logger.warning("This should not happen. :-(");
                    continue;
                }
                successor = (PathNode)openList.get(newTile.getId());
                if (successor != null) {
                    if (successor.getCost() <= cost) continue;
                    openList.remove(successor.getTile().getId());
                    openListQueue.remove(successor);
                }
                successor = new PathNode(newTile, cost, cost, direction, movesLeft, turns);
                successor.previous = currentNode;
                successor.setOnCarrier(onCarrier);
                openList.put(successor.getTile().getId(), successor);
                openListQueue.offer(successor);
            }
        }
        if ((bestTarget = gd.getGoal()) != null) {
            while (bestTarget.previous != null) {
                bestTarget.previous.next = bestTarget;
                bestTarget = bestTarget.previous;
            }
            return bestTarget.next;
        }
        return null;
    }

    public CostDecider getDefaultCostDecider() {
        return this.defaultCostDecider;
    }

    public boolean isAdjacentToMapEdge(Tile tile) {
        for (Direction direction : Direction.values()) {
            if (this.getNeighbourOrNull(direction, tile) != null) continue;
            return true;
        }
        return false;
    }

    public PathNode findPathToEurope(Unit unit, Tile start) {
        GoalDecider gd = new GoalDecider(){
            private PathNode goal = null;

            public PathNode getGoal() {
                return this.goal;
            }

            public boolean hasSubGoals() {
                return false;
            }

            public boolean check(Unit u, PathNode pathNode) {
                Map map = u.getGame().getMap();
                if (pathNode.getTile().canMoveToEurope()) {
                    this.goal = pathNode;
                    return true;
                }
                if (map.isAdjacentToMapEdge(pathNode.getTile())) {
                    this.goal = pathNode;
                    return true;
                }
                return false;
            }
        };
        return this.search(unit, start, gd, this.defaultCostDecider, Integer.MAX_VALUE);
    }

    public boolean isLandWithinDistance(int x, int y, int distance) {
        CircleIterator i = this.getCircleIterator(new Position(x, y), true, distance);
        while (i.hasNext()) {
            if (!this.getTile((Position)i.next()).isLand()) continue;
            return true;
        }
        return false;
    }

    public Tile getTile(Position p) {
        return this.getTile(p.getX(), p.getY());
    }

    public Tile getTile(int x, int y) {
        if (this.isValid(x, y)) {
            return this.tiles[x][y];
        }
        return null;
    }

    public void setTile(Tile tile, int x, int y) {
        this.tiles[x][y] = tile;
    }

    public int getWidth() {
        if (this.tiles == null) {
            return 0;
        }
        return this.tiles.length;
    }

    public int getHeight() {
        if (this.tiles == null) {
            return 0;
        }
        return this.tiles[0].length;
    }

    public Tile getNeighbourOrNull(Direction direction, Tile t) {
        return this.getNeighbourOrNull(direction, t.getX(), t.getY());
    }

    public Tile getNeighbourOrNull(Direction direction, int x, int y) {
        if (this.isValid(x, y)) {
            Position pos = Map.getAdjacent(new Position(x, y), direction);
            return this.getTile(pos.getX(), pos.getY());
        }
        return null;
    }

    public List<Tile> getSurroundingTiles(Tile t, int range) {
        CircleIterator i;
        ArrayList<Tile> result = new ArrayList<Tile>();
        Position tilePosition = new Position(t.getX(), t.getY());
        CircleIterator circleIterator = i = range == 1 ? this.getAdjacentIterator(tilePosition) : this.getCircleIterator(tilePosition, true, range);
        while (i.hasNext()) {
            Position p = (Position)i.next();
            if (p.equals(tilePosition)) continue;
            result.add(this.getTile(p));
        }
        return result;
    }

    public Direction getRandomDirection() {
        int random = this.getGame().getModelController().getPseudoRandom().nextInt(NUMBER_OF_DIRECTIONS);
        return Direction.values()[random];
    }

    public Direction[] getRandomDirectionArray() {
        Direction[] directions = Direction.values();
        PseudoRandom random = this.getGame().getModelController().getPseudoRandom();
        for (int i = 0; i < directions.length; ++i) {
            int i2 = random.nextInt(NUMBER_OF_DIRECTIONS);
            if (i2 == i) continue;
            Direction temp = directions[i2];
            directions[i2] = directions[i];
            directions[i] = temp;
        }
        return directions;
    }

    public WholeMapIterator getWholeMapIterator() {
        return new WholeMapIterator();
    }

    public static Position getAdjacent(Position position, Direction direction) {
        int x = position.x + ((position.y & 1) != 0 ? direction.getOddDX() : direction.getEvenDX());
        int y = position.y + ((position.y & 1) != 0 ? direction.getOddDY() : direction.getEvenDY());
        return new Position(x, y);
    }

    public Iterator<Position> getAdjacentIterator(Position centerPosition) {
        return new AdjacentIterator(centerPosition);
    }

    public Iterator<Position> getBorderAdjacentIterator(Position centerPosition) {
        return new BorderAdjacentIterator(centerPosition);
    }

    public Iterator<Position> getFloodFillIterator(Position centerPosition) {
        return new CircleIterator(centerPosition, true, Integer.MAX_VALUE);
    }

    public CircleIterator getCircleIterator(Position center, boolean isFilled, int radius) {
        return new CircleIterator(center, isFilled, radius);
    }

    public boolean isValid(Position position) {
        return Map.isValid(position.x, position.y, this.getWidth(), this.getHeight());
    }

    public boolean isValid(int x, int y) {
        return Map.isValid(x, y, this.getWidth(), this.getHeight());
    }

    public static boolean isValid(Position position, int width, int height) {
        return Map.isValid(position.x, position.y, width, height);
    }

    public static boolean isValid(int x, int y, int width, int height) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    public Position getRandomLandPosition() {
        PseudoRandom random = this.getGame().getModelController().getPseudoRandom();
        int x = this.getWidth() > 10 ? random.nextInt(this.getWidth() - 10) + 5 : random.nextInt(this.getWidth());
        int y = this.getHeight() > 10 ? random.nextInt(this.getHeight() - 10) + 5 : random.nextInt(this.getHeight());
        Position centerPosition = new Position(x, y);
        Iterator<Position> it = this.getFloodFillIterator(centerPosition);
        while (it.hasNext()) {
            Position p = it.next();
            if (!this.getTile(p).isLand()) continue;
            return p;
        }
        return null;
    }

    public int getDistance(Position position1, Position position2) {
        return this.getDistance(position1.getX(), position1.getY(), position2.getX(), position2.getY());
    }

    public int getDistance(int ax, int ay, int bx, int by) {
        int r = bx - ax - (ay - by) / 2;
        if (by > ay && ay % 2 == 0 && by % 2 != 0) {
            ++r;
        } else if (by < ay && ay % 2 != 0 && by % 2 == 0) {
            --r;
        }
        return Math.max(Math.abs(ay - by + r), Math.abs(r));
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Map.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("width", Integer.toString(this.getWidth()));
        out.writeAttribute("height", Integer.toString(this.getHeight()));
        for (Region region : this.regions.values()) {
            region.toXML(out);
        }
        WholeMapIterator tileIterator = this.getWholeMapIterator();
        while (tileIterator.hasNext()) {
            Tile tile = this.getTile((Position)tileIterator.next());
            if (showAll || player.hasExplored(tile)) {
                tile.toXML(out, player, showAll, toSavedGame);
                continue;
            }
            Tile hiddenTile = new Tile(this.getGame(), null, tile.getX(), tile.getY());
            hiddenTile.setFakeID(tile.getId());
            hiddenTile.toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        if (this.tiles == null) {
            int width = Integer.parseInt(in.getAttributeValue(null, "width"));
            int height = Integer.parseInt(in.getAttributeValue(null, "height"));
            this.tiles = new Tile[width][height];
        }
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(Tile.getXMLElementTagName())) {
                Tile t = this.updateFreeColGameObject(in, Tile.class);
                this.setTile(t, t.getX(), t.getY());
                continue;
            }
            if (in.getLocalName().equals(Region.getXMLElementTagName())) {
                this.setRegion(this.updateFreeColGameObject(in, Region.class));
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " loading map");
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "map";
    }

    public Iterable<Tile> getAllTiles() {
        return new Iterable<Tile>(){

            @Override
            public Iterator<Tile> iterator() {
                final WholeMapIterator m = Map.this.getWholeMapIterator();
                return new Iterator<Tile>(){

                    @Override
                    public boolean hasNext() {
                        return m.hasNext();
                    }

                    @Override
                    public Tile next() {
                        return Map.this.getTile(m.next());
                    }

                    @Override
                    public void remove() {
                        m.remove();
                    }
                };
            }
        };
    }

    private final class BorderAdjacentIterator
    extends MapIterator {
        private Position basePosition;
        private int index;

        public BorderAdjacentIterator(Position basePosition) {
            this.basePosition = basePosition;
            this.index = 1;
        }

        public boolean hasNext() {
            for (int i = this.index; i < 8; i += 2) {
                Position newPosition = Map.getAdjacent(this.basePosition, this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                return true;
            }
            return false;
        }

        public Position nextPosition() throws NoSuchElementException {
            for (int i = this.index; i < 8; i += 2) {
                Position newPosition = Map.getAdjacent(this.basePosition, this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                this.index = i + 2;
                return newPosition;
            }
            throw new NoSuchElementException("Iterator exhausted");
        }
    }

    public final class CircleIterator
    extends MapIterator {
        private int radius;
        private int currentRadius;
        private Position nextPosition;
        private int n;

        public CircleIterator(Position center, boolean isFilled, int radius) {
            this.nextPosition = null;
            this.radius = radius;
            if (center == null) {
                throw new IllegalArgumentException("center must not be 'null'.");
            }
            this.n = 0;
            if (isFilled || radius == 1) {
                this.nextPosition = Map.getAdjacent(center, Direction.NE);
                this.currentRadius = 1;
            } else {
                this.currentRadius = radius;
                this.nextPosition = center;
                for (int i = 1; i < radius; ++i) {
                    this.nextPosition = Map.getAdjacent(this.nextPosition, Direction.N);
                }
                this.nextPosition = Map.getAdjacent(this.nextPosition, Direction.NE);
            }
            if (!Map.this.isValid(this.nextPosition)) {
                this.determineNextPosition();
            }
        }

        public int getCurrentRadius() {
            return this.currentRadius;
        }

        private void determineNextPosition() {
            boolean positionReturned = this.n != 0;
            do {
                Direction direction;
                ++this.n;
                int width = this.currentRadius * 2;
                if (this.n >= width * 4) {
                    ++this.currentRadius;
                    if (this.currentRadius > this.radius) {
                        this.nextPosition = null;
                        continue;
                    }
                    if (!positionReturned) {
                        this.nextPosition = null;
                        continue;
                    }
                    this.n = 0;
                    positionReturned = false;
                    this.nextPosition = Map.getAdjacent(this.nextPosition, Direction.NE);
                    continue;
                }
                int i = this.n / width;
                switch (i) {
                    case 0: {
                        direction = Direction.SE;
                        break;
                    }
                    case 1: {
                        direction = Direction.SW;
                        break;
                    }
                    case 2: {
                        direction = Direction.NW;
                        break;
                    }
                    case 3: {
                        direction = Direction.NE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("i=" + i + ", n=" + this.n + ", width=" + width);
                    }
                }
                this.nextPosition = Map.getAdjacent(this.nextPosition, direction);
            } while (this.nextPosition != null && !Map.this.isValid(this.nextPosition));
        }

        public boolean hasNext() {
            return this.nextPosition != null;
        }

        public Position nextPosition() {
            if (this.nextPosition != null) {
                Position p = this.nextPosition;
                this.determineNextPosition();
                return p;
            }
            return null;
        }
    }

    private final class AdjacentIterator
    extends MapIterator {
        private Position basePosition;
        private int x;

        public AdjacentIterator(Position basePosition) {
            this.x = 0;
            this.basePosition = basePosition;
        }

        public boolean hasNext() {
            for (int i = this.x; i < 8; ++i) {
                Position newPosition = Map.getAdjacent(this.basePosition, this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                return true;
            }
            return false;
        }

        public Position nextPosition() throws NoSuchElementException {
            for (int i = this.x; i < 8; ++i) {
                Position newPosition = Map.getAdjacent(this.basePosition, this.directions[i]);
                if (!Map.this.isValid(newPosition)) continue;
                this.x = i + 1;
                return newPosition;
            }
            throw new NoSuchElementException("Iterator exhausted");
        }
    }

    public final class WholeMapIterator
    extends MapIterator {
        private int x;
        private int y;

        public WholeMapIterator() {
            this.x = 0;
            this.y = 0;
        }

        public boolean hasNext() {
            return this.y < Map.this.getHeight();
        }

        public Position nextPosition() throws NoSuchElementException {
            if (this.y < Map.this.getHeight()) {
                Position newPosition = new Position(this.x, this.y);
                ++this.x;
                if (this.x == Map.this.getWidth()) {
                    this.x = 0;
                    ++this.y;
                }
                return newPosition;
            }
            throw new NoSuchElementException("Iterator exhausted");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MapIterator
    implements Iterator<Position> {
        protected Direction[] directions = Direction.values();

        private MapIterator() {
        }

        public abstract Position nextPosition() throws NoSuchElementException;

        @Override
        public Position next() {
            return this.nextPosition();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Position {
        public final int x;
        public final int y;

        public Position(int posX, int posY) {
            this.x = posX;
            this.y = posY;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Position)) {
                return false;
            }
            return this.x == ((Position)other).x && this.y == ((Position)other).y;
        }

        public int hashCode() {
            return this.x | this.y << 16;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathType {
        BOTH_LAND_AND_SEA,
        ONLY_LAND,
        ONLY_SEA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        N(0, -2, 0, -2),
        NE(1, -1, 0, -1),
        E(1, 0, 1, 0),
        SE(1, 1, 0, 1),
        S(0, 2, 0, 2),
        SW(0, 1, -1, 1),
        W(-1, 0, -1, 0),
        NW(0, -1, -1, -1);

        private int oddDX;
        private int oddDY;
        private int evenDX;
        private int evenDY;

        private Direction(int oddDX, int oddDY, int evenDX, int evenDY) {
            this.oddDX = oddDX;
            this.oddDY = oddDY;
            this.evenDX = evenDX;
            this.evenDY = evenDY;
        }

        public int getOddDX() {
            return this.oddDX;
        }

        public int getOddDY() {
            return this.oddDY;
        }

        public int getEvenDX() {
            return this.evenDX;
        }

        public int getEvenDY() {
            return this.evenDY;
        }

        public Direction getReverseDirection() {
            switch (this) {
                case N: {
                    return S;
                }
                case NE: {
                    return SW;
                }
                case E: {
                    return W;
                }
                case SE: {
                    return NW;
                }
                case S: {
                    return N;
                }
                case SW: {
                    return NE;
                }
                case W: {
                    return E;
                }
                case NW: {
                    return SE;
                }
            }
            return null;
        }
    }
}

