/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TransactionListener;
import org.w3c.dom.Element;

public final class Market
extends FreeColGameObject
implements Ownable {
    public static final int MINIMUM_PRICE = 1;
    public static final int MAXIMUM_PRICE = 19;
    private Player owner;
    private boolean initialized = false;
    public static final int EUROPE = 0;
    public static final int CUSTOM_HOUSE = 1;
    private final Map<GoodsType, MarketData> marketData = new HashMap<GoodsType, MarketData>();
    private ArrayList<TransactionListener> transactionListeners = new ArrayList();

    public Market(Game game, Player player) {
        super(game);
        this.owner = player;
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            MarketData data = new MarketData();
            data.setId(goodsType.getId());
            if (goodsType.isStorable()) {
                data.setAmountInMarket(goodsType.getInitialAmount());
                data.setPaidForSale(goodsType.getInitialSellPrice());
                data.setCostToBuy(goodsType.getInitialBuyPrice());
                data.setOldPrice(goodsType.getInitialBuyPrice());
                data.setInitialPrice(goodsType.getInitialSellPrice());
            }
            this.marketData.put(goodsType, data);
        }
        this.priceGoods();
    }

    public Market(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Market(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Market(Game game, String id) {
        super(game, id);
    }

    public MarketData getMarketData(GoodsType goodsType) {
        return this.marketData.get(goodsType);
    }

    public void putMarketData(GoodsType goodsType, MarketData data) {
        this.marketData.put(goodsType, data);
    }

    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    public int costToBuy(GoodsType type) {
        MarketData data = this.marketData.get(type);
        if (data == null) {
            return 0;
        }
        return data.getCostToBuy();
    }

    public int paidForSale(GoodsType type) {
        MarketData data = this.marketData.get(type);
        if (data == null) {
            return 0;
        }
        return data.getPaidForSale();
    }

    public void sell(GoodsType type, int amount, Player player) {
        this.sell(type, amount, player, 0);
    }

    public void sell(GoodsType type, int amount, Player player, int marketAccess) {
        if (player.canTrade(type, marketAccess)) {
            int unitPrice = this.paidForSale(type);
            int tax = player.getTax();
            int incomeBeforeTaxes = this.getSalePrice(type, amount);
            int incomeAfterTaxes = (100 - tax) * incomeBeforeTaxes / 100;
            player.modifyGold(incomeAfterTaxes);
            player.modifySales(type, amount);
            player.modifyIncomeBeforeTaxes(type, incomeBeforeTaxes);
            player.modifyIncomeAfterTaxes(type, incomeAfterTaxes);
            for (TransactionListener listener : this.transactionListeners) {
                listener.logSale(type, amount, unitPrice, tax);
            }
            amount = (int)player.getFeatureContainer().applyModifier(amount, "model.modifier.tradeBonus", type, this.getGame().getTurn());
            this.add(type, amount);
        } else {
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.WARNING, "model.europe.market", "%goods%", type.getName());
        }
    }

    public void sell(Goods goods, Player player) {
        GoodsType type = goods.getType();
        int amount = goods.getAmount();
        goods.setLocation(null);
        this.sell(type, amount, player, 0);
    }

    public void buy(GoodsType goodsType, int amount, Player player) {
        int price = this.getBidPrice(goodsType, amount);
        if (price > player.getGold()) {
            throw new IllegalStateException();
        }
        int unitPrice = this.costToBuy(goodsType);
        player.modifyGold(-price);
        player.modifySales(goodsType, -amount);
        player.modifyIncomeBeforeTaxes(goodsType, -price);
        player.modifyIncomeAfterTaxes(goodsType, -price);
        for (TransactionListener listener : this.transactionListeners) {
            listener.logPurchase(goodsType, amount, unitPrice);
        }
        amount = (int)player.getFeatureContainer().applyModifier(amount, "model.modifier.tradeBonus", goodsType, this.getGame().getTurn());
        this.remove(goodsType, amount);
    }

    public void add(GoodsType goodsType, int amount) {
        MarketData data = this.marketData.get(goodsType);
        if (data == null) {
            data = new MarketData();
            this.marketData.put(goodsType, data);
        }
        int oldAmount = data.getAmountInMarket();
        data.setAmountInMarket(oldAmount + amount);
        this.priceGoods(goodsType, true);
    }

    public void remove(GoodsType goodsType, int amount) {
        MarketData data = this.marketData.get(goodsType);
        if (data == null) {
            data = new MarketData();
            this.marketData.put(goodsType, data);
        }
        int oldAmount = data.getAmountInMarket();
        data.setAmountInMarket(Math.max(oldAmount - amount, 100));
        this.priceGoods(goodsType, true);
    }

    public int getBidPrice(GoodsType type, int amount) {
        MarketData data = this.marketData.get(type);
        if (data == null) {
            return 0;
        }
        return amount * data.getCostToBuy();
    }

    public int getSalePrice(GoodsType type, int amount) {
        MarketData data = this.marketData.get(type);
        if (data == null) {
            return 0;
        }
        return amount * data.getPaidForSale();
    }

    public int getSalePrice(Goods goods) {
        return this.getSalePrice(goods.getType(), goods.getAmount());
    }

    private void priceGoods() {
        this.priceGoods(this.initialized);
        this.initialized = true;
    }

    private void priceGoods(boolean addMessages) {
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            if (!goodsType.isStorable()) continue;
            this.priceGoods(goodsType, addMessages);
        }
    }

    private void priceGoods(GoodsType goodsType, boolean addMessages) {
        MarketData data = this.marketData.get(goodsType);
        if (data != null) {
            data.setOldPrice(data.getCostToBuy());
            int newPrice = Math.round((float)(goodsType.getInitialAmount() * data.getInitialPrice()) / (float)data.getAmountInMarket());
            if (newPrice + goodsType.getPriceDifference() > 19) {
                data.setCostToBuy(19);
                data.setPaidForSale(19 - goodsType.getPriceDifference());
            } else {
                if (newPrice < 1) {
                    newPrice = 1;
                }
                data.setPaidForSale(newPrice);
                data.setCostToBuy(data.getPaidForSale() + goodsType.getPriceDifference());
            }
            if (addMessages && this.owner != null && this.owner.getEurope() != null && goodsType.isStorable()) {
                if (data.getOldPrice() > data.getCostToBuy()) {
                    this.addModelMessage((FreeColGameObject)this.owner.getEurope(), ModelMessage.MessageType.MARKET_PRICES, goodsType, "model.market.priceDecrease", "%europe%", this.owner.getEurope().getName(), "%goods%", goodsType.getName(), "%buy%", String.valueOf(data.getCostToBuy()), "%sell%", String.valueOf(data.getPaidForSale()));
                } else if (data.getOldPrice() < data.getCostToBuy()) {
                    this.addModelMessage((FreeColGameObject)this.owner.getEurope(), ModelMessage.MessageType.MARKET_PRICES, goodsType, "model.market.priceIncrease", "%europe%", this.owner.getEurope().getName(), "%goods%", goodsType.getName(), "%buy%", String.valueOf(data.getCostToBuy()), "%sell%", String.valueOf(data.getPaidForSale()));
                }
            }
        }
    }

    public void newTurn() {
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            MarketData data;
            if (!goodsType.isStorable() || (data = this.marketData.get(goodsType)) == null || data.getAmountInMarket() <= goodsType.getInitialAmount()) continue;
            this.remove(goodsType, 10);
        }
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Market.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("owner", this.owner.getId());
        for (MarketData data : this.marketData.values()) {
            data.toXML(out, player, showAll, toSavedGame);
        }
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.owner = this.getFreeColGameObject(in, "owner", Player.class);
        while (in.nextTag() != 2) {
            if (!in.getLocalName().equals(MarketData.getXMLElementTagName())) continue;
            MarketData data = new MarketData();
            data.readFromXML(in);
            this.marketData.put(FreeCol.getSpecification().getGoodsType(data.getId()), data);
        }
        this.priceGoods();
    }

    public static String getXMLElementTagName() {
        return "market";
    }

    public void addTransactionListener(TransactionListener listener) {
        this.transactionListeners.add(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.transactionListeners.remove(listener);
    }

    public TransactionListener[] getTransactionListener() {
        return this.transactionListeners.toArray(new TransactionListener[0]);
    }
}

