/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;

public class MarketData
extends FreeColObject {
    private int costToBuy;
    private int paidForSale;
    private int amountInMarket;
    private int oldPrice;
    private int initialPrice;
    private int arrears;
    private int sales;
    private int incomeBeforeTaxes;
    private int incomeAfterTaxes;
    private boolean traded;

    public MarketData() {
        this.traded = false;
    }

    public MarketData(GoodsType goodsType) {
        this.setId(goodsType.getId());
        this.traded = false;
    }

    public final int getCostToBuy() {
        return this.costToBuy;
    }

    public final void setCostToBuy(int newCostToBuy) {
        this.costToBuy = newCostToBuy;
    }

    public final int getPaidForSale() {
        return this.paidForSale;
    }

    public final void setPaidForSale(int newPaidForSale) {
        this.paidForSale = newPaidForSale;
    }

    public final int getAmountInMarket() {
        return this.amountInMarket;
    }

    public final void setAmountInMarket(int newAmountInMarket) {
        this.amountInMarket = newAmountInMarket;
    }

    public final int getOldPrice() {
        return this.oldPrice;
    }

    public final void setOldPrice(int newOldPrice) {
        this.oldPrice = newOldPrice;
    }

    public final int getInitialPrice() {
        return this.initialPrice;
    }

    public final void setInitialPrice(int newInitialPrice) {
        this.initialPrice = newInitialPrice;
    }

    public final int getArrears() {
        return this.arrears;
    }

    public final void setArrears(int newArrears) {
        this.arrears = newArrears;
    }

    public final int getSales() {
        return this.sales;
    }

    public final void setSales(int newSales) {
        this.traded |= this.sales != newSales;
        this.sales = newSales;
    }

    public final int getIncomeBeforeTaxes() {
        return this.incomeBeforeTaxes;
    }

    public final void setIncomeBeforeTaxes(int newIncomeBeforeTaxes) {
        this.incomeBeforeTaxes = newIncomeBeforeTaxes;
    }

    public final int getIncomeAfterTaxes() {
        return this.incomeAfterTaxes;
    }

    public final void setIncomeAfterTaxes(int newIncomeAfterTaxes) {
        this.incomeAfterTaxes = newIncomeAfterTaxes;
    }

    public final boolean getTraded() {
        return this.traded;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(MarketData.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("amount", Integer.toString(this.amountInMarket));
        out.writeAttribute("initialPrice", Integer.toString(this.initialPrice));
        out.writeAttribute("arrears", Integer.toString(this.arrears));
        out.writeAttribute("sales", Integer.toString(this.sales));
        out.writeAttribute("incomeBeforeTaxes", Integer.toString(this.incomeBeforeTaxes));
        out.writeAttribute("incomeAfterTaxes", Integer.toString(this.incomeAfterTaxes));
        out.writeAttribute("traded", Boolean.toString(this.traded));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.amountInMarket = Integer.parseInt(in.getAttributeValue(null, "amount"));
        this.initialPrice = this.getAttribute(in, "initialPrice", -1);
        if (this.initialPrice < 0) {
            this.initialPrice = Specification.getSpecification().getGoodsType(this.getId()).getInitialSellPrice();
        }
        this.arrears = Integer.parseInt(in.getAttributeValue(null, "arrears"));
        this.sales = Integer.parseInt(in.getAttributeValue(null, "sales"));
        this.incomeBeforeTaxes = Integer.parseInt(in.getAttributeValue(null, "incomeBeforeTaxes"));
        this.incomeAfterTaxes = Integer.parseInt(in.getAttributeValue(null, "incomeAfterTaxes"));
        this.traded = this.getAttribute(in, "traded", this.sales != 0);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "marketData";
    }
}

