/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;

public class ModelMessage
extends FreeColObject {
    private Player owner;
    private FreeColGameObject source;
    private Location sourceLocation;
    private FreeColObject display;
    private MessageType type;
    private String[] data;
    private boolean beenDisplayed = false;

    public ModelMessage() {
    }

    private static String[] convertData(String[][] data) {
        if (data == null) {
            return null;
        }
        String[] strings = new String[data.length * 2];
        for (int index = 0; index < data.length; ++index) {
            strings[index * 2] = data[index][0];
            strings[index * 2 + 1] = data[index][1];
        }
        return strings;
    }

    @Deprecated
    public ModelMessage(FreeColGameObject source, String id, String[][] data, MessageType type, FreeColObject display) {
        this(source, type, display, id, ModelMessage.convertData(data));
    }

    public ModelMessage(FreeColGameObject source, MessageType type, FreeColObject display, String id, String ... data) {
        this.source = source;
        this.sourceLocation = null;
        if (source instanceof Unit) {
            Unit u = (Unit)source;
            this.owner = u.getOwner();
            if (u.getTile() != null) {
                this.sourceLocation = u.getTile();
            } else if (u.getColony() != null) {
                this.sourceLocation = u.getColony().getTile();
            } else if (u.getIndianSettlement() != null) {
                this.sourceLocation = u.getIndianSettlement().getTile();
            } else if (u.isInEurope()) {
                this.sourceLocation = u.getOwner().getEurope();
            }
        } else if (source instanceof Settlement) {
            this.owner = ((Settlement)source).getOwner();
            this.sourceLocation = ((Settlement)source).getTile();
        } else if (source instanceof Europe) {
            this.owner = ((Europe)source).getOwner();
        } else if (source instanceof Player) {
            this.owner = (Player)source;
        } else if (source instanceof Ownable) {
            this.owner = ((Ownable)((Object)source)).getOwner();
        }
        this.setId(id);
        this.data = data;
        this.type = type;
        this.display = display == null ? ModelMessage.getDefaultDisplay(type, source) : display;
        this.verifyFields();
    }

    private void verifyFields() {
        if (this.getId() == null) {
            throw new IllegalArgumentException("ModelMessage should not have a null id.");
        }
        if (this.source == null) {
            throw new IllegalArgumentException("ModelMessage with ID " + this.toString() + " should not have a null source.");
        }
        if (this.owner == null) {
            throw new IllegalArgumentException("ModelMessage with ID " + this.getId() + " should not have a null owner.");
        }
        if (this.display != null && !(this.display instanceof FreeColGameObject) && !(this.display instanceof FreeColGameObjectType)) {
            throw new IllegalArgumentException("The display must be a FreeColGameObject or FreeColGameObjectType!");
        }
        if (this.data != null && this.data.length % 2 != 0) {
            throw new IllegalArgumentException("Data length must be multiple of 2.");
        }
    }

    public ModelMessage(FreeColGameObject source, String id, String[][] data, MessageType type) {
        this(source, type, ModelMessage.getDefaultDisplay(type, source), id, ModelMessage.convertData(data));
    }

    public ModelMessage(FreeColGameObject source, String id, String[][] data) {
        this(source, MessageType.DEFAULT, ModelMessage.getDefaultDisplay(MessageType.DEFAULT, source), id, ModelMessage.convertData(data));
    }

    private static FreeColObject getDefaultDisplay(MessageType type, FreeColGameObject source) {
        FreeColObject newDisplay = null;
        switch (type) {
            case SONS_OF_LIBERTY: 
            case GOVERNMENT_EFFICIENCY: {
                newDisplay = FreeCol.getSpecification().getGoodsType("model.goods.bells");
                break;
            }
            case LOST_CITY_RUMOUR: {
                newDisplay = new LostCityRumour();
                break;
            }
            case UNIT_IMPROVED: 
            case UNIT_DEMOTED: 
            case UNIT_LOST: 
            case UNIT_ADDED: 
            case COMBAT_RESULT: {
                newDisplay = source;
                break;
            }
            case BUILDING_COMPLETED: {
                newDisplay = FreeCol.getSpecification().getGoodsType("model.goods.hammers");
                break;
            }
            default: {
                if (!(source instanceof Player)) break;
                newDisplay = source;
            }
        }
        return newDisplay;
    }

    public boolean hasBeenDisplayed() {
        return this.beenDisplayed;
    }

    public void setBeenDisplayed(boolean beenDisplayed) {
        this.beenDisplayed = beenDisplayed;
    }

    public FreeColGameObject getSource() {
        return this.source;
    }

    public void setSource(FreeColGameObject newSource) {
        this.source = newSource;
    }

    public String[] getData() {
        return this.data;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getTypeName() {
        return Messages.message("model.message." + this.type.toString(), new String[0]);
    }

    public FreeColObject getDisplay() {
        return this.display;
    }

    public void setDisplay(FreeColGameObject newDisplay) {
        this.display = newDisplay;
    }

    public Player getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModelMessage)) {
            return false;
        }
        ModelMessage m = (ModelMessage)o;
        if (!Arrays.equals(this.data, m.data)) {
            return false;
        }
        return this.source.equals(m.source) && this.getId().equals(m.getId()) && this.type == m.type;
    }

    public int hashCode() {
        int value = 1;
        value = 37 * value + (this.source == null ? 0 : this.source.hashCode());
        value = 37 * value + this.getId().hashCode();
        if (this.data != null) {
            for (String s : this.data) {
                value = 37 * value + s.hashCode();
            }
        }
        value = 37 * value + this.type.ordinal();
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ModelMessage<");
        sb.append(this.hashCode() + ", " + (this.source == null ? "null" : this.source.getId()) + ", " + this.getId() + ", " + (this.display == null ? "null" : this.display.getId()) + ", ");
        if (this.data != null) {
            for (String s : this.data) {
                sb.append(s + "/");
            }
        }
        sb.append(", " + (Object)((Object)this.type) + " >");
        return sb.toString();
    }

    public static String getXMLElementTagName() {
        return "modelMessage";
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(ModelMessage.getXMLElementTagName());
        out.writeAttribute("owner", this.owner.getId());
        if (this.source != null) {
            if (this.source instanceof Unit && ((Unit)this.source).isDisposed() || this.source instanceof Settlement && ((Settlement)this.source).isDisposed()) {
                if (this.sourceLocation == null) {
                    logger.warning("sourceLocation==null for source " + this.source.getId());
                    out.writeAttribute("source", this.owner.getId());
                } else {
                    out.writeAttribute("source", this.sourceLocation.getId());
                }
            } else {
                out.writeAttribute("source", this.source.getId());
            }
        }
        if (this.display != null) {
            out.writeAttribute("display", this.display.getId());
        }
        out.writeAttribute("type", this.type.toString());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("hasBeenDisplayed", String.valueOf(this.beenDisplayed));
        if (this.data != null) {
            this.toArrayElement("data", this.data, out);
        }
        out.writeEndElement();
    }

    public void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.type = Enum.valueOf(MessageType.class, this.getAttribute(in, "type", MessageType.DEFAULT.toString()));
        this.beenDisplayed = Boolean.parseBoolean(in.getAttributeValue(null, "hasBeenDisplayed"));
        while (in.nextTag() != 2) {
            if (!in.getLocalName().equals("data")) continue;
            this.data = this.readFromArrayElement("data", in, new String[0]);
        }
        in.nextTag();
    }

    public void readFromXML(XMLStreamReader in, Game game) throws XMLStreamException {
        String displayString;
        this.setId(in.getAttributeValue(null, "ID"));
        String ownerPlayer = in.getAttributeValue(null, "owner");
        this.owner = (Player)game.getFreeColGameObject(ownerPlayer);
        this.type = Enum.valueOf(MessageType.class, this.getAttribute(in, "type", MessageType.DEFAULT.toString()));
        this.beenDisplayed = Boolean.parseBoolean(in.getAttributeValue(null, "hasBeenDisplayed"));
        String sourceString = in.getAttributeValue(null, "source");
        this.source = game.getFreeColGameObject(sourceString);
        if (this.source == null) {
            logger.warning("source null from string " + sourceString);
            this.source = this.owner;
        }
        if ((displayString = in.getAttributeValue(null, "display")) != null) {
            this.display = game.getFreeColGameObject(displayString);
            if (this.display == null) {
                try {
                    this.display = FreeCol.getSpecification().getType(displayString);
                }
                catch (IllegalArgumentException e) {
                    this.display = this.owner;
                    logger.warning("display null from string " + displayString);
                }
            }
        }
        while (in.nextTag() != 2) {
            if (!in.getLocalName().equals("data")) continue;
            this.data = this.readFromArrayElement("data", in, new String[0]);
        }
        this.verifyFields();
        this.owner.addModelMessage(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        DEFAULT,
        WARNING,
        SONS_OF_LIBERTY,
        GOVERNMENT_EFFICIENCY,
        WAREHOUSE_CAPACITY,
        UNIT_IMPROVED,
        UNIT_DEMOTED,
        UNIT_LOST,
        UNIT_ADDED,
        BUILDING_COMPLETED,
        FOREIGN_DIPLOMACY,
        MARKET_PRICES,
        LOST_CITY_RUMOUR,
        GIFT_GOODS,
        MISSING_GOODS,
        TUTORIAL,
        COMBAT_RESULT;

    }
}

