/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.BonusOrPenalty;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Turn;
import org.w3c.dom.Element;

public final class Modifier
extends Feature {
    public static final String OFFENCE = "model.modifier.offence";
    public static final String DEFENCE = "model.modifier.defence";
    public static final BonusOrPenalty COLONY_GOODS_PARTY = new BonusOrPenalty("model.monarch.colonyGoodsParty");
    public static final float UNKNOWN = Float.MIN_VALUE;
    private float value;
    private float increment;
    private Type type;
    private Type incrementType;

    private Modifier() {
    }

    public Modifier(String id, float value, Type type) {
        this.setId(id);
        this.setType(type);
        this.setValue(value);
    }

    public Modifier(String id, FreeColGameObjectType source, float value, Type type) {
        this.setId(id);
        this.setSource(source);
        this.setType(type);
        this.setValue(value);
    }

    public Modifier(Modifier template) {
        this.setId(template.getId());
        this.setSource(template.getSource());
        this.setType(template.getType());
        this.setValue(template.getValue());
        if (template.hasIncrement()) {
            this.setIncrement(template.getIncrement(), template.getIncrementType(), template.getFirstTurn(), template.getLastTurn());
        }
    }

    public Modifier(Element element) {
        this.readFromXMLElement(element);
    }

    public Modifier(XMLStreamReader in) throws XMLStreamException {
        this.readFromXML(in);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newType) {
        this.type = newType;
    }

    public Type getIncrementType() {
        return this.incrementType;
    }

    public void setIncrementType(Type newIncrementType) {
        this.incrementType = newIncrementType;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float newValue) {
        this.value = newValue;
    }

    public float getIncrement() {
        return this.increment;
    }

    public void setIncrement(float newIncrement, Type type, Turn firstTurn, Turn lastTurn) {
        if (firstTurn == null) {
            throw new IllegalArgumentException("Parameter firstTurn must not be 'null'.");
        }
        this.increment = newIncrement;
        this.incrementType = type;
        this.setFirstTurn(firstTurn);
        this.setLastTurn(lastTurn);
    }

    public boolean hasIncrement() {
        return this.incrementType != null;
    }

    public float applyTo(float number) {
        switch (this.type) {
            case ADDITIVE: {
                return number + this.value;
            }
            case MULTIPLICATIVE: {
                return number * this.value;
            }
            case PERCENTAGE: {
                return number + number * this.value / 100.0f;
            }
        }
        return number;
    }

    public static Modifier createTeaPartyModifier(Turn turn) {
        Modifier bellsBonus = new Modifier("model.goods.bells", COLONY_GOODS_PARTY, 50.0f, Type.PERCENTAGE);
        bellsBonus.setIncrement(-2.0f, Type.ADDITIVE, turn, new Turn(turn.getNumber() + 25));
        return bellsBonus;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(Modifier.getXMLElementTagName());
        this.writeAttributes(out);
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "modifier";
    }

    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        this.setType(Enum.valueOf(Type.class, in.getAttributeValue(null, "type").toUpperCase()));
        this.value = Float.parseFloat(in.getAttributeValue(null, "value"));
        String incrementString = in.getAttributeValue(null, "incrementType");
        if (incrementString != null) {
            this.setType(Enum.valueOf(Type.class, incrementString.toUpperCase()));
            this.increment = Float.parseFloat(in.getAttributeValue(null, "increment"));
        }
    }

    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", String.valueOf(this.value));
        out.writeAttribute("type", this.type.toString());
        if (this.incrementType != null) {
            out.writeAttribute("incrementType", this.incrementType.toString());
            out.writeAttribute("increment", String.valueOf(this.increment));
        }
    }

    public String toString() {
        return this.getId() + (this.getSource() == null ? " " : " (" + this.getSource().getId() + ") ") + (Object)((Object)this.type) + " " + this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADDITIVE,
        MULTIPLICATIVE,
        PERCENTAGE;

    }
}

