/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Monarch
extends FreeColGameObject {
    private String name;
    private Player player;
    private static final Logger logger = Logger.getLogger(Monarch.class.getName());
    private static final EquipmentType muskets = FreeCol.getSpecification().getEquipmentType("model.equipment.muskets");
    private static final EquipmentType horses = FreeCol.getSpecification().getEquipmentType("model.equipment.horses");
    int spaceRequired;
    int capacity;
    private List<AbstractUnit> landUnits = new ArrayList<AbstractUnit>();
    private List<AbstractUnit> navalUnits = new ArrayList<AbstractUnit>();
    public static final int MINIMUM_PRICE = 100;
    public static final int MAXIMUM_TAX_RATE = 75;
    public static final int MINIMUM_TAX_RATE = 20;
    private boolean supportSea = false;

    public Monarch(Game game, Player player, String name) {
        super(game);
        if (player == null) {
            throw new IllegalStateException("player == null");
        }
        this.player = player;
        this.name = name;
        int number = game.getGameOptions().getInteger("model.option.difficulty") * 2 + 3;
        for (UnitType unitType : FreeCol.getSpecification().getUnitTypeList()) {
            if (!unitType.hasAbility("model.ability.refUnit")) continue;
            if (unitType.hasAbility("model.ability.navalUnit")) {
                this.navalUnits.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, number));
                if (!unitType.canCarryUnits()) continue;
                this.capacity += unitType.getSpace() * number;
                continue;
            }
            if (unitType.hasAbility("model.ability.canBeEquipped")) {
                this.landUnits.add(new AbstractUnit(unitType, Unit.Role.SOLDIER, number));
                this.landUnits.add(new AbstractUnit(unitType, Unit.Role.DRAGOON, number));
                this.spaceRequired += unitType.getSpaceTaken() * 2 * number;
                continue;
            }
            this.landUnits.add(new AbstractUnit(unitType, Unit.Role.DEFAULT, number));
            this.spaceRequired += unitType.getSpaceTaken() * number;
        }
    }

    public Monarch(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Monarch(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Monarch(Game game, String id) {
        super(game, id);
    }

    public MonarchAction getAction() {
        List choices = this.getActionChoices();
        if (choices == null) {
            return MonarchAction.NO_ACTION;
        }
        return (MonarchAction)((Object)RandomChoice.getWeightedRandom(this.getGame().getModelController().getPseudoRandom(), choices));
    }

    public List<RandomChoice<MonarchAction>> getActionChoices() {
        int grace;
        int dx = this.getGame().getGameOptions().getInteger("model.option.difficulty") + 1;
        int turn = this.getGame().getTurn().getNumber();
        if (turn < (grace = (6 - dx) * 10) || this.player.getPlayerType() != Player.PlayerType.COLONIAL) {
            return null;
        }
        boolean canDeclareWar = false;
        boolean atWar = false;
        if (!this.player.hasAbility("model.ability.ignoreEuropeanWars")) {
            for (Player enemy : this.getGame().getPlayers()) {
                if (!enemy.isEuropean() || enemy.isREF() || !this.player.hasContacted(enemy)) continue;
                switch (this.player.getStance(enemy)) {
                    case WAR: {
                        atWar = true;
                        break;
                    }
                    case PEACE: 
                    case CEASE_FIRE: {
                        canDeclareWar = true;
                        break;
                    }
                }
            }
        }
        ArrayList<RandomChoice<MonarchAction>> choices = new ArrayList<RandomChoice<MonarchAction>>();
        choices.add(new RandomChoice<MonarchAction>(MonarchAction.NO_ACTION, Math.max(200 - turn, 100)));
        if (this.player.getTax() < 75) {
            choices.add(new RandomChoice<MonarchAction>(MonarchAction.RAISE_TAX, 10 + dx));
        }
        choices.add(new RandomChoice<MonarchAction>(MonarchAction.ADD_TO_REF, 10 + dx));
        if (canDeclareWar) {
            choices.add(new RandomChoice<MonarchAction>(MonarchAction.DECLARE_WAR, 5 + dx));
        }
        if (this.player.hasBeenAttackedByPrivateers() && !this.supportSea) {
            choices.add(new RandomChoice<MonarchAction>(MonarchAction.SUPPORT_SEA, 6 - dx));
        }
        if (atWar && this.player.getGold() > 100) {
            choices.add(new RandomChoice<MonarchAction>(MonarchAction.OFFER_MERCENARIES, 6 - dx));
        }
        if (this.player.getTax() > 30) {
            choices.add(new RandomChoice<MonarchAction>(MonarchAction.LOWER_TAX, 10 - dx));
        }
        return choices;
    }

    public List<AbstractUnit> getREF() {
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>(this.landUnits);
        result.addAll(this.navalUnits);
        return result;
    }

    public List<AbstractUnit> getNavalUnits() {
        return this.navalUnits;
    }

    public List<AbstractUnit> getLandUnits() {
        return this.landUnits;
    }

    public int getNewTax(MonarchAction taxChange) {
        int newTax = 110;
        int adjustment = 0;
        switch (taxChange) {
            case RAISE_TAX: {
                int turn = this.getGame().getTurn().getNumber();
                adjustment = (6 - this.player.getDifficulty().getIndex()) * 10;
                int increase = this.getGame().getModelController().getPseudoRandom().nextInt(5 + turn / adjustment) + 1;
                newTax = this.player.getTax() + increase;
                newTax = Math.min(newTax, 75);
                break;
            }
            case LOWER_TAX: {
                adjustment = 10 - this.player.getDifficulty().getIndex();
                int decrease = this.getGame().getModelController().getPseudoRandom().nextInt(adjustment) + 1;
                newTax = this.player.getTax() - decrease;
                newTax = Math.max(newTax, 20);
                break;
            }
            default: {
                logger.warning("Wrong tax change type");
                return newTax;
            }
        }
        return newTax;
    }

    public List<AbstractUnit> getMercenaries() {
        ArrayList<AbstractUnit> mercenaries = new ArrayList<AbstractUnit>();
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (UnitType unitType : FreeCol.getSpecification().getUnitTypeList()) {
            if (!unitType.hasAbility("model.ability.mercenaryUnit")) continue;
            unitTypes.add(unitType);
        }
        int gold = this.player.getGold();
        int price = 0;
        int limit = unitTypes.size();
        FreeColGameObjectType unitType = null;
        for (int count = 0; count < limit; ++count) {
            int number;
            int newPrice;
            int index = this.getGame().getModelController().getPseudoRandom().nextInt(unitTypes.size());
            unitType = (UnitType)unitTypes.get(index);
            if (unitType.hasAbility("model.ability.canBeEquipped")) {
                newPrice = this.getPrice((UnitType)unitType, Unit.Role.DRAGOON);
                for (number = 3; number > 0; --number) {
                    if (price + newPrice * number > gold) continue;
                    mercenaries.add(new AbstractUnit((UnitType)unitType, Unit.Role.DRAGOON, number));
                    price += newPrice * number;
                    break;
                }
                newPrice = this.getPrice((UnitType)unitType, Unit.Role.SOLDIER);
                for (number = 3; number > 0; --number) {
                    if (price + newPrice * number > gold) continue;
                    mercenaries.add(new AbstractUnit((UnitType)unitType, Unit.Role.SOLDIER, number));
                    price += newPrice * number;
                    break;
                }
            } else {
                newPrice = this.getPrice((UnitType)unitType, Unit.Role.DEFAULT);
                for (number = 3; number > 0; --number) {
                    if (price + newPrice * number > gold) continue;
                    mercenaries.add(new AbstractUnit((UnitType)unitType, Unit.Role.DEFAULT, number));
                    price += newPrice * number;
                    break;
                }
            }
            unitTypes.remove(index);
        }
        if (price == 0 && unitType != null) {
            if (unitType.hasAbility("model.ability.canBeEquipped")) {
                mercenaries.add(new AbstractUnit((UnitType)unitType, Unit.Role.SOLDIER, 1));
            } else {
                mercenaries.add(new AbstractUnit((UnitType)unitType, Unit.Role.DEFAULT, 1));
            }
        }
        return mercenaries;
    }

    public List<AbstractUnit> addToREF() {
        ArrayList<AbstractUnit> result = new ArrayList<AbstractUnit>();
        if (this.capacity < this.spaceRequired) {
            AbstractUnit unit = this.navalUnits.get(this.getGame().getModelController().getPseudoRandom().nextInt(this.navalUnits.size()));
            result.add(new AbstractUnit(unit.getUnitType(), unit.getRole(), 1));
        } else {
            int number = this.getGame().getModelController().getPseudoRandom().nextInt(3) + 1;
            AbstractUnit unit = this.landUnits.get(this.getGame().getModelController().getPseudoRandom().nextInt(this.landUnits.size()));
            result.add(new AbstractUnit(unit.getUnitType(), unit.getRole(), number));
        }
        return result;
    }

    public void addToREF(List<AbstractUnit> units) {
        for (AbstractUnit unitToAdd : units) {
            UnitType unitType = unitToAdd.getUnitType();
            if (unitType.hasAbility("model.ability.navalUnit")) {
                for (AbstractUnit refUnit : this.navalUnits) {
                    if (!refUnit.getUnitType().equals(unitType)) continue;
                    refUnit.setNumber(refUnit.getNumber() + unitToAdd.getNumber());
                    if (!unitType.canCarryUnits()) continue;
                    this.capacity += unitType.getSpace() * unitToAdd.getNumber();
                }
                continue;
            }
            for (AbstractUnit refUnit : this.landUnits) {
                if (!refUnit.getUnitType().equals(unitType) || !refUnit.getRole().equals((Object)unitToAdd.getRole())) continue;
                refUnit.setNumber(refUnit.getNumber() + unitToAdd.getNumber());
                this.spaceRequired += unitType.getSpaceTaken() * unitToAdd.getNumber();
            }
        }
    }

    public int getPrice(List<AbstractUnit> units, boolean rebate) {
        int price = 0;
        for (AbstractUnit unit : units) {
            int newPrice = this.getPrice(unit.getUnitType(), unit.getRole());
            price += newPrice * unit.getNumber();
        }
        if (price > this.player.getGold() && rebate) {
            return this.player.getGold();
        }
        return price;
    }

    public int getPrice(UnitType unitType, Unit.Role role) {
        if (unitType.hasPrice()) {
            int price = this.player.getEurope().getUnitPrice(unitType);
            if (Unit.Role.SOLDIER.equals((Object)role)) {
                price += this.getEquipmentPrice(muskets);
            } else if (Unit.Role.DRAGOON.equals((Object)role)) {
                price += this.getEquipmentPrice(muskets);
                price += this.getEquipmentPrice(horses);
            }
            return price / 10 + 25 * this.player.getDifficulty().getIndex();
        }
        return 1000000;
    }

    private int getEquipmentPrice(EquipmentType equipment) {
        int price = 0;
        for (AbstractGoods goods : equipment.getGoodsRequired()) {
            price += this.player.getMarket().getBidPrice(goods.getType(), goods.getAmount());
        }
        return price;
    }

    public Player declareWar() {
        ArrayList<Player> europeanPlayers = new ArrayList<Player>();
        for (Player enemy : this.getGame().getPlayers()) {
            Player.Stance stance;
            if (enemy == this.player || !this.player.hasContacted(enemy) || !enemy.isEuropean() || enemy.isREF() || (stance = this.player.getStance(enemy)) != Player.Stance.PEACE && stance != Player.Stance.CEASE_FIRE) continue;
            europeanPlayers.add(enemy);
        }
        if (europeanPlayers.size() > 0) {
            Player enemy;
            int randomInt = this.getGame().getModelController().getPseudoRandom().nextInt(europeanPlayers.size());
            enemy = (Player)europeanPlayers.get(randomInt);
            return enemy;
        }
        return null;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Monarch.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("player", this.player.getId());
        out.writeAttribute("name", this.name);
        out.writeAttribute("supportSea", String.valueOf(this.supportSea));
        out.writeStartElement("navalUnits");
        for (AbstractUnit unit : this.navalUnits) {
            unit.toXMLImpl(out);
        }
        out.writeEndElement();
        out.writeStartElement("landUnits");
        for (AbstractUnit unit : this.landUnits) {
            unit.toXMLImpl(out);
        }
        out.writeEndElement();
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
        if (this.player == null) {
            this.player = new Player(this.getGame(), in.getAttributeValue(null, "player"));
        }
        this.name = in.getAttributeValue(null, "name");
        this.supportSea = Boolean.valueOf(in.getAttributeValue(null, "supportSea"));
        while (in.nextTag() != 2) {
            AbstractUnit newUnit;
            String childName = in.getLocalName();
            if ("navalUnits".equals(childName)) {
                while (in.nextTag() != 2) {
                    newUnit = new AbstractUnit(in);
                    this.navalUnits.add(newUnit);
                }
                continue;
            }
            if (!"landUnits".equals(childName)) continue;
            while (in.nextTag() != 2) {
                newUnit = new AbstractUnit(in);
                this.landUnits.add(newUnit);
            }
        }
        if (!in.getLocalName().equals(Monarch.getXMLElementTagName())) {
            logger.warning("Error parsing xml: expecting closing tag </" + Monarch.getXMLElementTagName() + "> " + "found instead: " + in.getLocalName());
        }
    }

    public static String getXMLElementTagName() {
        return "monarch";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonarchAction {
        NO_ACTION,
        RAISE_TAX,
        ADD_TO_REF,
        DECLARE_WAR,
        SUPPORT_SEA,
        SUPPORT_LAND,
        OFFER_MERCENARIES,
        LOWER_TAX,
        WAIVE_TAX,
        ADD_UNITS;

    }
}

