/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DifficultyLevel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Player
extends FreeColGameObject
implements Nameable {
    private static final Logger logger = Logger.getLogger(Player.class.getName());
    public static final int SCORE_SETTLEMENT_DESTROYED = -40;
    public static final int SCORE_INDEPENDENCE_DECLARED = 100;
    public static final int SCORE_INDEPENDENCE_GRANTED = 1000;
    private static final String FOUNDING_FATHER_TAG = "foundingFathers";
    private static final String STANCE_TAG = "stance";
    private static final String TENSION_TAG = "tension";
    private int index;
    private java.util.Map<Player, Tension> tension = new HashMap<Player, Tension>();
    private java.util.Map<String, Stance> stance = new HashMap<String, Stance>();
    private static final Color noNationColor = Color.BLACK;
    private String name;
    public static final String UNKNOWN_ENEMY = "unknown enemy";
    private NationType nationType;
    private String nationID;
    private String newLandName = null;
    private Color color = Color.BLACK;
    private boolean admin;
    private int score;
    private int gold;
    private int numberOfSettlements;
    private Market market;
    private Europe europe;
    private Monarch monarch;
    private boolean ready;
    private boolean ai;
    private boolean attackedByPrivateers = false;
    private int oldSoL;
    private int crosses;
    private int bells;
    private boolean dead = false;
    private final Set<FoundingFather> allFathers = new HashSet<FoundingFather>();
    private FoundingFather currentFather;
    private int tax = 0;
    private PlayerType playerType;
    private int crossesRequired = 12;
    private int colonyNameIndex = 0;
    private EnumMap<Region.RegionType, Integer> regionNameIndex = new EnumMap(Region.RegionType.class);
    private Location entryLocation;
    private final java.util.Map<String, Unit> units = new HashMap<String, Unit>();
    private final Iterator<Unit> nextActiveUnitIterator = new UnitIterator(this, new ActivePredicate());
    private final Iterator<Unit> nextGoingToUnitIterator = new UnitIterator(this, new GoingToPredicate());
    private final List<Settlement> settlements = new ArrayList<Settlement>();
    private List<TradeRoute> tradeRoutes = new ArrayList<TradeRoute>();
    private final List<ModelMessage> modelMessages = new ArrayList<ModelMessage>();
    protected boolean[][] canSeeTiles = null;
    private FeatureContainer featureContainer = new FeatureContainer();
    private String independentNationName;
    private List<HistoryEvent> history = new ArrayList<HistoryEvent>();

    protected Player() {
    }

    public Player(Game game, String name, boolean admin, boolean ai, Nation nation) {
        this(game, name, admin, nation);
        this.ai = ai;
    }

    public Player(Game game, String name, boolean admin) {
        this(game, name, admin, game.getVacantNation());
    }

    public Player(Game game, String name, boolean admin, Nation newNation) {
        super(game);
        this.name = name;
        this.admin = admin;
        if (newNation != null && newNation.getType() != null) {
            this.nationType = newNation.getType();
            this.color = newNation.getColor();
            this.nationID = newNation.getId();
            try {
                this.featureContainer.add(this.nationType.getFeatureContainer());
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
            if (this.nationType.isEuropean()) {
                this.gold = 0;
                this.europe = new Europe(game, this);
                if (!this.nationType.isREF()) {
                    this.monarch = new Monarch(game, this, "");
                    this.playerType = PlayerType.COLONIAL;
                } else {
                    this.playerType = PlayerType.ROYAL;
                }
            } else {
                this.gold = 1500;
                this.playerType = PlayerType.NATIVE;
            }
        } else {
            this.nationID = "model.nation.unknownEnemy";
            this.color = noNationColor;
            this.playerType = PlayerType.COLONIAL;
        }
        this.market = new Market(this.getGame(), this);
        this.crosses = 0;
        this.bells = 0;
        this.currentFather = null;
    }

    public Player(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Player(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Player(Game game, String id) {
        super(game, id);
    }

    public int getIndex() {
        return this.index;
    }

    public final FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    public final void setFeatureContainer(FeatureContainer newFeatureContainer) {
        this.featureContainer = newFeatureContainer;
    }

    public boolean hasAbility(String id) {
        return this.featureContainer.hasAbility(id);
    }

    @Override
    public void addModelMessage(ModelMessage modelMessage) {
        this.modelMessages.add(modelMessage);
    }

    public List<ModelMessage> getModelMessages() {
        return this.modelMessages;
    }

    public List<ModelMessage> getNewModelMessages() {
        ArrayList<ModelMessage> out = new ArrayList<ModelMessage>();
        for (ModelMessage message : this.modelMessages) {
            if (message.hasBeenDisplayed()) continue;
            out.add(message);
        }
        return out;
    }

    public void removeModelMessages() {
        Iterator<ModelMessage> messageIterator = this.modelMessages.iterator();
        while (messageIterator.hasNext()) {
            ModelMessage message = messageIterator.next();
            if (!message.hasBeenDisplayed()) continue;
            messageIterator.remove();
        }
    }

    public void clearModelMessages() {
        this.modelMessages.clear();
    }

    public void divertModelMessages(FreeColGameObject source, FreeColGameObject newSource) {
        ArrayList<ModelMessage> modelMessagesList = new ArrayList<ModelMessage>();
        modelMessagesList.addAll(this.modelMessages);
        for (ModelMessage modelMessage : modelMessagesList) {
            if (modelMessage.getSource() != source) continue;
            if (newSource == null) {
                this.modelMessages.remove(modelMessage);
                continue;
            }
            modelMessage.setSource(newSource);
            if (modelMessage.getDisplay() != source) continue;
            modelMessage.setDisplay(newSource);
        }
    }

    public int getScore() {
        return this.score;
    }

    public void modifyScore(int value) {
        this.score += value;
    }

    public Market getMarket() {
        return this.market;
    }

    public void reinitialiseMarket() {
        this.market = new Market(this.getGame(), this);
    }

    public boolean hasSettlement(Settlement s) {
        return this.settlements.contains(s);
    }

    public void addSettlement(Settlement s) {
        if (!this.settlements.contains(s)) {
            this.settlements.add(s);
            if (s.getOwner() != this) {
                s.setOwner(this);
            }
        }
    }

    public void removeSettlement(Settlement s) {
        if (this.settlements.contains(s)) {
            if (s.getOwner() == this) {
                throw new IllegalStateException("Cannot remove the ownership of the given settlement before it has been given to another player.");
            }
            this.settlements.remove(s);
        }
    }

    public int getNumberOfSettlements() {
        return this.numberOfSettlements;
    }

    public void setNumberOfSettlements(int number) {
        this.numberOfSettlements = number;
    }

    public List<Settlement> getSettlements() {
        return this.settlements;
    }

    public List<Colony> getColonies() {
        ArrayList<Colony> colonies = new ArrayList<Colony>();
        for (Settlement s : this.settlements) {
            if (s instanceof Colony) {
                colonies.add((Colony)s);
                continue;
            }
            throw new RuntimeException("getColonies can only be called for players whose settlements are colonies.");
        }
        return colonies;
    }

    public List<IndianSettlement> getIndianSettlements() {
        ArrayList<IndianSettlement> indianSettlements = new ArrayList<IndianSettlement>();
        for (Settlement s : this.settlements) {
            if (s instanceof IndianSettlement) {
                indianSettlements.add((IndianSettlement)s);
                continue;
            }
            throw new RuntimeException("getIndianSettlements can only be called for players whose settlements are IndianSettlements.");
        }
        return indianSettlements;
    }

    public Colony getColony(String name) {
        for (Colony colony : this.getColonies()) {
            if (!colony.getName().equals(name)) continue;
            return colony;
        }
        return null;
    }

    public PlayerType getPlayerType() {
        return this.playerType;
    }

    public void setPlayerType(PlayerType type) {
        this.playerType = type;
    }

    public boolean isEuropean() {
        return this.nationType != null && this.nationType.isEuropean();
    }

    public boolean isIndian() {
        return this.playerType == PlayerType.NATIVE;
    }

    public boolean isREF() {
        return this.nationType != null && this.nationType.isREF();
    }

    public boolean isAI() {
        return this.ai;
    }

    public void setAI(boolean ai) {
        this.ai = ai;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public static boolean checkForDeath(Player player) {
        if (player.isREF()) {
            return false;
        }
        if (!player.getSettlements().isEmpty()) {
            return false;
        }
        boolean hasCarrier = false;
        List<Unit> unitList = player.getUnits();
        for (Unit unit : unitList) {
            Unit carrier;
            boolean isValidUnit = false;
            if (unit.isCarrier()) {
                hasCarrier = true;
                logger.info("Still has carrier");
                continue;
            }
            if (unit.isColonist()) {
                isValidUnit = true;
            }
            if (unit.isOffensiveUnit()) {
                isValidUnit = true;
            }
            if (!isValidUnit) continue;
            Location unitLocation = unit.getLocation();
            if (unitLocation instanceof Tile) {
                logger.info("Found colonist in new world");
                return false;
            }
            if (!unit.isOnCarrier() || !((carrier = (Unit)unitLocation).getLocation() instanceof Tile)) continue;
            logger.info("Found colonist aboard carrier in new world");
            return false;
        }
        if (!player.isEuropean() || player.getEurope() == null) {
            return true;
        }
        if (player.getGame().getTurn().getYear() >= 1600) {
            logger.info("No presence in new world after 1600");
            return true;
        }
        int goldNeeded = 0;
        if (!hasCarrier) {
            Iterator<UnitType> navalUnits = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.navalUnit").iterator();
            int lowerPrice = Integer.MAX_VALUE;
            while (navalUnits.hasNext()) {
                UnitType unit = navalUnits.next();
                int unitPrice = player.getEurope().getUnitPrice(unit);
                if (unitPrice == Integer.MIN_VALUE || unitPrice >= lowerPrice) continue;
                lowerPrice = unitPrice;
            }
            if (lowerPrice == Integer.MAX_VALUE) {
                logger.warning("Couldnt find naval unit to buy");
                return true;
            }
            if ((goldNeeded += lowerPrice) > player.getGold()) {
                logger.info("Does not have enough money to buy carrier");
                return true;
            }
            logger.info("Has enough money to buy carrier, has=" + player.getGold() + ", needs=" + lowerPrice);
        }
        Iterator<Unit> unitIterator = player.getEurope().getUnitIterator();
        while (unitIterator.hasNext()) {
            Unit unit = unitIterator.next();
            if (unit.isCarrier()) {
                for (Unit u : unit.getUnitList()) {
                    if (!u.isColonist()) continue;
                    return false;
                }
                if (unit.getGoodsCount() <= 0) continue;
                logger.info("Has goods to sell");
                return false;
            }
            if (!unit.isColonist()) continue;
            logger.info("Has colonist unit waiting in port");
            return false;
        }
        int goldToRecruit = player.getEurope().getRecruitPrice();
        Iterator<UnitType> trainedUnits = FreeCol.getSpecification().getUnitTypesTrainedInEurope().iterator();
        int goldToTrain = Integer.MAX_VALUE;
        while (trainedUnits.hasNext()) {
            int unitPrice;
            UnitType unit = trainedUnits.next();
            if (!unit.hasAbility("model.ability.foundColony") || (unitPrice = player.getEurope().getUnitPrice(unit)) == Integer.MIN_VALUE || unitPrice >= goldToTrain) continue;
            goldToTrain = unitPrice;
        }
        if ((goldNeeded += Math.min(goldToTrain, goldToRecruit)) > player.getGold()) {
            logger.info("Does not have enough money for recruiting or training");
            return true;
        }
        return false;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
    }

    public boolean isAtWar() {
        for (Player player : this.getGame().getPlayers()) {
            if (this.getStance(player) != Stance.WAR) continue;
            return true;
        }
        return false;
    }

    public List<Player> getDominionsAtWar() {
        LinkedList<Player> dominions = new LinkedList<Player>();
        Iterator<Player> it = this.getGame().getPlayerIterator();
        while (it.hasNext()) {
            Player p = it.next();
            if (p.getREFPlayer() != this || p.getPlayerType() != PlayerType.REBEL || p.getMonarch() != null) continue;
            dominions.add(p);
        }
        return dominions;
    }

    public final Unit getUnit(String id) {
        return this.units.get(id);
    }

    public final void setUnit(Unit newUnit) {
        if (newUnit == null) {
            logger.warning("Unit to add is null");
            return;
        }
        if (newUnit.getOwner() != null && newUnit.getOwner() != this) {
            throw new IllegalStateException(this + " adding another players unit=" + newUnit);
        }
        this.units.put(newUnit.getId(), newUnit);
    }

    public void removeUnit(Unit oldUnit) {
        if (oldUnit != null) {
            this.units.remove(oldUnit.getId());
        }
    }

    public int getSoL() {
        int sum = 0;
        int number = 0;
        for (Colony c : this.getColonies()) {
            sum += c.getSoL();
            ++number;
        }
        if (number > 0) {
            return sum / number;
        }
        return 0;
    }

    public final String getIndependentNationName() {
        return this.independentNationName;
    }

    public final void setIndependentNationName(String newIndependentNationName) {
        this.independentNationName = newIndependentNationName;
    }

    public void declareIndependence() {
        if (this.getSoL() < 50) {
            throw new IllegalStateException("Cannot declare independence. SoL is only: " + this.getSoL());
        }
        if (this.playerType != PlayerType.COLONIAL) {
            throw new IllegalStateException("Independence has already been declared.");
        }
        this.setPlayerType(PlayerType.REBEL);
        this.featureContainer.addAbility(new Ability("model.ability.independenceDeclared"));
        this.changeRelationWithPlayer(this.getREFPlayer(), Stance.WAR);
        this.setTax(0);
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            this.resetArrears(goodsType);
        }
        ArrayList<String> unitNames = new ArrayList<String>();
        for (Unit unit : this.europe.getUnitList()) {
            unitNames.add(unit.getName());
        }
        this.europe.disposeUnitList();
        if (!unitNames.isEmpty()) {
            this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.UNIT_LOST, "model.player.independence.unitsSeized", "%units%", Utils.join(", ", unitNames));
        }
        for (Colony colony : this.getColonies()) {
            int sol = colony.getSoL();
            if (sol <= 50) continue;
            ArrayList<Unit> veterans = new ArrayList<Unit>();
            for (Unit unit : colony.getTile().getUnitList()) {
                if (!unit.hasAbility("model.ability.expertSoldier")) continue;
                veterans.add(unit);
            }
            int limit = (veterans.size() + 2) * (sol - 50) / 100;
            if (limit <= 0) continue;
            for (int index = 0; index < limit && limit < veterans.size(); ++index) {
                Unit unit = (Unit)veterans.get(index);
                unit.setType(unit.getType().getPromotion());
            }
            this.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.DEFAULT, "model.player.continentalArmyMuster", "%colony%", colony.getName(), "%number%", String.valueOf(limit));
        }
        this.divertModelMessages(this.europe, null);
        this.europe.dispose();
        this.europe = null;
        this.monarch = null;
        this.modifyScore(100);
        this.history.add(new HistoryEvent(this.getGame().getTurn().getNumber(), HistoryEvent.Type.DECLARE_INDEPENDENCE, new String[0]));
    }

    public void giveIndependence() {
        if (!this.isEuropean()) {
            throw new IllegalStateException("The player \"" + this.getName() + "\" is not European.");
        }
        if (this.playerType != PlayerType.REBEL) {
            throw new IllegalStateException("The player \"" + this.getName() + "\" is not a Rebel.");
        }
        this.setPlayerType(PlayerType.INDEPENDENT);
        this.changeRelationWithPlayer(this.getREFPlayer(), Stance.PEACE);
        this.modifyScore(1000 - this.getGame().getTurn().getNumber());
        this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.DEFAULT, "model.player.independence", new String[0]);
        this.history.add(new HistoryEvent(this.getGame().getTurn().getNumber(), HistoryEvent.Type.INDEPENDENCE, new String[0]));
    }

    public Player getREFPlayer() {
        return this.getGame().getPlayer(this.getNation().getRefId());
    }

    public String getNewLandName() {
        if (this.newLandName == null) {
            return Messages.message(this.nationID + ".newLandName", new String[0]);
        }
        return this.newLandName;
    }

    public boolean isNewLandNamed() {
        return this.newLandName != null;
    }

    public String getDefaultColonyName() {
        String name;
        String prefix = this.nationID + ".newColonyName.";
        while (Messages.containsKey(prefix + Integer.toString(this.colonyNameIndex))) {
            name = Messages.message(prefix + Integer.toString(this.colonyNameIndex), new String[0]);
            ++this.colonyNameIndex;
            if (this.getGame().getColony(name) != null) continue;
            return name;
        }
        do {
            name = Messages.message("Colony", new String[0]) + this.colonyNameIndex;
            ++this.colonyNameIndex;
        } while (this.getColony(name) != null);
        return name;
    }

    public String getDefaultRegionName(Region.RegionType regionType) {
        String prefix = this.nationID + ".region." + regionType.toString().toLowerCase() + ".";
        String name = null;
        int index = 1;
        Integer newIndex = this.regionNameIndex.get((Object)regionType);
        if (newIndex != null) {
            index = newIndex;
        }
        do {
            name = null;
            if (!Messages.containsKey(prefix + Integer.toString(index))) continue;
            name = Messages.message(prefix + Integer.toString(index), new String[0]);
            ++index;
        } while (name != null && this.getGame().getMap().getRegionByName(name) != null);
        if (name == null) {
            do {
                String type = Messages.message("model.region." + regionType.toString().toLowerCase() + ".name", new String[0]);
                name = Messages.message("model.region.default", "%nation%", this.getNationAsString(), "%type%", type, "%index%", Integer.toString(index));
                ++index;
            } while (this.getGame().getMap().getRegionByName(name) != null);
        }
        this.regionNameIndex.put(regionType, index);
        return name;
    }

    public void setNewLandName(String newLandName) {
        this.newLandName = newLandName;
    }

    public int getLandPrice(Tile tile) {
        Player nationOwner = tile.getOwner();
        if (nationOwner == null || nationOwner == this || nationOwner.isEuropean() || tile.getSettlement() != null) {
            return 0;
        }
        int price = 0;
        for (GoodsType type : FreeCol.getSpecification().getGoodsTypeList()) {
            price += tile.potential(type, null);
        }
        price = price * Specification.getSpecification().getIntegerOption("model.option.landPriceFactor").getValue() + 100;
        return (int)this.featureContainer.applyModifier(price, "model.modifier.landPaymentModifier", null, this.getGame().getTurn());
    }

    public void buyLand(Tile tile) {
        Player owner = tile.getOwner();
        if (owner == null) {
            throw new IllegalStateException("The Tile is not owned by any nation!");
        }
        if (owner == this) {
            throw new IllegalStateException("The Player already owns the Tile.");
        }
        if (owner.isEuropean()) {
            throw new IllegalStateException("The owner is an european player");
        }
        int price = this.getLandPrice(tile);
        this.modifyGold(-price);
        owner.modifyGold(price);
        tile.setOwner(this);
        tile.setOwningSettlement(null);
    }

    public boolean hasContacted(Player player) {
        if (player == null) {
            return true;
        }
        return this.stance.containsKey(player.getId());
    }

    public void setContacted(Player player, boolean contacted) {
        if (player == null || player == this || player == this.getGame().getUnknownEnemy()) {
            return;
        }
        if (contacted && !this.hasContacted(player)) {
            this.stance.put(player.getId(), Stance.PEACE);
            this.history.add(new HistoryEvent(this.getGame().getTurn().getNumber(), HistoryEvent.Type.MEET_NATION, "%nation%", player.getNationAsString()));
            if (this.isEuropean() && !this.isAI()) {
                boolean contactedIndians = false;
                boolean contactedEuro = false;
                for (Player player1 : this.getGame().getPlayers()) {
                    if (!this.hasContacted(player1)) continue;
                    if (player1.isEuropean()) {
                        contactedEuro = true;
                        if (!contactedIndians) continue;
                        break;
                    }
                    contactedIndians = true;
                    if (!contactedEuro) continue;
                    break;
                }
                if (player.isEuropean()) {
                    if (!contactedEuro) {
                        this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.FOREIGN_DIPLOMACY, player, "EventPanel.MEETING_EUROPEANS", new String[0]);
                    }
                } else {
                    if (!contactedIndians) {
                        this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.FOREIGN_DIPLOMACY, player, "EventPanel.MEETING_NATIVES", new String[0]);
                    }
                    if (player.getNationType() == FreeCol.getSpecification().getNationType("model.nationType.aztec")) {
                        this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.FOREIGN_DIPLOMACY, player, "EventPanel.MEETING_AZTEC", new String[0]);
                    } else if (player.getNationType() == FreeCol.getSpecification().getNationType("model.nationType.inca")) {
                        this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.FOREIGN_DIPLOMACY, player, "EventPanel.MEETING_INCA", new String[0]);
                    }
                }
            } else if (!this.isEuropean()) {
                this.tension.put(player, new Tension(0));
            }
        }
        if (!contacted) {
            this.stance.remove(player.getId());
        }
    }

    public boolean hasBeenAttackedByPrivateers() {
        return this.attackedByPrivateers;
    }

    public void setAttackedByPrivateers() {
        this.attackedByPrivateers = true;
    }

    public Location getEntryLocation() {
        return this.entryLocation;
    }

    public void setEntryLocation(Location entryLocation) {
        this.entryLocation = entryLocation;
    }

    public boolean hasExplored(Tile tile) {
        return tile.isExplored();
    }

    public void setExplored(Tile tile) {
        logger.warning("Implemented by ServerPlayer");
    }

    public void setExplored(Unit unit) {
        if (this.getGame() == null || this.getGame().getMap() == null || unit == null || unit.getLocation() == null || unit.getTile() == null || this.isIndian()) {
            return;
        }
        if (this.canSeeTiles == null) {
            this.resetCanSeeTiles();
        }
        Map.CircleIterator positionIterator = this.getGame().getMap().getCircleIterator(unit.getTile().getPosition(), true, unit.getLineOfSight());
        while (positionIterator.hasNext()) {
            Map.Position p = (Map.Position)positionIterator.next();
            this.canSeeTiles[p.getX()][p.getY()] = true;
        }
    }

    public void invalidateCanSeeTiles() {
        this.canSeeTiles = null;
    }

    public void resetCanSeeTiles() {
        block8: {
            Map map = this.getGame().getMap();
            if (map == null) break block8;
            this.canSeeTiles = new boolean[map.getWidth()][map.getHeight()];
            if (!this.getGameOptions().getBoolean("model.option.fogOfWar")) {
                Map.WholeMapIterator positionIterator = this.getGame().getMap().getWholeMapIterator();
                while (positionIterator.hasNext()) {
                    Map.Position p = (Map.Position)positionIterator.next();
                    Tile t = map.getTile(p);
                    if (t == null) continue;
                    this.canSeeTiles[p.getX()][p.getY()] = this.hasExplored(t);
                }
            } else {
                Iterator<Unit> unitIterator = this.getUnitIterator();
                while (unitIterator.hasNext()) {
                    Unit unit = unitIterator.next();
                    if (!(unit.getLocation() instanceof Tile)) continue;
                    Map.Position position = unit.getTile().getPosition();
                    if (position == null) {
                        logger.warning("position == null");
                    }
                    this.canSeeTiles[position.getX()][position.getY()] = true;
                    Map.CircleIterator positionIterator = map.getCircleIterator(position, true, unit.getLineOfSight());
                    while (positionIterator.hasNext()) {
                        Map.Position p = (Map.Position)positionIterator.next();
                        Tile t = map.getTile(p);
                        if (t == null || !this.hasExplored(t)) continue;
                        this.canSeeTiles[p.getX()][p.getY()] = true;
                    }
                }
                for (Settlement settlement : this.getSettlements()) {
                    Map.Position position = settlement.getTile().getPosition();
                    this.canSeeTiles[position.getX()][position.getY()] = true;
                    Map.CircleIterator positionIterator = map.getCircleIterator(position, true, settlement.getLineOfSight());
                    while (positionIterator.hasNext()) {
                        Map.Position p = (Map.Position)positionIterator.next();
                        Tile t = map.getTile(p);
                        if (t == null || !this.hasExplored(t)) continue;
                        this.canSeeTiles[p.getX()][p.getY()] = true;
                    }
                }
            }
        }
    }

    public boolean canSee(Tile tile) {
        if (tile == null) {
            return false;
        }
        if (this.canSeeTiles == null) {
            this.resetCanSeeTiles();
            if (this.canSeeTiles == null) {
                return false;
            }
        }
        return this.canSeeTiles[tile.getX()][tile.getY()];
    }

    public boolean canBuildColonies() {
        return this.nationType.hasAbility("model.ability.foundColony");
    }

    public boolean canHaveFoundingFathers() {
        return this.nationType.hasAbility("model.ability.electFoundingFather");
    }

    public boolean hasFather(FoundingFather someFather) {
        return this.allFathers.contains(someFather);
    }

    public int getFatherCount() {
        return this.allFathers.size();
    }

    public void setCurrentFather(FoundingFather someFather) {
        this.currentFather = someFather;
    }

    public FoundingFather getCurrentFather() {
        return this.currentFather;
    }

    public int getRemainingFoundingFatherCost() {
        return this.getTotalFoundingFatherCost() - this.getBells();
    }

    public int getTotalFoundingFatherCost() {
        return this.getFatherCount() * this.getFatherCount() * Specification.getSpecification().getIntegerOption("model.option.foundingFatherFactor").getValue() + 50;
    }

    public void addFather(FoundingFather father) {
        java.util.Map<UnitType, UnitType> upgrades;
        this.allFathers.add(father);
        this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.DEFAULT, "model.player.foundingFatherJoinedCongress", "%foundingFather%", father.getName(), "%description%", father.getDescription());
        this.history.add(new HistoryEvent(this.getGame().getTurn().getNumber(), HistoryEvent.Type.FOUNDING_FATHER, "%father%", father.getName()));
        this.featureContainer.add(father.getFeatureContainer());
        List<AbstractUnit> units = father.getUnits();
        if (units != null) {
            for (int index = 0; index < units.size(); ++index) {
                AbstractUnit unit = units.get(index);
                String uniqueID = this.getId() + "newTurn" + father.getId() + index;
                this.getGame().getModelController().createUnit(uniqueID, this.getEurope(), this, unit.getUnitType());
            }
        }
        if ((upgrades = father.getUpgrades()) != null) {
            Iterator<Unit> unitIterator = this.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit unit = unitIterator.next();
                UnitType newType = upgrades.get(unit.getType());
                if (newType == null) continue;
                unit.setType(newType);
            }
        }
        for (Ability ability : father.getFeatureContainer().getAbilities()) {
            if (!"model.ability.addTaxToBells".equals(ability.getId())) continue;
            this.updateAddTaxToBells();
        }
        for (String event : father.getEvents().keySet()) {
            if (event.equals("model.event.resetNativeAlarm")) {
                for (Player player : this.getGame().getPlayers()) {
                    if (player.isEuropean() || player.getTension(this) == null) continue;
                    player.getTension(this).setValue(0);
                    for (IndianSettlement is : player.getIndianSettlements()) {
                        if (is.getAlarm(this) == null) continue;
                        is.getAlarm(this).setValue(0);
                    }
                }
                continue;
            }
            if (event.equals("model.event.boycottsLifted")) {
                for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
                    this.resetArrears(goodsType);
                }
                continue;
            }
            if (event.equals("model.event.freeBuilding")) {
                BuildingType type = FreeCol.getSpecification().getBuildingType(father.getEvents().get(event));
                for (Colony colony : this.getColonies()) {
                    if (!colony.canBuild(type)) continue;
                    String taskIDplus = colony.getId() + "buildBuilding" + father.getId();
                    Building building = this.getGame().getModelController().createBuilding(taskIDplus, colony, type);
                    colony.addBuilding(building);
                }
                continue;
            }
            if (event.equals("model.event.seeAllColonies")) {
                this.exploreAllColonies();
                continue;
            }
            if (event.equals("model.event.increaseSonsOfLiberty")) {
                int value = Integer.parseInt(father.getEvents().get(event));
                for (Colony colony : this.getColonies()) {
                    int requiredBells = (colony.getSoL() + value) * 200 * colony.getUnitCount() / 100;
                    colony.addGoods(Goods.BELLS, requiredBells - colony.getGoodsCount(Goods.BELLS));
                }
                continue;
            }
            if (!event.equals("model.event.newRecruits")) continue;
            for (int index = 0; index < 3; ++index) {
                UnitType recruitable = this.getEurope().getRecruitable(index);
                if (!this.featureContainer.hasAbility("model.ability.canNotRecruitUnit", recruitable)) continue;
                this.getEurope().setRecruitable(index, this.generateRecruitable("newRecruits" + index));
            }
        }
    }

    public void endTurn() {
        this.removeModelMessages();
        this.resetCanSeeTiles();
    }

    public boolean canMoveToEurope() {
        return this.getEurope() != null;
    }

    public Europe getEurope() {
        return this.europe;
    }

    public String getEuropeName() {
        if (this.europe == null) {
            return null;
        }
        return Messages.message(this.nationID + ".europe", new String[0]);
    }

    public Monarch getMonarch() {
        return this.monarch;
    }

    public void setMonarch(Monarch monarch) {
        this.monarch = monarch;
    }

    public int getGold() {
        return this.gold;
    }

    public void modifyGold(int amount) {
        if (this.gold == -1) {
            return;
        }
        if (this.gold + amount >= 0) {
            this.modifyScore((this.gold + amount) / 1000 - this.gold / 1000);
            this.gold += amount;
        } else {
            logger.warning("Cannot add " + amount + " gold for " + this + ": would be negative!");
            this.gold = 0;
        }
    }

    public Iterator<Unit> getUnitIterator() {
        return this.units.values().iterator();
    }

    public List<Unit> getUnits() {
        return new ArrayList<Unit>(this.units.values());
    }

    public int getNumberOfKingLandUnits() {
        int n = 0;
        for (Unit unit : this.getUnits()) {
            if (!unit.hasAbility("model.ability.refUnit") || unit.isNaval()) continue;
            ++n;
        }
        return n;
    }

    public boolean hasManOfWar() {
        Iterator<Unit> it = this.getUnitIterator();
        while (it.hasNext()) {
            Unit unit = it.next();
            if (!"model.unit.manOWar".equals(unit.getType().getId())) continue;
            return true;
        }
        return false;
    }

    public Unit getNextActiveUnit() {
        return this.nextActiveUnitIterator.next();
    }

    public Unit getNextGoingToUnit() {
        return this.nextGoingToUnitIterator.next();
    }

    public boolean hasNextActiveUnit() {
        return this.nextActiveUnitIterator.hasNext();
    }

    public boolean hasNextGoingToUnit() {
        return this.nextGoingToUnitIterator.hasNext();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public NationType getNationType() {
        return this.nationType;
    }

    public void setNationType(NationType newNationType) {
        if (this.nationType != null) {
            this.featureContainer.remove(this.nationType.getFeatureContainer());
        }
        this.nationType = newNationType;
        this.featureContainer.add(newNationType.getFeatureContainer());
    }

    public Nation getNation() {
        return FreeCol.getSpecification().getNation(this.nationID);
    }

    public void setNation(Nation newNation) {
        String oldNationID = this.nationID;
        this.nationID = newNation.getId();
        this.firePropertyChange("nationID", oldNationID, this.nationID);
    }

    public String getNationID() {
        return this.nationID;
    }

    public String getNationAsString() {
        return Messages.message(this.nationID + ".name", new String[0]);
    }

    public final String getRulerName() {
        return Messages.message(this.nationID + ".ruler", new String[0]);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public Location getRepairLocation(Unit unit) {
        if (!unit.isNaval()) {
            throw new IllegalArgumentException();
        }
        Colony closestLocation = null;
        int shortestDistance = Integer.MAX_VALUE;
        for (Colony colony : this.getColonies()) {
            int distance;
            PathNode pn;
            if (colony == null || colony.getTile() == unit.getTile() || !colony.hasAbility("model.ability.repairUnits") || (pn = this.getGame().getMap().findPath(unit.getTile(), colony.getTile(), Map.PathType.ONLY_SEA)) == null || (distance = pn.getTotalTurns()) >= shortestDistance) continue;
            closestLocation = colony;
            shortestDistance = distance;
        }
        if (closestLocation != null) {
            return closestLocation;
        }
        return this.getEurope();
    }

    public void increment(GoodsType goodsType, int amount) {
        if (this.canRecruitUnits()) {
            if (goodsType == Goods.CROSSES) {
                this.crosses += amount;
            } else if (goodsType == Goods.BELLS) {
                this.bells += amount;
            }
        }
    }

    public void reduceCrosses() {
        int cost;
        if (!this.canRecruitUnits()) {
            return;
        }
        int n = cost = this.getGameOptions().getBoolean("model.option.saveProductionOverflow") ? this.crossesRequired : this.crosses;
        this.crosses = cost > this.crosses ? 0 : (this.crosses -= cost);
    }

    public int getCrosses() {
        if (!this.canRecruitUnits()) {
            return 0;
        }
        return this.crosses;
    }

    public final List<TradeRoute> getTradeRoutes() {
        return this.tradeRoutes;
    }

    public final void setTradeRoutes(List<TradeRoute> newTradeRoutes) {
        this.tradeRoutes = newTradeRoutes;
    }

    public boolean checkEmigrate() {
        if (!this.canRecruitUnits()) {
            return false;
        }
        return this.getCrossesRequired() <= this.crosses;
    }

    public int getCrossesRequired() {
        if (!this.canRecruitUnits()) {
            return 0;
        }
        return this.crossesRequired;
    }

    public void setCrossesRequired(int crossesRequired) {
        if (!this.canRecruitUnits()) {
            return;
        }
        this.crossesRequired = crossesRequired;
    }

    public void updateCrossesRequired() {
        if (!this.canRecruitUnits()) {
            return;
        }
        this.crossesRequired += (int)this.featureContainer.applyModifier(Specification.getSpecification().getIntegerOption("model.option.crossesIncrement").getValue(), "model.modifier.religiousUnrestBonus");
    }

    public boolean canRecruitUnits() {
        return this.playerType == PlayerType.COLONIAL;
    }

    public void modifyTension(Player player, int addToTension) {
        this.modifyTension(player, addToTension, null);
    }

    public void modifyTension(Player player, int addToTension, IndianSettlement origin) {
        if (player == this || player == null) {
            return;
        }
        if (this.tension.get(player) == null) {
            this.tension.put(player, new Tension(addToTension));
        } else {
            this.tension.get(player).modify(addToTension);
        }
        if (origin != null && origin.getOwner() != this) {
            return;
        }
        if (this.isIndian()) {
            for (Settlement settlement : this.settlements) {
                if (origin != null && origin.equals(settlement)) continue;
                if (!(settlement instanceof IndianSettlement)) {
                    throw new IllegalStateException("Indian player owns non indian settlement");
                }
                ((IndianSettlement)settlement).propagatedAlarm(player, addToTension);
            }
        }
    }

    public void setTension(Player player, Tension newTension) {
        if (player == this || player == null) {
            return;
        }
        this.tension.put(player, newTension);
    }

    public Tension getTension(Player player) {
        if (player == null) {
            return new Tension();
        }
        return this.tension.get(player);
    }

    public void surrenderTo(Player player) {
        if (!this.isIndian()) {
            logger.warning("Only indians should surrender");
            return;
        }
        this.changeRelationWithPlayer(player, Stance.PEACE);
        this.getTension(player).setValue(Tension.SURRENDED);
    }

    public final List<HistoryEvent> getHistory() {
        return this.history;
    }

    public final void setHistory(List<HistoryEvent> newHistory) {
        this.history = newHistory;
    }

    private static int getNearbyColonyBonus(Player owner, Tile tile) {
        Tile ct;
        Game game = tile.getGame();
        Map map = game.getMap();
        Map.CircleIterator it = map.getCircleIterator(tile.getPosition(), false, 3);
        while (it.hasNext()) {
            ct = map.getTile((Map.Position)it.next());
            if (ct.getColony() == null || ct.getColony().getOwner() != owner) continue;
            return 45;
        }
        it = map.getCircleIterator(tile.getPosition(), false, 4);
        while (it.hasNext()) {
            ct = map.getTile((Map.Position)it.next());
            if (ct.getColony() == null || ct.getColony().getOwner() != owner) continue;
            return 25;
        }
        it = map.getCircleIterator(tile.getPosition(), false, 5);
        while (it.hasNext()) {
            ct = map.getTile((Map.Position)it.next());
            if (ct.getColony() == null || ct.getColony().getOwner() != owner) continue;
            return 20;
        }
        it = map.getCircleIterator(tile.getPosition(), false, 6);
        while (it.hasNext()) {
            ct = map.getTile((Map.Position)it.next());
            if (ct.getColony() == null || ct.getColony().getOwner() != owner) continue;
            return 30;
        }
        it = map.getCircleIterator(tile.getPosition(), false, 7);
        while (it.hasNext()) {
            ct = map.getTile((Map.Position)it.next());
            if (ct.getColony() == null || ct.getColony().getOwner() != owner) continue;
            return 15;
        }
        it = map.getCircleIterator(tile.getPosition(), false, 8);
        while (it.hasNext()) {
            ct = map.getTile((Map.Position)it.next());
            if (ct.getColony() == null || ct.getColony().getOwner() != owner) continue;
            return 5;
        }
        return 0;
    }

    public int getColonyValue(Tile tile) {
        int value = tile.getColonyValue();
        if (value == 0) {
            return 0;
        }
        Map.CircleIterator it = this.getGame().getMap().getCircleIterator(tile.getPosition(), true, 4);
        while (it.hasNext()) {
            Tile ct = this.getGame().getMap().getTile((Map.Position)it.next());
            if (ct.getColony() != null && ct.getColony().getOwner() != this) {
                value = this.getStance(ct.getColony().getOwner()) == Stance.WAR ? (value -= Math.max(0, 20 - tile.getDistanceTo(tile) * 4)) : (value -= Math.max(0, 8 - tile.getDistanceTo(tile) * 2));
            }
            Iterator<Unit> ui = ct.getUnitIterator();
            while (ui.hasNext()) {
                Unit u = ui.next();
                if (u.getOwner() == this || !u.isOffensiveUnit() || !u.getOwner().isEuropean() || this.getStance(u.getOwner()) != Stance.WAR) continue;
                value -= Math.max(0, 40 - tile.getDistanceTo(tile) * 9);
            }
        }
        return Math.max(0, value + Player.getNearbyColonyBonus(this, tile));
    }

    public Stance getStance(Player player) {
        if (player == null) {
            return Stance.PEACE;
        }
        return this.stance.get(player.getId());
    }

    public static String getStanceAsString(Stance stance) {
        return Messages.message("model.stance." + stance.toString().toLowerCase(), new String[0]);
    }

    public void setStance(Player player, Stance newStance) {
        if (player == null) {
            throw new IllegalArgumentException("Player must not be 'null'.");
        }
        if (player == this) {
            throw new IllegalArgumentException("Cannot set the stance towards ourselves.");
        }
        Stance oldStance = this.stance.get(player.getId());
        if (newStance.equals((Object)oldStance)) {
            return;
        }
        if (newStance == Stance.CEASE_FIRE && oldStance != Stance.WAR) {
            throw new IllegalStateException("Cease fire can only be declared when at war.");
        }
        this.stance.put(player.getId(), newStance);
    }

    public void changeRelationWithPlayer(Player player, Stance newStance) {
        Stance oldStance = this.getStance(player);
        if (newStance == oldStance) {
            return;
        }
        this.setStance(player, newStance);
        if (oldStance == null) {
            oldStance = Stance.PEACE;
        }
        int modifier = 0;
        switch (newStance) {
            case PEACE: {
                if (oldStance == Stance.WAR) {
                    modifier = -500;
                }
                if (oldStance != Stance.CEASE_FIRE) break;
                modifier = -250;
                break;
            }
            case CEASE_FIRE: {
                if (oldStance != Stance.WAR) break;
                modifier = -250;
                break;
            }
        }
        this.modifyTension(player, modifier);
        if (player.getStance(this) != newStance) {
            this.getGame().getModelController().setStance(this, player, newStance);
            player.setStance(this, newStance);
            if (newStance == Stance.WAR) {
                switch (oldStance) {
                    case PEACE: {
                        modifier = 1000;
                        break;
                    }
                    case CEASE_FIRE: {
                        modifier = 750;
                        break;
                    }
                }
            }
            player.modifyTension(this, modifier);
        }
    }

    public int getRecruitPrice() {
        return this.getEurope().getRecruitPrice();
    }

    public int getBells() {
        if (!this.canHaveFoundingFathers()) {
            return 0;
        }
        return this.bells;
    }

    public int getBellsProductionNextTurn() {
        int bellsNextTurn = 0;
        for (Colony colony : this.getColonies()) {
            bellsNextTurn += colony.getProductionOf(Goods.BELLS);
        }
        return bellsNextTurn;
    }

    public void newTurn() {
        int newSoL = 0;
        if (this.isIndian()) {
            for (Tension tension1 : this.tension.values()) {
                if (tension1.getValue() <= 0) continue;
                tension1.modify(-(4 + tension1.getValue() / 100));
            }
        }
        ArrayList<Settlement> settlements = new ArrayList<Settlement>(this.getSettlements());
        for (Settlement settlement : settlements) {
            logger.finest("Calling newTurn for settlement " + settlement.toString());
            settlement.newTurn();
            if (!this.isEuropean()) continue;
            Colony colony = (Colony)settlement;
            newSoL += colony.getSoL();
        }
        if (this.isEuropean()) {
            int numberOfColonies;
            if (!this.hasAbility("model.ability.independenceDeclared") && this.getBells() >= this.getTotalFoundingFatherCost() && this.currentFather != null) {
                this.addFather(this.currentFather);
                this.currentFather = null;
                this.bells -= this.getGameOptions().getBoolean("model.option.saveProductionOverflow") ? this.getTotalFoundingFatherCost() : this.bells;
            }
            for (Unit unit : new ArrayList<Unit>(this.units.values())) {
                logger.finest("Calling newTurn for unit " + unit.getName() + " " + unit.getId());
                unit.newTurn();
            }
            if (this.getEurope() != null) {
                logger.finest("Calling newTurn for player " + this.getName() + "'s Europe");
                this.getEurope().newTurn();
            }
            if (this.getMarket() != null) {
                logger.finest("Calling newTurn for player " + this.getName() + "'s Market");
                this.getMarket().newTurn();
            }
            if ((numberOfColonies = settlements.size()) > 0 && this.oldSoL / 10 != (newSoL /= numberOfColonies) / 10) {
                if (newSoL > this.oldSoL) {
                    this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.SONS_OF_LIBERTY, "model.player.SoLIncrease", "%oldSoL%", String.valueOf(this.oldSoL), "%newSoL%", String.valueOf(newSoL));
                } else {
                    this.addModelMessage((FreeColGameObject)this, ModelMessage.MessageType.SONS_OF_LIBERTY, "model.player.SoLDecrease", "%oldSoL%", String.valueOf(this.oldSoL), "%newSoL%", String.valueOf(newSoL));
                }
            }
            this.oldSoL = newSoL;
        } else {
            Iterator<Unit> unitIterator = this.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit unit;
                unit = unitIterator.next();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Calling newTurn for unit " + unit.getName() + " " + unit.getId());
                }
                unit.newTurn();
            }
        }
    }

    private void exploreAllColonies() {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        Map.WholeMapIterator tileIterator = this.getGame().getMap().getWholeMapIterator();
        while (tileIterator.hasNext()) {
            Tile tile = this.getGame().getMap().getTile((Map.Position)tileIterator.next());
            if (tile.getColony() == null || tile.getColony().getOwner() == this) continue;
            tiles.add(tile);
            for (Map.Direction direction : Map.Direction.values()) {
                Tile addTile = this.getGame().getMap().getNeighbourOrNull(direction, tile);
                if (addTile == null || addTile.isExploredBy(this)) continue;
                tiles.add(addTile);
            }
        }
        this.getGame().getModelController().exploreTiles(this, tiles);
    }

    public UnitType generateRecruitable(String unique) {
        ArrayList recruitableUnits = new ArrayList();
        for (UnitType unitType : FreeCol.getSpecification().getUnitTypeList()) {
            if (!unitType.isRecruitable() || this.featureContainer.hasAbility("model.ability.canNotRecruitUnit", unitType)) continue;
            recruitableUnits.add(new RandomChoice<UnitType>(unitType, unitType.getRecruitProbability()));
        }
        int totalProbability = RandomChoice.getTotalProbability(recruitableUnits);
        int random = this.getGame().getModelController().getRandom(this.getId() + "newRecruitableUnit" + unique, totalProbability);
        return (UnitType)RandomChoice.select(recruitableUnits, random);
    }

    public int getArrears(GoodsType type) {
        MarketData data = this.getMarket().getMarketData(type);
        return data == null ? 0 : data.getArrears();
    }

    public int getArrears(Goods goods) {
        return this.getArrears(goods.getType());
    }

    public void setArrears(GoodsType goodsType) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            data = new MarketData(goodsType);
            this.getMarket().putMarketData(goodsType, data);
        }
        Specification spec = Specification.getSpecification();
        data.setArrears(spec.getIntegerOption("model.option.arrearsFactor").getValue() * data.getPaidForSale());
    }

    public void setArrears(Goods goods) {
        this.setArrears(goods.getType());
    }

    public void resetArrears(GoodsType goodsType) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            data = new MarketData(goodsType);
            this.getMarket().putMarketData(goodsType, data);
        }
        data.setArrears(0);
    }

    public void resetArrears(Goods goods) {
        this.resetArrears(goods.getType());
    }

    public boolean canTrade(GoodsType type) {
        return this.canTrade(type, 0);
    }

    public boolean canTrade(GoodsType type, int marketAccess) {
        MarketData data = this.getMarket().getMarketData(type);
        if (data == null) {
            return true;
        }
        return data.getArrears() == 0 || marketAccess == 1 && this.getGameOptions().getBoolean("model.option.customIgnoreBoycott");
    }

    public boolean canTrade(Goods goods, int marketAccess) {
        return this.canTrade(goods.getType(), marketAccess);
    }

    public boolean canTrade(Goods goods) {
        return this.canTrade(goods, 0);
    }

    public int getTax() {
        return this.tax;
    }

    public void setTax(int amount) {
        if (amount != this.tax) {
            this.tax = amount;
            this.updateAddTaxToBells();
        }
    }

    private void updateAddTaxToBells() {
        Set<Modifier> bellsBonus = this.featureContainer.getModifierSet("model.goods.bells");
        for (Ability ability : this.featureContainer.getAbilitySet("model.ability.addTaxToBells")) {
            FreeColGameObjectType source = ability.getSource();
            if (source == null) continue;
            for (Modifier modifier : bellsBonus) {
                if (!source.equals(modifier.getSource())) continue;
                modifier.setValue(this.tax);
                return;
            }
        }
    }

    public int getSales(GoodsType goodsType) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            return 0;
        }
        return data.getSales();
    }

    public void modifySales(GoodsType goodsType, int amount) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            data = new MarketData(goodsType);
            this.getMarket().putMarketData(goodsType, data);
        }
        int oldSales = data.getSales();
        data.setSales(oldSales + amount);
    }

    public boolean hasTraded(GoodsType goodsType) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        return data != null && data.getTraded();
    }

    public Goods getMostValuableGoods() {
        Goods goods = null;
        if (!this.isEuropean()) {
            return goods;
        }
        int value = 0;
        for (Colony colony : this.getColonies()) {
            List<Goods> colonyGoods = colony.getCompactGoods();
            for (Goods currentGoods : colonyGoods) {
                int goodsValue;
                if (this.getArrears(currentGoods) != 0 || !this.hasTraded(currentGoods.getType())) continue;
                if (currentGoods.getAmount() > 100) {
                    currentGoods.setAmount(100);
                }
                if ((goodsValue = this.market.getSalePrice(currentGoods)) <= value) continue;
                value = goodsValue;
                goods = currentGoods;
            }
        }
        return goods;
    }

    public int getIncomeBeforeTaxes(GoodsType goodsType) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            return 0;
        }
        return data.getIncomeBeforeTaxes();
    }

    public void modifyIncomeBeforeTaxes(GoodsType goodsType, int amount) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            data = new MarketData(goodsType);
            this.getMarket().putMarketData(goodsType, data);
        }
        int oldAmount = data.getIncomeBeforeTaxes();
        data.setIncomeBeforeTaxes(oldAmount += amount);
    }

    public int getIncomeAfterTaxes(GoodsType goodsType) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            return 0;
        }
        return data.getIncomeAfterTaxes();
    }

    public void modifyIncomeAfterTaxes(GoodsType goodsType, int amount) {
        MarketData data = this.getMarket().getMarketData(goodsType);
        if (data == null) {
            data = new MarketData(goodsType);
            this.getMarket().putMarketData(goodsType, data);
        }
        int oldAmount = data.getIncomeAfterTaxes();
        data.setIncomeAfterTaxes(oldAmount + amount);
    }

    public DifficultyLevel getDifficulty() {
        int level = this.getGame().getGameOptions().getInteger("model.option.difficulty");
        return FreeCol.getSpecification().getDifficultyLevel(level);
    }

    public boolean equals(Player o) {
        if (o == null) {
            return false;
        }
        if (this.getId() == null || o.getId() == null) {
            return false;
        }
        return this.getId().equals(o.getId());
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Player.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("index", String.valueOf(this.index));
        out.writeAttribute("username", this.name);
        out.writeAttribute("nationID", this.nationID);
        if (this.nationType != null) {
            out.writeAttribute("nationType", this.nationType.getId());
        }
        out.writeAttribute("color", Integer.toString(this.color.getRGB()));
        out.writeAttribute("admin", Boolean.toString(this.admin));
        out.writeAttribute("ready", Boolean.toString(this.ready));
        out.writeAttribute("dead", Boolean.toString(this.dead));
        out.writeAttribute("playerType", this.playerType.toString());
        out.writeAttribute("ai", Boolean.toString(this.ai));
        out.writeAttribute("tax", Integer.toString(this.tax));
        out.writeAttribute("numberOfSettlements", Integer.toString(this.numberOfSettlements));
        if (this.getGame().isClientTrusted() || showAll || this.equals(player)) {
            out.writeAttribute("gold", Integer.toString(this.gold));
            out.writeAttribute("crosses", Integer.toString(this.crosses));
            out.writeAttribute("bells", Integer.toString(this.bells));
            if (this.currentFather != null) {
                out.writeAttribute("currentFather", this.currentFather.getId());
            }
            out.writeAttribute("crossesRequired", Integer.toString(this.crossesRequired));
            out.writeAttribute("attackedByPrivateers", Boolean.toString(this.attackedByPrivateers));
            out.writeAttribute("oldSoL", Integer.toString(this.oldSoL));
            out.writeAttribute("score", Integer.toString(this.score));
        } else {
            out.writeAttribute("gold", Integer.toString(-1));
            out.writeAttribute("crosses", Integer.toString(-1));
            out.writeAttribute("bells", Integer.toString(-1));
            out.writeAttribute("crossesRequired", Integer.toString(-1));
        }
        if (this.newLandName != null) {
            out.writeAttribute("newLandName", this.newLandName);
        }
        if (this.independentNationName != null) {
            out.writeAttribute("independentNationName", this.independentNationName);
        }
        if (this.entryLocation != null) {
            out.writeAttribute("entryLocation", this.entryLocation.getId());
        }
        for (Map.Entry<Player, Tension> entry : this.tension.entrySet()) {
            out.writeStartElement(TENSION_TAG);
            out.writeAttribute("player", entry.getKey().getId());
            out.writeAttribute("value", String.valueOf(entry.getValue().getValue()));
            out.writeEndElement();
        }
        for (Map.Entry<Object, Object> entry : this.stance.entrySet()) {
            out.writeStartElement(STANCE_TAG);
            out.writeAttribute("player", (String)entry.getKey());
            out.writeAttribute("value", ((Stance)((Object)entry.getValue())).toString());
            out.writeEndElement();
        }
        for (HistoryEvent historyEvent : this.history) {
            historyEvent.toXML(out, this);
        }
        for (TradeRoute tradeRoute : this.getTradeRoutes()) {
            tradeRoute.toXML(out, this);
        }
        if (this.market != null) {
            this.market.toXML(out, player, showAll, toSavedGame);
        }
        if (this.getGame().isClientTrusted() || showAll || this.equals(player)) {
            out.writeStartElement(FOUNDING_FATHER_TAG);
            out.writeAttribute("xLength", Integer.toString(this.allFathers.size()));
            int index = 0;
            for (FoundingFather father : this.allFathers) {
                out.writeAttribute("x" + Integer.toString(index), father.getId());
                ++index;
            }
            out.writeEndElement();
            if (this.europe != null) {
                this.europe.toXML(out, player, showAll, toSavedGame);
            }
            if (this.monarch != null) {
                this.monarch.toXML(out, player, showAll, toSavedGame);
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.index = Integer.parseInt(in.getAttributeValue(null, "index"));
        this.name = in.getAttributeValue(null, "username");
        this.nationID = in.getAttributeValue(null, "nationID");
        if (!this.name.equals(UNKNOWN_ENEMY)) {
            this.nationType = FreeCol.getSpecification().getNationType(in.getAttributeValue(null, "nationType"));
        }
        this.color = new Color(Integer.parseInt(in.getAttributeValue(null, "color")));
        this.admin = this.getAttribute(in, "admin", false);
        this.gold = Integer.parseInt(in.getAttributeValue(null, "gold"));
        this.crosses = Integer.parseInt(in.getAttributeValue(null, "crosses"));
        this.bells = Integer.parseInt(in.getAttributeValue(null, "bells"));
        this.oldSoL = this.getAttribute(in, "oldSoL", 0);
        this.score = this.getAttribute(in, "score", 0);
        this.ready = this.getAttribute(in, "ready", false);
        this.ai = this.getAttribute(in, "ai", false);
        this.dead = this.getAttribute(in, "dead", false);
        this.tax = Integer.parseInt(in.getAttributeValue(null, "tax"));
        this.numberOfSettlements = this.getAttribute(in, "numberOfSettlements", 0);
        this.playerType = Enum.valueOf(PlayerType.class, in.getAttributeValue(null, "playerType"));
        this.currentFather = FreeCol.getSpecification().getType(in, "currentFather", FoundingFather.class, null);
        this.crossesRequired = this.getAttribute(in, "crossesRequired", 12);
        this.newLandName = this.getAttribute(in, "newLandName", null);
        this.independentNationName = this.getAttribute(in, "independentNationName", null);
        this.attackedByPrivateers = this.getAttribute(in, "attackedByPrivateers", false);
        String entryLocationStr = in.getAttributeValue(null, "entryLocation");
        if (entryLocationStr != null) {
            this.entryLocation = (Location)((Object)this.getGame().getFreeColGameObject(entryLocationStr));
            if (this.entryLocation == null) {
                this.entryLocation = new Tile(this.getGame(), entryLocationStr);
            }
        }
        this.featureContainer = new FeatureContainer();
        if (this.nationType != null) {
            this.featureContainer.add(this.nationType.getFeatureContainer());
        }
        switch (this.playerType) {
            case REBEL: 
            case INDEPENDENT: {
                this.featureContainer.addAbility(new Ability("model.ability.independenceDeclared"));
                break;
            }
        }
        this.tension = new HashMap<Player, Tension>();
        this.stance = new HashMap<String, Stance>();
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(TENSION_TAG)) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                this.tension.put(player, new Tension(this.getAttribute(in, "value", 0)));
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(FOUNDING_FATHER_TAG)) {
                int length = Integer.parseInt(in.getAttributeValue(null, "xLength"));
                for (int index = 0; index < length; ++index) {
                    String fatherId = in.getAttributeValue(null, "x" + String.valueOf(index));
                    FoundingFather father = FreeCol.getSpecification().getFoundingFather(fatherId);
                    this.allFathers.add(father);
                    this.featureContainer.add(father.getFeatureContainer());
                }
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(STANCE_TAG)) {
                String playerId = in.getAttributeValue(null, "player");
                this.stance.put(playerId, Enum.valueOf(Stance.class, in.getAttributeValue(null, "value")));
                in.nextTag();
                continue;
            }
            if (in.getLocalName().equals(Europe.getXMLElementTagName())) {
                this.europe = this.updateFreeColGameObject(in, Europe.class);
                continue;
            }
            if (in.getLocalName().equals(Monarch.getXMLElementTagName())) {
                this.monarch = this.updateFreeColGameObject(in, Monarch.class);
                continue;
            }
            if (in.getLocalName().equals(HistoryEvent.getXMLElementTagName())) {
                HistoryEvent event = new HistoryEvent();
                event.readFromXMLImpl(in);
                this.getHistory().add(event);
                continue;
            }
            if (in.getLocalName().equals(TradeRoute.getXMLElementTagName())) {
                TradeRoute route = new TradeRoute(this.getGame(), in);
                this.getTradeRoutes().add(route);
                continue;
            }
            if (in.getLocalName().equals(Market.getXMLElementTagName())) {
                this.market = this.updateFreeColGameObject(in, Market.class);
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " loading player");
            in.nextTag();
        }
        if (!in.getLocalName().equals(Player.getXMLElementTagName())) {
            logger.warning("Error parsing xml: expecting closing tag </" + Player.getXMLElementTagName() + "> " + "found instead: " + in.getLocalName());
        }
        if (this.market == null) {
            this.market = new Market(this.getGame(), this);
        }
        this.invalidateCanSeeTiles();
    }

    public static String getXMLElementTagName() {
        return "player";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnitIterator
    implements Iterator<Unit> {
        private Iterator<Unit> unitIterator = null;
        private Player owner;
        private Unit nextUnit = null;
        private UnitPredicate predicate;

        public UnitIterator(Player owner, UnitPredicate predicate) {
            this.owner = owner;
            this.predicate = predicate;
        }

        @Override
        public boolean hasNext() {
            if (this.nextUnit != null && this.predicate.obtains(this.nextUnit)) {
                return true;
            }
            if (this.unitIterator == null) {
                this.unitIterator = this.createUnitIterator();
            }
            while (this.unitIterator.hasNext()) {
                this.nextUnit = this.unitIterator.next();
                if (!this.predicate.obtains(this.nextUnit)) continue;
                return true;
            }
            this.unitIterator = this.createUnitIterator();
            while (this.unitIterator.hasNext()) {
                this.nextUnit = this.unitIterator.next();
                if (!this.predicate.obtains(this.nextUnit)) continue;
                return true;
            }
            this.nextUnit = null;
            return false;
        }

        @Override
        public Unit next() {
            if (this.nextUnit == null || !this.predicate.obtains(this.nextUnit)) {
                this.hasNext();
            }
            Unit temp = this.nextUnit;
            this.nextUnit = null;
            return temp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Iterator<Unit> createUnitIterator() {
            ArrayList<Unit> units = new ArrayList<Unit>();
            Map map = Player.this.getGame().getMap();
            Map.WholeMapIterator tileIterator = map.getWholeMapIterator();
            while (tileIterator.hasNext()) {
                Tile t = map.getTile((Map.Position)tileIterator.next());
                if (t == null || t.getFirstUnit() == null || !t.getFirstUnit().getOwner().equals(this.owner)) continue;
                Iterator<Unit> unitIterator = t.getUnitIterator();
                while (unitIterator.hasNext()) {
                    Unit u = unitIterator.next();
                    Iterator<Unit> childUnitIterator = u.getUnitIterator();
                    while (childUnitIterator.hasNext()) {
                        Unit childUnit = childUnitIterator.next();
                        if (!this.predicate.obtains(childUnit)) continue;
                        units.add(childUnit);
                    }
                    if (!this.predicate.obtains(u)) continue;
                    units.add(u);
                }
            }
            return units.iterator();
        }
    }

    public class GoingToPredicate
    extends UnitPredicate {
        public boolean obtains(Unit unit) {
            return !unit.isDisposed() && unit.getMovesLeft() > 0 && unit.getDestination() != null && !(unit.getLocation() instanceof WorkLocation) && unit.getTile() != null;
        }
    }

    public class ActivePredicate
    extends UnitPredicate {
        public boolean obtains(Unit unit) {
            return !unit.isDisposed() && unit.getMovesLeft() > 0 && unit.getState() == Unit.UnitState.ACTIVE && unit.getDestination() == null && !(unit.getLocation() instanceof WorkLocation) && unit.getTile() != null;
        }
    }

    public abstract class UnitPredicate {
        public abstract boolean obtains(Unit var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlayerType {
        NATIVE,
        COLONIAL,
        REBEL,
        INDEPENDENT,
        ROYAL,
        UNDEAD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stance {
        WAR,
        CEASE_FIRE,
        PEACE,
        ALLIANCE;

    }
}

