/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region
extends FreeColGameObject
implements Nameable {
    public static final String PACIFIC_NAME_KEY = "model.region.pacific";
    private String name;
    private String nameKey;
    private Region parent;
    private boolean claimable = false;
    private boolean discoverable = false;
    private Turn discoveredIn;
    private Player discoveredBy;
    private boolean prediscovered = false;
    private int scoreValue = 0;
    private RegionType type;
    private List<Region> children;

    public Region(Game game) {
        super(game);
    }

    public Region(Game game, String id) {
        super(game, id);
    }

    public Region(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXMLImpl(in);
    }

    public final String getNameKey() {
        return this.nameKey;
    }

    public final void setNameKey(String newNameKey) {
        this.nameKey = newNameKey;
    }

    public boolean isPacific() {
        if (PACIFIC_NAME_KEY.equals(this.nameKey)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isPacific();
        }
        return false;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String newName) {
        this.name = newName;
    }

    public String getDisplayName() {
        if (this.prediscovered || this.isPacific()) {
            return Messages.message(this.nameKey, new String[0]);
        }
        if (this.name == null) {
            return Messages.message("model.region." + this.type.toString().toLowerCase() + ".unknown", new String[0]);
        }
        return this.name;
    }

    public String getTypeName() {
        return Messages.message("model.region." + this.type.toString().toLowerCase() + ".name", new String[0]);
    }

    public final Region getParent() {
        return this.parent;
    }

    public final void setParent(Region newParent) {
        this.parent = newParent;
    }

    public final List<Region> getChildren() {
        return this.children;
    }

    public final void setChildren(List<Region> newChildren) {
        this.children = newChildren;
    }

    public final boolean isClaimable() {
        return this.claimable;
    }

    public final void setClaimable(boolean newClaimable) {
        this.claimable = newClaimable;
    }

    public final boolean isDiscoverable() {
        return this.discoverable;
    }

    public final void setDiscoverable(boolean newDiscoverable) {
        this.discoverable = newDiscoverable;
        if (this.discoverable) {
            this.prediscovered = false;
        }
    }

    public final boolean isPrediscovered() {
        return this.prediscovered;
    }

    public final void setPrediscovered(boolean newPrediscovered) {
        this.prediscovered = newPrediscovered;
    }

    public final int getScoreValue() {
        return this.scoreValue;
    }

    public final void setScoreValue(int newScoreValue) {
        this.scoreValue = newScoreValue;
    }

    public final RegionType getType() {
        return this.type;
    }

    public final void setType(RegionType newType) {
        this.type = newType;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public Region getDiscoverableRegion() {
        if (this.isDiscoverable()) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getDiscoverableRegion();
        }
        return null;
    }

    public final Turn getDiscoveredIn() {
        return this.discoveredIn;
    }

    public final void setDiscoveredIn(Turn newDiscoveredIn) {
        this.discoveredIn = newDiscoveredIn;
    }

    public final Player getDiscoveredBy() {
        return this.discoveredBy;
    }

    public final void setDiscoveredBy(Player newDiscoveredBy) {
        this.discoveredBy = newDiscoveredBy;
    }

    public void discover(Player player, Turn turn, String newName) {
        this.discoveredBy = player;
        this.discoveredIn = turn;
        this.name = newName;
        this.discoverable = false;
        if (this.getGame().getGameOptions().getBoolean("model.option.explorationPoints") || this.isPacific()) {
            player.modifyScore(this.getScoreValue());
        }
        player.getHistory().add(new HistoryEvent(turn.getNumber(), HistoryEvent.Type.DISCOVER_REGION, "%region%", Messages.message(newName, new String[0])));
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Region.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("nameKey", this.nameKey);
        out.writeAttribute("type", this.type.toString());
        if (this.name != null) {
            out.writeAttribute("name", this.name);
        }
        if (this.prediscovered) {
            out.writeAttribute("prediscovered", Boolean.toString(this.prediscovered));
        }
        if (this.claimable) {
            out.writeAttribute("claimable", Boolean.toString(this.claimable));
        }
        if (this.discoverable) {
            out.writeAttribute("discoverable", Boolean.toString(this.discoverable));
        }
        if (this.parent != null) {
            out.writeAttribute("parent", this.parent.getId());
        }
        if (this.discoveredIn != null) {
            out.writeAttribute("discoveredIn", String.valueOf(this.discoveredIn.getNumber()));
        }
        if (this.discoveredBy != null) {
            out.writeAttribute("discoveredBy", this.discoveredBy.getId());
        }
        if (this.scoreValue > 0) {
            out.writeAttribute("scoreValue", String.valueOf(this.scoreValue));
        }
        if (this.children != null) {
            String[] childArray = new String[this.children.size()];
            for (int index = 0; index < childArray.length; ++index) {
                childArray[index] = this.children.get(index).getId();
            }
            this.toArrayElement("children", childArray, out);
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.nameKey = in.getAttributeValue(null, "nameKey");
        this.name = in.getAttributeValue(null, "name");
        this.claimable = this.getAttribute(in, "claimable", false);
        this.discoverable = this.getAttribute(in, "discoverable", false);
        this.prediscovered = this.getAttribute(in, "prediscovered", false);
        this.scoreValue = this.getAttribute(in, "scoreValue", 0);
        this.type = Enum.valueOf(RegionType.class, in.getAttributeValue(null, "type"));
        int turn = this.getAttribute(in, "discoveredIn", -1);
        if (turn > 0) {
            this.discoveredIn = new Turn(turn);
        }
        this.discoveredBy = this.getFreeColGameObject(in, "discoveredBy", Player.class, null);
        this.parent = this.getFreeColGameObject(in, "parent", Region.class);
        while (in.nextTag() != 2) {
            if (!in.getLocalName().equals("children")) continue;
            String[] childArray = this.readFromArrayElement("children", in, new String[0]);
            this.children = new ArrayList<Region>();
            for (String child : childArray) {
                this.children.add(this.getGame().getMap().getRegion(child));
            }
        }
    }

    public static String getXMLElementTagName() {
        return "region";
    }

    @Override
    public String toString() {
        return this.nameKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RegionType {
        OCEAN,
        COAST,
        LAKE,
        RIVER,
        LAND,
        MOUNTAIN,
        DESERT;

    }
}

