/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

public class Resource
extends TileItem {
    private static Logger logger = Logger.getLogger(Resource.class.getName());
    private ResourceType type;
    private int quantity;

    public Resource(Game game, Tile tile, ResourceType type) {
        super(game, tile);
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' must not be 'null'.");
        }
        this.type = type;
        this.quantity = type.getRandomValue();
    }

    public Resource(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Resource(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public String toString() {
        if (this.quantity > -1) {
            return Integer.toString(this.quantity) + " " + this.getName();
        }
        return this.getName();
    }

    public String getName() {
        return this.getType().getName();
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getOutputString() {
        return this.type.getOutputString();
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int newQuantity) {
        this.quantity = newQuantity;
    }

    public GoodsType getBestGoodsType() {
        return this.type.getBestGoodsType();
    }

    public int getBonus(GoodsType goodsType, UnitType unitType, int potential) {
        Set<Modifier> productionBonus = this.type.getProductionModifier(goodsType, unitType);
        int bonusAmount = (int)FeatureContainer.applyModifierSet(potential, null, productionBonus) - potential;
        if (this.quantity > -1 && bonusAmount > this.quantity) {
            return potential + this.quantity;
        }
        return potential + bonusAmount;
    }

    public int useQuantity(GoodsType goodsType, UnitType unitType, int potential) {
        return this.useQuantity(this.getBonus(goodsType, unitType, potential) - potential);
    }

    public int useQuantity(int usedQuantity) {
        if (this.quantity >= usedQuantity) {
            this.quantity -= usedQuantity;
        } else if (this.quantity == -1) {
            logger.warning("useQuantity called for unlimited resource");
        } else {
            logger.severe("Insufficient quantity in " + this);
            this.quantity = 0;
        }
        return this.quantity;
    }

    public void dispose() {
        super.dispose();
    }

    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Resource.getXMLElementTagName());
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("tile", this.getTile().getId());
        out.writeAttribute("type", this.getType().getId());
        out.writeAttribute("quantity", Integer.toString(this.quantity));
        out.writeEndElement();
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.tile = this.getFreeColGameObject(in, "tile", Tile.class);
        this.type = FreeCol.getSpecification().getResourceType(in.getAttributeValue(null, "type"));
        this.quantity = Integer.parseInt(in.getAttributeValue(null, "quantity"));
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "resource";
    }

    public void setName(String newName) {
    }
}

