/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Random;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceType
extends FreeColGameObjectType {
    private int minValue;
    private int maxValue;

    public ResourceType(int index) {
        this.setIndex(index);
    }

    public int getRandomValue() {
        if (this.minValue == this.maxValue) {
            return this.maxValue;
        }
        Random rand = new Random();
        return this.minValue + rand.nextInt(this.maxValue - this.minValue + 1);
    }

    public Set<Modifier> getProductionModifier(GoodsType goodsType, UnitType unitType) {
        return this.featureContainer.getModifierSet(goodsType.getId(), unitType);
    }

    public GoodsType getBestGoodsType() {
        GoodsType bestType = null;
        float bestValue = 0.0f;
        for (Modifier modifier : this.featureContainer.getModifiers()) {
            GoodsType goodsType = Specification.getSpecification().getGoodsType(modifier.getId());
            float value = (float)goodsType.getInitialSellPrice() * modifier.applyTo(100.0f);
            if (bestType != null && !(value > bestValue)) continue;
            bestType = goodsType;
            bestValue = value;
        }
        return bestType;
    }

    public String getOutputString() {
        return "";
    }

    @Override
    public void readAttributes(XMLStreamReader in, Specification specification) throws XMLStreamException {
        if (this.hasAttribute(in, "maximum-value")) {
            this.maxValue = Integer.parseInt(in.getAttributeValue(null, "maximum-value"));
            this.minValue = this.getAttribute(in, "minimum-value", 0);
        } else {
            this.maxValue = -1;
            this.minValue = -1;
        }
    }
}

