/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;

public final class Scope
extends FreeColObject
implements Cloneable {
    private String type;
    private String abilityID;
    private boolean abilityValue = true;
    private String methodName;
    private String methodValue;
    private boolean matchesNull = true;
    private boolean matchNegated = false;

    public Scope() {
    }

    public Scope(XMLStreamReader in) throws XMLStreamException {
        this.readFromXMLImpl(in);
    }

    public boolean isMatchesNull() {
        return this.matchesNull;
    }

    public void setMatchesNull(boolean newMatchesNull) {
        this.matchesNull = newMatchesNull;
    }

    public boolean isMatchNegated() {
        return this.matchNegated;
    }

    public void setMatchNegated(boolean newMatchNegated) {
        this.matchNegated = newMatchNegated;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getAbilityID() {
        return this.abilityID;
    }

    public void setAbilityID(String newAbilityID) {
        this.abilityID = newAbilityID;
    }

    public boolean isAbilityValue() {
        return this.abilityValue;
    }

    public void setAbilityValue(boolean newAbilityValue) {
        this.abilityValue = newAbilityValue;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String newMethodName) {
        this.methodName = newMethodName;
    }

    public String getMethodValue() {
        return this.methodValue;
    }

    public void setMethodValue(String newMethodValue) {
        this.methodValue = newMethodValue;
    }

    public boolean appliesTo(FreeColGameObjectType object) {
        if (object == null) {
            return this.matchesNull;
        }
        if (this.type != null && !this.type.equals(object.getId())) {
            return this.matchNegated;
        }
        if (this.abilityID != null && object.hasAbility(this.abilityID) != this.abilityValue) {
            return this.matchNegated;
        }
        if (this.methodName != null) {
            try {
                Method method = object.getClass().getMethod(this.methodName, new Class[0]);
                if (!method.invoke((Object)object, new Object[0]).toString().equals(this.methodValue)) {
                    return this.matchNegated;
                }
            }
            catch (Exception e) {
                return this.matchNegated;
            }
        }
        return !this.matchNegated;
    }

    public boolean equals(Object o) {
        if (o instanceof Scope) {
            Scope otherScope = (Scope)o;
            if (this.matchNegated != otherScope.matchNegated) {
                return false;
            }
            if (this.matchesNull != otherScope.matchesNull) {
                return false;
            }
            if (this.type == null ? otherScope.getType() != this.type : !this.type.equals(otherScope.getType())) {
                return false;
            }
            if (this.abilityID == null ? otherScope.getAbilityID() != this.abilityID : !this.abilityID.equals(otherScope.getAbilityID())) {
                return false;
            }
            if (this.abilityValue != otherScope.isAbilityValue()) {
                return false;
            }
            if (this.methodName == null ? otherScope.getMethodName() != this.methodName : !this.methodName.equals(otherScope.getMethodName())) {
                return false;
            }
            return !(this.methodValue == null ? otherScope.getMethodValue() != this.methodValue : !this.methodValue.equals(otherScope.getMethodValue()));
        }
        return false;
    }

    public void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.matchNegated = this.getAttribute(in, "matchNegated", false);
        this.matchesNull = this.getAttribute(in, "matchesNull", true);
        this.type = in.getAttributeValue(null, "type");
        this.abilityID = in.getAttributeValue(null, "ability-id");
        this.abilityValue = this.getAttribute(in, "ability-value", true);
        this.methodName = in.getAttributeValue(null, "method-name");
        this.methodValue = in.getAttributeValue(null, "method-value");
        in.nextTag();
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(Scope.getXMLElementTagName());
        out.writeAttribute("matchNegated", Boolean.toString(this.matchNegated));
        out.writeAttribute("matchesNull", Boolean.toString(this.matchesNull));
        out.writeAttribute("type", this.type);
        out.writeAttribute("ability-id", this.abilityID);
        out.writeAttribute("ability-value", String.valueOf(this.abilityValue));
        out.writeAttribute("method-name", this.methodName);
        out.writeAttribute("method-value", this.methodValue);
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "scope";
    }
}

