/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BonusOrPenalty;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Settlement
extends FreeColGameObject
implements Location,
Ownable {
    private static final Logger logger = Logger.getLogger(Settlement.class.getName());
    public static final int RADIUS = 1;
    public static final int FOOD_CONSUMPTION = 2;
    public static final Modifier DEFENCE_MODIFIER = new Modifier("model.modifier.defence", new BonusOrPenalty("modifiers.inSettlement"), 50.0f, Modifier.Type.PERCENTAGE);
    protected Player owner;
    protected Tile tile;
    protected GoodsContainer goodsContainer;
    protected FeatureContainer featureContainer = new FeatureContainer();

    public Settlement(Game game, Player owner, Tile tile) {
        super(game);
        this.tile = tile;
        this.owner = owner;
        this.featureContainer.addModifier(DEFENCE_MODIFIER);
        Map.CircleIterator exploreIt = game.getMap().getCircleIterator(tile.getPosition(), true, this.getLineOfSight());
        while (exploreIt.hasNext()) {
            Tile t = game.getMap().getTile((Map.Position)exploreIt.next());
            t.setExploredBy(owner, true);
        }
        this.tile.setExploredBy(owner, true);
        owner.invalidateCanSeeTiles();
        if (tile.getOwningSettlement() != null) {
            if (tile.getOwningSettlement() instanceof Colony) {
                Colony oc = tile.getColony();
                ColonyTile ct = oc.getColonyTile(tile);
                ct.relocateWorkers();
            } else if (tile.getOwningSettlement() instanceof IndianSettlement) {
                logger.warning("An indian settlement is already owning the tile.");
            } else {
                logger.warning("An unknown type of settlement is already owning the tile.");
            }
        }
        owner.addSettlement(this);
    }

    public Settlement(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public Settlement(Game game, Element e) {
        super(game, e);
    }

    public Settlement(Game game, String id) {
        super(game, id);
    }

    public FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    public int getLineOfSight() {
        return 2;
    }

    public abstract Unit getDefendingUnit(Unit var1);

    @Override
    public Tile getTile() {
        return this.tile;
    }

    public Tile getTile(int x, int y) {
        if (x == 0 && y == 0) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.N, this.tile);
        }
        if (x == 0 && y == 1) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.NE, this.tile);
        }
        if (x == 0 && y == 2) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.E, this.tile);
        }
        if (x == 1 && y == 0) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.NW, this.tile);
        }
        if (x == 1 && y == 1) {
            return this.tile;
        }
        if (x == 1 && y == 2) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.SE, this.tile);
        }
        if (x == 2 && y == 0) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.W, this.tile);
        }
        if (x == 2 && y == 1) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.SW, this.tile);
        }
        if (x == 2 && y == 2) {
            return this.getGame().getMap().getNeighbourOrNull(Map.Direction.S, this.tile);
        }
        return null;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player owner) {
        Player oldOwner = this.owner;
        this.owner = owner;
        if (oldOwner.hasSettlement(this)) {
            oldOwner.removeSettlement(this);
        }
        if (!owner.hasSettlement(this)) {
            owner.addSettlement(this);
        }
        oldOwner.invalidateCanSeeTiles();
        owner.setExplored(this.getTile());
        Map.CircleIterator positionIterator = this.getGame().getMap().getCircleIterator(this.getTile().getPosition(), true, this.getLineOfSight());
        while (positionIterator.hasNext()) {
            Map.Position p = (Map.Position)positionIterator.next();
            owner.setExplored(this.getGame().getMap().getTile(p));
        }
        if (this.getGame().getFreeColGameObjectListener() != null) {
            this.getGame().getFreeColGameObjectListener().ownerChanged(this, oldOwner, owner);
        }
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return this.goodsContainer;
    }

    public Iterator<Goods> getGoodsIterator() {
        return this.goodsContainer.getGoodsIterator();
    }

    public List<Goods> getCompactGoods() {
        return this.goodsContainer.getCompactGoods();
    }

    @Override
    public abstract void add(Locatable var1);

    @Override
    public abstract void remove(Locatable var1);

    @Override
    public abstract boolean canAdd(Locatable var1);

    @Override
    public abstract int getUnitCount();

    @Override
    public abstract boolean contains(Locatable var1);

    @Override
    public void dispose() {
        Tile settlementTile = this.getTile();
        Map map = this.getGame().getMap();
        Map.Position position = settlementTile.getPosition();
        Map.CircleIterator circleIterator = map.getCircleIterator(position, true, this.getRadius());
        settlementTile.setOwner(null);
        while (circleIterator.hasNext()) {
            Tile tile = map.getTile((Map.Position)circleIterator.next());
            if (tile.getOwningSettlement() != this) continue;
            tile.setOwningSettlement(null);
            tile.setOwner(null);
        }
        Player oldOwner = this.owner;
        this.owner = null;
        settlementTile.setSettlement(null);
        oldOwner.removeSettlement(this);
        oldOwner.invalidateCanSeeTiles();
        this.goodsContainer.dispose();
        super.dispose();
    }

    public int getRadius() {
        return 1;
    }

    public abstract void newTurn();

    public void removeGoods(GoodsType type, int amount) {
        this.goodsContainer.removeGoods(type, amount);
    }

    public void removeGoods(AbstractGoods goods) {
        this.goodsContainer.removeGoods(goods);
    }

    public void removeGoods(GoodsType type) {
        this.goodsContainer.removeGoods(type);
    }

    public void addGoods(GoodsType type, int amount) {
        this.goodsContainer.addGoods(type.getStoredAs(), amount);
    }

    public void addGoods(AbstractGoods goods) {
        this.addGoods(goods.getType(), goods.getAmount());
    }

    public int getGoodsCount(GoodsType type) {
        if (type != null && !type.isStoredAs()) {
            return this.goodsContainer.getGoodsCount(type);
        }
        return 0;
    }

    public abstract int getProductionOf(GoodsType var1);

    public int getFoodConsumption() {
        return 2 * this.getUnitCount();
    }

    public int getFoodConsumptionByType(GoodsType type) {
        if (!type.isFoodType()) {
            logger.warning("Good type given isnt food type");
            return 0;
        }
        int required = this.getFoodConsumption();
        int consumed = 0;
        GoodsType corn = FreeCol.getSpecification().getGoodsType("model.goods.food");
        for (GoodsType foodType : FreeCol.getSpecification().getGoodsFood()) {
            if (foodType == corn) continue;
            consumed = Math.min(this.getProductionOf(foodType), required);
            if (type == foodType) {
                return consumed;
            }
            required -= consumed;
        }
        consumed = Math.min(this.getProductionOf(corn), required);
        return consumed;
    }

    protected void removeFood(int amount) {
        int rest = amount;
        ArrayList<AbstractGoods> backlog = new ArrayList<AbstractGoods>();
        for (GoodsType foodType : FreeCol.getSpecification().getGoodsFood()) {
            int available = this.getGoodsCount(foodType);
            if (available >= rest) {
                this.removeGoods(foodType, rest);
                for (AbstractGoods food : backlog) {
                    this.removeGoods(food.getType(), food.getAmount());
                }
                rest = 0;
                continue;
            }
            backlog.add(new AbstractGoods(foodType, available));
            rest -= available;
        }
        if (rest > 0) {
            throw new IllegalStateException("Attempted to remove more food than was present.");
        }
    }

    public int getFoodCount() {
        int result = 0;
        for (GoodsType foodType : FreeCol.getSpecification().getGoodsFood()) {
            result += this.getGoodsCount(foodType);
        }
        return result;
    }

    public boolean canBuildEquipment(EquipmentType equipmentType) {
        for (AbstractGoods requiredGoods : equipmentType.getGoodsRequired()) {
            if (this.getGoodsCount(requiredGoods.getType()) >= requiredGoods.getAmount()) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SettlementType {
        SMALL,
        MEDIUM,
        LARGE,
        SMALL_STOCKADE,
        MEDIUM_STOCKADE,
        MEDIUM_FORT,
        LARGE_STOCKADE,
        LARGE_FORT,
        LARGE_FORTRESS,
        UNDEAD,
        INDIAN_CAMP,
        INDIAN_VILLAGE,
        AZTEC_CITY,
        INCA_CITY;

    }
}

