/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.PseudoRandom;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BonusOrPenalty;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelController;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCombatModel
implements CombatModel {
    private static final Logger logger = Logger.getLogger(SimpleCombatModel.class.getName());
    public static final int MAXIMUM_BOMBARD_POWER = 48;
    public static final BonusOrPenalty MOVEMENT_PENALTY_SOURCE = new BonusOrPenalty("modifiers.movementPenalty");
    public static final BonusOrPenalty ARTILLERY_PENALTY_SOURCE = new BonusOrPenalty("modifiers.artilleryPenalty");
    public static final BonusOrPenalty ATTACK_BONUS_SOURCE = new BonusOrPenalty("modifiers.attackBonus");
    public static final BonusOrPenalty FORTIFICATION_BONUS_SOURCE = new BonusOrPenalty("modifiers.fortified");
    public static final BonusOrPenalty INDIAN_RAID_BONUS_SOURCE = new BonusOrPenalty("modifiers.artilleryAgainstRaid");
    public static final BonusOrPenalty BASE_OFFENCE_SOURCE = new BonusOrPenalty("modifiers.baseOffence");
    public static final BonusOrPenalty BASE_DEFENCE_SOURCE = new BonusOrPenalty("modifiers.baseDefence");
    public static final BonusOrPenalty CARGO_PENALTY_SOURCE = new BonusOrPenalty("modifiers.cargoPenalty");
    public static final BonusOrPenalty AMBUSH_BONUS_SOURCE = new BonusOrPenalty("modifiers.ambushBonus");
    public static final Modifier SMALL_MOVEMENT_PENALTY = new Modifier("model.modifier.offence", MOVEMENT_PENALTY_SOURCE, -33.0f, Modifier.Type.PERCENTAGE);
    public static final Modifier BIG_MOVEMENT_PENALTY = new Modifier("model.modifier.offence", MOVEMENT_PENALTY_SOURCE, -66.0f, Modifier.Type.PERCENTAGE);
    public static final Modifier ARTILLERY_PENALTY = new Modifier("model.modifier.offence", ARTILLERY_PENALTY_SOURCE, -75.0f, Modifier.Type.PERCENTAGE);
    public static final Modifier ATTACK_BONUS = new Modifier("model.modifier.offence", ATTACK_BONUS_SOURCE, 50.0f, Modifier.Type.PERCENTAGE);
    public static final Modifier FORTIFICATION_BONUS = new Modifier("model.modifier.defence", FORTIFICATION_BONUS_SOURCE, 50.0f, Modifier.Type.PERCENTAGE);
    public static final Modifier INDIAN_RAID_BONUS = new Modifier("model.modifier.defence", INDIAN_RAID_BONUS_SOURCE, 100.0f, Modifier.Type.PERCENTAGE);
    private PseudoRandom random;

    @Override
    public CombatModel.CombatOdds calculateCombatOdds(Unit attacker, Unit defender) {
        if (attacker == null || defender == null) {
            return new CombatModel.CombatOdds(-1.0f);
        }
        float attackPower = this.getOffencePower(attacker, defender);
        float defencePower = this.getDefencePower(attacker, defender);
        if (attackPower == 0.0f && defencePower == 0.0f) {
            return new CombatModel.CombatOdds(-1.0f);
        }
        float victory = attackPower / (attackPower + defencePower);
        return new CombatModel.CombatOdds(victory);
    }

    public SimpleCombatModel(PseudoRandom pseudoRandom) {
        this.random = pseudoRandom;
    }

    @Override
    public CombatModel.CombatResult generateAttackResult(Unit attacker, Unit defender) {
        float attackPower = this.getOffencePower(attacker, defender);
        float defencePower = this.getDefencePower(attacker, defender);
        float victory = attackPower / (attackPower + defencePower);
        int damage = 0;
        int r = this.random.nextInt(100);
        CombatModel.CombatResultType result = CombatModel.CombatResultType.EVADES;
        if ((float)r <= victory * 20.0f) {
            result = CombatModel.CombatResultType.GREAT_WIN;
            damage = defender.getHitpoints();
        } else if ((float)r <= 100.0f * victory) {
            result = CombatModel.CombatResultType.WIN;
            damage = defender.getHitpoints() - 1;
        } else if (defender.isNaval() && (float)r <= 80.0f * victory + 20.0f) {
            result = CombatModel.CombatResultType.EVADES;
        } else if ((float)r <= 10.0f * victory + 90.0f) {
            result = CombatModel.CombatResultType.LOSS;
            damage = attacker.getHitpoints() - 1;
        } else {
            result = CombatModel.CombatResultType.GREAT_LOSS;
            damage = attacker.getHitpoints();
        }
        if (defender.isNaval() && result == CombatModel.CombatResultType.WIN && defender.getOwner().getRepairLocation(defender) == null) {
            result = CombatModel.CombatResultType.GREAT_WIN;
            damage = defender.getHitpoints();
        }
        if (attacker.isNaval() && result == CombatModel.CombatResultType.LOSS && attacker.getOwner().getRepairLocation(attacker) == null) {
            result = CombatModel.CombatResultType.GREAT_LOSS;
            damage = defender.getHitpoints();
        }
        if (result.compareTo(CombatModel.CombatResultType.WIN) >= 0 && defender.getTile().getSettlement() != null) {
            if (defender.getTile().getSettlement() instanceof Colony) {
                if (!defender.isDefensiveUnit() && defender.getAutomaticEquipment() == null) {
                    result = CombatModel.CombatResultType.DONE_SETTLEMENT;
                }
            } else if (defender.getTile().getSettlement() instanceof IndianSettlement) {
                if (defender.getTile().getUnitCount() + defender.getTile().getSettlement().getUnitCount() <= 1) {
                    result = CombatModel.CombatResultType.DONE_SETTLEMENT;
                }
            } else {
                throw new IllegalStateException("Unknown Settlement.");
            }
        }
        return new CombatModel.CombatResult(result, damage);
    }

    @Override
    public CombatModel.CombatResult generateAttackResult(Colony colony, Unit defender) {
        float attackPower = this.getOffencePower(colony, defender);
        float defencePower = this.getDefencePower(colony, defender);
        float totalProbability = attackPower + defencePower;
        int damage = 0;
        CombatModel.CombatResultType result = CombatModel.CombatResultType.EVADES;
        int r = this.random.nextInt(Math.round(totalProbability) + 1);
        if ((float)r < attackPower) {
            int diff = Math.round(defencePower * 2.0f - attackPower);
            int r2 = this.random.nextInt(diff < 3 ? 3 : diff);
            if (r2 == 0) {
                result = CombatModel.CombatResultType.GREAT_WIN;
                damage = defender.getHitpoints();
            } else {
                result = CombatModel.CombatResultType.WIN;
                damage = defender.getHitpoints() - 1;
                if (defender.isNaval() && defender.getOwner().getRepairLocation(defender) == null) {
                    result = CombatModel.CombatResultType.GREAT_WIN;
                    damage = defender.getHitpoints();
                }
            }
        }
        return new CombatModel.CombatResult(result, damage);
    }

    @Override
    public float getOffencePower(Colony colony, Unit defender) {
        float attackPower = 0.0f;
        if (defender.isNaval() && colony.hasAbility("model.ability.bombardShips")) {
            for (Unit unit : colony.getTile().getUnitList()) {
                if (!unit.hasAbility("model.ability.bombard") || !((attackPower += (float)unit.getType().getOffence()) >= 48.0f)) continue;
                return 48.0f;
            }
        }
        return attackPower;
    }

    @Override
    public float getOffencePower(Unit attacker, Unit defender) {
        return FeatureContainer.applyModifierSet(0.0f, attacker.getGame().getTurn(), this.getOffensiveModifiers(attacker, defender));
    }

    @Override
    public Set<Modifier> getOffensiveModifiers(Colony colony, Unit defender) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.add(new Modifier("model.modifier.bombardModifier", this.getOffencePower(colony, defender), Modifier.Type.ADDITIVE));
        return result;
    }

    @Override
    public Set<Modifier> getOffensiveModifiers(Unit attacker, Unit defender) {
        LinkedHashSet<Modifier> result = new LinkedHashSet<Modifier>();
        result.add(new Modifier("model.modifier.offence", BASE_OFFENCE_SOURCE, attacker.getType().getOffence(), Modifier.Type.ADDITIVE));
        result.addAll(attacker.getType().getFeatureContainer().getModifierSet("model.modifier.offence"));
        result.addAll(attacker.getOwner().getFeatureContainer().getModifierSet("model.modifier.offence", attacker.getType()));
        if (attacker.isNaval()) {
            int goodsCount = attacker.getGoodsCount();
            if (goodsCount > 0) {
                result.add(new Modifier("model.modifier.offence", CARGO_PENALTY_SOURCE, -12.5f * (float)goodsCount, Modifier.Type.PERCENTAGE));
            }
        } else {
            for (EquipmentType equipment : attacker.getEquipment()) {
                result.addAll(equipment.getFeatureContainer().getModifierSet("model.modifier.offence"));
            }
            result.add(ATTACK_BONUS);
            int movesLeft = attacker.getMovesLeft();
            if (movesLeft == 1) {
                result.add(BIG_MOVEMENT_PENALTY);
            } else if (movesLeft == 2) {
                result.add(SMALL_MOVEMENT_PENALTY);
            }
            if (defender != null && defender.getTile() != null) {
                if (defender.getTile().getSettlement() == null) {
                    if (attacker.hasAbility("model.ability.ambushBonus") || defender.hasAbility("model.ability.ambushPenalty")) {
                        Set<Modifier> ambushModifiers = defender.getTile().getType().getModifierSet("model.modifier.defence");
                        for (Modifier modifier : ambushModifiers) {
                            Modifier ambushModifier = new Modifier(modifier);
                            ambushModifier.setId("model.modifier.offence");
                            ambushModifier.setSource(AMBUSH_BONUS_SOURCE);
                            result.add(ambushModifier);
                        }
                    }
                    if (attacker.hasAbility("model.ability.bombard") && attacker.getTile().getSettlement() == null) {
                        result.add(ARTILLERY_PENALTY);
                    }
                } else {
                    result.addAll(attacker.getModifierSet("model.modifier.bombardBonus"));
                }
            }
        }
        return result;
    }

    @Override
    public float getDefencePower(Colony colony, Unit defender) {
        return defender.getType().getDefence();
    }

    @Override
    public float getDefencePower(Unit attacker, Unit defender) {
        return FeatureContainer.applyModifierSet(0.0f, attacker.getGame().getTurn(), this.getDefensiveModifiers(attacker, defender));
    }

    @Override
    public Set<Modifier> getDefensiveModifiers(Colony colony, Unit defender) {
        LinkedHashSet<Modifier> result = new LinkedHashSet<Modifier>();
        result.add(new Modifier("model.modifier.defenceBonus", defender.getType().getDefence(), Modifier.Type.ADDITIVE));
        return result;
    }

    @Override
    public Set<Modifier> getDefensiveModifiers(Unit attacker, Unit defender) {
        LinkedHashSet<Modifier> result = new LinkedHashSet<Modifier>();
        if (defender == null) {
            return result;
        }
        result.add(new Modifier("model.modifier.defence", BASE_DEFENCE_SOURCE, defender.getType().getDefence(), Modifier.Type.ADDITIVE));
        result.addAll(defender.getType().getFeatureContainer().getModifierSet("model.modifier.defence"));
        if (defender.isNaval()) {
            int goodsCount = defender.getVisibleGoodsCount();
            if (goodsCount > 0) {
                result.add(new Modifier("model.modifier.defence", CARGO_PENALTY_SOURCE, -12.5f * (float)goodsCount, Modifier.Type.PERCENTAGE));
            }
        } else {
            List<EquipmentType> autoEquipList = defender.getAutomaticEquipment();
            if (autoEquipList != null) {
                for (EquipmentType equipment : autoEquipList) {
                    result.addAll(equipment.getModifierSet("model.modifier.defence"));
                }
            }
            for (EquipmentType equipment : defender.getEquipment()) {
                result.addAll(equipment.getFeatureContainer().getModifierSet("model.modifier.defence"));
            }
            if (defender.getState() == Unit.UnitState.FORTIFIED) {
                result.add(FORTIFICATION_BONUS);
            }
            if (defender.getTile() != null) {
                Tile tile = defender.getTile();
                if (tile.getSettlement() == null) {
                    if (!attacker.hasAbility("model.ability.ambushBonus") && !defender.hasAbility("model.ability.ambushPenalty")) {
                        result.addAll(tile.getType().getDefenceBonus());
                    }
                    if (defender.hasAbility("model.ability.bombard") && defender.getState() != Unit.UnitState.FORTIFIED) {
                        result.add(ARTILLERY_PENALTY);
                    }
                } else {
                    result.addAll(tile.getSettlement().getFeatureContainer().getModifierSet("model.modifier.defence"));
                    if (defender.hasAbility("model.ability.bombard") && attacker.getOwner().isIndian()) {
                        result.add(INDIAN_RAID_BONUS);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void attack(Unit attacker, Unit defender, CombatModel.CombatResult result, int plunderGold, Location repairLocation) {
        Player attackingPlayer = attacker.getOwner();
        Player defendingPlayer = defender.getOwner();
        if (attacker.hasAbility("model.ability.piracy")) {
            defendingPlayer.setAttackedByPrivateers();
        } else if (!defender.hasAbility("model.ability.piracy")) {
            attackingPlayer.changeRelationWithPlayer(defendingPlayer, Player.Stance.WAR);
        }
        attacker.setState(Unit.UnitState.ACTIVE);
        if (!attacker.hasAbility("model.ability.multipleAttacks")) {
            attacker.setMovesLeft(0);
        }
        Tile newTile = defender.getTile();
        Settlement settlement = newTile.getSettlement();
        List<EquipmentType> autoEquipList = defender.getAutomaticEquipment();
        if (autoEquipList != null) {
            defender.addModelMessage((FreeColGameObject)defender, ModelMessage.MessageType.COMBAT_RESULT, defender, "model.unit.automaticDefence", "%unit%", defender.getName(), "%colony%", settlement.getLocationName());
        }
        switch (result.type) {
            case EVADES: {
                if (attacker.isNaval()) {
                    this.evade(defender, null, attacker);
                    break;
                }
                logger.warning("Non-naval unit evades!");
                break;
            }
            case LOSS: {
                if (attacker.isNaval()) {
                    this.damageShip(attacker, null, defender, repairLocation);
                    break;
                }
                this.loseCombat(attacker, defender);
                if (!defendingPlayer.hasAbility("model.ability.automaticPromotion")) break;
                this.promote(defender);
                break;
            }
            case GREAT_LOSS: {
                if (attacker.isNaval()) {
                    this.sinkShip(attacker, null, defender);
                    break;
                }
                this.loseCombat(attacker, defender);
                this.promote(defender);
                break;
            }
            case DONE_SETTLEMENT: {
                if (settlement instanceof IndianSettlement) {
                    defender.dispose();
                    this.destroySettlement(attacker, (IndianSettlement)settlement);
                } else if (settlement instanceof Colony) {
                    this.captureColony(attacker, (Colony)settlement, plunderGold, repairLocation);
                } else {
                    throw new IllegalStateException("Unknown type of settlement.");
                }
                this.promote(attacker);
                break;
            }
            case WIN: {
                if (attacker.isNaval()) {
                    attacker.captureGoods(defender);
                    this.damageShip(defender, null, attacker, repairLocation);
                    break;
                }
                if (attacker.hasAbility("model.ability.pillageUnprotectedColony") && !defender.isDefensiveUnit() && defender.getColony() != null && !defender.getColony().hasStockade() && defender.getAutomaticEquipment() == null) {
                    this.pillageColony(attacker, defender.getColony(), repairLocation);
                    break;
                }
                if (!defender.isNaval()) {
                    this.loseCombat(defender, attacker);
                    if (settlement instanceof IndianSettlement) {
                        this.getConvert(attacker, (IndianSettlement)settlement);
                    }
                }
                if (!attacker.hasAbility("model.ability.automaticPromotion")) break;
                this.promote(attacker);
                break;
            }
            case GREAT_WIN: {
                if (attacker.isNaval()) {
                    attacker.captureGoods(defender);
                    this.sinkShip(defender, null, attacker);
                    break;
                }
                if (!defender.isNaval()) {
                    this.loseCombat(defender, attacker);
                    if (settlement instanceof IndianSettlement) {
                        this.getConvert(attacker, (IndianSettlement)settlement);
                    }
                }
                this.promote(attacker);
                break;
            }
            default: {
                logger.warning("Illegal result of attack!");
                throw new IllegalArgumentException("Illegal result of attack!");
            }
        }
    }

    @Override
    public void bombard(Colony colony, Unit defender, CombatModel.CombatResult result, Location repairLocation) {
        switch (result.type) {
            case EVADES: {
                this.evade(defender, colony, null);
                break;
            }
            case WIN: {
                this.damageShip(defender, colony, null, repairLocation);
                break;
            }
            case GREAT_WIN: {
                this.sinkShip(defender, colony, null);
                break;
            }
            case DONE_SETTLEMENT: {
                assert (false);
                break;
            }
        }
    }

    public void captureColony(Unit attacker, Colony colony, int plunderGold, Location repairLocation) {
        Player enemy = colony.getOwner();
        Player myPlayer = attacker.getOwner();
        enemy.modifyTension(attacker.getOwner(), 300);
        if (myPlayer.isEuropean()) {
            UnitType downgrade;
            myPlayer.getHistory().add(new HistoryEvent(myPlayer.getGame().getTurn().getNumber(), HistoryEvent.Type.CONQUER_COLONY, "%nation%", enemy.getNationAsString(), "%colony%", colony.getName()));
            enemy.getHistory().add(new HistoryEvent(enemy.getGame().getTurn().getNumber(), HistoryEvent.Type.COLONY_CONQUERED, "%colony%", colony.getName(), "%nation%", myPlayer.getNationAsString()));
            enemy.addModelMessage((FreeColGameObject)enemy, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyCapturedBy", "%colony%", colony.getName(), "%amount%", Integer.toString(plunderGold), "%player%", myPlayer.getNationAsString());
            this.damageAllShips(colony, attacker, repairLocation);
            myPlayer.modifyGold(plunderGold);
            enemy.modifyGold(-plunderGold);
            enemy.divertModelMessages(colony, enemy);
            colony.setOwner(myPlayer);
            for (Unit capturedUnit : colony.getUnitList()) {
                enemy.divertModelMessages(capturedUnit, enemy);
                if (capturedUnit.getType().isAvailableTo(myPlayer)) continue;
                downgrade = capturedUnit.getType().getDowngrade(UnitType.DowngradeType.CAPTURE);
                if (downgrade != null && downgrade.isAvailableTo(myPlayer)) {
                    capturedUnit.setType(downgrade);
                    continue;
                }
                capturedUnit.dispose();
            }
            myPlayer.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyCaptured", "%colony%", colony.getName(), "%amount%", Integer.toString(plunderGold));
            for (Unit capturedUnit : colony.getTile().getUnitList()) {
                enemy.divertModelMessages(capturedUnit, enemy);
                if (attacker.isUndead()) {
                    capturedUnit.setType(attacker.getType());
                } else {
                    downgrade = capturedUnit.getType().getDowngrade(UnitType.DowngradeType.CAPTURE);
                    if (downgrade != null) {
                        capturedUnit.setType(downgrade);
                    }
                }
                capturedUnit.setState(Unit.UnitState.ACTIVE);
            }
            for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
                colony.getExportData(goodsType).setExported(false);
            }
            if (attacker.isUndead()) {
                for (Unit capturedUnit : colony.getUnitList()) {
                    capturedUnit.setType(attacker.getType());
                }
            }
            attacker.setLocation(colony.getTile());
        } else if (colony.getUnitCount() <= 1) {
            myPlayer.getHistory().add(new HistoryEvent(myPlayer.getGame().getTurn().getNumber(), HistoryEvent.Type.COLONY_DESTROYED, "%nation%", enemy.getNationAsString(), "%colony%", colony.getName()));
            myPlayer.addModelMessage((FreeColGameObject)enemy, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyBurning", "%colony%", colony.getName(), "%amount%", Integer.toString(plunderGold), "%nation%", myPlayer.getNationAsString(), "%unit%", attacker.getName());
            myPlayer.modifyGold(plunderGold);
            enemy.modifyGold(-plunderGold);
            this.damageAllShips(colony, attacker, repairLocation);
            enemy.divertModelMessages(colony, enemy);
            for (Unit victim : colony.getUnitList()) {
                enemy.divertModelMessages(victim, enemy);
                victim.dispose();
            }
            colony.dispose();
            attacker.setLocation(colony.getTile());
        } else {
            Unit victim = colony.getRandomUnit();
            if (victim == null) {
                logger.warning("could not find colonist to slaughter");
            } else {
                myPlayer.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonistSlaughtered", "%colony%", colony.getName(), "%unit%", victim.getName(), "%nation%", myPlayer.getNationAsString(), "%enemyUnit%", attacker.getName());
                enemy.divertModelMessages(victim, enemy);
                victim.dispose();
            }
        }
    }

    private void damageAllShips(Colony colony, Unit attacker, Location repairLocation) {
        ArrayList<Unit> navalUnitsOutsideColony = new ArrayList<Unit>();
        for (Unit unit : colony.getTile().getUnitList()) {
            if (!unit.isNaval()) continue;
            navalUnitsOutsideColony.add(unit);
        }
        for (Unit unit : navalUnitsOutsideColony) {
            this.damageShip(unit, null, attacker, repairLocation);
        }
    }

    private void pillageColony(Unit attacker, Colony colony, Location repairLocation) {
        ArrayList<Building> buildingList = new ArrayList<Building>();
        ArrayList<Unit> shipList = new ArrayList<Unit>();
        List<Goods> goodsList = colony.getGoodsContainer().getCompactGoods();
        for (Building building : colony.getBuildings()) {
            if (!building.canBeDamaged()) continue;
            buildingList.add(building);
        }
        List<Unit> unitList = colony.getTile().getUnitList();
        for (Unit unit : unitList) {
            if (!unit.isNaval()) continue;
            shipList.add(unit);
        }
        String nation = attacker.getOwner().getNationAsString();
        String unitName = attacker.getName();
        String colonyName = colony.getName();
        int limit = buildingList.size() + goodsList.size() + shipList.size() + 1;
        int random = attacker.getGame().getModelController().getRandom(attacker.getId() + "pillageColony", limit);
        if (random < buildingList.size()) {
            Building building = (Building)buildingList.get(random);
            colony.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.COMBAT_RESULT, colony, "model.unit.buildingDamaged", "%building%", building.getName(), "%colony%", colonyName, "%enemyNation%", nation, "%enemyUnit%", unitName);
            building.damage();
        } else if (random < buildingList.size() + goodsList.size()) {
            Goods goods = goodsList.get(random - buildingList.size());
            goods.setAmount(Math.min(goods.getAmount() / 2, 50));
            colony.removeGoods(goods);
            if (attacker.getSpaceLeft() > 0) {
                attacker.add(goods);
            }
            colony.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.COMBAT_RESULT, goods, "model.unit.goodsStolen", "%amount%", String.valueOf(goods.getAmount()), "%goods%", goods.getName(), "%colony%", colonyName, "%enemyNation%", nation, "%enemyUnit%", unitName);
        } else if (random < buildingList.size() + goodsList.size() + shipList.size()) {
            Unit ship = (Unit)shipList.get(random - buildingList.size() - goodsList.size());
            this.damageShip(ship, null, attacker, repairLocation);
        } else {
            int gold = colony.getOwner().getGold() / 10;
            colony.getOwner().modifyGold(-gold);
            attacker.getOwner().modifyGold(gold);
            colony.addModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.COMBAT_RESULT, colony, "model.unit.indianPlunder", "%amount%", String.valueOf(gold), "%colony%", colonyName, "%enemyNation%", nation, "%enemyUnit%", unitName);
        }
    }

    private void destroySettlement(Unit attacker, IndianSettlement settlement) {
        Player enemy = settlement.getOwner();
        boolean wasCapital = settlement.isCapital();
        Tile newTile = settlement.getTile();
        ModelController modelController = attacker.getGame().getModelController();
        Settlement.SettlementType settlementType = ((IndianNationType)enemy.getNationType()).getTypeOfSettlement();
        settlement.dispose();
        enemy.modifyTension(attacker.getOwner(), 300);
        List<UnitType> treasureUnitTypes = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.carryTreasure");
        if (treasureUnitTypes.size() > 0) {
            int randomTreasure = modelController.getRandom(attacker.getId() + "indianTreasureRandom" + attacker.getId(), 11);
            int random = modelController.getRandom(attacker.getId() + "newUnitForTreasure" + attacker.getId(), treasureUnitTypes.size());
            Unit tTrain = modelController.createUnit(attacker.getId() + "indianTreasure" + attacker.getId(), newTile, attacker.getOwner(), treasureUnitTypes.get(random));
            Set<Modifier> modifierSet = attacker.getModifierSet("model.modifier.nativeTreasureModifier");
            randomTreasure = (int)FeatureContainer.applyModifierSet(randomTreasure, attacker.getGame().getTurn(), modifierSet);
            if (settlementType == Settlement.SettlementType.INCA_CITY || settlementType == Settlement.SettlementType.AZTEC_CITY) {
                tTrain.setTreasureAmount(randomTreasure * 500 + 1000);
            } else {
                tTrain.setTreasureAmount(randomTreasure * 50 + 300);
            }
            if (wasCapital) {
                tTrain.setTreasureAmount(tTrain.getTreasureAmount() * 3 / 2);
            }
            attacker.addModelMessage((FreeColGameObject)attacker, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianTreasure", "%indian%", enemy.getNationAsString(), "%amount%", Integer.toString(tTrain.getTreasureAmount()));
        }
        int atrocities = -40;
        if (settlementType == Settlement.SettlementType.INCA_CITY || settlementType == Settlement.SettlementType.AZTEC_CITY) {
            atrocities *= 2;
        }
        if (wasCapital) {
            atrocities = atrocities * 3 / 2;
        }
        attacker.getOwner().modifyScore(atrocities);
        attacker.setLocation(newTile);
        attacker.getOwner().getHistory().add(new HistoryEvent(attacker.getGame().getTurn().getNumber(), HistoryEvent.Type.DESTROY_SETTLEMENT, "%nation%", enemy.getNationAsString()));
        if (enemy.getSettlements().isEmpty()) {
            attacker.getOwner().getHistory().add(new HistoryEvent(attacker.getGame().getTurn().getNumber(), HistoryEvent.Type.DESTROY_NATION, "%nation%", enemy.getNationAsString()));
        }
    }

    private void getConvert(Unit attacker, IndianSettlement indianSettlement) {
        ModelController modelController = attacker.getGame().getModelController();
        int random = modelController.getRandom(attacker.getId() + "getConvert", 100);
        int convertProbability = (int)FeatureContainer.applyModifierSet(Specification.getSpecification().getIntegerOption("model.option.nativeConvertProbability").getValue(), attacker.getGame().getTurn(), attacker.getModifierSet("model.modifier.nativeConvertBonus"));
        int burnProbability = Specification.getSpecification().getIntegerOption("model.option.burnProbability").getValue();
        if (random < convertProbability) {
            List<UnitType> converts;
            Unit missionary = indianSettlement.getMissionary();
            if (missionary != null && missionary.getOwner() == attacker.getOwner() && attacker.getGame().getViewOwner() == null && indianSettlement.getUnitCount() > 1 && (converts = FreeCol.getSpecification().getUnitTypesWithAbility("model.ability.convert")).size() > 0) {
                indianSettlement.getFirstUnit().dispose();
                random = modelController.getRandom(attacker.getId() + "getConvertType", converts.size());
                modelController.createUnit(attacker.getId() + "indianConvert", attacker.getLocation(), attacker.getOwner(), converts.get(random));
            }
        } else if (random >= 100 - burnProbability) {
            boolean burn = false;
            List<Settlement> settlements = indianSettlement.getOwner().getSettlements();
            for (Settlement settlement : settlements) {
                IndianSettlement indian = (IndianSettlement)settlement;
                Unit missionary = indian.getMissionary();
                if (missionary == null || missionary.getOwner() != attacker.getOwner()) continue;
                burn = true;
                indian.setMissionary(null);
            }
            if (burn) {
                attacker.addModelMessage((FreeColGameObject)attacker, ModelMessage.MessageType.COMBAT_RESULT, indianSettlement, "model.unit.burnMissions", "%nation%", attacker.getOwner().getNationAsString(), "%enemyNation%", indianSettlement.getOwner().getNationAsString());
            }
        }
    }

    private void evade(Unit defender, Colony attackerColony, Unit attackerUnit) {
        String nation = defender.getApparentOwnerName();
        if (attackerColony != null) {
            attackerColony.addModelMessage((FreeColGameObject)attackerColony, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvadedBombardment", "%colony%", attackerColony.getName(), "%unit%", defender.getName(), "%nation%", nation);
            defender.addModelMessage((FreeColGameObject)defender, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvadedBombardment", "%colony%", attackerColony.getName(), "%unit%", defender.getName(), "%nation%", nation);
        } else if (attackerUnit != null) {
            String attackerNation = attackerUnit.getApparentOwnerName();
            attackerUnit.addModelMessage((FreeColGameObject)attackerUnit, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipEvaded", "%unit%", attackerUnit.getName(), "%enemyUnit%", defender.getName(), "%enemyNation%", nation);
            defender.addModelMessage((FreeColGameObject)defender, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvaded", "%unit%", defender.getName(), "%enemyUnit%", attackerUnit.getName(), "%enemyNation%", attackerNation);
        }
    }

    private void damageShip(Unit damagedShip, Colony attackerColony, Unit attackerUnit, Location repairLocation) {
        String repairLocationName;
        String nation = damagedShip.getApparentOwnerName();
        String string = repairLocationName = repairLocation == null ? "" : repairLocation.getLocationName();
        if (attackerColony != null) {
            attackerColony.addModelMessage((FreeColGameObject)attackerColony, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipDamagedByBombardment", "%colony%", attackerColony.getName(), "%nation%", nation, "%unit%", damagedShip.getName());
            damagedShip.addModelMessage((FreeColGameObject)damagedShip, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipDamagedByBombardment", "%colony%", attackerColony.getName(), "%unit%", damagedShip.getName(), "%repairLocation%", repairLocationName);
        } else if (attackerUnit != null) {
            String attackerNation = attackerUnit.getApparentOwnerName();
            attackerUnit.addModelMessage((FreeColGameObject)attackerUnit, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipDamaged", "%unit%", attackerUnit.getName(), "%enemyNation%", nation, "%enemyUnit%", damagedShip.getName());
            damagedShip.addModelMessage((FreeColGameObject)damagedShip, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipDamaged", "%unit%", damagedShip.getName(), "%enemyUnit%", attackerUnit.getName(), "%enemyNation%", attackerNation, "%repairLocation%", repairLocationName);
        }
        damagedShip.setHitpoints(1);
        damagedShip.disposeAllUnits();
        damagedShip.getGoodsContainer().removeAll();
        damagedShip.setDestination(null);
        damagedShip.sendToRepairLocation(repairLocation);
    }

    private void sinkShip(Unit sinkingShip, Colony attackerColony, Unit attackerUnit) {
        String nation = sinkingShip.getApparentOwnerName();
        if (attackerColony != null) {
            attackerColony.addModelMessage((FreeColGameObject)attackerColony, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunkByBombardment", "%colony%", attackerColony.getName(), "%unit%", sinkingShip.getName(), "%nation%", nation);
            sinkingShip.addModelMessage((FreeColGameObject)sinkingShip, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunkByBombardment", "%colony%", attackerColony.getName(), "%unit%", sinkingShip.getName());
        } else if (attackerUnit != null) {
            String attackerNation = attackerUnit.getApparentOwnerName();
            attackerUnit.addModelMessage((FreeColGameObject)attackerUnit, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipSunk", "%unit%", attackerUnit.getName(), "%enemyUnit%", sinkingShip.getName(), "%enemyNation%", nation);
            sinkingShip.addModelMessage((FreeColGameObject)sinkingShip, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunk", "%unit%", sinkingShip.getName(), "%enemyUnit%", attackerUnit.getName(), "%enemyNation%", attackerNation);
        }
        sinkingShip.getOwner().divertModelMessages(sinkingShip, sinkingShip.getTile());
        sinkingShip.dispose();
    }

    private EquipmentType findEquipmentTypeToLose(Unit victim) {
        List<EquipmentType> autoEquipment;
        EquipmentType toLose = null;
        int combatLossPriority = 0;
        List<EquipmentType> equipmentList = victim.getEquipment();
        if (equipmentList.isEmpty() && (autoEquipment = victim.getAutomaticEquipment()) != null) {
            equipmentList = autoEquipment;
        }
        for (EquipmentType equipmentType : equipmentList) {
            if (equipmentType.getCombatLossPriority() <= combatLossPriority) continue;
            toLose = equipmentType;
            combatLossPriority = equipmentType.getCombatLossPriority();
        }
        return toLose;
    }

    private void loseCombat(Unit unit, Unit enemyUnit) {
        boolean unitCanBeCaptured;
        boolean hasEquipToLose;
        if (unit.hasAbility("model.ability.disposeOnCombatLoss")) {
            this.slaughterUnit(unit, enemyUnit);
            return;
        }
        EquipmentType typeToLose = this.findEquipmentTypeToLose(unit);
        boolean bl = hasEquipToLose = typeToLose != null;
        if (hasEquipToLose) {
            if (this.losingEquipDiscardsUnit(unit, typeToLose)) {
                this.slaughterUnit(unit, enemyUnit);
            } else {
                this.disarmUnit(unit, typeToLose, enemyUnit);
            }
            return;
        }
        UnitType downgrade = unit.getType().getDowngrade(UnitType.DowngradeType.DEMOTION);
        if (downgrade != null) {
            this.demoteUnit(unit, downgrade, enemyUnit);
            return;
        }
        boolean bl2 = unitCanBeCaptured = unit.hasAbility("model.ability.canBeCaptured") && enemyUnit.hasAbility("model.ability.captureUnits");
        if (unitCanBeCaptured) {
            this.captureUnit(unit, enemyUnit);
        } else {
            this.slaughterUnit(unit, enemyUnit);
        }
    }

    private boolean losingEquipDiscardsUnit(Unit unit, EquipmentType typeToLose) {
        if (!unit.hasAbility("model.ability.disposeOnAllEquipLost")) {
            return false;
        }
        for (EquipmentType equip : unit.getEquipment()) {
            if (equip == typeToLose) continue;
            return false;
        }
        return true;
    }

    private void captureUnit(Unit unit, Unit enemyUnit) {
        String locationName = unit.getLocation().getLocationName();
        Player loser = unit.getOwner();
        String nation = loser.getNationAsString();
        String oldName = unit.getName();
        String enemyNation = enemyUnit.getOwner().getNationAsString();
        String messageID = Messages.getKey(unit.getType().getId() + ".captured", "model.unit.unitCaptured");
        unit.addModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%unit%", oldName, "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
        loser.divertModelMessages(unit, unit.getTile());
        unit.setLocation(enemyUnit.getTile());
        unit.setOwner(enemyUnit.getOwner());
        if (enemyUnit.isUndead()) {
            unit.setType(enemyUnit.getType());
        } else {
            UnitType downgrade = unit.getType().getDowngrade(UnitType.DowngradeType.CAPTURE);
            if (downgrade != null) {
                unit.setType(downgrade);
            }
        }
        enemyUnit.addModelMessage((FreeColGameObject)enemyUnit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%unit%", oldName, "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
    }

    private void demoteUnit(Unit unit, UnitType downgrade, Unit enemyUnit) {
        String locationName = unit.getLocation().getLocationName();
        String nation = unit.getOwner().getNationAsString();
        String oldName = unit.getName();
        String enemyNation = enemyUnit.getOwner().getNationAsString();
        String messageID = Messages.getKey(unit.getType().getId() + ".demoted", "model.unit.unitDemoted");
        unit.setType(downgrade);
        enemyUnit.addModelMessage((FreeColGameObject)enemyUnit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%oldName%", oldName, "%unit%", unit.getName(), "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
        unit.addModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%oldName%", oldName, "%unit%", unit.getName(), "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
    }

    private void disarmUnit(Unit unit, EquipmentType typeToLose, Unit enemyUnit) {
        boolean hasAutoEquipment;
        String locationName = unit.getLocation().getLocationName();
        String nation = unit.getOwner().getNationAsString();
        String oldName = unit.getName();
        String enemyNation = enemyUnit.getOwner().getNationAsString();
        String messageID = Messages.getKey(unit.getType().getId() + ".demoted", "model.unit.unitDemoted");
        boolean bl = hasAutoEquipment = unit.getEquipment().isEmpty() && unit.getAutomaticEquipment() != null;
        if (hasAutoEquipment) {
            Settlement settlement = null;
            settlement = unit.getLocation() instanceof IndianSettlement ? unit.getIndianSettlement() : unit.getColony();
            for (AbstractGoods goods : typeToLose.getGoodsRequired()) {
                settlement.removeGoods(goods);
            }
        } else {
            unit.removeEquipment(typeToLose, true);
            if (unit.getEquipment().isEmpty()) {
                messageID = "model.unit.unitDemotedToUnarmed";
            }
        }
        enemyUnit.addModelMessage((FreeColGameObject)enemyUnit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%oldName%", oldName, "%unit%", unit.getName(), "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
        unit.addModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%oldName%", oldName, "%unit%", unit.getName(), "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
        this.enemyCapturesEquipment(unit, enemyUnit, typeToLose);
    }

    private void enemyCapturesEquipment(Unit unit, Unit enemyUnit, EquipmentType typeToLose) {
        if (!enemyUnit.hasAbility("model.ability.captureEquipment")) {
            return;
        }
        EquipmentType newEquipType = typeToLose;
        if (!unit.getOwner().isIndian() && enemyUnit.getOwner().isIndian()) {
            if (typeToLose == FreeCol.getSpecification().getEquipmentType("model.equipment.horses")) {
                newEquipType = FreeCol.getSpecification().getEquipmentType("model.equipment.indian.horses");
            }
            if (typeToLose == FreeCol.getSpecification().getEquipmentType("model.equipment.muskets")) {
                newEquipType = FreeCol.getSpecification().getEquipmentType("model.equipment.indian.muskets");
            }
        }
        if (unit.getOwner().isIndian() && !enemyUnit.getOwner().isIndian()) {
            if (typeToLose == FreeCol.getSpecification().getEquipmentType("model.equipment.indian.horses")) {
                newEquipType = FreeCol.getSpecification().getEquipmentType("model.equipment.horses");
            }
            if (typeToLose == FreeCol.getSpecification().getEquipmentType("model.equipment.indian.muskets")) {
                newEquipType = FreeCol.getSpecification().getEquipmentType("model.equipment.muskets");
            }
        }
        if (!enemyUnit.canBeEquippedWith(newEquipType)) {
            return;
        }
        IndianSettlement settlement = enemyUnit.getIndianSettlement();
        enemyUnit.equipWith(newEquipType, true);
        unit.addModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.equipmentCaptured", "%nation%", enemyUnit.getOwner().getNationAsString(), "%equipment%", typeToLose.getName());
        if (settlement != null) {
            for (AbstractGoods goods : typeToLose.getGoodsRequired()) {
                settlement.addGoods(goods);
            }
        }
    }

    private void slaughterUnit(Unit unit, Unit enemyUnit) {
        String locationName = enemyUnit.getLocation().getLocationName();
        Player loser = unit.getOwner();
        String nation = loser.getNationAsString();
        String enemyNation = enemyUnit.getOwner().getNationAsString();
        String messageID = Messages.getKey(unit.getType().getId() + ".destroyed", "model.unit.unitSlaughtered");
        enemyUnit.addModelMessage((FreeColGameObject)enemyUnit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%unit%", unit.getName(), "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
        unit.addModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.COMBAT_RESULT, messageID, "%nation%", nation, "%unit%", unit.getName(), "%enemyNation%", enemyNation, "%enemyUnit%", enemyUnit.getName(), "%location%", locationName);
        for (EquipmentType equip : unit.getEquipment()) {
            this.enemyCapturesEquipment(unit, enemyUnit, equip);
        }
        loser.divertModelMessages(unit, unit.getTile());
        unit.dispose();
    }

    private void promote(Unit unit) {
        String oldName = unit.getName();
        String nation = unit.getOwner().getNationAsString();
        UnitType newType = unit.getType().getPromotion();
        if (newType != null && newType.isAvailableTo(unit.getOwner())) {
            unit.setType(newType);
            if (unit.getType().equals(newType)) {
                unit.addModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.COMBAT_RESULT, "model.unit.unitPromoted", "%oldName%", oldName, "%unit%", unit.getName(), "%nation%", nation);
            }
        }
    }
}

