/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeItem;

public class StanceTradeItem
extends TradeItem {
    private Player.Stance stance;

    public StanceTradeItem(Game game, Player source, Player destination, Player.Stance stance) {
        super(game, "tradeItem.stance", source, destination);
        this.stance = stance;
    }

    public StanceTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXMLImpl(in);
    }

    public final Player.Stance getStance() {
        return this.stance;
    }

    public final void setStance(Player.Stance newStance) {
        this.stance = newStance;
    }

    public boolean isValid() {
        return this.stance != null;
    }

    public boolean isUnique() {
        return true;
    }

    public void makeTrade() {
        this.getSource().changeRelationWithPlayer(this.getDestination(), this.stance);
    }

    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        super.readFromXMLImpl(in);
        this.stance = Enum.valueOf(Player.Stance.class, in.getAttributeValue(null, "stance"));
        in.nextTag();
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(StanceTradeItem.getXMLElementTagName());
        super.toXMLImpl(out);
        out.writeAttribute("stance", this.stance.toString());
        out.writeEndElement();
    }

    public static String getXMLElementTagName() {
        return "stanceTradeItem";
    }
}

