/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.client.gui.i18n.Messages;

public class Tension {
    public static final int TENSION_ADD_MINOR = 100;
    public static final int TENSION_ADD_NORMAL = 200;
    public static final int TENSION_ADD_MAJOR = 300;
    public static final int TENSION_ADD_LAND_TAKEN = 200;
    public static final int TENSION_ADD_UNIT_DESTROYED = 400;
    public static final int TENSION_ADD_SETTLEMENT_ATTACKED = 500;
    public static final int TENSION_ADD_CAPITAL_ATTACKED = 600;
    public static final int TENSION_ADD_DECLARE_WAR_FROM_PEACE = 1000;
    public static final int TENSION_ADD_DECLARE_WAR_FROM_CEASE_FIRE = 750;
    public static final int PEACE_TREATY_MODIFIER = -250;
    public static final int CEASE_FIRE_MODIFIER = -250;
    public static final int ALLIANCE_MODIFIER = -500;
    static int SURRENDED = (Level.access$000(Level.CONTENT) + Level.access$000(Level.HAPPY)) / 2;
    private int value;

    public Tension() {
        this.setValue(Level.HAPPY.getLimit());
    }

    public Tension(int newTension) {
        this.setValue(newTension);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        this.value = newValue < 0 ? 0 : (newValue > Level.HATEFUL.getLimit() ? Level.HATEFUL.getLimit() : newValue);
    }

    public Level getLevel() {
        for (Level level : Level.values()) {
            if (this.value > level.getLimit()) continue;
            return level;
        }
        return Level.HATEFUL;
    }

    public void setLevel(Level level) {
        if (level != this.getLevel()) {
            this.setValue(level.getLimit());
        }
    }

    public void modify(int newTension) {
        this.setValue(this.value + newTension);
    }

    public String toString() {
        return Messages.message(this.getLevel().toString().toLowerCase(), new String[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        HAPPY(100),
        CONTENT(600),
        DISPLEASED(700),
        ANGRY(800),
        HATEFUL(1000);

        private int limit;

        private Level(int limit) {
            this.limit = limit;
        }

        public int getLimit() {
            return this.limit;
        }

        static /* synthetic */ int access$000(Level x0) {
            return x0.limit;
        }
    }
}

