/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BonusOrPenalty;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CostDecider;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItem;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tile
extends FreeColGameObject
implements Location,
Named,
Ownable {
    private static final Logger logger = Logger.getLogger(Tile.class.getName());
    private static final String UNITS_TAG_NAME = "units";
    public static final BonusOrPenalty FISH_BONUS_SOURCE = new BonusOrPenalty("model.modifier.fishBonus");
    private TileType type;
    private boolean lostCityRumour = false;
    private int x;
    private int y;
    private Player owner;
    private Settlement settlement;
    private TileItemContainer tileItemContainer;
    private List<Unit> units = Collections.emptyList();
    private int landCount = 0;
    private int fishBonus = 0;
    private Settlement owningSettlement;
    private java.util.Map<Player, PlayerExploredTile> playerExploredTiles;
    private Region region;
    private boolean connected = false;
    private Boolean moveToEurope;

    public Tile(Game game, TileType type, int locX, int locY) {
        super(game);
        this.type = type;
        this.lostCityRumour = false;
        this.x = locX;
        this.y = locY;
        this.owningSettlement = null;
        this.settlement = null;
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
    }

    public Tile(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
        this.readFromXML(in);
    }

    public Tile(Game game, Element e) {
        super(game, e);
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
        this.readFromXMLElement(e);
    }

    public Tile(Game game, String id) {
        super(game, id);
        if (!this.isViewShared()) {
            this.playerExploredTiles = new HashMap<Player, PlayerExploredTile>();
        }
    }

    public boolean isViewShared() {
        return this.getGame().getViewOwner() != null;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region newRegion) {
        this.region = newRegion;
    }

    public Region getDiscoverableRegion() {
        if (this.region == null) {
            return null;
        }
        return this.region.getDiscoverableRegion();
    }

    @Override
    public String getName() {
        if (this.isViewShared()) {
            if (this.isExplored()) {
                return this.getType().getName();
            }
            return Messages.message("unexplored", new String[0]);
        }
        Player player = this.getGame().getCurrentPlayer();
        if (player != null) {
            PlayerExploredTile pet = this.playerExploredTiles.get(player);
            if (pet != null && pet.explored) {
                return this.getType().getName();
            }
            return Messages.message("unexplored", new String[0]);
        }
        logger.warning("player == null");
        return "";
    }

    public String getLabel() {
        if (this.tileItemContainer == null) {
            return this.getName();
        }
        return this.getName() + this.tileItemContainer.getLabel();
    }

    @Override
    public String getLocationName() {
        if (this.settlement == null) {
            Settlement nearSettlement = null;
            int radius = 8;
            Map.CircleIterator mapIterator = this.getMap().getCircleIterator(this.getPosition(), true, radius);
            while (mapIterator.hasNext()) {
                nearSettlement = this.getMap().getTile(mapIterator.nextPosition()).getSettlement();
                if (nearSettlement == null || !(nearSettlement instanceof Colony)) continue;
                String name = ((Colony)nearSettlement).getName();
                return this.getName() + " (" + Messages.message("nearLocation", "%location%", name) + ")";
            }
            if (this.region != null && this.region.getName() != null) {
                return this.getName() + " (" + this.region.getName() + ")";
            }
            return this.getName();
        }
        return this.settlement.getLocationName();
    }

    public int getDistanceTo(Tile tile) {
        return this.getGame().getMap().getDistance(this.getPosition(), tile.getPosition());
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    public TileItemContainer getTileItemContainer() {
        return this.tileItemContainer;
    }

    public void setTileItemContainer(TileItemContainer newTileItemContainer) {
        this.tileItemContainer = newTileItemContainer;
    }

    public List<TileImprovement> getTileImprovements() {
        if (this.tileItemContainer == null) {
            return Collections.emptyList();
        }
        return this.tileItemContainer.getImprovements();
    }

    public List<TileImprovement> getCompletedTileImprovements() {
        if (this.tileItemContainer == null) {
            return Collections.emptyList();
        }
        ArrayList<TileImprovement> result = new ArrayList<TileImprovement>();
        for (TileImprovement improvement : this.tileItemContainer.getImprovements()) {
            if (improvement.getTurnsToComplete() != 0) continue;
            result.add(improvement);
        }
        return result;
    }

    public int getColonyValue() {
        if (!this.getType().canSettle()) {
            return 0;
        }
        if (this.getSettlement() != null) {
            return 0;
        }
        int value = this.potential(this.primaryGoods(), null) * 3;
        boolean nearbyTileIsOcean = false;
        HashMap<GoodsType, Boolean> buildingMaterialMap = new HashMap<GoodsType, Boolean>();
        for (GoodsType type : FreeCol.getSpecification().getGoodsTypeList()) {
            if (!type.isRawBuildingMaterial()) continue;
            buildingMaterialMap.put(type, false);
        }
        for (Tile tile : this.getGame().getMap().getSurroundingTiles(this, 1)) {
            if (tile.getColony() != null) {
                return 0;
            }
            if (tile.getSettlement() != null) {
                value -= 10;
                continue;
            }
            if (!tile.isConnected()) {
                nearbyTileIsOcean = true;
            }
            for (GoodsType type : FreeCol.getSpecification().getGoodsTypeList()) {
                int potential = tile.potential(type, null);
                value += potential;
                if (!type.isRawBuildingMaterial() || potential <= 4) continue;
                buildingMaterialMap.put(type, true);
            }
            if (tile.hasResource()) {
                value += 20;
            }
            if (tile.getOwner() == null || tile.getOwner() == this.getGame().getCurrentPlayer()) continue;
            if (tile.getOwner().isEuropean()) {
                value -= 20;
                continue;
            }
            value -= 5;
        }
        if (this.hasResource()) {
            value -= 10;
        }
        if (this.isForested()) {
            value -= 5;
        }
        for (Boolean buildingMaterial : buildingMaterialMap.values()) {
            if (buildingMaterial.booleanValue()) continue;
            value -= 40;
        }
        if (!nearbyTileIsOcean) {
            value = 0;
        } else {
            GoalDecider gd = new GoalDecider(){
                private PathNode goal = null;

                public PathNode getGoal() {
                    return this.goal;
                }

                public boolean hasSubGoals() {
                    return false;
                }

                public boolean check(Unit u, PathNode pathNode) {
                    Map map = Tile.this.getGame().getMap();
                    TileType tileType = pathNode.getTile().getType();
                    if (Tile.this.canMoveToEurope()) {
                        this.goal = pathNode;
                        return true;
                    }
                    if (map.isAdjacentToMapEdge(pathNode.getTile())) {
                        this.goal = pathNode;
                        return true;
                    }
                    return false;
                }
            };
            CostDecider cd = new CostDecider(){

                public int getCost(Unit unit, Tile oldTile, Tile newTile, int movesLeft, int turns) {
                    if (newTile.isLand()) {
                        return -1;
                    }
                    return 1;
                }

                public int getMovesLeft() {
                    return 0;
                }

                public boolean isNewTurn() {
                    return false;
                }
            };
            PathNode n = this.getMap().search(this, gd, cd, Integer.MAX_VALUE);
            if (n == null) {
                value = 0;
            }
        }
        return Math.max(0, value);
    }

    public Unit getDefendingUnit(Unit attacker) {
        Unit settlementDefender;
        Unit tileDefender = null;
        float defencePower = -1.0f;
        for (Unit nextUnit : this.units) {
            float tmpPower;
            if (this.isLand() == nextUnit.isNaval() || !((tmpPower = this.getGame().getCombatModel().getDefencePower(attacker, nextUnit)) > defencePower) && tileDefender != null) continue;
            tileDefender = nextUnit;
            defencePower = tmpPower;
        }
        if ((tileDefender == null || !tileDefender.isDefensiveUnit()) && this.getSettlement() != null && (settlementDefender = this.settlement.getDefendingUnit(attacker)) != null && this.getGame().getCombatModel().getDefencePower(attacker, settlementDefender) > defencePower) {
            return settlementDefender;
        }
        return tileDefender;
    }

    public int getMoveCost(Tile fromTile) {
        if (!this.isLand() || this.tileItemContainer == null) {
            return this.getType().getBasicMoveCost();
        }
        return this.tileItemContainer.getMoveCost(this.getType().getBasicMoveCost(), fromTile);
    }

    public void disposeAllUnits() {
        for (Unit unit : new ArrayList<Unit>(this.units)) {
            unit.dispose();
        }
        this.updatePlayerExploredTiles();
    }

    @Override
    public void dispose() {
        if (this.settlement != null) {
            this.settlement.dispose();
        }
        if (this.tileItemContainer != null) {
            this.tileItemContainer.dispose();
        }
        super.dispose();
    }

    public Unit getFirstUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(0);
    }

    public Unit getLastUnit() {
        if (this.units.isEmpty()) {
            return null;
        }
        return this.units.get(this.units.size() - 1);
    }

    public int getTotalUnitCount() {
        int result = 0;
        for (Unit unit : this.units) {
            ++result;
            result += unit.getUnitCount();
        }
        return result;
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.units.contains(locatable);
        }
        if (locatable instanceof TileItem) {
            return this.tileItemContainer != null && this.tileItemContainer.contains((TileItem)locatable);
        }
        logger.warning("Tile.contains(" + locatable + ") Not implemented yet!");
        return false;
    }

    public Map getMap() {
        return this.getGame().getMap();
    }

    public boolean isConnected() {
        return this.connected || this.type != null && this.type.isConnected();
    }

    public void setConnected(boolean newConnected) {
        this.connected = newConnected;
    }

    public boolean canMoveToEurope() {
        if (this.moveToEurope != null) {
            return this.moveToEurope;
        }
        if (this.type == null) {
            return false;
        }
        return this.type.hasAbility("model.ability.moveToEurope");
    }

    public void setMoveToEurope(Boolean newMoveToEurope) {
        this.moveToEurope = newMoveToEurope;
    }

    public boolean isExplored() {
        return this.type != null;
    }

    public boolean isLand() {
        return this.type != null && !this.type.isWater();
    }

    public boolean isForested() {
        return this.type != null && this.type.isForested();
    }

    public boolean hasRiver() {
        return this.tileItemContainer != null && this.getTileItemContainer().hasRiver();
    }

    public boolean hasResource() {
        return this.tileItemContainer != null && this.getTileItemContainer().hasResource();
    }

    public boolean hasRoad() {
        return this.tileItemContainer != null && this.getTileItemContainer().hasRoad();
    }

    public TileImprovement getRoad() {
        if (this.tileItemContainer == null) {
            return null;
        }
        return this.getTileItemContainer().getRoad();
    }

    public TileType getType() {
        return this.type;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player owner) {
        this.owner = owner;
        this.updatePlayerExploredTiles();
    }

    public void takeOwnership(Player player, Settlement settlement) {
        if (player.getLandPrice(this) > 0) {
            Player otherPlayer = this.getOwner();
            if (otherPlayer != null) {
                if (!otherPlayer.isEuropean()) {
                    otherPlayer.modifyTension(player, 200, (IndianSettlement)this.owningSettlement);
                }
            } else {
                logger.warning("Could not find player with nation: " + this.getOwner());
            }
        }
        this.setOwner(player);
        this.owningSettlement = settlement;
        this.updatePlayerExploredTiles();
    }

    public TileImprovement getRiver() {
        if (this.tileItemContainer == null) {
            return null;
        }
        return this.tileItemContainer.getRiver();
    }

    public int getRiverStyle() {
        if (this.tileItemContainer == null) {
            return 0;
        }
        return this.tileItemContainer.getRiverStyle();
    }

    public boolean hasUnexploredAdjacent() {
        Iterator<Map.Position> tileIterator = this.getMap().getAdjacentIterator(this.getPosition());
        while (tileIterator.hasNext()) {
            Tile t = this.getMap().getTile(tileIterator.next());
            if (t.isExplored()) continue;
            return true;
        }
        return false;
    }

    public int getLandCount() {
        return this.landCount;
    }

    public void setLandCount(int landCount) {
        this.landCount = landCount;
    }

    public int getFishBonus() {
        return this.fishBonus;
    }

    public void setFishBonus(int fishBonus) {
        this.fishBonus = fishBonus;
    }

    public void setSettlement(Settlement s) {
        this.settlement = s;
        this.owningSettlement = s;
        this.setLostCityRumour(false);
        this.updatePlayerExploredTiles();
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    @Override
    public Colony getColony() {
        if (this.settlement != null && this.settlement instanceof Colony) {
            return (Colony)this.settlement;
        }
        return null;
    }

    public void setOwningSettlement(Settlement owner) {
        this.owningSettlement = owner;
        this.updatePlayerExploredTiles();
    }

    public Settlement getOwningSettlement() {
        return this.owningSettlement;
    }

    public void setResource(ResourceType r) {
        if (r == null) {
            return;
        }
        if (this.tileItemContainer == null) {
            this.tileItemContainer = new TileItemContainer(this.getGame(), this);
        }
        Resource resource = new Resource(this.getGame(), this, r);
        this.tileItemContainer.addTileItem(resource);
        this.updatePlayerExploredTiles();
    }

    public void setType(TileType t) {
        if (t == null) {
            throw new IllegalArgumentException("Tile type must not be null");
        }
        this.type = t;
        if (this.tileItemContainer != null) {
            this.tileItemContainer.removeIncompatibleImprovements();
        }
        if (!this.isLand()) {
            this.settlement = null;
        }
        this.updatePlayerExploredTiles();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Map.Position getPosition() {
        return new Map.Position(this.x, this.y);
    }

    public boolean hasLostCityRumour() {
        return this.lostCityRumour;
    }

    public void setLostCityRumour(boolean rumour) {
        this.lostCityRumour = rumour;
        if (!this.isLand() && rumour) {
            logger.warning("Setting lost city rumour to Ocean.");
            for (TileType t : FreeCol.getSpecification().getTileTypeList()) {
                if (t.isWater()) continue;
                this.setType(t);
                break;
            }
        }
        this.updatePlayerExploredTiles();
    }

    public boolean isSettleable() {
        return this.getType().canSettle();
    }

    public boolean isColonizeable() {
        if (!this.isSettleable()) {
            return false;
        }
        if (this.settlement != null) {
            return false;
        }
        for (Map.Direction direction : Map.Direction.values()) {
            Settlement set;
            Tile otherTile = this.getMap().getNeighbourOrNull(direction, this);
            if (otherTile == null || (set = otherTile.getSettlement()) == null || !set.getOwner().isEuropean()) continue;
            return false;
        }
        return true;
    }

    public Unit getMovableUnit() {
        Unit childUnit;
        Iterator<Unit> childUnitIterator;
        Unit u;
        Iterator<Unit> unitIterator;
        if (this.getFirstUnit() != null) {
            unitIterator = this.getUnitIterator();
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                childUnitIterator = u.getUnitIterator();
                while (childUnitIterator.hasNext()) {
                    childUnit = childUnitIterator.next();
                    if (childUnit.getMovesLeft() <= 0 || childUnit.getState() != Unit.UnitState.ACTIVE) continue;
                    return childUnit;
                }
                if (u.getMovesLeft() <= 0 || u.getState() != Unit.UnitState.ACTIVE) continue;
                return u;
            }
        } else {
            return null;
        }
        unitIterator = this.getUnitIterator();
        while (unitIterator.hasNext()) {
            u = unitIterator.next();
            childUnitIterator = u.getUnitIterator();
            while (childUnitIterator.hasNext()) {
                childUnit = childUnitIterator.next();
                if (childUnit.getMovesLeft() <= 0) continue;
                return childUnit;
            }
            if (u.getMovesLeft() <= 0) continue;
            return u;
        }
        return null;
    }

    @Override
    public Tile getTile() {
        return this;
    }

    @Override
    public void add(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (!this.units.contains(locatable)) {
                if (((Object)this.units).equals(Collections.emptyList())) {
                    this.units = new ArrayList<Unit>();
                }
                this.units.add((Unit)locatable);
            }
        } else if (locatable instanceof TileItem) {
            if (this.tileItemContainer == null) {
                this.tileItemContainer = new TileItemContainer(this.getGame(), this);
            }
            this.tileItemContainer.addTileItem((TileItem)locatable);
        } else {
            logger.warning("Tried to add an unrecognized 'Locatable' to a tile.");
        }
        this.updatePlayerExploredTiles();
    }

    @Override
    public void remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            boolean removed = this.units.remove(locatable);
            if (!removed) {
                logger.warning("Unit with ID " + ((Unit)locatable).getId() + " could not be removed from " + this.toString() + " with ID " + this.getId());
            }
        } else if (locatable instanceof TileItem) {
            this.tileItemContainer.addTileItem((TileItem)locatable);
        } else {
            logger.warning("Tried to remove an unrecognized 'Locatable' from a tile.");
        }
        this.updatePlayerExploredTiles();
    }

    public void removeUnitNoUpdate(Unit unit) {
        this.units.remove(unit);
    }

    public void addUnitNoUpdate(Unit unit) {
        if (((Object)this.units).equals(Collections.emptyList())) {
            this.units = new ArrayList<Unit>();
        }
        this.units.add(unit);
    }

    @Override
    public int getUnitCount() {
        return this.units.size();
    }

    @Override
    public List<Unit> getUnitList() {
        return this.units;
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.units.iterator();
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return true;
    }

    public int potential(GoodsType goodsType, UnitType unitType) {
        return Tile.getTileTypePotential(this.getType(), goodsType, this.getTileItemContainer(), unitType, this.getFishBonus());
    }

    public int getMaximumPotential(GoodsType goodsType, UnitType unitType) {
        ArrayList<TileType> tileTypes = new ArrayList<TileType>();
        tileTypes.add(this.getType());
        for (TileImprovementType impType : FreeCol.getSpecification().getTileImprovementTypeList()) {
            if (impType.getChange(this.getType()) == null) continue;
            tileTypes.add(impType.getChange(this.getType()));
        }
        int maxProduction = 0;
        for (TileType tileType : tileTypes) {
            float potential = tileType.getProductionOf(goodsType, unitType);
            if (tileType.isWater() && goodsType.isFoodType()) {
                potential += (float)this.fishBonus;
            }
            if (tileType == this.getType() && this.hasResource()) {
                potential = this.tileItemContainer.getResourceBonusPotential(goodsType, unitType, (int)potential);
            }
            for (TileImprovementType impType : FreeCol.getSpecification().getTileImprovementTypeList()) {
                if (impType.isNatural() || !impType.isTileTypeAllowed(tileType) || impType.getBonus(goodsType) <= 0) continue;
                potential = impType.getProductionModifier(goodsType).applyTo(potential);
            }
            maxProduction = Math.max((int)potential, maxProduction);
        }
        return maxProduction;
    }

    public Set<Modifier> getProductionBonus(GoodsType goodsType, UnitType unitType) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(this.type.getProductionBonus(goodsType));
        if (this.fishBonus > 0) {
            result.add(new Modifier(goodsType.getId(), FISH_BONUS_SOURCE, this.fishBonus, Modifier.Type.ADDITIVE));
        }
        if (!result.isEmpty() && this.tileItemContainer != null) {
            result.addAll(this.tileItemContainer.getProductionBonus(goodsType, unitType));
        }
        return result;
    }

    public boolean canGetRoad() {
        return this.isLand() && (this.tileItemContainer == null || !this.tileItemContainer.hasRoad());
    }

    public TileImprovement findTileImprovementType(TileImprovementType type) {
        if (this.tileItemContainer == null) {
            return null;
        }
        return this.tileItemContainer.findTileImprovementType(type);
    }

    public boolean hasImprovement(TileImprovementType type) {
        return this.tileItemContainer != null && this.tileItemContainer.hasImprovement(type);
    }

    public static int getTileTypePotential(TileType tileType, GoodsType goodsType, TileItemContainer tiContainer, UnitType unitType, int fishBonus) {
        if (tileType == null || goodsType == null || !goodsType.isFarmed()) {
            return 0;
        }
        int potential = tileType.getProductionOf(goodsType, unitType);
        if (potential > 0) {
            if (tileType.isWater() && goodsType.isFoodType()) {
                potential += fishBonus;
            }
            if (tiContainer != null) {
                potential = tiContainer.getTotalBonusPotential(goodsType, unitType, potential);
            }
        }
        return potential;
    }

    public List<AbstractGoods> getSortedPotential() {
        ArrayList<AbstractGoods> goodsTypeList = new ArrayList<AbstractGoods>();
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            int potential = this.potential(goodsType, null);
            if (potential <= 0) continue;
            goodsTypeList.add(new AbstractGoods(goodsType, potential));
        }
        Collections.sort(goodsTypeList, new Comparator<AbstractGoods>(){

            @Override
            public int compare(AbstractGoods o, AbstractGoods p) {
                return p.getAmount() - o.getAmount();
            }
        });
        return goodsTypeList;
    }

    public GoodsType primaryGoods() {
        if (this.type == null) {
            return null;
        }
        for (AbstractGoods goods : this.getSortedPotential()) {
            if (!goods.getType().isFoodType()) continue;
            return goods.getType();
        }
        return null;
    }

    public GoodsType secondaryGoods() {
        if (this.type == null) {
            return null;
        }
        return this.type.getSecondaryGoods();
    }

    public void expendResource(GoodsType goodsType, UnitType unitType, Settlement settlement) {
        int potential;
        Resource resource;
        if (this.hasResource() && this.tileItemContainer.getResource().getQuantity() != -1 && (resource = this.tileItemContainer.getResource()).useQuantity(goodsType, unitType, potential = Tile.getTileTypePotential(this.getType(), goodsType, this.tileItemContainer, unitType, this.getFishBonus()) + this.tileItemContainer.getImprovementBonusPotential(goodsType)) == 0) {
            this.addModelMessage((FreeColGameObject)settlement, ModelMessage.MessageType.WARNING, "model.tile.resourceExhausted", "%resource%", resource.getName(), "%colony%", ((Colony)settlement).getName());
            this.tileItemContainer.clearResource();
            this.updatePlayerExploredTiles();
        }
    }

    private void unitsToXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        if (!this.units.isEmpty()) {
            out.writeStartElement(UNITS_TAG_NAME);
            for (Unit unit : this.units) {
                unit.toXML(out, player, showAll, toSavedGame);
            }
            out.writeEndElement();
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        boolean lostCity;
        out.writeStartElement(Tile.getXMLElementTagName());
        if (toSavedGame && !showAll) {
            logger.warning("toSavedGame is true, but showAll is false");
        }
        PlayerExploredTile pet = null;
        if (!showAll) {
            if (player != null) {
                pet = this.playerExploredTiles.get(player);
            } else {
                logger.warning("player == null");
            }
        }
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("x", Integer.toString(this.x));
        out.writeAttribute("y", Integer.toString(this.y));
        this.writeAttribute(out, "type", this.getType());
        this.writeAttribute(out, "region", this.getRegion());
        if (this.fishBonus != 0) {
            out.writeAttribute("fishBonus", Integer.toString(this.fishBonus));
        }
        boolean bl = lostCity = pet == null ? this.lostCityRumour : pet.hasLostCityRumour();
        if (lostCity) {
            out.writeAttribute("lostCityRumour", Boolean.toString(lostCity));
        }
        if (this.connected && !this.type.isConnected()) {
            out.writeAttribute("connected", Boolean.toString(true));
        }
        if (this.owner != null) {
            if (this.getGame().isClientTrusted() || showAll || player.canSee(this)) {
                out.writeAttribute("owner", this.owner.getId());
            } else if (pet != null) {
                this.writeAttribute(out, "owner", pet.getOwner());
            }
        }
        if ((this.getGame().isClientTrusted() || showAll || player.canSee(this)) && this.owningSettlement != null) {
            out.writeAttribute("owningSettlement", this.owningSettlement.getId());
        }
        if (this.settlement != null) {
            GoodsContainer emptyGoodsContainer;
            if (pet == null || this.getGame().isClientTrusted() || showAll || this.settlement.getOwner() == player) {
                this.settlement.toXML(out, player, showAll, toSavedGame);
            } else if (this.getColony() != null) {
                if (!player.canSee(this.getTile())) {
                    if (pet.getColonyUnitCount() != 0) {
                        out.writeStartElement(Colony.getXMLElementTagName());
                        out.writeAttribute("ID", this.getColony().getId());
                        out.writeAttribute("name", this.getColony().getName());
                        out.writeAttribute("owner", this.getColony().getOwner().getId());
                        out.writeAttribute("tile", this.getId());
                        out.writeAttribute("unitCount", Integer.toString(pet.getColonyUnitCount()));
                        Building stockade = this.getColony().getStockade();
                        if (stockade != null) {
                            stockade.toXML(out);
                        }
                        emptyGoodsContainer = new GoodsContainer(this.getGame(), this.getColony());
                        emptyGoodsContainer.setFakeID(this.getColony().getGoodsContainer().getId());
                        emptyGoodsContainer.toXML(out, player, showAll, toSavedGame);
                        out.writeEndElement();
                    }
                } else {
                    this.settlement.toXML(out, player, showAll, toSavedGame);
                }
            } else if (this.getSettlement() instanceof IndianSettlement) {
                IndianSettlement is = (IndianSettlement)this.getSettlement();
                out.writeStartElement(IndianSettlement.getXMLElementTagName());
                out.writeAttribute("ID", this.getSettlement().getId());
                out.writeAttribute("tile", this.getId());
                out.writeAttribute("owner", this.getSettlement().getOwner().getId());
                out.writeAttribute("isCapital", Boolean.toString(is.isCapital()));
                this.writeAttribute(out, "learnableSkill", pet.getSkill());
                if (pet.getWantedGoods()[0] != null) {
                    out.writeAttribute("wantedGoods0", pet.getWantedGoods()[0].getId());
                    out.writeAttribute("wantedGoods1", pet.getWantedGoods()[1].getId());
                    out.writeAttribute("wantedGoods2", pet.getWantedGoods()[2].getId());
                }
                out.writeAttribute("hasBeenVisited", Boolean.toString(pet.hasBeenVisited()));
                for (Map.Entry<Player, Tension> entry : is.getAlarm().entrySet()) {
                    out.writeStartElement("alarm");
                    out.writeAttribute("player", entry.getKey().getId());
                    out.writeAttribute("value", String.valueOf(entry.getValue().getValue()));
                    out.writeEndElement();
                }
                if (pet.getMissionary() != null) {
                    out.writeStartElement("missionary");
                    pet.getMissionary().toXML(out, player, false, false);
                    out.writeEndElement();
                }
                emptyGoodsContainer = new GoodsContainer(this.getGame(), is);
                emptyGoodsContainer.setFakeID(is.getGoodsContainer().getId());
                emptyGoodsContainer.toXML(out, player, showAll, toSavedGame);
                out.writeEndElement();
            } else {
                logger.warning("Unknown type of settlement: " + this.getSettlement());
            }
        }
        if (this.getGame().isClientTrusted() || showAll || player.canSee(this) && (this.settlement == null || this.settlement.getOwner() == player) || !this.getGameOptions().getBoolean("model.option.unitHiding") && player.canSee(this)) {
            this.unitsToXML(out, player, showAll, toSavedGame);
            if (this.tileItemContainer != null) {
                this.tileItemContainer.toXML(out, player, showAll, toSavedGame);
            }
        } else if (this.tileItemContainer != null) {
            TileItemContainer newTileItemContainer = null;
            newTileItemContainer = pet != null ? new TileItemContainer(this.getGame(), this, pet) : new TileItemContainer(this.getGame(), this);
            newTileItemContainer.setFakeID(this.tileItemContainer.getId());
            newTileItemContainer.toXML(out, player, showAll, toSavedGame);
        }
        if (toSavedGame) {
            for (PlayerExploredTile peTile : this.playerExploredTiles.values()) {
                if (!peTile.isExplored()) continue;
                peTile.toXML(out, player, showAll, toSavedGame);
            }
        }
        out.writeEndElement();
    }

    @Override
    protected void readFromXMLImpl(XMLStreamReader in) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "ID"));
        this.x = Integer.parseInt(in.getAttributeValue(null, "x"));
        this.y = Integer.parseInt(in.getAttributeValue(null, "y"));
        String typeStr = in.getAttributeValue(null, "type");
        if (typeStr != null) {
            if (!typeStr.startsWith("model.tile")) {
                boolean forested;
                String additionStr = in.getAttributeValue(null, "addition");
                String forestedStr = in.getAttributeValue(null, "forested");
                boolean bl = forested = forestedStr != null ? Boolean.valueOf(forestedStr) : false;
                if (additionStr != null && additionStr.equals("4")) {
                    typeStr = "model.tile.mountains";
                } else if (additionStr != null && additionStr.equals("3")) {
                    typeStr = "model.tile.hills";
                } else if (typeStr.equals("1")) {
                    typeStr = forested ? "model.tile.mixedForest" : "model.tile.plains";
                } else if (typeStr.equals("2")) {
                    typeStr = forested ? "model.tile.coniferForest" : "model.tile.grassland";
                } else if (typeStr.equals("3")) {
                    typeStr = forested ? "model.tile.broadleafForest" : "model.tile.prairie";
                } else if (typeStr.equals("4")) {
                    typeStr = forested ? "model.tile.tropicalForest" : "model.tile.savannah";
                } else if (typeStr.equals("5")) {
                    typeStr = forested ? "model.tile.wetlandForest" : "model.tile.marsh";
                } else if (typeStr.equals("6")) {
                    typeStr = forested ? "model.tile.rainForest" : "model.tile.swamp";
                } else if (typeStr.equals("7")) {
                    typeStr = forested ? "model.tile.scrubForest" : "model.tile.desert";
                } else if (typeStr.equals("8")) {
                    typeStr = forested ? "model.tile.borealForest" : "model.tile.tundra";
                } else if (typeStr.equals("9")) {
                    typeStr = "model.tile.arctic";
                } else if (typeStr.equals("10")) {
                    typeStr = "model.tile.ocean";
                } else if (typeStr.equals("11")) {
                    typeStr = "model.tile.highSeas";
                }
                String riverString = in.getAttributeValue(null, "river");
                if (riverString != null && !typeStr.equals("model.tile.ocean") && !typeStr.equals("model.tile.highSeas")) {
                    int riverType = Integer.parseInt(riverString);
                    if (this.tileItemContainer == null) {
                        this.tileItemContainer = new TileItemContainer(this.getGame(), this);
                    }
                    this.tileItemContainer.addRiver(1, riverType);
                }
            }
            this.type = FreeCol.getSpecification().getTileType(typeStr);
        }
        this.lostCityRumour = this.getAttribute(in, LostCityRumour.getXMLElementTagName(), false);
        this.connected = this.getAttribute(in, "connected", false);
        this.owner = this.getFreeColGameObject(in, "owner", Player.class, null);
        this.region = this.getFreeColGameObject(in, "region", Region.class, null);
        this.fishBonus = this.getAttribute(in, "fishBonus", 0);
        String owningSettlementStr = in.getAttributeValue(null, "owningSettlement");
        if (owningSettlementStr != null) {
            this.owningSettlement = (Settlement)this.getGame().getFreeColGameObject(owningSettlementStr);
            if (this.owningSettlement == null) {
                if (owningSettlementStr.startsWith(IndianSettlement.getXMLElementTagName())) {
                    this.owningSettlement = new IndianSettlement(this.getGame(), owningSettlementStr);
                } else if (owningSettlementStr.startsWith(Colony.getXMLElementTagName())) {
                    this.owningSettlement = new Colony(this.getGame(), owningSettlementStr);
                } else {
                    logger.warning("Unknown type of Settlement.");
                }
            }
        } else {
            this.owningSettlement = null;
        }
        boolean settlementSent = false;
        while (in.nextTag() != 2) {
            if (in.getLocalName().equals(Colony.getXMLElementTagName())) {
                this.settlement = this.updateFreeColGameObject(in, Colony.class);
                settlementSent = true;
                continue;
            }
            if (in.getLocalName().equals(IndianSettlement.getXMLElementTagName())) {
                this.settlement = this.updateFreeColGameObject(in, IndianSettlement.class);
                settlementSent = true;
                continue;
            }
            if (in.getLocalName().equals(UNITS_TAG_NAME)) {
                this.units = new ArrayList<Unit>();
                while (in.nextTag() != 2) {
                    if (!in.getLocalName().equals(Unit.getXMLElementTagName())) continue;
                    this.units.add(this.updateFreeColGameObject(in, Unit.class));
                }
                continue;
            }
            if (in.getLocalName().equals(TileItemContainer.getXMLElementTagName())) {
                this.tileItemContainer = (TileItemContainer)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                if (this.tileItemContainer != null) {
                    this.tileItemContainer.readFromXML(in);
                    continue;
                }
                this.tileItemContainer = new TileItemContainer(this.getGame(), this, in);
                continue;
            }
            if (in.getLocalName().equals("playerExploredTile")) {
                Player player = (Player)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
                if (this.playerExploredTiles.get(player) == null) {
                    PlayerExploredTile pet = new PlayerExploredTile(in);
                    this.playerExploredTiles.put(player, pet);
                    continue;
                }
                this.playerExploredTiles.get(player).readFromXML(in);
                continue;
            }
            logger.warning("Unknown tag: " + in.getLocalName() + " [" + in.getAttributeValue(null, "ID") + "] " + " loading tile with ID " + this.getId());
            in.nextTag();
        }
        if (!settlementSent && this.settlement != null) {
            this.settlement.dispose();
        }
    }

    public static String getXMLElementTagName() {
        return "tile";
    }

    private PlayerExploredTile getPlayerExploredTile(Player player) {
        if (this.playerExploredTiles == null) {
            return null;
        }
        return this.playerExploredTiles.get(player);
    }

    private void createPlayerExploredTile(Player player) {
        this.playerExploredTiles.put(player, new PlayerExploredTile(player, this.getTileItemContainer()));
    }

    public void updatePlayerExploredTile(Player player) {
        if (this.playerExploredTiles == null || this.getGame().getViewOwner() != null) {
            return;
        }
        PlayerExploredTile pet = this.playerExploredTiles.get(player);
        if (pet == null) {
            if (player.isEuropean()) {
                String message = "'playerExploredTiles' for " + (Object)((Object)player.getPlayerType()) + " player '" + player.getName() + "' is 'null'. " + player.canSee(this) + ", " + this.isExploredBy(player) + " ::: " + this.getPosition();
                logger.warning(message);
                pet = new PlayerExploredTile(player, this.getTileItemContainer());
                this.playerExploredTiles.put(player, pet);
            } else {
                return;
            }
        }
        pet.getTileItemInfo(this.tileItemContainer);
        pet.setLostCityRumour(this.lostCityRumour);
        pet.setConnected(this.connected);
        pet.setOwner(this.owner);
        pet.setRegion(this.region);
        pet.setFishBonus(this.getFishBonus());
        if (this.getColony() != null) {
            pet.setColonyUnitCount(this.getSettlement().getUnitCount());
            Building stockade = this.getColony().getStockade();
            if (stockade != null) {
                pet.setColonyStockadeLevel(stockade.getType().getIndex());
            } else {
                pet.setColonyStockadeLevel(0);
            }
        } else if (this.getSettlement() != null) {
            IndianSettlement settlement = (IndianSettlement)this.getSettlement();
            pet.setMissionary(settlement.getMissionary());
            if (settlement.hasBeenVisited(player)) {
                pet.setVisited();
            }
        } else {
            pet.setColonyUnitCount(0);
        }
    }

    public void updatePlayerExploredTiles() {
        if (this.playerExploredTiles == null || this.getGame().getViewOwner() != null) {
            return;
        }
        for (Player player : this.getGame().getPlayers()) {
            if (this.playerExploredTiles.get(player) == null && (!player.isEuropean() || !player.canSee(this))) continue;
            this.updatePlayerExploredTile(player);
        }
    }

    public boolean isExploredBy(Player player) {
        if (player.isIndian()) {
            return true;
        }
        if (this.playerExploredTiles == null || this.playerExploredTiles.get(player) == null || !this.isExplored()) {
            return false;
        }
        return this.getPlayerExploredTile(player).isExplored();
    }

    public void setExploredBy(Player player, boolean explored) {
        if (player.isIndian()) {
            return;
        }
        if (this.playerExploredTiles.get(player) == null) {
            this.createPlayerExploredTile(player);
        }
        this.getPlayerExploredTile(player).setExplored(explored);
        this.updatePlayerExploredTile(player);
    }

    public void updateIndianSettlementSkill(Player player) {
        IndianSettlement is = (IndianSettlement)this.getSettlement();
        PlayerExploredTile pet = this.getPlayerExploredTile(player);
        pet.setSkill(is.getLearnableSkill());
        pet.setVisited();
    }

    public void updateIndianSettlementInformation(Player player) {
        if (player.isIndian()) {
            return;
        }
        PlayerExploredTile playerExploredTile = this.getPlayerExploredTile(player);
        IndianSettlement is = (IndianSettlement)this.getSettlement();
        playerExploredTile.setSkill(is.getLearnableSkill());
        playerExploredTile.setWantedGoods(is.getWantedGoods());
        playerExploredTile.setVisited();
    }

    public int getWorkAmount(TileImprovementType workType) {
        if (workType == null) {
            return -1;
        }
        if (!workType.isTileAllowed(this)) {
            return -1;
        }
        return this.getType().getBasicWorkTurns() + workType.getAddWorkTurns();
    }

    public Unit getOccupyingUnit() {
        Unit unit = this.getFirstUnit();
        Player owner = null;
        if (this.owningSettlement != null) {
            owner = this.owningSettlement.getOwner();
        }
        if (owner != null && unit != null && unit.getOwner() != owner && owner.getStance(unit.getOwner()) != Player.Stance.ALLIANCE) {
            for (Unit enemyUnit : this.getUnitList()) {
                if (!enemyUnit.isOffensiveUnit() || enemyUnit.getState() != Unit.UnitState.FORTIFIED) continue;
                return enemyUnit;
            }
        }
        return null;
    }

    public boolean isOccupied() {
        return this.getOccupyingUnit() != null;
    }

    public boolean isAdjacent(Tile tile) {
        if (tile == null) {
            return false;
        }
        return this.getDistanceTo(tile) == 1;
    }

    @Override
    public String toString() {
        return "Tile(" + this.x + "," + this.y + "):" + (this.type == null ? "unknown" : this.type.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PlayerExploredTile {
        private Player player;
        private boolean explored = false;
        private Player owner;
        private Region region;
        private Resource resource;
        private List<TileImprovement> improvements;
        private TileImprovement road;
        private TileImprovement river;
        private int fishBonus;
        private int colonyUnitCount = 0;
        private int colonyStockadeLevel;
        private UnitType skill = null;
        private GoodsType[] wantedGoods = new GoodsType[]{null, null, null};
        private boolean settlementVisited = false;
        private Unit missionary = null;
        private boolean lostCityRumour;
        private boolean connected = false;

        public PlayerExploredTile(Player player, TileItemContainer tic) {
            this.player = player;
            this.getTileItemInfo(tic);
        }

        public PlayerExploredTile(XMLStreamReader in) throws XMLStreamException {
            this.readFromXML(in);
        }

        public void getTileItemInfo(TileItemContainer tic) {
            if (tic != null) {
                this.resource = tic.getResource();
                this.improvements = tic.getImprovements();
                this.road = tic.getRoad();
                this.river = tic.getRiver();
            } else {
                this.improvements = Collections.emptyList();
            }
        }

        public void setColonyUnitCount(int colonyUnitCount) {
            this.colonyUnitCount = colonyUnitCount;
        }

        public int getColonyUnitCount() {
            return this.colonyUnitCount;
        }

        public void setColonyStockadeLevel(int colonyStockadeLevel) {
            this.colonyStockadeLevel = colonyStockadeLevel;
        }

        public int getColonyStockadeLevel() {
            return this.colonyStockadeLevel;
        }

        public boolean hasRoad() {
            return this.road != null;
        }

        public TileImprovement getRoad() {
            return this.road;
        }

        public boolean hasRiver() {
            return this.river != null;
        }

        public TileImprovement getRiver() {
            return this.river;
        }

        public Resource getResource() {
            return this.resource;
        }

        public List<TileImprovement> getImprovements() {
            return this.improvements;
        }

        public void setLostCityRumour(boolean lostCityRumour) {
            this.lostCityRumour = lostCityRumour;
        }

        public boolean hasLostCityRumour() {
            return this.lostCityRumour;
        }

        public void setConnected(boolean connected) {
            this.connected = connected;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void setExplored(boolean explored) {
            this.explored = explored;
        }

        public void setSkill(UnitType newSkill) {
            this.skill = newSkill;
        }

        public UnitType getSkill() {
            return this.skill;
        }

        public void setOwner(Player owner) {
            this.owner = owner;
        }

        public Player getOwner() {
            return this.owner;
        }

        public void setWantedGoods(GoodsType[] newWantedGoods) {
            this.wantedGoods = newWantedGoods;
        }

        public GoodsType[] getWantedGoods() {
            return this.wantedGoods;
        }

        public void setMissionary(Unit missionary) {
            this.missionary = missionary;
        }

        public Unit getMissionary() {
            return this.missionary;
        }

        private void setVisited() {
            this.settlementVisited = true;
        }

        private boolean hasBeenVisited() {
            return this.settlementVisited;
        }

        public Region getRegion() {
            return this.region;
        }

        private void setRegion(Region region) {
            this.region = region;
        }

        public int getFishBonus() {
            return this.fishBonus;
        }

        public void setFishBonus(int fishBonus) {
            this.fishBonus = fishBonus;
        }

        public boolean isExplored() {
            return this.explored;
        }

        public Player getPlayer() {
            return this.player;
        }

        public void toXML(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
            out.writeStartElement("playerExploredTile");
            out.writeAttribute("player", this.player.getId());
            if (!this.explored) {
                out.writeAttribute("explored", Boolean.toString(this.explored));
            }
            if (Tile.this.hasLostCityRumour()) {
                out.writeAttribute("lostCityRumour", Boolean.toString(this.lostCityRumour));
            }
            if (Tile.this.getOwner() != this.owner && this.owner != null) {
                out.writeAttribute("owner", this.owner.getId());
            }
            if (this.colonyUnitCount != 0) {
                out.writeAttribute("colonyUnitCount", Integer.toString(this.colonyUnitCount));
                out.writeAttribute("colonyStockadeLevel", Integer.toString(this.colonyStockadeLevel));
            }
            if (this.fishBonus != 0) {
                out.writeAttribute("fishBonus", Integer.toString(this.fishBonus));
            }
            out.writeAttribute("connected", Boolean.toString(this.connected));
            Tile.this.writeAttribute(out, "region", this.region);
            out.writeAttribute("settlementVisited", Boolean.toString(this.settlementVisited));
            if (this.settlementVisited) {
                Tile.this.writeAttribute(out, "learnableSkill", this.skill);
                Tile.this.writeAttribute(out, "wantedGoods0", this.wantedGoods[0]);
                Tile.this.writeAttribute(out, "wantedGoods1", this.wantedGoods[1]);
                Tile.this.writeAttribute(out, "wantedGoods2", this.wantedGoods[2]);
            }
            if (this.missionary != null && this.settlementVisited) {
                out.writeStartElement("missionary");
                this.missionary.toXML(out, player, showAll, toSavedGame);
                out.writeEndElement();
            }
            if (Tile.this.hasResource()) {
                this.resource.toXML(out, player, showAll, toSavedGame);
            }
            for (TileImprovement t : this.improvements) {
                t.toXML(out, player, showAll, toSavedGame);
            }
            out.writeEndElement();
        }

        public void readFromXML(XMLStreamReader in) throws XMLStreamException {
            this.player = (Player)Tile.this.getGame().getFreeColGameObject(in.getAttributeValue(null, "player"));
            this.explored = Tile.this.getAttribute(in, "explored", true);
            this.colonyUnitCount = Tile.this.getAttribute(in, "colonyUnitCount", 0);
            this.colonyStockadeLevel = Tile.this.getAttribute(in, "colonyStockadeLevel", 0);
            this.lostCityRumour = Tile.this.getAttribute(in, LostCityRumour.getXMLElementTagName(), Tile.this.hasLostCityRumour());
            this.connected = Tile.this.getAttribute(in, "connected", false);
            this.fishBonus = Tile.this.getAttribute(in, "fishBonus", 0);
            this.owner = Tile.this.getFreeColGameObject(in, "owner", Player.class, Tile.this.getOwner());
            this.region = Tile.this.getFreeColGameObject(in, "region", Region.class, null);
            this.settlementVisited = Tile.this.getAttribute(in, "settlementVisited", false);
            if (this.settlementVisited) {
                Specification spec = FreeCol.getSpecification();
                this.skill = spec.getType(in, "learnableSkill", UnitType.class, null);
                this.wantedGoods[0] = spec.getType(in, "wantedGoods0", GoodsType.class, null);
                this.wantedGoods[1] = spec.getType(in, "wantedGoods1", GoodsType.class, null);
                this.wantedGoods[2] = spec.getType(in, "wantedGoods2", GoodsType.class, null);
            }
            this.missionary = null;
            TileItemContainer tileItemContainer = new TileItemContainer(Tile.this.getGame(), Tile.this);
            while (in.nextTag() != 2) {
                if (in.getLocalName().equals("missionary")) {
                    in.nextTag();
                    this.missionary = (Unit)Tile.this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                    if (this.missionary == null) {
                        this.missionary = new Unit(Tile.this.getGame(), in);
                    } else {
                        this.missionary.readFromXML(in);
                    }
                    in.nextTag();
                    continue;
                }
                if (in.getLocalName().equals(Resource.getXMLElementTagName())) {
                    Resource resource = (Resource)Tile.this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                    if (resource != null) {
                        resource.readFromXML(in);
                    } else {
                        resource = new Resource(Tile.this.getGame(), in);
                    }
                    tileItemContainer.addTileItem(resource);
                    continue;
                }
                if (in.getLocalName().equals(TileImprovement.getXMLElementTagName())) {
                    TileImprovement ti = (TileImprovement)Tile.this.getGame().getFreeColGameObject(in.getAttributeValue(null, "ID"));
                    if (ti != null) {
                        ti.readFromXML(in);
                    } else {
                        ti = new TileImprovement(Tile.this.getGame(), in);
                    }
                    tileItemContainer.addTileItem(ti);
                    continue;
                }
                logger.warning("Unknown tag: " + in.getLocalName() + " loading PlayerExploredTile");
                in.nextTag();
            }
            this.getTileItemInfo(tileItemContainer);
        }
    }
}

